/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.TagUtility;
import org.farng.mp3.object.AbstractMP3Object;

public class ObjectStringFixedLength
extends AbstractMP3Object {
    int length = 0;

    public ObjectStringFixedLength(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("length is less than zero: " + n);
        }
        this.identifier = string;
        this.length = n;
    }

    public ObjectStringFixedLength(ObjectStringFixedLength objectStringFixedLength) {
        super(objectStringFixedLength);
        this.length = objectStringFixedLength.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public int getLength() {
        return this.length;
    }

    public int getSize() {
        return this.length;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectStringFixedLength)) {
            return false;
        }
        ObjectStringFixedLength objectStringFixedLength = (ObjectStringFixedLength)object;
        if (this.length != objectStringFixedLength.length) {
            return false;
        }
        return super.equals(object);
    }

    public void readString(String string, int n) {
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to String is out of bounds: offset = " + n + ", string.length()" + string.length());
        }
        this.value = string.substring(n, this.length + n);
    }

    public String toString() {
        return this.writeString();
    }

    public String writeString() {
        int n;
        String string = this.value == null ? String.valueOf(new char[this.length]) : ((n = ((String)this.value).length()) > this.length ? ((String)this.value).substring(0, this.length) : (n == this.length ? (String)this.value : TagUtility.padString((String)this.value, this.length, ' ', false)));
        return string;
    }
}

