/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.net.SocketNode;
import org.apache.log4j.xml.DOMConfigurator;

public class SimpleSocketServer {
    static Logger cat = Logger.getLogger(SimpleSocketServer.class);
    static int port;

    public static void main(String[] stringArray) {
        if (stringArray.length == 2) {
            SimpleSocketServer.init(stringArray[0], stringArray[1]);
        } else {
            SimpleSocketServer.usage("Wrong number of arguments.");
        }
        try {
            cat.info("Listening on port " + port);
            ServerSocket serverSocket = new ServerSocket(port);
            while (true) {
                cat.info("Waiting to accept a new client.");
                Socket socket = serverSocket.accept();
                cat.info("Connected to client at " + socket.getInetAddress());
                cat.info("Starting new socket node.");
                new Thread((Runnable)new SocketNode(socket, LogManager.getLoggerRepository()), "SimpleSocketServer-" + port).start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static void usage(String string) {
        System.err.println(string);
        System.err.println("Usage: java " + SimpleSocketServer.class.getName() + " port configFile");
        System.exit(1);
    }

    static void init(String string, String string2) {
        try {
            port = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            SimpleSocketServer.usage("Could not interpret port number [" + string + "].");
        }
        if (string2.endsWith(".xml")) {
            DOMConfigurator.configure(string2);
        } else {
            PropertyConfigurator.configure(string2);
        }
    }
}

