/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.helpers.LogLog;

public class ZeroConfSupport {
    private static Object jmDNS = ZeroConfSupport.initializeJMDNS();
    Object serviceInfo;
    private static Class jmDNSClass;
    private static Class serviceInfoClass;

    public ZeroConfSupport(String string, int n, String string2, Map map) {
        boolean bl = false;
        try {
            jmDNSClass.getMethod("create", null);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (bl) {
            LogLog.debug("using JmDNS version 3 to construct serviceInfo instance");
            this.serviceInfo = this.buildServiceInfoVersion3(string, n, string2, map);
        } else {
            LogLog.debug("using JmDNS version 1.0 to construct serviceInfo instance");
            this.serviceInfo = this.buildServiceInfoVersion1(string, n, string2, map);
        }
    }

    public ZeroConfSupport(String string, int n, String string2) {
        this(string, n, string2, new HashMap());
    }

    private static Object createJmDNSVersion1() {
        try {
            return jmDNSClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            LogLog.warn("Unable to instantiate JMDNS", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogLog.warn("Unable to instantiate JMDNS", illegalAccessException);
        }
        return null;
    }

    private static Object createJmDNSVersion3() {
        try {
            Method method = jmDNSClass.getMethod("create", null);
            return method.invoke(null, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogLog.warn("Unable to instantiate jmdns class", illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogLog.warn("Unable to access constructor", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogLog.warn("Unable to call constructor", invocationTargetException);
        }
        return null;
    }

    private Object buildServiceInfoVersion1(String string, int n, String string2, Map map) {
        Hashtable hashtable = new Hashtable(map);
        try {
            Class[] classArray = new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Hashtable.class};
            Constructor constructor = serviceInfoClass.getConstructor(classArray);
            Object[] objectArray = new Object[]{string, string2, new Integer(n), new Integer(0), new Integer(0), hashtable};
            Object t = constructor.newInstance(objectArray);
            LogLog.debug("created serviceinfo: " + t);
            return t;
        }
        catch (IllegalAccessException illegalAccessException) {
            LogLog.warn("Unable to construct ServiceInfo instance", illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogLog.warn("Unable to get ServiceInfo constructor", noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            LogLog.warn("Unable to construct ServiceInfo instance", instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogLog.warn("Unable to construct ServiceInfo instance", invocationTargetException);
        }
        return null;
    }

    private Object buildServiceInfoVersion3(String string, int n, String string2, Map map) {
        try {
            Class[] classArray = new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Map.class};
            Method method = serviceInfoClass.getMethod("create", classArray);
            Object[] objectArray = new Object[]{string, string2, new Integer(n), new Integer(0), new Integer(0), map};
            Object object = method.invoke(null, objectArray);
            LogLog.debug("created serviceinfo: " + object);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            LogLog.warn("Unable to invoke create method", illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogLog.warn("Unable to find create method", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogLog.warn("Unable to invoke create method", invocationTargetException);
        }
        return null;
    }

    public void advertise() {
        try {
            Method method = jmDNSClass.getMethod("registerService", serviceInfoClass);
            method.invoke(jmDNS, this.serviceInfo);
            LogLog.debug("registered serviceInfo: " + this.serviceInfo);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogLog.warn("Unable to invoke registerService method", illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogLog.warn("No registerService method", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogLog.warn("Unable to invoke registerService method", invocationTargetException);
        }
    }

    public void unadvertise() {
        try {
            Method method = jmDNSClass.getMethod("unregisterService", serviceInfoClass);
            method.invoke(jmDNS, this.serviceInfo);
            LogLog.debug("unregistered serviceInfo: " + this.serviceInfo);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogLog.warn("Unable to invoke unregisterService method", illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogLog.warn("No unregisterService method", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LogLog.warn("Unable to invoke unregisterService method", invocationTargetException);
        }
    }

    private static Object initializeJMDNS() {
        try {
            jmDNSClass = Class.forName("javax.jmdns.JmDNS");
            serviceInfoClass = Class.forName("javax.jmdns.ServiceInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogLog.warn("JmDNS or serviceInfo class not found", classNotFoundException);
        }
        boolean bl = false;
        try {
            jmDNSClass.getMethod("create", null);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (bl) {
            return ZeroConfSupport.createJmDNSVersion3();
        }
        return ZeroConfSupport.createJmDNSVersion1();
    }

    public static Object getJMDNSInstance() {
        return jmDNS;
    }
}

