/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.mp3;

import com.wowza.io.FileChunk;
import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.io.ScheduledRandomAccessReaderWrapper;
import com.wowza.util.Base64;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.MP3Utils;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameAttachedPicture;
import com.wowza.wms.mediareader.mp3.MP3StreamPosition;
import com.wowza.wms.mediareader.mp3.MediaReaderMP3NodeData;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Header;
import org.farng.mp3.MP3File;
import org.farng.mp3.id3.AbstractID3v2Frame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaReaderMP3
implements IMediaReader {
    public static final int SYNCBLOCKSIZE = 10240;
    protected IRandomAccessReader fileStream = null;
    protected ScheduledRandomAccessReaderWrapper fileReader = null;
    protected Bitstream bitstream = null;
    protected boolean errorReported = false;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = Base64.valueOf((String)"qm-", (int)(-45 - 23));
    protected String mediaReaderExt = Base64.valueOf((String)"dz8", (int)(39 * 47));
    protected byte[] syncHeader;
    protected byte[] packetHeader;
    protected byte[] workBuffer;
    protected MediaReaderItem mediaReaderItem = null;
    protected MediaReaderMP3NodeData nodeData = null;
    protected int frequency = 0;
    protected int bitrate = 0;
    protected int samplesPerFrame = 0;
    protected long streamSize = 0L;
    protected long headerOffset = 0L;
    protected long tailOffset = 0L;
    protected long maxFrames = 0L;
    protected long duration = -1L;
    protected long length = 0L;
    protected int channels = 0;
    protected int layers = 3;
    protected List metaData = null;
    protected boolean justID3Tags = false;
    protected boolean readID3Tags = true;
    protected boolean readAttachedPictures = true;
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = Base64.valueOf((String)".4v", (int)(39 * 5));
    protected long currentSample = 0L;
    protected boolean bitrateErrorSent = false;
    protected int readAheadSize = 16384;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected String randomAccessReaderClass = FileChunk.getChars((int)(49 + 20), (String)"&)*f>%<6,`&?\u007f\u0016:&05#\n84?30\u001f<#$10\u0016 '#-;");
    protected IApplicationInstance appInstance = null;
    protected boolean calculateMoreAccurateFrameSize = false;
    protected int calculateMoreAccurateFrameWindow = 100;
    protected boolean isVBR = false;
    protected long saveLastAudioPos = 0L;
    protected int saveLastAudioSize = 0;
    protected Header h = null;
    protected Map<Integer, ID3V2FrameAttachedPicture> attachedPictures = new HashMap<Integer, ID3V2FrameAttachedPicture>();

    public MediaReaderMP3() {
        this.syncHeader = new byte[4];
        this.packetHeader = new byte[1];
        this.workBuffer = new byte[12];
        this.packetHeader[0] = 47;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperties(WMSProperties wMSProperties) {
        this.justID3Tags = wMSProperties.getPropertyBoolean(Base64.valueOf((String)",2p\u000e053\u0001\ry\u001f-*=", (int)(97 + -32)), false);
        this.readID3Tags = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(-52 - 42), (String)"os7Wcfl@N8Xli|"), this.readID3Tags);
        this.readAttachedPictures = wMSProperties.getPropertyBoolean(FileChunk.getChars((int)(120 + -91), (String)"pn,RdcgEqrfkaoo\\dm{ecw`"), this.readAttachedPictures);
        this.readAheadSize = wMSProperties.getPropertyInt(FileChunk.getChars((int)(21 * 25), (String)"`~<BtswU}sv|Jsay"), this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt(Base64.valueOf((String)"4*h\u000e8?;Aigb`Qtnonoy", (int)(-23 - -16)), this.readAheadTrigger);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr(Base64.valueOf((String)"qekbheHihi~}]upvvfVzvkj", (int)(676 / 189)), this.randomAccessReaderClass);
        this.calculateMoreAccurateFrameSize = wMSProperties.getPropertyBoolean(Base64.valueOf((String)"z{w\u007fhr~tdOlv`Gdk|xjxhH}q|w@}os", (int)(36 + 117)), this.calculateMoreAccurateFrameSize);
        this.calculateMoreAccurateFrameWindow = wMSProperties.getPropertyInt(Base64.valueOf((String)"ij`n{cqew^{gsV{zoi}i{Yr`ofSlhcg~", (int)(52 + 86)), this.calculateMoreAccurateFrameWindow);
        if (!WMSLoggerFactory.getLogger(MediaReaderMP3.class).isDebugEnabled()) {
            return;
        }
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.getChars((int)(63 * 39), (String)"T\u007f\u007fu|LzaegqIU5)ey9YiljNxtswG|lr\"9") + this.readAheadSize);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"]tvzuGsv||hVL.0r0r\u0010&%!\u0007/-(.\u001f>$)(5#hs", (int)(46 - -2)) + this.readAheadTrigger);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"\n--#*\u001e(/+5#\u001f\u0003g{;'k\u0013/((\u0014\u001alT`ep>%", (int)(11 * 21)) + this.justID3Tags);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.getChars((int)(21 * 15), (String)"Vyyw~\u0012$#'!7\u000b\u0017{g';\u007f\u001f+.4\u0018\u0016`\u000041$by") + this.readID3Tags);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"HccahXnmik}]A!=fpwsYmnz\u007fu{{Phawqwct2)", (int)(957 / 169)) + this.readAttachedPictures);
        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(FileChunk.getChars((int)(-5 - -52), (String)"Buu{rFpws}kWK/3l~.%-.\u0005&%\";:\u0018.-)+=\u0013=3 'ov") + this.randomAccessReaderClass);
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderExt = this.mediaReaderType = this.mediaReaderType.toLowerCase();
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.fileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
        this.fileReader = new ScheduledRandomAccessReaderWrapper(this.stream, this.fileStream, this.readAheadSize, this.readAheadTrigger);
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(String var1_1, String var2_2) {
        var3_3 = this.lock;
        synchronized (var3_3) {
            block7: {
                if (this.fileStream.isOpen()) {
                    this.close();
                }
                try {
                    this.fileStream.open();
                    this.fileReader.open();
                    this.bitstream = new Bitstream((IRandomAccessReader)this.fileReader);
                    this.errorReported = false;
                    v0 = this;
                    this.appInstance.notifyMediaReaderOpen((IMediaReader)v0, v0.stream);
                    this.readMetadata();
                    v1 = this;
                    this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)v1, v1.stream);
lbl19:
                    // 2 sources

                    return;
                }
                catch (Exception var4_5) {
                    if (this.errorReported) break block7;
                }
                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"+5#)ri", (int)(30 - -38)) + var4_5.toString());
            }
            this.errorReported = true;
            ** continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close() {
        try {
            Object object = this.lock;
            // MONITORENTER : object
            if (this.bitstream != null) {
                this.bitstream.close();
            }
            this.bitstream = null;
            try {
                if (this.fileReader != null) {
                    WMSLoggerFactory.getLogger(null).debug(FileChunk.getChars((int)(-16 - 27), (String)"\u00183318\b>=9;-\r\u0011qm'))4-\u0012,\" (\u001c*157!\t"));
                    this.fileReader.close();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.getChars((int)(38 + -30), (String)"keexiVhf|t@vuqseE#:") + exception.toString());
            }
            try {
                if (this.fileStream != null) {
                    WMSLoggerFactory.getLogger(null).debug(Base64.valueOf((String)"LggmdTbimoyA]=!s}}`qNp~t|Ionx\u007fr\u001d", (int)(61 * 53)));
                    this.fileStream.close();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.getChars((int)(35 * 61), (String)"446)>\u0007;73%\u001261!$+\u001ari") + exception.toString());
            }
            this.frequency = 0;
            this.samplesPerFrame = 0;
            this.streamSize = 0L;
            this.maxFrames = 0L;
            this.headerOffset = 0L;
            this.tailOffset = 0L;
            this.duration = -1L;
            this.length = 0L;
            this.bitrate = 0;
            // MONITOREXIT : object
            MediaReaderMP3 mediaReaderMP3 = this;
            this.appInstance.notifyMediaReaderClose((IMediaReader)mediaReaderMP3, mediaReaderMP3.stream);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.getChars((int)(16 - -24), (String)"keexi7.") + exception.toString());
            exception.printStackTrace();
            return;
        }
    }

    public boolean isOpen() {
        if (this.fileStream == null) {
            return false;
        }
        return this.fileStream.isOpen();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readMetadata() throws Exception {
        block37: {
            block34: {
                block33: {
                    block35: {
                        block31: {
                            block29: {
                                block30: {
                                    try {
                                        block36: {
                                            this.length = this.fileStream.length();
                                            var1_1 = this.bitstream.readFrame();
                                            if (var1_1 == null) break block29;
                                            this.frequency = var1_1.frequency();
                                            this.bitrate = var1_1.bitrate();
                                            this.samplesPerFrame = var1_1.samples_per_frame();
                                            this.headerOffset = this.bitstream.header_pos();
                                            this.tailOffset = this.bitstream.tail_size();
                                            this.streamSize = this.length - this.headerOffset - this.tailOffset;
                                            this.isVBR = var1_1.vbr();
                                            this.maxFrames = var1_1.max_number_of_frames((int)this.streamSize);
                                            this.duration = this.frequency > 0 ? Math.round(1000.0 * (double)this.samplesPerFrame * (double)this.maxFrames / (double)this.frequency) : 0L;
                                            switch (var1_1.mode()) {
                                                case 2: {
                                                    this.channels = 2;
                                                    ** break;
                                                }
                                                case 1: {
                                                    this.channels = 2;
                                                    ** break;
                                                }
                                                case 3: {
                                                    this.channels = 1;
                                                }
lbl23:
                                                // 4 sources

                                                default: {
                                                    break block36;
                                                }
                                                case 0: 
                                            }
                                            this.channels = 2;
                                        }
                                        this.layers = var1_1.layer();
                                        if (this.readID3Tags) {
                                            ** break;
lbl31:
                                            // 1 sources

                                            this.decodeID3V2Tags();
                                        }
                                        this.bitstream.closeFrame();
                                        break block29;
                                    }
                                    catch (Exception var1_2) {
                                        if (this.errorReported) break block30;
                                    }
                                    WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"*6\"&\u0012{\u0016vm", (int)(39 * 51)) + var1_2.toString());
                                }
                                this.errorReported = true;
                            }
                            if (this.calculateMoreAccurateFrameSize && !this.isVBR) {
                                block32: {
                                    try {
                                        this.bitstream.rewind();
                                        var1_3 = -1L;
                                        var3_6 = 0;
                                        var4_7 = 0;
                                        while (true) {
                                            if (var1_3 > 0L) {
                                                var5_10 = (int)(this.fileReader.getFilePointer() - var1_3);
                                                var3_6 += var5_10;
                                                if (++var4_7 > this.calculateMoreAccurateFrameWindow) break;
                                            }
                                            var1_3 = this.fileReader.getFilePointer();
                                            var5_9 = this.bitstream.readFrame();
                                            if (var5_9 == null) break;
                                            this.bitstream.closeFrame();
                                        }
                                        if (var4_7 <= 0 || (var5_11 = (double)var3_6 / (double)var4_7) <= 0.0) break block31;
                                        this.maxFrames = (int)Math.round((double)this.streamSize / var5_11);
                                        if (this.frequency > 0) {
                                            this.duration = Math.round(1000.0 * (double)this.samplesPerFrame * (double)this.maxFrames / (double)this.frequency);
                                        }
                                        break block31;
                                    }
                                    catch (Exception var1_5) {
                                        if (this.errorReported) break block32;
                                    }
                                    WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"vj~rF,Bza", (int)(19 * 3)) + var1_5.toString());
                                }
                                this.errorReported = true;
                            }
                        }
                        if (this.duration > 0L) {
                            if (this.metaData == null) {
                                this.metaData = new ArrayList<E>();
                            }
                            var1_1 = new AMFDataObj();
                            var2_13 = (double)this.duration / 1000.0;
                            var1_1.put(Base64.valueOf((String)");=1%;<:", (int)(55 + 54)), (AMFData)new AMFDataItem(var2_13));
                            var1_1.put(FileChunk.getChars((int)(182 / 43), (String)"epbngjeoingk"), (AMFData)new AMFDataItem(Base64.valueOf((String)"e!=}", (int)(15 - -60))));
                            if (this.frequency > 0) {
                                var1_1.put(FileChunk.getChars((int)(30 - -57), (String)"6-=34/<3/,$0\"0 "), (AMFData)new AMFDataItem(this.frequency));
                            }
                            if (this.streamSize > 0L && this.duration > 0L) {
                                var1_1.put(FileChunk.getChars((int)(3 + 42), (String)"l{ky~vr`tdvl|"), (AMFData)new AMFDataItem(this.streamSize * 1000L / (this.duration * 1024L)));
                            }
                            var4_8 = new AMFDataList();
                            var4_8.add((AMFData)new AMFDataItem(FileChunk.getChars((int)(915 / 202), (String)"kkKb|hNjxl")));
                            var4_8.add((AMFData)var1_1);
                            var5_12 = var4_8.serialize();
                            this.metaData.add(ByteBuffer.wrap(var5_12));
                        }
                        try {
                            this.bitstream.rewind();
                            this.packetHeader[0] = 34;
                            this.packetHeader[0] = (byte)(this.packetHeader[0] + (this.channels - 1));
                            if (this.frequency < 32000) break block33;
                            this.packetHeader[0] = (byte)(this.packetHeader[0] | 12);
                            break block34;
                        }
                        catch (Exception var1_4) {
                            if (this.errorReported) break block35;
                        }
                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"iwmgQ9Q7.", (int)(1006 / 145)) + var1_4.toString());
                    }
                    this.errorReported = true;
                    ** GOTO lbl107
                }
                if (this.frequency < 22050) break block37;
                this.packetHeader[0] = (byte)(this.packetHeader[0] | 8);
            }
lbl101:
            // 3 sources

            while (true) {
                v0 = this;
                if (v0.isConfigDecodeCapable(v0.stream)) {
                    this.packetHeader[0] = 46;
                    if (this.channels >= 2) {
                        this.packetHeader[0] = (byte)(this.packetHeader[0] | 1);
                    }
                }
lbl107:
                // 6 sources

                if (this.duration > 0L) return;
                throw new Exception(FileChunk.getChars((int)(738 / 200), (String)"NT6&aaeo+jb|bqe2}{a6ayus\u007f2=Dzrn\"gqwgsafd%,^kj{1ezxy6ywm:}is}k).,c47)7-;&2vm") + this.mediaName);
            }
        }
        if (this.frequency < 11025) ** GOTO lbl101
        this.packetHeader[0] = (byte)(this.packetHeader[0] | 4);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean isConfigDecodeCapable(IMediaStream iMediaStream) {
        if (iMediaStream == null) return false;
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        if (iClient.testFlashVersion(nArray) >= 0) return true;
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decodeID3V2Tags() {
        block81: {
            block80: {
                block102: {
                    block68: {
                        block74: {
                            block83: {
                                block82: {
                                    var1_1 = null;
                                    ** try [egrp 1[TRYBLOCK] [18 : 115->2710)] { 
lbl3:
                                    // 1 sources

                                    break block82;
lbl4:
                                    // 1 sources

                                    catch (Exception var2_2) {
                                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"bbkfnnEI=Y\"Estg/6", (int)(1314 / 218)) + var2_2.toString());
                                        var2_2.printStackTrace();
                                    }
lbl7:
                                    // 3 sources

                                    while (true) {
                                        try {
                                            if (var1_1 == null) return;
                                            var1_1.close();
                                            return;
                                        }
                                        catch (Exception var2_4) {
                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.getChars((int)(37 + 53), (String)">>?2::\t\u0005q\u0015v\u0011' ;sj") + var2_4.toString());
                                            return;
                                        }
                                        break;
                                    }
                                }
                                var1_1 = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                                var1_1.open();
                                var2_3 = 0;
                                var3_5 = new AMFDataObj();
                                var4_6 = new MP3File(var1_1, false);
                                if (var4_6 == null) break block74;
                                if (this.stream == null) break block83;
                                v0 /* !! */  = var5_7 = this.stream.getStreams().getVHost().getMp3TagMap();
lbl24:
                                // 2 sources

                                while (true) {
                                    if (!var4_6.hasID3v2Tag()) ** GOTO lbl104
                                    var6_10 = var4_6.getID3v2Tag();
                                    var7_11 = var6_10.iterator();
lbl28:
                                    // 4 sources

                                    while (true) {
                                        block75: {
                                            block94: {
                                                block76: {
                                                    block93: {
                                                        block92: {
                                                            block71: {
                                                                block84: {
                                                                    block91: {
                                                                        block73: {
                                                                            block90: {
                                                                                block69: {
                                                                                    if (!var7_11.hasNext()) break block84;
                                                                                    var8_26 = FileChunk.getChars((int)(43 * 7), (String)"x`d~~e}");
                                                                                    var9_27 = Base64.valueOf((String)"qkmig~d", (int)(551 / 117));
                                                                                    ** try [egrp 9[TRYBLOCK] [17, 16 : 2220->2710)] { 
lbl33:
                                                                                    // 1 sources

                                                                                    break block68;
lbl34:
                                                                                    // 1 sources

                                                                                    catch (Exception var10_29) {
                                                                                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.getChars((int)(-39 - 9), (String)"441<00\u001f\u0013k\u000fh\u000f=:-e`#-'=l|g#,3q") + (String)var9_27 + FileChunk.getChars((int)(47 * 19), (String)"}(>ltg9") + var8_26 + FileChunk.getChars((int)(71 + 20), (String)"{9/,02{") + var10_29.toString());
                                                                                        continue;
                                                                                    }
lbl37:
                                                                                    // 1 sources

                                                                                    catch (UnsupportedOperationException var10_30) {
                                                                                        WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"gaficm@N8Z?Znwb(3vzrn1#:pyd$", (int)(457 / 140)) + (String)var9_27 + FileChunk.getChars((int)(-61 - 41), (String)":m}qkz:") + var8_26 + FileChunk.getChars((int)(36 + -17), (String)"3qgdxj#") + var10_30.toString());
                                                                                        continue;
                                                                                    }
lbl-1000:
                                                                                    // 1 sources

                                                                                    {
                                                                                        while (true) {
                                                                                            block86: {
                                                                                                block70: {
                                                                                                    block85: {
                                                                                                        if (var6_10.getSongTitle() == null || var6_10.getSongTitle().length() <= 0) break block69;
                                                                                                        break block85;
                                                                                                        while (true) {
                                                                                                            var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                                                            break block70;
                                                                                                            break;
                                                                                                        }
                                                                                                    }
                                                                                                    var7_11 = Base64.valueOf((String)"&`\u0001<:2\u0002>,5?", (int)(39 + 73));
                                                                                                    var8_26 = var6_10.getSongTitle();
                                                                                                    if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                                                                    break block86;
                                                                                                }
lbl52:
                                                                                                // 2 sources

                                                                                                while (true) {
                                                                                                    ++var2_3;
                                                                                                    break block69;
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            var3_5.put((String)var9_27.get(FileChunk.getChars((int)(14 + 89), (String)"))$/")), (AMFData)new AMFDataItem(var8_26));
                                                                                            ** continue;
                                                                                            break;
                                                                                        }
                                                                                    }
lbl58:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        block89: {
                                                                                            block72: {
                                                                                                block88: {
                                                                                                    block87: {
                                                                                                        ** try [egrp 3[TRYBLOCK] [3, 4 : 716->844)] { 
lbl60:
                                                                                                        // 1 sources

                                                                                                        break block87;
lbl61:
                                                                                                        // 1 sources

                                                                                                        catch (UnsupportedOperationException var7_12) {
                                                                                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"1y\u001a%%+\u000e!\"=4<'nu", (int)(16 - 41)) + var7_12.toString());
                                                                                                            break block71;
                                                                                                        }
                                                                                                    }
                                                                                                    if (var6_10.getSongComment() == null || var6_10.getSongComment().length() <= 0) break block71;
                                                                                                    break block88;
                                                                                                    while (true) {
                                                                                                        var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                                                        break block72;
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                var7_11 = FileChunk.getChars((int)(57 * 7), (String)"y!B}}sVyzu|to");
                                                                                                var8_26 = var6_10.getSongComment();
                                                                                                if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                                                                break block89;
                                                                                            }
lbl76:
                                                                                            // 2 sources

                                                                                            while (true) {
                                                                                                ++var2_3;
                                                                                                break block71;
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        var3_5.put((String)var9_27.get(Base64.valueOf((String)"kgjm", (int)(1208 / 215))), (AMFData)new AMFDataItem(var8_26));
                                                                                        ** continue;
lbl82:
                                                                                        // 1 sources

                                                                                        catch (Exception var7_18) {
                                                                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.getChars((int)(954 / 155), (String)"p6[fdlObcbu\u007ff)4") + var7_18.toString());
                                                                                            break block71;
                                                                                        }
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                if (var6_10.getLeadArtist() == null || var6_10.getLeadArtist().length() <= 0) ** GOTO lbl179
                                                                                break block90;
                                                                                while (true) {
                                                                                    var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                                    break block73;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            var7_11 = FileChunk.getChars((int)(113 + -84), (String)"k/Se`fBvqot|");
                                                                            var8_26 = var6_10.getLeadArtist();
                                                                            if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                                            break block91;
                                                                        }
lbl98:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            ++var2_3;
                                                                            break;
                                                                        }
                                                                    }
                                                                    var3_5.put((String)var9_27.get(FileChunk.getChars((int)(-2 - -37), (String)"mehc")), (AMFData)new AMFDataItem(var8_26));
                                                                    ** continue;
                                                                }
                                                                if (var4_6.hasID3v1Tag()) {
                                                                    var6_10 = var4_6.getID3v1Tag();
                                                                    ** continue;
                                                                }
                                                                break block74;
                                                            }
                                                            ** try [egrp 5[TRYBLOCK] [7, 8 : 1196->1323)] { 
lbl111:
                                                            // 1 sources

                                                            break block92;
lbl112:
                                                            // 1 sources

                                                            catch (UnsupportedOperationException var7_14) {
                                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"c'Dww}\\yslzza", (int)(33 * 21)) + var7_14.toString());
                                                                break block75;
                                                            }
                                                        }
                                                        if (var6_10.getSongGenre() == null || var6_10.getSongGenre().length() <= 0) break block75;
                                                        break block93;
                                                        while (true) {
                                                            var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                            break block76;
                                                            break;
                                                        }
                                                    }
                                                    var7_11 = FileChunk.getChars((int)(539 / 110), (String)"r4UhfnMnb\u007fk");
                                                    var8_26 = var6_10.getSongGenre();
                                                    if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                    break block94;
                                                }
lbl127:
                                                // 2 sources

                                                while (true) {
                                                    ++var2_3;
                                                    break block75;
                                                    break;
                                                }
                                            }
                                            var3_5.put((String)var9_27.get(FileChunk.getChars((int)(51 - 21), (String)"p~md")), (AMFData)new AMFDataItem(var8_26));
                                            ** continue;
                                        }
lbl134:
                                        // 2 sources

                                        while (true) {
                                            block97: {
                                                block77: {
                                                    block96: {
                                                        block95: {
                                                            ** try [egrp 6[TRYBLOCK] [10, 9 : 1323->1448)] { 
lbl136:
                                                            // 1 sources

                                                            break block95;
lbl137:
                                                            // 1 sources

                                                            catch (Exception var7_13) {
                                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"s7Szhi`Bxcmuc]}Uytbu#:", (int)(746 / 127)) + var7_13.toString());
                                                                break block74;
                                                            }
lbl140:
                                                            // 1 sources

                                                            catch (UnsupportedOperationException var7_16) {
                                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"t2PwgdcG\u007ffnh|@~P~qax,7", (int)(97 + 33)) + var7_16.toString());
                                                                break block74;
                                                            }
                                                        }
                                                        if (var6_10.getTrackNumberOnAlbum() == null || var6_10.getTrackNumberOnAlbum().length() <= 0) break block74;
                                                        break block96;
                                                        while (true) {
                                                            var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                            break block77;
                                                            break;
                                                        }
                                                    }
                                                    var7_11 = FileChunk.getChars((int)(31 + 1), (String)"v0VqefmI}dhn~B`N|sg~");
                                                    var8_26 = var6_10.getTrackNumberOnAlbum();
                                                    if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                    break block97;
                                                }
lbl155:
                                                // 2 sources

                                                while (true) {
                                                    ++var2_3;
                                                    break block74;
                                                    break;
                                                }
                                            }
                                            var3_5.put((String)var9_27.get(Base64.valueOf((String)"ocna", (int)(91 + 38))), (AMFData)new AMFDataItem(var8_26));
                                            ** continue;
                                            break;
                                        }
lbl-1000:
                                        // 4 sources

                                        {
                                            while (true) {
                                                block99: {
                                                    block78: {
                                                        block98: {
                                                            if (var6_10.getYearReleased() == null || var6_10.getYearReleased().length() <= 0) ** GOTO lbl58
                                                            break block98;
                                                            while (true) {
                                                                var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                break block78;
                                                                break;
                                                            }
                                                        }
                                                        var7_11 = FileChunk.getChars((int)(351 / 92), (String)"u5\\cfz[ogil}jt");
                                                        var8_26 = var6_10.getYearReleased();
                                                        if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                        break block99;
                                                    }
lbl173:
                                                    // 2 sources

                                                    while (true) {
                                                        ++var2_3;
                                                        ** continue;
                                                        break;
                                                    }
                                                }
                                                var3_5.put((String)var9_27.get(FileChunk.getChars((int)(41 - 47), (String)"4:18")), (AMFData)new AMFDataItem(var8_26));
                                                ** continue;
                                                break;
                                            }
                                        }
lbl179:
                                        // 4 sources

                                        while (true) {
                                            try {
                                                block101: {
                                                    block79: {
                                                        block100: {
                                                            if (var6_10.getAlbumTitle() == null || var6_10.getAlbumTitle().length() <= 0) ** GOTO lbl-1000
                                                            break block100;
                                                            while (true) {
                                                                var3_5.put((String)var7_11, (AMFData)new AMFDataItem(var8_26));
                                                                break block79;
                                                                break;
                                                            }
                                                        }
                                                        var7_11 = FileChunk.getChars((int)(11 - 24), (String)"%e\u0014:5-4\u000e2(1;");
                                                        var8_26 = var6_10.getAlbumTitle();
                                                        if ((var9_27 = (Map)var5_7.get(var7_11)) == null) ** continue;
                                                        break block101;
                                                    }
lbl192:
                                                    // 2 sources

                                                    while (true) {
                                                        ++var2_3;
                                                        ** GOTO lbl-1000
                                                        break;
                                                    }
                                                }
                                                var3_5.put((String)var9_27.get(Base64.valueOf((String)"\u007fs~q", (int)(56 + 89))), (AMFData)new AMFDataItem(var8_26));
                                                ** continue;
                                            }
                                            catch (Exception var7_21) {
                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"&`\u0013?6 ;\u00031-6>f}", (int)(118 + 122)) + var7_21.toString());
                                                ** GOTO lbl-1000
                                            }
                                            catch (UnsupportedOperationException var7_22) {
                                                WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"j,_sbtoWmqjb2)", (int)(-10 - -38)) + var7_22.toString());
                                                ** continue;
                                            }
                                            break;
                                        }
                                        catch (UnsupportedOperationException var7_23) {
                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).debug(Base64.valueOf((String)"{?CupvRfa\u007fdl#:", (int)(49 * 29)) + var7_23.toString());
                                        }
lbl207:
                                        // 1 sources

                                        catch (Exception var7_24) {
                                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.getChars((int)(-17 - 53), (String)"l*Orpx\u0007$,1!\u007ff") + var7_24.toString());
                                            ** continue;
                                        }
                                        break;
                                    }
                                    break;
                                }
                            }
                            v0 /* !! */  = new HashMap<K, V>();
                            ** while (true)
                        }
                        if (!(var5_7 = WMSLoggerFactory.getLogger(MediaReaderMP3.class)).isDebugEnabled()) {
                            var5_7 = null;
                        }
                        this.metaData = null;
                        if (var2_3 <= 0) ** GOTO lbl7
                        if (this.metaData != null) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                if (var5_7 != null) {
                                    for (var6_8 = 0; var6_8 < var2_3; ++var6_8) {
                                        var7_11 = var3_5.getKey(var6_8);
                                        var8_26 = (AMFDataItem)var3_5.get((String)var7_11);
                                        var5_7.debug(FileChunk.getChars((int)(93 + -19), (String)"%%\u0005\t}up") + (String)var7_11 + "=" + var8_26.toString());
                                    }
                                }
                                var6_9 = new AMFDataList();
                                var6_9.add((AMFData)new AMFDataItem(FileChunk.getChars((int)(35 * 11), (String)"nlJ@6")));
                                var6_9.add((AMFData)var3_5);
                                var7_11 = var6_9.serialize();
                                this.metaData.add(ByteBuffer.wrap((byte[])var7_11));
                                ** continue;
                                break;
                            }
                        }
                        this.metaData = new ArrayList<E>();
                        ** while (true)
                        catch (Exception var7_25) {
                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(Base64.valueOf((String)"*l\u0012:!%\u000310,53ri", (int)(21 + 71)) + var7_25.toString());
                            ** continue;
                        }
lbl238:
                        // 1 sources

                        ** GOTO lbl179
                    }
                    var10_28 = (AbstractID3v2Frame)var7_11.next();
                    var11_31 = var10_28.getBody();
                    if (var11_31 == null) ** GOTO lbl28
                    var9_27 = var10_28.getIdentifier();
                    var12_32 = var9_27;
                    if (var12_32.length() > 4) break block102;
lbl246:
                    // 2 sources

                    while (true) {
                        var8_26 = var11_31.getBriefDescription();
                        if (var8_26 == null) ** GOTO lbl28
                        if (this.readAttachedPictures) break block80;
lbl250:
                        // 4 sources

                        while (true) {
                            var13_33 = (Map)var5_7.get(var12_32);
                            if (var13_33 != null) {
                                var14_37 = (String)var13_33.get(Base64.valueOf((String)"mehc", (int)(160 / 49)));
                                if (var14_37 == null) {
                                    var3_5.put((String)var9_27, (AMFData)new AMFDataItem(var8_26));
lbl256:
                                    // 3 sources

                                    while (true) {
                                        ++var2_3;
                                        ** continue;
                                        break;
                                    }
                                }
                                break block81;
                            }
                            var3_5.put((String)var9_27, (AMFData)new AMFDataItem(var8_26));
                            ** GOTO lbl256
                            break;
                        }
                        break;
                    }
                }
                var12_32 = var12_32.substring(0, 4);
                ** while (true)
            }
            if (!var12_32.equals(Base64.valueOf((String)"J\\DM", (int)(37 * 15)))) ** GOTO lbl250
            var13_34 = 0;
            var14_38 = 16;
            var15_39 = null;
            var16_40 = null;
            var17_41 = null;
            try {
                var18_42 = (Long)var11_31.getObject(Base64.valueOf((String)"C}an;Ys}pdhld", (int)(27 * 53)));
                if (var18_42 != null) {
                    var13_34 = var18_42.intValue();
                }
                if ((var19_44 = (Long)var11_31.getObject(FileChunk.getChars((int)(17 * 17), (String)"Qk`pptb(]s{i"))) != null) {
                    var14_38 = var19_44.intValue();
                }
                var15_39 = (String)var11_31.getObject(Base64.valueOf((String)"\u0000\u0007\u0002\u0015q\u0006*$0", (int)(30 + 47)));
                var16_40 = (String)var11_31.getObject(Base64.valueOf((String)"\u000e.?.<& %;<:", (int)(127 + 107)));
                var17_41 = (byte[])var11_31.getObject(Base64.valueOf((String)"Isxhhlz`\u0005#7%", (int)(117 + 68)));
lbl281:
                // 2 sources

                while (true) {
                    if (var17_41 == null) ** GOTO lbl250
                    break;
                }
            }
            catch (Exception var18_43) {
                ** continue;
            }
            {
                var18_42 = new ID3V2FrameAttachedPicture();
                var18_42.setTextEncoding(var13_34);
                var18_42.setPictureType(var14_38);
                var18_42.setPictureData(var17_41);
                if (var15_39 != null) {
                    var18_42.setMimeType(var15_39);
                }
                if (var16_40 != null) {
                    var18_42.setDescription(var16_40);
                }
                this.attachedPictures.put(new Integer(var14_38), (ID3V2FrameAttachedPicture)var18_42);
                ** continue;
            }
        }
        var3_5.put(var14_37, (AMFData)new AMFDataItem(var8_26));
        ** while (true)
    }

    public List getMetadata() {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rewind() {
        if (this.bitstream == null) {
            return;
        }
        synchronized (this.lock) {
            this.bitstream.rewind();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected long sample2TC(long l) {
        return l * 1000L / (long)this.frequency;
    }

    protected long sample290(long l) {
        return l * 90000L / (long)this.frequency;
    }

    protected long tc2Sample(long l) {
        return l * (long)this.frequency / 1000L;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void touchClient() {
        if (this.stream == null) {
            return;
        }
        IClient iClient = this.stream.getClient();
        if (iClient != null) {
            iClient.touch();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlaylistSeekResult seek(long l, int n) {
        MP3StreamPosition mP3StreamPosition;
        long l2;
        long l3;
        PlaylistSeekResult playlistSeekResult = null;
        if (l <= 0L) {
            l = 0L;
        }
        if (!this.fileStream.exists()) {
            return null;
        }
        if (this.duration > 0L) {
            block18: {
                if (l > this.duration) {
                    l = this.duration;
                }
                l3 = -1L;
                l2 = 0L;
                mP3StreamPosition = null;
                if (l <= 0L) {
                    l3 = this.headerOffset;
                    l2 = 0L;
                } else {
                    long l4 = this.headerOffset + this.streamSize * l / this.duration;
                    if (l4 >= this.headerOffset + this.streamSize) {
                        l3 = this.headerOffset + this.streamSize;
                        l2 = this.maxFrames * (long)this.samplesPerFrame;
                    } else {
                        try {
                            mP3StreamPosition = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                            mP3StreamPosition.open();
                            long l5 = 10240L;
                            if (l4 + l5 > mP3StreamPosition.length()) {
                                long l6 = this.maxFrames > 0L ? this.streamSize / this.maxFrames : 256L;
                                if (l6 > 0L && l6 < l4) {
                                    l4 -= l6;
                                }
                                l5 = mP3StreamPosition.length() - l4;
                            }
                            mP3StreamPosition.seek(l4);
                            byte[] byArray = new byte[(int)l5];
                            this.touchClient();
                            mP3StreamPosition.read(byArray, 0, byArray.length);
                            this.touchClient();
                            int n2 = MP3Utils.decodeFirstChunkMP3((byte[])byArray, (int)0, (long)byArray.length, (int)this.bitrate);
                            this.touchClient();
                            if (n2 >= 0) {
                                l3 = l4 + (long)n2;
                                l2 = this.maxFrames * (long)this.samplesPerFrame * l / this.duration;
                                break block18;
                            }
                            if ((double)l * 100.0 / (double)this.duration > 95.0) {
                                l3 = this.headerOffset + this.streamSize;
                                l2 = this.maxFrames * (long)this.samplesPerFrame;
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            try {
                if (mP3StreamPosition != null) {
                    mP3StreamPosition.close();
                }
            }
            catch (Exception exception) {}
            mP3StreamPosition = null;
            if (l3 >= 0L) {
                playlistSeekResult = new PlaylistSeekResult(0L);
                MP3StreamPosition mP3StreamPosition2 = new MP3StreamPosition(l3, l2);
                playlistSeekResult.setResults((IMediaReaderStreamPosition)mP3StreamPosition2, this.sample2TC(l2), 8, 0);
                playlistSeekResult.setVideoStreamPos(null);
            }
        }
        if (playlistSeekResult != null) return playlistSeekResult;
        l3 = this.headerOffset;
        l2 = 0L;
        playlistSeekResult = new PlaylistSeekResult(0L);
        mP3StreamPosition = new MP3StreamPosition(l3, l2);
        playlistSeekResult.setResults((IMediaReaderStreamPosition)mP3StreamPosition, 0L, 8, 0);
        playlistSeekResult.setVideoStreamPos(null);
        return playlistSeekResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMediaReaderStreamPosition getStreamPosition() {
        MP3StreamPosition mP3StreamPosition = new MP3StreamPosition();
        try {
            mP3StreamPosition.setSample(this.currentSample);
            if (this.fileStream == null) return mP3StreamPosition;
            mP3StreamPosition.setFilePos(this.fileStream.getFilePointer());
            return mP3StreamPosition;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.getChars((int)(116 + 97), (String)"23#\u001e06>\f2714$0yd") + exception.toString());
            return mP3StreamPosition;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        MP3StreamPosition mP3StreamPosition = (MP3StreamPosition)iMediaReaderStreamPosition;
        try {
            if (this.fileReader != null) {
                this.fileReader.seek(mP3StreamPosition.getFilePos());
            }
            this.currentSample = mP3StreamPosition.getSample();
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.getChars((int)(49 * 27), (String)"liyHf|tB|}{brj#:") + exception.toString());
            return;
        }
    }

    public int rewriteLastPacket(int n, long l, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, long[] lArray, FastPlaySettings fastPlaySettings) {
        return 0;
    }

    public void startPlayback() {
    }

    public int writeGeneratedKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        int n = 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        int n = 0;
        if (this.justID3Tags) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        if (this.duration <= 0L) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        synchronized (this.lock) {
            if (this.bitstream == null) {
                playlistReaderWriteResults.setHitEnd(true);
                // ** MonitorExit[var13_13] (shouldn't be in output)
                return n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDuration() {
        long l = 0L;
        if (this.duration >= 0L) {
            return this.duration;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        long l2 = 0L;
        long l3 = 0L;
        Bitstream bitstream = null;
        IRandomAccessReader iRandomAccessReader = null;
        try {
            iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
            iRandomAccessReader.open();
            bitstream = new Bitstream(iRandomAccessReader);
            Header header = bitstream.readFrame();
            if (header != null) {
                n = header.frequency();
                n2 = header.samples_per_frame();
                long l4 = bitstream.header_pos();
                long l5 = bitstream.tail_size();
                l2 = iRandomAccessReader.length() - l4 - l5;
                bl = header.vbr();
                int n3 = header.max_number_of_frames((int)l2);
                l3 = n > 0 ? Math.round(1000.0 * (double)n2 * (double)n3 / (double)n) : 0L;
                bitstream.closeFrame();
            }
            bitstream.close();
            iRandomAccessReader.close();
            l = l3;
        }
        catch (Exception exception) {}
        if (this.calculateMoreAccurateFrameSize && !bl) {
            double d;
            int n4;
            int n5;
            long l6;
            try {
                bitstream.rewind();
                l6 = -1L;
                n5 = 0;
                n4 = 0;
            }
            catch (Exception exception) {
            }
            while (true) {
                if (l6 > 0L) {
                    int n6 = (int)(iRandomAccessReader.getFilePointer() - l6);
                    n5 += n6;
                    if (++n4 > this.calculateMoreAccurateFrameWindow) break;
                }
                l6 = iRandomAccessReader.getFilePointer();
                Header header = bitstream.readFrame();
                if (header == null) break;
                bitstream.closeFrame();
            }
            if (n4 > 0 && !((d = (double)n5 / (double)n4) <= 0.0)) {
                int n7 = (int)Math.round((double)l2 / d);
                if (n > 0) {
                    l3 = Math.round(1000.0 * (double)n2 * (double)n7 / (double)n);
                }
                l = l3;
            }
        }
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {}
        }
        iRandomAccessReader = null;
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() {
        if (this.fileStream == null) return 0L;
        long l = this.fileStream.length();
        return l;
    }

    public String getPath() {
        return this.fileStream.getPath();
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writePackets(List<AMFPacket> list, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings) {
        int n = 0;
        if (this.justID3Tags) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        if (this.duration <= 0L) {
            playlistReaderWriteResults.setHitEnd(true);
            return n;
        }
        synchronized (this.lock) {
            if (this.bitstream == null) {
                playlistReaderWriteResults.setHitEnd(true);
                // ** MonitorExit[var8_8] (shouldn't be in output)
                return n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AMFPacket createPacket(Header header) {
        int n = 8;
        AMFPacket aMFPacket = new AMFPacket(n, 0, this.bitstream.framesize + 4 + 1);
        try {
            byte[] byArray = aMFPacket.getData();
            byArray[0] = this.packetHeader[0];
            header.getSyncHeader(this.syncHeader);
            aMFPacket.addDataEx(this.syncHeader, 0, 1, 4);
            aMFPacket.addDataEx(this.bitstream.frame_bytes, 0, 5, this.bitstream.framesize);
            return aMFPacket;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error(FileChunk.getChars((int)(90 + -19), (String)"\n--#*\u001e(/+5#\u001f\u0003g{5%=8.>\f<=4%5xc") + exception.toString());
            exception.printStackTrace();
            return aMFPacket;
        }
    }
}

