/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.net.ServerSocket;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.support.BaseIoAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfigImpl;

public class SocketAcceptorConfig
extends BaseIoAcceptorConfig {
    private IoSessionConfig sessionConfig = new SocketSessionConfigImpl();
    private int backlog = 50;
    private boolean reuseAddress;

    public SocketAcceptorConfig() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket();
            this.reuseAddress = serverSocket.getReuseAddress();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException("Failed to get the default configuration.", iOException);
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                }
            }
        }
    }

    public IoSessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean bl) {
        this.reuseAddress = bl;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int n) {
        this.backlog = n;
    }
}

