/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.AbstractIoFilterChain;
import org.apache.mina.transport.socket.nio.support.DatagramAcceptorDelegate;
import org.apache.mina.transport.socket.nio.support.DatagramConnectorDelegate;
import org.apache.mina.transport.socket.nio.support.DatagramService;
import org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.apache.mina.util.Queue;

class DatagramFilterChain
extends AbstractIoFilterChain {
    DatagramFilterChain(IoSession ioSession) {
        super(ioSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(IoSession ioSession, IoFilter.WriteRequest writeRequest) {
        DatagramSessionImpl datagramSessionImpl = (DatagramSessionImpl)ioSession;
        Queue queue = datagramSessionImpl.getWriteRequestQueue();
        ((ByteBuffer)writeRequest.getMessage()).mark();
        Queue queue2 = queue;
        synchronized (queue2) {
            queue.push(writeRequest);
        }
        if (ioSession.getTrafficMask().isWritable()) {
            datagramSessionImpl.getManagerDelegate().flushSession(datagramSessionImpl);
        }
    }

    protected void doClose(IoSession ioSession) {
        DatagramSessionImpl datagramSessionImpl = (DatagramSessionImpl)ioSession;
        DatagramService datagramService = datagramSessionImpl.getManagerDelegate();
        if (datagramService instanceof DatagramConnectorDelegate) {
            ((DatagramConnectorDelegate)datagramService).closeSession(datagramSessionImpl);
        } else {
            ((DatagramAcceptorDelegate)datagramService).getListeners().fireSessionDestroyed(ioSession);
            ioSession.getCloseFuture().setClosed();
        }
    }
}

