/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264;

import com.wowza.wms.mediareader.h264.H264CursorPosition;
import com.wowza.wms.mediareader.h264.atom.IQTMediaCursor;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.mediareader.h264.atom.QTMediaCursor;

public class H264Cursor {
    protected QTAtomtrak videoTrackAtom = null;
    protected QTAtomtrak audioTrackAtom = null;
    protected QTAtomtrak dataTrackAtom = null;
    protected IQTMediaCursor dCursor = null;
    protected boolean dAtEnd = false;
    protected IQTMediaCursor vCursor = null;
    protected boolean vAtEnd = false;
    protected IQTMediaCursor aCursor = null;
    protected boolean aAtEnd = false;
    protected int cursorType = 0;

    public H264Cursor(QTAtomtrak qTAtomtrak, QTAtomtrak qTAtomtrak2, QTAtomtrak qTAtomtrak3) {
        this.videoTrackAtom = qTAtomtrak;
        this.audioTrackAtom = qTAtomtrak2;
        this.dataTrackAtom = qTAtomtrak3;
        this.a();
    }

    public H264Cursor(QTAtomtrak qTAtomtrak, QTAtomtrak qTAtomtrak2, QTAtomtrak qTAtomtrak3, int n) {
        this.videoTrackAtom = qTAtomtrak;
        this.audioTrackAtom = qTAtomtrak2;
        this.dataTrackAtom = qTAtomtrak3;
        this.a();
    }

    private void a() {
        this.initDataCursor();
        this.initVideoCursor();
        this.initAudioCursor();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initAudioCursor() {
        IQTMediaCursor iQTMediaCursor = this.aCursor = this.audioTrackAtom == null ? null : new QTMediaCursor(this.audioTrackAtom);
        if (this.aCursor != null) {
            this.aCursor.setCursorType(this.cursorType);
        }
        if (this.aCursor != null) return;
        this.aAtEnd = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initVideoCursor() {
        IQTMediaCursor iQTMediaCursor = this.vCursor = this.videoTrackAtom == null ? null : new QTMediaCursor(this.videoTrackAtom);
        if (this.vCursor != null) {
            this.vCursor.setCursorType(this.cursorType);
        }
        if (this.vCursor != null) return;
        this.vAtEnd = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initDataCursor() {
        IQTMediaCursor iQTMediaCursor = this.dCursor = this.dataTrackAtom == null ? null : new QTMediaCursor(this.dataTrackAtom);
        if (this.dCursor != null) {
            this.dCursor.setCursorType(this.cursorType);
        }
        if (this.dCursor != null) return;
        this.dAtEnd = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsAudio() {
        if (this.audioTrackAtom == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsVideo() {
        if (this.videoTrackAtom == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsData() {
        if (this.dataTrackAtom == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void close() {
        if (this.dCursor != null) {
            this.dCursor.close();
        }
        this.dCursor = null;
        if (this.vCursor != null) {
            this.vCursor.close();
        }
        this.vCursor = null;
        if (this.aCursor != null) {
            this.aCursor.close();
        }
        this.aCursor = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IQTMediaCursor b() {
        IQTMediaCursor iQTMediaCursor = null;
        if (this.vAtEnd && this.aAtEnd) {
            if (this.dAtEnd) return null;
        }
        switch (this.getCurrentType()) {
            case 8: {
                return this.aCursor;
            }
            case 9: {
                return this.vCursor;
            }
            case 18: {
                return this.dCursor;
            }
        }
        return iQTMediaCursor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getCurrentType() {
        int n = 0;
        if (this.vAtEnd && this.aAtEnd && this.dAtEnd) {
            return n;
        }
        long l = this.dAtEnd || this.dCursor == null ? Long.MAX_VALUE : this.dCursor.getTimeMillis();
        long l2 = !this.vAtEnd && this.vCursor != null ? this.vCursor.getTimeMillis() : Long.MAX_VALUE;
        long l3 = !this.aAtEnd && this.aCursor != null ? this.aCursor.getTimeMillis() : Long.MAX_VALUE;
        n = l > l3 || l > l2 ? (l3 > l || l3 > l2 ? 9 : 8) : 18;
        IQTMediaCursor iQTMediaCursor = null;
        switch (n) {
            case 9: {
                iQTMediaCursor = this.vCursor;
                break;
            }
            case 8: {
                iQTMediaCursor = this.aCursor;
                break;
            }
            case 18: {
                iQTMediaCursor = this.dCursor;
                break;
            }
        }
        if (iQTMediaCursor != null) return n;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isAtEnd() {
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        if (this.dAtEnd) return true;
        return false;
    }

    public boolean isAtAudioEnd() {
        return this.aAtEnd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAtVideoEnd() {
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        return true;
    }

    public boolean isAtDataEnd() {
        return this.dAtEnd;
    }

    public long getTimeMillis() {
        return this.b().getTimeMillis();
    }

    public long getTimeSL() {
        return this.b().getTimeSL();
    }

    public long getTimeScaled(int n) {
        return this.b().getTimeScaled(n);
    }

    public long getAudioTimescale() {
        if (this.aCursor == null) {
            return 0L;
        }
        return this.aCursor.getTimescale();
    }

    public long getDataTimescale() {
        if (this.dCursor == null) {
            return 0L;
        }
        return this.dCursor.getTimescale();
    }

    public long getVideoTimescale() {
        if (this.vCursor == null) {
            return 0L;
        }
        return this.vCursor.getTimescale();
    }

    public double getSeekPoint() {
        return this.b().getSeekPoint();
    }

    public int getCTTS() {
        return this.b().getCTTS();
    }

    public int getCTTSMillis() {
        return this.b().getCTTSMillis();
    }

    public long getFileLoc() {
        return this.b().getFileLoc();
    }

    public long getSample() {
        return this.b().getSample();
    }

    public long getSampleDesc() {
        return this.b().getSampleDesc();
    }

    public boolean getAudioSampleValid(long l) {
        if (this.aCursor == null) {
            return false;
        }
        return this.aCursor.isSampleValid(l);
    }

    public boolean getDataSampleValid(long l) {
        if (this.dCursor == null) {
            return false;
        }
        return this.dCursor.isSampleValid(l);
    }

    public boolean getVideoSampleValid(long l) {
        if (this.vCursor == null) {
            return false;
        }
        return this.vCursor.isSampleValid(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getAudioSample() {
        if (this.aCursor == null) {
            return -1L;
        }
        long l = this.aCursor.getSample();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAudioSample(long l) {
        if (this.aCursor == null) return;
        if (l < 0L) return;
        boolean bl = this.aCursor.moveToSample(l);
        if (!bl) return;
        this.aAtEnd = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDataSample(long l) {
        if (this.dCursor == null) return;
        if (l < 0L) return;
        boolean bl = this.dCursor.moveToSample(l);
        if (!bl) return;
        this.dAtEnd = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDataAtEnd() {
        if (this.dCursor == null) return;
        if (this.dCursor.getSampleCount() > 0L) {
            IQTMediaCursor iQTMediaCursor = this.dCursor;
            iQTMediaCursor.moveToSample(iQTMediaCursor.getSampleCount() - 1L);
        }
        this.dAtEnd = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setVideoSample(long l) {
        if (this.vCursor == null) return;
        if (l < 0L) return;
        boolean bl = this.vCursor.moveToSample(l);
        if (!bl) return;
        this.vAtEnd = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getDataSample() {
        if (this.dCursor == null) {
            return -1L;
        }
        long l = this.dCursor.getSample();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getVideoSample() {
        if (this.vCursor == null) {
            return -1L;
        }
        long l = this.vCursor.getSample();
        return l;
    }

    public boolean isKeyFrame() {
        return this.b().isKeyFrame();
    }

    public long getSize() {
        return this.b().getSize();
    }

    public long dataGetTotalTrackSize() {
        if (this.dCursor == null) {
            return 0L;
        }
        return this.dCursor.getTotalTrackSize();
    }

    public int videoGetTrackBitrate(long l) {
        if (this.vCursor == null) {
            return 0;
        }
        return this.vCursor.getTrackBiterate(l);
    }

    public int audioGetTrackBitrate(long l) {
        if (this.aCursor == null) {
            return 0;
        }
        return this.aCursor.getTrackBiterate(l);
    }

    public long videoGetTotalTrackSize() {
        if (this.vCursor == null) {
            return 0L;
        }
        return this.vCursor.getTotalTrackSize();
    }

    public long audioGetTotalTrackSize() {
        if (this.aCursor == null) {
            return 0L;
        }
        return this.aCursor.getTotalTrackSize();
    }

    public long dataFindKeySample(long l, int n) {
        if (this.dCursor == null) {
            return -1L;
        }
        return this.dCursor.findKeySample(l, n);
    }

    public long videoFindKeySample(long l, int n) {
        if (this.vCursor == null) {
            return -1L;
        }
        return this.vCursor.findKeySample(l, n);
    }

    public long dataTimecodeToSample(long l) {
        if (this.dCursor == null) {
            return -1L;
        }
        return this.dCursor.timecodeToSample(l);
    }

    public long videoTimecodeToSample(long l) {
        if (this.vCursor == null) {
            return -1L;
        }
        return this.vCursor.timecodeToSample(l);
    }

    public long dataSampleToTimecode(long l) {
        if (this.dCursor == null) {
            return -1L;
        }
        return this.dCursor.sampleToTimecode(l);
    }

    public long videoSampleToTimecode(long l) {
        if (this.vCursor == null) {
            return -1L;
        }
        return this.vCursor.sampleToTimecode(l);
    }

    public long dataTimeMillisToTimecode(long l) {
        if (this.dCursor == null) {
            return 0L;
        }
        return this.dCursor.timeMillisToTimecode(l);
    }

    public long videoTimeMillisToTimecode(long l) {
        if (this.vCursor == null) {
            return 0L;
        }
        return this.vCursor.timeMillisToTimecode(l);
    }

    public long dataTimecodeToTimeMillis(long l) {
        if (this.dCursor == null) {
            return 0L;
        }
        return this.dCursor.timecodeToTimeMillis(l);
    }

    public long videoTimecodeToTimeMillis(long l) {
        if (this.vCursor == null) {
            return 0L;
        }
        return this.vCursor.timecodeToTimeMillis(l);
    }

    public long dataTimecodeToTimeSL(long l) {
        if (this.dCursor == null) {
            return 0L;
        }
        return this.dCursor.timecodeToTimeSL(l);
    }

    public long videoTimecodeToTimeSL(long l) {
        if (this.vCursor == null) {
            return 0L;
        }
        return this.vCursor.timecodeToTimeSL(l);
    }

    public long audioTimecodeToSample(long l) {
        if (this.aCursor == null) {
            return -1L;
        }
        return this.aCursor.timecodeToSample(l);
    }

    public long audioSampleToTimecode(long l) {
        if (this.aCursor == null) {
            return -1L;
        }
        return this.aCursor.sampleToTimecode(l);
    }

    public long audioTimeMillisToTimecode(long l) {
        if (this.aCursor == null) {
            return 0L;
        }
        return this.aCursor.timeMillisToTimecode(l);
    }

    public long audioTimecodeToTimeMillis(long l) {
        if (this.aCursor == null) {
            return 0L;
        }
        return this.aCursor.timecodeToTimeMillis(l);
    }

    public long audioTimecodeToTimeSL(long l) {
        if (this.aCursor == null) {
            return 0L;
        }
        return this.aCursor.timecodeToTimeSL(l);
    }

    public long getAudioSampleCount() {
        if (this.aCursor == null) {
            return -1L;
        }
        return this.aCursor.getSampleCount();
    }

    public long getDataSampleCount() {
        if (this.dCursor == null) {
            return -1L;
        }
        return this.dCursor.getSampleCount();
    }

    public long getVideoSampleCount() {
        if (this.vCursor == null) {
            return -1L;
        }
        return this.vCursor.getSampleCount();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean movePrevSample() {
        block7: {
            block6: {
                block5: {
                    int n = this.getCurrentType();
                    switch (n) {
                        case 9: {
                            if (this.vCursor.movePrevSample()) break;
                            break block5;
                        }
                        case 8: {
                            if (this.aCursor.movePrevSample()) break;
                            break block6;
                        }
                        case 18: {
                            if (this.dCursor.movePrevSample()) break;
                            this.dAtEnd = true;
                        }
                    }
                    break block7;
                }
                this.vAtEnd = true;
                break block7;
            }
            this.aAtEnd = true;
        }
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        if (this.dAtEnd) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean moveNextSample() {
        int n = this.getCurrentType();
        switch (n) {
            case 9: {
                if (this.vCursor.moveNextSample()) break;
                this.vAtEnd = true;
                break;
            }
            case 18: {
                if (this.dCursor.moveNextSample()) break;
                this.dAtEnd = true;
                break;
            }
            case 8: {
                if (this.aCursor.moveNextSample()) break;
                this.aAtEnd = true;
            }
        }
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        if (this.dAtEnd) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean moveNextAudioSample() {
        if (this.aCursor != null && !this.aCursor.moveNextSample()) {
            this.aAtEnd = true;
        }
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        if (!this.dAtEnd) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean moveNextVideoSample() {
        if (this.vCursor != null && !this.vCursor.moveNextSample()) {
            this.vAtEnd = true;
        }
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        if (this.dAtEnd) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean moveNextDataSample() {
        if (this.dCursor != null && !this.dCursor.moveNextSample()) {
            this.dAtEnd = true;
        }
        if (!this.vAtEnd) return false;
        if (!this.aAtEnd) return false;
        if (!this.dAtEnd) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetAudioAtEnd() {
        this.aAtEnd = false;
        if (this.aCursor != null) {
            return;
        }
        this.aAtEnd = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetVideoAtEnd() {
        this.vAtEnd = false;
        if (this.vCursor != null) {
            return;
        }
        this.vAtEnd = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetDataAtEnd() {
        this.dAtEnd = false;
        if (this.dCursor != null) {
            return;
        }
        this.dAtEnd = true;
    }

    public void setCurrentPosition(H264CursorPosition h264CursorPosition) {
        this.setAudioSample(h264CursorPosition.getAudioSample());
        this.setVideoSample(h264CursorPosition.getVideoSample());
        this.setDataSample(h264CursorPosition.getDataSample());
        this.vAtEnd = h264CursorPosition.isVAtEnd();
        this.aAtEnd = h264CursorPosition.isAAtEnd();
        this.dAtEnd = h264CursorPosition.isDAtEnd();
    }

    public H264CursorPosition getCurrentPosition() {
        return new H264CursorPosition(this.getVideoSample(), this.vAtEnd, this.getAudioSample(), this.aAtEnd, this.getDataSample(), this.dAtEnd);
    }

    public int getDataKeyFrameCount() {
        if (this.dCursor != null) {
            return this.dCursor.getKeyFrameCount();
        }
        return 0;
    }

    public int getVideoKeyFrameCount() {
        if (this.vCursor != null) {
            return this.vCursor.getKeyFrameCount();
        }
        return 0;
    }

    public long getDataKeyFrameSample(int n) {
        if (this.dCursor != null) {
            return this.dCursor.getKeyFrameSample(n);
        }
        return -1L;
    }

    public long getVideoKeyFrameSample(int n) {
        if (this.vCursor != null) {
            return this.vCursor.getKeyFrameSample(n);
        }
        return -1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getDataKeyFrameTimesMillis() {
        long[] lArray = null;
        if (this.dCursor == null) return lArray;
        return this.dCursor.getKeyFrameTimesMillis();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getKeyFrameTimesMillis() {
        long[] lArray = null;
        if (this.vCursor == null) return lArray;
        return this.vCursor.getKeyFrameTimesMillis();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getDataKeyFrameTimecodes() {
        long[] lArray = null;
        if (this.dCursor == null) return lArray;
        return this.dCursor.getKeyFrameTimecodes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getKeyFrameTimecodes() {
        long[] lArray = null;
        if (this.vCursor == null) return lArray;
        return this.vCursor.getKeyFrameTimecodes();
    }
}

