/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;

public class ReferenceCountingIoFilter
implements IoFilter {
    private final IoFilter filter;
    private int count = 0;

    public ReferenceCountingIoFilter(IoFilter ioFilter) {
        this.filter = ioFilter;
    }

    public void init() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public synchronized void onPreAdd(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws Exception {
        if (0 == this.count) {
            this.filter.init();
            ++this.count;
        }
        this.filter.onPreAdd(ioFilterChain, string, nextFilter);
    }

    public synchronized void onPostRemove(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws Exception {
        this.filter.onPostRemove(ioFilterChain, string, nextFilter);
        --this.count;
        if (0 == this.count) {
            this.filter.destroy();
        }
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession ioSession, Throwable throwable) throws Exception {
        this.filter.exceptionCaught(nextFilter, ioSession, throwable);
    }

    public void filterClose(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        this.filter.filterClose(nextFilter, ioSession);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, IoFilter.WriteRequest writeRequest) throws Exception {
        this.filter.filterWrite(nextFilter, ioSession, writeRequest);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
        this.filter.messageReceived(nextFilter, ioSession, object);
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
        this.filter.messageSent(nextFilter, ioSession, object);
    }

    public void onPostAdd(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws Exception {
        this.filter.onPostAdd(ioFilterChain, string, nextFilter);
    }

    public void onPreRemove(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws Exception {
        this.filter.onPreRemove(ioFilterChain, string, nextFilter);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        this.filter.sessionClosed(nextFilter, ioSession);
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        this.filter.sessionCreated(nextFilter, ioSession);
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession ioSession, IdleStatus idleStatus) throws Exception {
        this.filter.sessionIdle(nextFilter, ioSession, idleStatus);
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        this.filter.sessionOpened(nextFilter, ioSession);
    }
}

