/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferProxy;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.apache.mina.filter.codec.support.SimpleProtocolDecoderOutput;
import org.apache.mina.filter.codec.support.SimpleProtocolEncoderOutput;
import org.apache.mina.util.SessionLog;

public class ProtocolCodecFilter
extends IoFilterAdapter {
    public static final String ENCODER = ProtocolCodecFilter.class.getName() + ".encoder";
    public static final String DECODER = ProtocolCodecFilter.class.getName() + ".decoder";
    private static final Class[] EMPTY_PARAMS = new Class[0];
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private final ProtocolCodecFactory factory;

    public ProtocolCodecFilter(ProtocolCodecFactory protocolCodecFactory) {
        if (protocolCodecFactory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = protocolCodecFactory;
    }

    public ProtocolCodecFilter(final ProtocolEncoder protocolEncoder, final ProtocolDecoder protocolDecoder) {
        if (protocolEncoder == null) {
            throw new NullPointerException("encoder");
        }
        if (protocolDecoder == null) {
            throw new NullPointerException("decoder");
        }
        this.factory = new ProtocolCodecFactory(){

            public ProtocolEncoder getEncoder() {
                return protocolEncoder;
            }

            public ProtocolDecoder getDecoder() {
                return protocolDecoder;
            }
        };
    }

    public ProtocolCodecFilter(final Class clazz, final Class clazz2) {
        if (clazz == null) {
            throw new NullPointerException("encoderClass");
        }
        if (clazz2 == null) {
            throw new NullPointerException("decoderClass");
        }
        if (!ProtocolEncoder.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("encoderClass: " + clazz.getName());
        }
        if (!ProtocolDecoder.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("decoderClass: " + clazz2.getName());
        }
        try {
            clazz.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("encoderClass doesn't have a public default constructor.");
        }
        try {
            clazz2.getConstructor(EMPTY_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("decoderClass doesn't have a public default constructor.");
        }
        this.factory = new ProtocolCodecFactory(){

            public ProtocolEncoder getEncoder() throws Exception {
                return (ProtocolEncoder)clazz.newInstance();
            }

            public ProtocolDecoder getDecoder() throws Exception {
                return (ProtocolDecoder)clazz2.newInstance();
            }
        };
    }

    public void onPreAdd(IoFilterChain ioFilterChain, String string, IoFilter.NextFilter nextFilter) throws Exception {
        if (ioFilterChain.contains(ProtocolCodecFilter.class)) {
            throw new IllegalStateException("A filter chain cannot contain more than one ProtocolCodecFilter.");
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
        if (!(object instanceof ByteBuffer)) {
            nextFilter.messageReceived(ioSession, object);
            return;
        }
        ByteBuffer byteBuffer = (ByteBuffer)object;
        ProtocolDecoder protocolDecoder = this.getDecoder(ioSession);
        ProtocolDecoderOutput protocolDecoderOutput = this.getDecoderOut(ioSession, nextFilter);
        try {
            protocolDecoder.decode(ioSession, byteBuffer, protocolDecoderOutput);
        }
        catch (Throwable throwable) {
            ProtocolDecoderException protocolDecoderException = throwable instanceof ProtocolDecoderException ? (ProtocolDecoderException)throwable : new ProtocolDecoderException(throwable);
            protocolDecoderException.setHexdump(byteBuffer.getHexDump());
            throw protocolDecoderException;
        }
        finally {
            if (ioSession.getTransportType().isConnectionless()) {
                this.disposeDecoder(ioSession);
            }
            byteBuffer.release();
            protocolDecoderOutput.flush();
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
        if (object instanceof HiddenByteBuffer) {
            return;
        }
        if (!(object instanceof MessageByteBuffer)) {
            nextFilter.messageSent(ioSession, object);
            return;
        }
        nextFilter.messageSent(ioSession, ((MessageByteBuffer)object).message);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession ioSession, IoFilter.WriteRequest writeRequest) throws Exception {
        Object object = writeRequest.getMessage();
        if (object instanceof ByteBuffer) {
            nextFilter.filterWrite(ioSession, writeRequest);
            return;
        }
        ProtocolEncoder protocolEncoder = this.getEncoder(ioSession);
        ProtocolEncoderOutputImpl protocolEncoderOutputImpl = this.getEncoderOut(ioSession, nextFilter, writeRequest);
        try {
            protocolEncoder.encode(ioSession, object, protocolEncoderOutputImpl);
            protocolEncoderOutputImpl.flush();
            nextFilter.filterWrite(ioSession, new IoFilter.WriteRequest(new MessageByteBuffer(writeRequest.getMessage()), writeRequest.getFuture(), writeRequest.getDestination(), writeRequest.getWriteId(), writeRequest.getClientId()));
            if (ioSession instanceof BaseIoSession) {
                ((BaseIoSession)ioSession).increaseWrittenMessages();
            }
        }
        catch (Throwable throwable) {
            ProtocolEncoderException protocolEncoderException = throwable instanceof ProtocolEncoderException ? (ProtocolEncoderException)throwable : new ProtocolEncoderException(throwable);
            throw protocolEncoderException;
        }
        finally {
            if (ioSession.getTransportType().isConnectionless()) {
                this.disposeEncoder(ioSession);
            }
        }
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        ProtocolDecoder protocolDecoder = this.getDecoder(ioSession);
        ProtocolDecoderOutput protocolDecoderOutput = this.getDecoderOut(ioSession, nextFilter);
        try {
            protocolDecoder.finishDecode(ioSession, protocolDecoderOutput);
        }
        catch (Throwable throwable) {
            ProtocolDecoderException protocolDecoderException = throwable instanceof ProtocolDecoderException ? (ProtocolDecoderException)throwable : new ProtocolDecoderException(throwable);
            throw protocolDecoderException;
        }
        finally {
            this.disposeEncoder(ioSession);
            this.disposeDecoder(ioSession);
            protocolDecoderOutput.flush();
        }
        nextFilter.sessionClosed(ioSession);
    }

    private ProtocolEncoder getEncoder(IoSession ioSession) throws Exception {
        ProtocolEncoder protocolEncoder = (ProtocolEncoder)ioSession.getAttribute(ENCODER);
        if (protocolEncoder == null) {
            protocolEncoder = this.factory.getEncoder();
            ioSession.setAttribute(ENCODER, protocolEncoder);
        }
        return protocolEncoder;
    }

    private ProtocolEncoderOutputImpl getEncoderOut(IoSession ioSession, IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
        return new ProtocolEncoderOutputImpl(ioSession, nextFilter, writeRequest);
    }

    private ProtocolDecoder getDecoder(IoSession ioSession) throws Exception {
        ProtocolDecoder protocolDecoder = (ProtocolDecoder)ioSession.getAttribute(DECODER);
        if (protocolDecoder == null) {
            protocolDecoder = this.factory.getDecoder();
            ioSession.setAttribute(DECODER, protocolDecoder);
        }
        return protocolDecoder;
    }

    private ProtocolDecoderOutput getDecoderOut(IoSession ioSession, IoFilter.NextFilter nextFilter) {
        return new SimpleProtocolDecoderOutput(ioSession, nextFilter);
    }

    private void disposeEncoder(IoSession ioSession) {
        ProtocolEncoder protocolEncoder = (ProtocolEncoder)ioSession.removeAttribute(ENCODER);
        if (protocolEncoder == null) {
            return;
        }
        try {
            protocolEncoder.dispose(ioSession);
        }
        catch (Throwable throwable) {
            SessionLog.warn(ioSession, "Failed to dispose: " + protocolEncoder.getClass().getName() + " (" + protocolEncoder + ')');
        }
    }

    private void disposeDecoder(IoSession ioSession) {
        ProtocolDecoder protocolDecoder = (ProtocolDecoder)ioSession.removeAttribute(DECODER);
        if (protocolDecoder == null) {
            return;
        }
        try {
            protocolDecoder.dispose(ioSession);
        }
        catch (Throwable throwable) {
            SessionLog.warn(ioSession, "Falied to dispose: " + protocolDecoder.getClass().getName() + " (" + protocolDecoder + ')');
        }
    }

    private static class HiddenByteBuffer
    extends ByteBufferProxy {
        private HiddenByteBuffer(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.setExtra(byteBuffer.getExtra());
        }
    }

    private static class MessageByteBuffer
    extends ByteBufferProxy {
        private final Object message;

        private MessageByteBuffer(Object object) {
            super(EMPTY_BUFFER);
            this.message = object;
        }

        public void acquire() {
        }

        public void release() {
        }
    }

    private static class ProtocolEncoderOutputImpl
    extends SimpleProtocolEncoderOutput {
        private final IoSession session;
        private final IoFilter.NextFilter nextFilter;
        private final IoFilter.WriteRequest writeRequest;

        public ProtocolEncoderOutputImpl(IoSession ioSession, IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
            this.session = ioSession;
            this.nextFilter = nextFilter;
            this.writeRequest = writeRequest;
        }

        protected WriteFuture doFlush(ByteBuffer byteBuffer) {
            DefaultWriteFuture defaultWriteFuture = new DefaultWriteFuture(this.session);
            this.nextFilter.filterWrite(this.session, new IoFilter.WriteRequest(new HiddenByteBuffer(byteBuffer), defaultWriteFuture, this.writeRequest.getDestination(), this.writeRequest.getWriteId(), this.writeRequest.getClientId()));
            return defaultWriteFuture;
        }
    }
}

