/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec;

import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class SynchronizedProtocolEncoder
implements ProtocolEncoder {
    private final ProtocolEncoder encoder;

    public SynchronizedProtocolEncoder(ProtocolEncoder protocolEncoder) {
        if (protocolEncoder == null) {
            throw new NullPointerException("encoder");
        }
        this.encoder = protocolEncoder;
    }

    public ProtocolEncoder getEncoder() {
        return this.encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(IoSession ioSession, Object object, ProtocolEncoderOutput protocolEncoderOutput) throws Exception {
        ProtocolEncoder protocolEncoder = this.encoder;
        synchronized (protocolEncoder) {
            this.encoder.encode(ioSession, object, protocolEncoderOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(IoSession ioSession) throws Exception {
        ProtocolEncoder protocolEncoder = this.encoder;
        synchronized (protocolEncoder) {
            this.encoder.dispose(ioSession);
        }
    }
}

