/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.jmx;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public abstract class AbstractDynamicMBean
implements DynamicMBean,
MBeanRegistration {
    String dClassName;
    MBeanServer server;
    private final Vector mbeanList = new Vector();

    protected static String getAppenderName(Appender appender) {
        String string = appender.getName();
        if (string == null || string.trim().length() == 0) {
            string = appender.toString();
        }
        return string;
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + this.dClassName);
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (JMException jMException) {
                jMException.printStackTrace();
                continue;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        return attributeList;
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList attributes cannot be null"), "Cannot invoke a setter of " + this.dClassName);
        }
        AttributeList attributeList2 = new AttributeList();
        if (attributeList.isEmpty()) {
            return attributeList2;
        }
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            try {
                this.setAttribute(attribute);
                String string = attribute.getName();
                Object object = this.getAttribute(string);
                attributeList2.add(new Attribute(string, object));
            }
            catch (JMException jMException) {
                jMException.printStackTrace();
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        return attributeList2;
    }

    protected abstract Logger getLogger();

    public void postDeregister() {
        this.getLogger().debug("postDeregister is called.");
    }

    public void postRegister(Boolean bl) {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        this.getLogger().debug("preRegister called. Server=" + mBeanServer + ", name=" + objectName);
        this.server = mBeanServer;
        return objectName;
    }

    protected void registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.server.registerMBean(object, objectName);
        this.mbeanList.add(objectName);
    }

    public void preDeregister() {
        this.getLogger().debug("preDeregister called.");
        Enumeration enumeration = this.mbeanList.elements();
        while (enumeration.hasMoreElements()) {
            ObjectName objectName = (ObjectName)enumeration.nextElement();
            try {
                this.server.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                this.getLogger().warn("Missing MBean " + objectName.getCanonicalName());
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                this.getLogger().warn("Failed unregistering " + objectName.getCanonicalName());
            }
        }
    }
}

