/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.Serializable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class JMSAppender
extends AppenderSkeleton {
    String securityPrincipalName;
    String securityCredentials;
    String initialContextFactoryName;
    String urlPkgPrefixes;
    String providerURL;
    String topicBindingName;
    String tcfBindingName;
    String userName;
    String password;
    boolean locationInfo;
    TopicConnection topicConnection;
    TopicSession topicSession;
    TopicPublisher topicPublisher;

    public void setTopicConnectionFactoryBindingName(String string) {
        this.tcfBindingName = string;
    }

    public String getTopicConnectionFactoryBindingName() {
        return this.tcfBindingName;
    }

    public void setTopicBindingName(String string) {
        this.topicBindingName = string;
    }

    public String getTopicBindingName() {
        return this.topicBindingName;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void activateOptions() {
        try {
            InitialContext initialContext;
            Properties properties;
            LogLog.debug("Getting initial context.");
            if (this.initialContextFactoryName != null) {
                properties = new Properties();
                properties.put("java.naming.factory.initial", this.initialContextFactoryName);
                if (this.providerURL != null) {
                    properties.put("java.naming.provider.url", this.providerURL);
                } else {
                    LogLog.warn("You have set InitialContextFactoryName option but not the ProviderURL. This is likely to cause problems.");
                }
                if (this.urlPkgPrefixes != null) {
                    properties.put("java.naming.factory.url.pkgs", this.urlPkgPrefixes);
                }
                if (this.securityPrincipalName != null) {
                    properties.put("java.naming.security.principal", this.securityPrincipalName);
                    if (this.securityCredentials != null) {
                        properties.put("java.naming.security.credentials", this.securityCredentials);
                    } else {
                        LogLog.warn("You have set SecurityPrincipalName option but not the SecurityCredentials. This is likely to cause problems.");
                    }
                }
                initialContext = new InitialContext(properties);
            } else {
                initialContext = new InitialContext();
            }
            LogLog.debug("Looking up [" + this.tcfBindingName + "]");
            TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.lookup(initialContext, this.tcfBindingName);
            LogLog.debug("About to create TopicConnection.");
            this.topicConnection = this.userName != null ? topicConnectionFactory.createTopicConnection(this.userName, this.password) : topicConnectionFactory.createTopicConnection();
            LogLog.debug("Creating TopicSession, non-transactional, in AUTO_ACKNOWLEDGE mode.");
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            LogLog.debug("Looking up topic name [" + this.topicBindingName + "].");
            properties = (Topic)this.lookup(initialContext, this.topicBindingName);
            LogLog.debug("Creating TopicPublisher.");
            this.topicPublisher = this.topicSession.createPublisher((Topic)properties);
            LogLog.debug("Starting TopicConnection.");
            this.topicConnection.start();
            initialContext.close();
        }
        catch (JMSException jMSException) {
            this.errorHandler.error("Error while activating options for appender named [" + this.name + "].", (Exception)((Object)jMSException), 0);
        }
        catch (NamingException namingException) {
            this.errorHandler.error("Error while activating options for appender named [" + this.name + "].", namingException, 0);
        }
        catch (RuntimeException runtimeException) {
            this.errorHandler.error("Error while activating options for appender named [" + this.name + "].", runtimeException, 0);
        }
    }

    protected Object lookup(Context context, String string) throws NamingException {
        try {
            return context.lookup(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            LogLog.error("Could not find name [" + string + "].");
            throw nameNotFoundException;
        }
    }

    protected boolean checkEntryConditions() {
        String string = null;
        if (this.topicConnection == null) {
            string = "No TopicConnection";
        } else if (this.topicSession == null) {
            string = "No TopicSession";
        } else if (this.topicPublisher == null) {
            string = "No TopicPublisher";
        }
        if (string != null) {
            this.errorHandler.error(string + " for JMSAppender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug("Closing appender [" + this.name + "].");
        this.closed = true;
        try {
            if (this.topicSession != null) {
                this.topicSession.close();
            }
            if (this.topicConnection != null) {
                this.topicConnection.close();
            }
        }
        catch (JMSException jMSException) {
            LogLog.error("Error while closing JMSAppender [" + this.name + "].", jMSException);
        }
        catch (RuntimeException runtimeException) {
            LogLog.error("Error while closing JMSAppender [" + this.name + "].", runtimeException);
        }
        this.topicPublisher = null;
        this.topicSession = null;
        this.topicConnection = null;
    }

    public void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        try {
            ObjectMessage objectMessage = this.topicSession.createObjectMessage();
            if (this.locationInfo) {
                loggingEvent.getLocationInformation();
            }
            objectMessage.setObject((Serializable)loggingEvent);
            this.topicPublisher.publish((Message)objectMessage);
        }
        catch (JMSException jMSException) {
            this.errorHandler.error("Could not publish message in JMSAppender [" + this.name + "].", (Exception)((Object)jMSException), 0);
        }
        catch (RuntimeException runtimeException) {
            this.errorHandler.error("Could not publish message in JMSAppender [" + this.name + "].", runtimeException, 0);
        }
    }

    public String getInitialContextFactoryName() {
        return this.initialContextFactoryName;
    }

    public void setInitialContextFactoryName(String string) {
        this.initialContextFactoryName = string;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public void setProviderURL(String string) {
        this.providerURL = string;
    }

    String getURLPkgPrefixes() {
        return this.urlPkgPrefixes;
    }

    public void setURLPkgPrefixes(String string) {
        this.urlPkgPrefixes = string;
    }

    public String getSecurityCredentials() {
        return this.securityCredentials;
    }

    public void setSecurityCredentials(String string) {
        this.securityCredentials = string;
    }

    public String getSecurityPrincipalName() {
        return this.securityPrincipalName;
    }

    public void setSecurityPrincipalName(String string) {
        this.securityPrincipalName = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    protected TopicConnection getTopicConnection() {
        return this.topicConnection;
    }

    protected TopicSession getTopicSession() {
        return this.topicSession;
    }

    protected TopicPublisher getTopicPublisher() {
        return this.topicPublisher;
    }

    public boolean requiresLayout() {
        return false;
    }
}

