/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264;

import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.io.ScheduledRandomAccessReaderWrapper;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.HTTPUtils;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.util.JSON;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.drm.playready.PlayReadyMediaInfo;
import com.wowza.wms.drm.playready.PlayReadySampleInfo;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.h264.H264Cursor;
import com.wowza.wms.mediareader.h264.H264ReadAheadPacket;
import com.wowza.wms.mediareader.h264.H264ReadAheadRequest;
import com.wowza.wms.mediareader.h264.H264StreamPosition;
import com.wowza.wms.mediareader.h264.IQTDataDataToAMF;
import com.wowza.wms.mediareader.h264.atom.AVCCData;
import com.wowza.wms.mediareader.h264.atom.ESDSData;
import com.wowza.wms.mediareader.h264.atom.QTAtommdia;
import com.wowza.wms.mediareader.h264.atom.QTAtomminf;
import com.wowza.wms.mediareader.h264.atom.QTAtommoov;
import com.wowza.wms.mediareader.h264.atom.QTAtomstbl;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.mediareader.h264.atom.QTMediaContainer;
import com.wowza.wms.mediareader.h264.atom.QTTX3GData;
import com.wowza.wms.mediareader.h264.atom.QTTX3GFont;
import com.wowza.wms.mediareader.h264.util.QTParseContext;
import com.wowza.wms.mediareader.h264.util.QTUtils;
import com.wowza.wms.protocol.wowz.WOWZHeader;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderEncInfo;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderEncInfo;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import com.wowza.wms.timedtext.amf.ITimedTextProviderAMF;
import com.wowza.wms.timedtext.impl.H264CursorCaptionProvider;
import com.wowza.wms.timedtext.model.IVODTimedTextDelegate;
import com.wowza.wms.timedtext.model.IVODTimedTextProvider;
import com.wowza.wms.timedtext.model.TimedTextRequest;
import com.wowza.wms.timedtext.vod.model.TimedTextMediaReaderContext;
import com.wowza.wms.timedtext.vod.model.VODTimedTextDelegateFactory;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaReaderH264
implements IMediaReader,
IQTDataDataToAMF,
IMediaReaderEncInfo {
    private static final Object a = JSON.regionMatches((String)"\u0010;;) \u0010&%!#5\u0000{|\u007f", (int)(28 - 63));
    private static final Class<MediaReaderH264> b = MediaReaderH264.class;
    public static final String H264_DATATYPE_3GPP = "tx3g";
    protected MediaReaderItem mediaReaderItem = null;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = Base64.toString((int)(10 + 65), (String)"&<y");
    protected String mediaReaderExt = JSON.regionMatches((String)"hv3", (int)(202 / 35));
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = Base64.toString((int)(15 * 5), (String)"&<y");
    protected QTMediaContainer container = null;
    protected H264Cursor cursor = null;
    protected int cursorType = 2;
    protected H264Cursor cursorReadAhead = null;
    protected H264ReadAheadRequest currReadAhead = null;
    protected H264ReadAheadRequest nextReadAhead = null;
    protected boolean cacheReadAhead = false;
    protected Object readAheadLock = new Object();
    protected List<H264ReadAheadRequest> readAheadCache = new ArrayList<H264ReadAheadRequest>();
    protected int readAheadSize = 65536;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected int indexBufferSize = 65536;
    protected boolean useDisplaySize = true;
    protected IRandomAccessReader videoFileStream = null;
    protected IRandomAccessReader metaFileStream = null;
    protected List metaData = null;
    protected long duration = -1L;
    protected long length = 0L;
    protected long videoSampleCount = -1L;
    protected long audioSampleCount = -1L;
    protected long dataSampleCount = -1L;
    protected byte[] chunkWorkBuffer = null;
    protected int[] chunkHeaderValues = null;
    protected boolean doSendVideoTrakInfo = false;
    protected boolean doSendAudioTrakInfo = false;
    protected boolean doSendEnhanceSeek = false;
    protected boolean errorReported = false;
    protected int audioType = 175;
    protected int audioExtraSize = 2;
    protected String randomAccessReaderClass = JSON.regionMatches((String)"`kh(pg~pj\"da!Tx`vwaDvv}uv]~}zsrPfeacu", (int)(511 / 167));
    protected String randomAccessReadOptimizerClass = Base64.toString((int)(1517 / 230), (String)"ehe'}d{wo!y~<Au{rxuXyxynmMe`fLtqojasoy");
    protected IApplicationInstance appInstance = null;
    protected int videoCodec = 7;
    protected int audioCodec = 10;
    protected boolean openAudioTrack = true;
    protected boolean openVideoTrack = true;
    protected int trackIndexVideo = 0;
    protected int trackIndexAudio = 0;
    protected int trackIndexData = 0;
    protected String trackDataCharSet = Base64.toString((int)(-11 - 7), (String)"\u001b\u001b\u0016|j");
    protected long onMetadataSample = -1L;
    protected boolean bufferSeekIO = false;
    protected IQTDataDataToAMF dataDataToAMFHandler = this;
    protected MediaReaderEncInfo encInfo = new MediaReaderEncInfo();
    protected boolean captionsEnabled = true;
    protected IVODTimedTextDelegate captionsDelegate = null;
    protected TimedTextRequest captionRequest = new TimedTextRequest();
    protected String captionsDelegateClass = Base64.toString((int)(7 * 49), (String)"474t,3*$>n6/0j1/*-->.49`9?5|! 8&y\u000e\u0016\u001e\u000f50;;Tdzw@`jboh~n^yc\u007f");
    private String c = null;
    private ITimedTextProviderAMF d = null;
    protected String captionLanguageQueryParameter = Base64.toString((int)(-21 - -53), (String)"wnuyefgw|`ee`l`hepuvg");
    protected String captionFilenameQueryParameter = Base64.toString((int)(30 - -13), (String)"|cztnspbg}zxqqu\u007f");
    protected boolean onSeekUseVideoTimecode = false;
    static long e = -1L;

    public MediaReaderH264() {
        this.chunkHeaderValues = new int[5];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperties(WMSProperties wMSProperties) {
        this.readAheadSize = wMSProperties.getPropertyInt(JSON.regionMatches((String)"iu2UmhnJdhokCxhv", (int)(1069 / 245)), this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt(Base64.toString((int)(-40 - 29), (String)"vl)Lz!%\u0003+!$\"\u0013: -,)?"), this.readAheadTrigger);
        this.indexBufferSize = wMSProperties.getPropertyInt(JSON.regionMatches((String)" >{\u0019?66,\u0017#1><(\b5';", (int)(36 - -41)), this.indexBufferSize);
        this.cacheReadAhead = wMSProperties.getPropertyBoolean(Base64.toString((int)(9 - 12), (String)"0.kC`akaWcflHbnmi"), this.cacheReadAhead);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr(JSON.regionMatches((String)"wgilfgJonk|cCwrppdTtxih", (int)(1330 / 249)), this.randomAccessReaderClass);
        this.randomAccessReadOptimizerClass = wMSProperties.getPropertyStr(Base64.toString((int)(717 / 197), (String)"qekbheHihi~}]upv\\da\u007fzqc\u007fi_q\u007fls"), this.randomAccessReadOptimizerClass);
        this.useDisplaySize = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"lr7QvcCazzgmt]fjt", (int)(56 - 23)), this.useDisplaySize);
        this.bufferSeekIO = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"gsanlxXiheF_", (int)(232 / 45)), this.bufferSeekIO);
        this.bufferSeekIO = wMSProperties.getPropertyBoolean(Base64.toString((int)(59 * 19), (String)",2w\u00060 !-;\u0019.)&\u0007\u0000"), this.bufferSeekIO);
        this.onSeekUseVideoTimecode = wMSProperties.getPropertyBoolean(Base64.toString((int)(59 - -5), (String)"-1v\f*\u0016#\"#\u001c9.\u001a$**?\u0005;>1693="), this.onSeekUseVideoTimecode);
        if (!WMSLoggerFactory.getLogger(MediaReaderH264.class).isDebugEnabled()) {
            return;
        }
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(JSON.regionMatches((String)"NaaofZlkoi\u007fF=&%<~d!Dry}[sy|zLi{g9$", (int)(170 / 43)) + this.readAheadSize);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.toString((int)(-19 - -11), (String)"\u0015<>2=\u000f;>ddpK632)ey>YiljNxtsw@g\u007fp\u007f|h!<") + this.readAheadTrigger);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(JSON.regionMatches((String)"[r|p{Iy|zz2\tpupk+7|\u0000$/)5\f:677!\u0007<,2by", (int)(51 - -3)) + this.indexBufferSize);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.toString((int)(38 + 105), (String)"Buu{rFpws}kR)*)0maofliDedmzyYiljjbR~rgf,7") + this.randomAccessReaderClass);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(JSON.regionMatches((String)"\u001d46:5\u000736<<(\u0013nkjq2 ,'+(\u0007$+,98\u001e(/+5#\u001d# <;>\"<(\u00180<-,:!", (int)(90 + -10)) + this.randomAccessReadOptimizerClass);
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderExt = this.mediaReaderType = this.mediaReaderType.toLowerCase();
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.metaFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        this.videoFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        WMSProperties wMSProperties = iApplicationInstance.getTimedTextProperties();
        WMSProperties wMSProperties2 = iApplicationInstance.getProperties();
        this.captionsEnabled = wMSProperties2.getPropertyBoolean(JSON.regionMatches((String)"ukaEfx}cdb~Kaqs~vp", (int)(79 + 84)), this.captionsEnabled);
        this.captionsEnabled = wMSProperties.getPropertyBoolean(Base64.toString((int)(-59 - 47), (String)"`x|Z{khtqqsDlbficc"), this.captionsEnabled);
        this.captionsEnabled = wMSProperties2.getPropertyBoolean(Base64.toString((int)(435 / 89), (String)"vqkw^FNHm}zf\u007f\u007faVztt{}}"), this.captionsEnabled);
        this.captionsEnabled = wMSProperties.getPropertyBoolean(Base64.toString((int)(26 - 42), (String)"\"%?#\u0002\u001a\u0012\u00149).233-\u001an``oaa"), this.captionsEnabled);
        this.captionsDelegateClass = wMSProperties2.getPropertyStr(Base64.toString((int)(-1 - -37), (String)"vqkw^FNHm}zf\u007f\u007faWqyspym\u007fXp|ml"), this.captionsDelegateClass);
        this.captionsDelegateClass = wMSProperties.getPropertyStr(JSON.regionMatches((String)"tsey\\DHNo\u007fdx}}gQs{}~{oy^r~sr", (int)(462 / 72)), this.captionsDelegateClass);
        this.captionLanguageQueryParameter = wMSProperties2.getPropertyStr(JSON.regionMatches((String)"efx}cdbAoawdstqDcrj`Jzn|sztdp", (int)(474 / 77)), this.captionLanguageQueryParameter);
        this.captionLanguageQueryParameter = wMSProperties.getPropertyStr(JSON.regionMatches((String)"no\u007fdx}}Xtxpmx}~Mh{m9\u0011#1%(#3-;", (int)(21 + 24)), this.captionLanguageQueryParameter);
        this.captionFilenameQueryParameter = wMSProperties2.getPropertyStr(Base64.toString((int)(50 + 61), (String)",1!&:;;\u0010>4<4:18\u000f*es{Sewgjm}oy"), this.captionFilenameQueryParameter);
        this.captionFilenameQueryParameter = wMSProperties.getPropertyStr(JSON.regionMatches((String)" %52.''\f\" ( .=4\u0003&1'/\u00079+;69);-", (int)(9 - 38)), this.captionFilenameQueryParameter);
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initTimedTextOnOpen() {
        if (!this.captionsEnabled) return;
        String string = null;
        if (this.stream != null) {
            string = this.stream.getQueryStr();
        }
        Map map = HTTPUtils.splitQueryStr(string);
        this.captionRequest = this.a(map);
        MediaReaderH264 mediaReaderH264 = this;
        mediaReaderH264.initTimedTextDelegates(mediaReaderH264.captionRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initTimedTextDelegates(TimedTextRequest timedTextRequest) {
        String string;
        IVODTimedTextProvider iVODTimedTextProvider;
        if (!this.captionsEnabled) return;
        if (this.captionsDelegate != null) return;
        MediaReaderH264 mediaReaderH264 = this;
        TimedTextMediaReaderContext timedTextMediaReaderContext = new TimedTextMediaReaderContext((IMediaReader)mediaReaderH264, mediaReaderH264.randomAccessReaderClass, this.appInstance, this.basePath, this.mediaName, this.mediaExtension, this.stream, timedTextRequest);
        this.captionsDelegate = VODTimedTextDelegateFactory.createInstance((IMediaReader)this, (TimedTextMediaReaderContext)timedTextMediaReaderContext, (String)this.captionsDelegateClass);
        if (this.captionsDelegate == null) {
            WMSLoggerFactory.getLogger(b).warn(String.format(Base64.toString((int)(1075 / 158), (String)"#t&`dbxYgbuuFvlaRrt|}zhxm% Egoabgsm)-.\u007f*.a\u007fe2pfpwc}}4"), a, this.captionsDelegateClass));
            return;
        }
        this.captionsDelegate.indexTimedText();
        Map map = this.captionsDelegate.determineCaptionLanguages(timedTextRequest, ITimedTextProviderAMF.class);
        if (map == null) return;
        if (map.isEmpty()) return;
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        do {
            if (!iterator.hasNext()) return;
        } while (!((iVODTimedTextProvider = (IVODTimedTextProvider)map.get(string = (String)iterator.next())) instanceof ITimedTextProviderAMF));
        this.d = (ITimedTextProviderAMF)iVODTimedTextProvider;
        this.c = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            block30: {
                block31: {
                    block28: {
                        block29: {
                            if (this.metaFileStream.isOpen()) {
                                this.close();
                            }
                            try {
                                this.metaFileStream.open();
                                this.videoFileStream.open();
                                this.errorReported = false;
                                break block28;
                            }
                            catch (Exception exception) {
                                if (this.errorReported) break block29;
                            }
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, Base64.toString((int)(95 + 57), (String)"U|~r}O{~ddpK632)gyoeW<S50") + exception.toString(), null, Base64.toString((int)(13 * 7), (String)"(9/(:2"), "comment", 404, this.mediaName);
                        }
                        this.errorReported = true;
                    }
                    if (this.metaFileStream == null) return;
                    if (!this.metaFileStream.isOpen()) return;
                    try {
                        this.length = this.metaFileStream.length();
                        QTParseContext qTParseContext = new QTParseContext();
                        qTParseContext.setClientId(this.stream.getClientId());
                        qTParseContext.setIndexBufferSize(this.indexBufferSize);
                        qTParseContext.setParseAudioTrack(this.openAudioTrack);
                        qTParseContext.setParseVideoTrack(this.openVideoTrack);
                        qTParseContext.setIndexFilePtr(this.metaFileStream);
                        IRandomAccessReader iRandomAccessReader = this.metaFileStream;
                        IRandomAccessReader iRandomAccessReader2 = null;
                        if (this.bufferSeekIO) {
                            iRandomAccessReader = null;
                            try {
                                iRandomAccessReader2 = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                                iRandomAccessReader2.open();
                            }
                            catch (Exception exception) {
                                iRandomAccessReader2 = null;
                            }
                            try {
                                if (iRandomAccessReader2 != null) {
                                    int n = this.indexBufferSize;
                                    iRandomAccessReader = new ScheduledRandomAccessReaderWrapper(this.stream, iRandomAccessReader2, n, n / 2);
                                    iRandomAccessReader.open();
                                }
                            }
                            catch (Exception exception) {
                                iRandomAccessReader = null;
                            }
                            if (iRandomAccessReader == null) {
                                iRandomAccessReader = this.metaFileStream;
                            }
                        }
                        IRandomAccessReader iRandomAccessReader3 = iRandomAccessReader;
                        this.container = QTUtils.parseQTMediaContainer(iRandomAccessReader3, iRandomAccessReader3.length(), qTParseContext);
                        if (this.bufferSeekIO) {
                            try {
                                if (iRandomAccessReader != null) {
                                    iRandomAccessReader.close();
                                }
                                iRandomAccessReader = null;
                            }
                            catch (Exception exception) {}
                            try {
                                if (iRandomAccessReader2 != null) {
                                    iRandomAccessReader2.close();
                                }
                                iRandomAccessReader2 = null;
                            }
                            catch (Exception exception) {}
                        }
                        if (this.container != null) {
                            MediaReaderH264 mediaReaderH264 = this;
                            this.appInstance.notifyMediaReaderOpen((IMediaReader)mediaReaderH264, mediaReaderH264.stream);
                            QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
                            QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
                            QTAtomtrak qTAtomtrak3 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
                            this.cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, qTAtomtrak3, this.cursorType);
                            if (this.cursor != null) {
                                this.videoSampleCount = this.cursor.getVideoSampleCount();
                                this.audioSampleCount = this.cursor.getAudioSampleCount();
                                this.dataSampleCount = this.cursor.getDataSampleCount();
                            }
                            this.readMetadata();
                            if (this.d != null) {
                                this.cursor = new H264CursorCaptionProvider(this.d, this.c, qTAtomtrak, qTAtomtrak2, this.cursorType);
                                if (this.cursor != null) {
                                    this.videoSampleCount = this.cursor.getVideoSampleCount();
                                    this.audioSampleCount = this.cursor.getAudioSampleCount();
                                    this.dataSampleCount = this.cursor.getDataSampleCount();
                                }
                            }
                            MediaReaderH264 mediaReaderH2642 = this;
                            this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)mediaReaderH2642, mediaReaderH2642.stream);
                            if (qTParseContext.getIndexRefCount() <= 0) {
                                this.metaFileStream.close();
                                this.metaFileStream = null;
                            }
                        }
                        if (this.container != null) return;
                        if (!this.errorReported) {
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, Base64.toString((int)(17 * 5), (String)"\u00183318\b>=9;-\bstwjk)7-'pk\t?< \"q\"2&&?9?y<208~9osobp%]JX=W"), null, Base64.toString((int)(8 - -28), (String)"w`tqm{"), "comment", 500, this.mediaName);
                        }
                        this.errorReported = true;
                        break block30;
                    }
                    catch (Exception exception) {
                        if (this.errorReported) break block31;
                    }
                    WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, JSON.regionMatches((String)"HccahXnmik}X#$':zfrvB(F&=", (int)(1345 / 230)) + exception.toString(), null, Base64.toString((int)(41 * 35), (String)"hyohzr"), "comment", 404, this.mediaName);
                }
                this.errorReported = true;
                this.container = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOpen() {
        if (this.container == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        this.container = null;
        try {
            if (this.videoFileStream != null) {
                this.videoFileStream.close();
            }
            if (this.metaFileStream != null) {
                this.metaFileStream.close();
            }
            if (this.cursor != null) {
                this.cursor.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.toString((int)(1317 / 223), (String)"HccahXnmik}X#$':zfrv#:") + exception.toString());
        }
        this.metaData = null;
        this.duration = -1L;
        this.videoSampleCount = -1L;
        this.dataSampleCount = -1L;
        this.audioSampleCount = -1L;
        this.cursor = null;
        this.length = 0L;
        this.onMetadataSample = -1L;
        MediaReaderH264 mediaReaderH264 = this;
        this.appInstance.notifyMediaReaderClose((IMediaReader)mediaReaderH264, mediaReaderH264.stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readMetadata() {
        block40: {
            block36: {
                block35: {
                    block37: {
                        if (this.container == null) {
                            this.metaData = null;
                            return;
                        }
                        this.initTimedTextOnOpen();
                        this.metaData = new ArrayList<E>();
                        var1_1 = new AMFDataMixedArray();
                        var2_30 = this.container.getMoovAtom();
                        var3_2 = var2_30.getVideoTrack(this.trackIndexVideo);
                        var4_31 = var3_2 == null ? null : var3_2.getMdiaAtom().getMinfAtom().getStblAtom();
                        var5_32 = var2_30.getAudioTrack(this.trackIndexAudio);
                        v0 = var6_3 = var5_32 == null ? null : var5_32.getMdiaAtom().getMinfAtom().getStblAtom();
                        if (this.cursor == null || (var7_33 = this.cursor.getDataSampleCount()) <= 0L || !this.a(var2_30, this.trackIndexData)) ** GOTO lbl130
                        var9_35 = this.getStreamPosition();
                        var10_37 = 0;
                        if (true) ** GOTO lbl159
lbl16:
                        // 3 sources

                        while (true) {
                            var1_1.put(JSON.regionMatches((String)"$%$:=!<9%;<:", (int)(29 * 29)), (AMFData)new AMFDataItem(this.container.getMoovAtom().getOffset() + 8L));
                            var11_4 = 0.0;
                            if (var5_32 != null) {
                                var13_13 = var5_32.getMdiaAtom().getTimescale();
                                var15_18 = var5_32.getMdiaAtom().getDuration();
                                var11_4 = (double)var15_18 / (double)var13_13;
                                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.toString((int)(-33 - -1), (String)"!4&*+\u000135)=#$\"w") + var11_4 + ":" + var13_13 + ":" + var15_18);
                            }
                            var13_10 = 0.0;
                            if (var3_2 != null) {
                                var15_15 = var3_2.getMdiaAtom().getTimescale();
                                var17_21 = var3_2.getMdiaAtom().getDuration();
                                var13_10 = (double)var17_21 / (double)var15_15;
                                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.toString((int)(29 * 47), (String)"%=138\u001c,(:(411z") + var13_10 + ":" + var15_15 + ":" + var17_21);
                            }
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.toString((int)(207 / 41), (String)"asui}cdb7") + Math.max(var11_4, var13_10));
                            var15_19 = Math.max(var11_4, var13_10);
                            this.duration = Math.round(var15_19 * 1000.0);
                            var1_1.put(JSON.regionMatches((String)"ykmauklj", (int)(39 * 27)), (AMFData)new AMFDataItem(var15_19));
                            var17_22 = new AMFDataList();
                            var17_22.add((AMFData)new AMFDataItem(Base64.toString((int)(94 + 16), (String)"!!\u001d4&2\u00104\"6")));
                            var17_22.add((AMFData)var1_1);
                            var18_23 /* !! */  = var17_22.serialize();
                            this.metaData.add(ByteBuffer.wrap(var18_23 /* !! */ ));
                            if (var6_3 == null) return;
                            var19_24 = var6_3.getDataTypes();
                            var20_27 = this.getAudioCodecConfig(0L);
                            if (var19_24.contains(Base64.toString((int)(29 * 47), (String)"}9%e")) || var19_24.contains(JSON.regionMatches((String)"zh-{", (int)(3 * 61))) && var20_27 == null) {
                                this.audioType = 47;
                                this.audioExtraSize = 1;
                                this.audioCodec = 2;
                                return;
                            }
                            if (var19_24.contains(Base64.toString((int)(175 / 31), (String)"vvbp")) == false) return;
                            if (var20_27 != null) return;
                            this.audioType = 178;
                            this.audioExtraSize = 1;
                            this.audioCodec = 11;
                            return;
                        }
lbl54:
                        // 2 sources

                        while (true) {
                            var23_50 = var12_39.getMdiaAtom().getMinfAtom().getStblAtom().getTX3GData();
                            var21_46 = this.a(var23_50, var19_26);
                            var7_34 = true;
                            break block35;
                            break;
                        }
lbl59:
                        // 2 sources

                        while (true) {
                            if (var6_3 != null) {
                                var1_1.put(Base64.toString((int)(-65 - 61), (String)"cv`lidgmohei"), (AMFData)new AMFDataItem(var6_3.getDataTypes().get(0)));
                            }
                            if (var4_31 != null) {
                                var1_1.put(Base64.toString((int)(56 + -34), (String)"`~||uxsy{|ie"), (AMFData)new AMFDataItem(var4_31.getDataTypes().get(0)));
                            }
                            if (var4_31 == null) ** GOTO lbl16
                            if (!this.useDisplaySize) {
                                var1_1.put(Base64.toString((int)(40 + 106), (String)"ezpa~"), (AMFData)new AMFDataItem(var4_31.getFrameWidth()));
                                var1_1.put(Base64.toString((int)(-23 - 39), (String)"*&-\".3"), (AMFData)new AMFDataItem(var4_31.getFrameHeight()));
                            } else {
                                var1_1.put(Base64.toString((int)(35 * 47), (String)":'+$9"), (AMFData)new AMFDataItem(var4_31.getDisplayWidth()));
                                var1_1.put(JSON.regionMatches((String)"r~uzvk", (int)(15 - -11)), (AMFData)new AMFDataItem(var4_31.getDisplayHeight()));
                            }
                            var1_1.put(JSON.regionMatches((String)"m~lcjGxvg|", (int)(61 * 7)), (AMFData)new AMFDataItem(var4_31.getFrameWidth()));
                            var1_1.put(Base64.toString((int)(1507 / 216), (String)"`uidoCidigd"), (AMFData)new AMFDataItem(var4_31.getFrameHeight()));
                            var1_1.put(JSON.regionMatches((String)"gmvvkip]bhyf", (int)(425 / 138)), (AMFData)new AMFDataItem(var4_31.getDisplayWidth()));
                            var1_1.put(JSON.regionMatches((String)"1?$(5;\"\u0014878(5", (int)(-15 - 28)), (AMFData)new AMFDataItem(var4_31.getDisplayHeight()));
                            var11_7 = var4_31.getFrameRate();
                            if (!(var11_7 > 0.0)) ** GOTO lbl16
                            var1_1.put(JSON.regionMatches((String)"sdvu|hzhx", (int)(-65 - 10)), (AMFData)new AMFDataItem(var11_7));
                            ** continue;
                            break;
                        }
lbl79:
                        // 1 sources

                        while (true) {
                            var21_46.put(JSON.regionMatches((String)"h}pns%5;3!", (int)(45 * 7)), (AMFData)new AMFDataItem(var19_26));
                            break block36;
                            break;
                        }
lbl82:
                        // 1 sources

                        while (true) {
                            block38: {
                                if (!StringUtils.isEmpty((String)var13_14) && !var13_14.equals(this.c)) break block38;
                                var22_49 = this.d.getLanguageRenditionAMF(var13_14);
                                if (var22_49 == null) ** GOTO lbl54
                                var22_49.setTrackIndex(var10_37);
                                ** continue;
                            }
                            var20_29 = true;
                            break block35;
                            break;
                        }
lbl91:
                        // 1 sources

                        while (true) {
                            this.cursor.setDataAtEnd();
                            this.cursor.dCursor = null;
                            this.cursor.dataTrackAtom = null;
                            ** GOTO lbl99
                            break;
                        }
lbl96:
                        // 3 sources

                        while (true) {
                            ++var11_6;
                            ** GOTO lbl135
lbl99:
                            // 2 sources

                            while (true) {
                                if (this.d != null && !var7_34 && (var11_9 = this.d.getLanguageRenditionAMF(this.c)) != null) {
                                    var11_9.setTrackIndex(var10_37 + 1);
                                    var12_40 = new AMFDataObj();
                                    var12_40.put(Base64.toString((int)(-24 - -59), (String)"oekarino"), (AMFData)new AMFDataItem(this.c));
                                    var12_40.put(JSON.regionMatches((String)"rnelyhmak", (int)(100 + 34)), (AMFData)new AMFDataItem(1000));
                                    var12_40.put(Base64.toString((int)(15 * 41), (String)"+-'-?$"), (AMFData)new AMFDataItem(1000L * var11_9.getDuration()));
                                    var13_14 = new AMFDataArray();
                                    var14_42 = new AMFDataObj();
                                    var14_42.put(JSON.regionMatches((String)"pehvkm}s{i", (int)(770 / 201)), (AMFData)new AMFDataItem(JSON.regionMatches((String)"!.d?", (int)(-60 - -17))));
                                    var13_14.add((AMFData)var14_42);
                                    var12_40.put(Base64.toString((int)(32 + 42), (String)"9*!=\"*44!0&<&#164"), (AMFData)var13_14);
                                    var8_55.add((AMFData)var12_40);
                                }
                                var1_1.put(JSON.regionMatches((String)"/.<=4)/$,", (int)(49 - -42)), (AMFData)var8_55);
                                if (var6_3 != null) {
                                    var1_1.put(JSON.regionMatches((String)",;+9>1;5;824*", (int)(2 - 53)), (AMFData)new AMFDataItem(var6_3.getAudioChannels()));
                                    var1_1.put(JSON.regionMatches((String)"bqaoh{hg{`h|ndt", (int)(172 / 47)), (AMFData)new AMFDataItem(var5_32.getMdiaAtom().getTimescale()));
                                }
                                if (var4_31 != null) {
                                    var11_5 = var3_2.getMdiaAtom().getTimescale();
                                    var13_11 = 0.0;
                                    if (var4_31.getTimeToSample() != null) {
                                        var15_17 = var4_31.getTimeToSample().get(0, 1);
                                        var13_11 = (double)var11_5 / (double)var15_17;
                                    }
                                    var1_1.put(JSON.regionMatches((String)"pnllem~lcjbpfv", (int)(1397 / 213)), (AMFData)new AMFDataItem(var13_11));
                                }
                                var1_1.put(Base64.toString((int)(443 / 67), (String)"gfkhe\u007f"), (AMFData)new AMFDataItem(2.0));
                                if (var4_31 == null || (var11_8 = var4_31.getAVCCData()) == null) ** GOTO lbl59
                                var1_1.put(JSON.regionMatches((String)"9/979+;3", (int)(53 + 67)), (AMFData)new AMFDataItem(var11_8.getAvcLevel()));
                                var1_1.put(Base64.toString((int)(654 / 120), (String)"dpdx{emeak"), (AMFData)new AMFDataItem(var11_8.getAvcProfile()));
                                ** continue;
                                break;
                            }
                            break;
                        }
lbl128:
                        // 4 sources

                        while (true) {
                            block39: {
                                this.setStreamPosition(var9_35);
lbl130:
                                // 2 sources

                                var7_34 = false;
                                var8_55 = new AMFDataArray();
                                var9_36 = var2_30.getTrakCount();
                                var10_37 = 0;
                                var11_6 = 0;
lbl135:
                                // 2 sources

                                if (var11_6 >= var9_36) break block39;
                                var12_39 = var2_30.getTrak(var11_6);
                                if (var12_39 == null) ** GOTO lbl96
                                var13_14 = var12_39.getLanguageStr();
                                if (var13_14.length() <= 0) {
                                    var13_14 = JSON.regionMatches((String)"`h`", (int)(473 / 84));
                                }
                                var14_42 = new AMFDataObj();
                                var14_42.put(Base64.toString((int)(43 * 59), (String)"%+%+8/(5"), (AMFData)new AMFDataItem(var13_14));
                                var14_42.put(Base64.toString((int)(-47 - -58), (String)"\u007fe`k|sp~v"), (AMFData)new AMFDataItem(var12_39.getMdiaAtom().getTimescale()));
                                var14_42.put(Base64.toString((int)(13 * 55), (String)"')#);8"), (AMFData)new AMFDataItem(var12_39.getMdiaAtom().getDuration()));
                                var15_16 = new AMFDataArray();
                                var16_45 = false;
                                var17_20 = var12_39.getMdiaAtom().getMinfAtom().getStblAtom().getDataTypes();
                                var18_23 /* !! */  = (byte[])var17_20.iterator();
                                break block37;
                            }
                            if (this.d != null || !this.b(var2_30, this.trackIndexData)) ** continue;
                            ** continue;
                            break;
                        }
                        while (true) {
                            if (this.onMetadataSample >= 0L) ** GOTO lbl128
                            this.cursor.moveNextSample();
                            if (this.cursor.isAtEnd()) ** GOTO lbl128
                            ++var10_37;
lbl159:
                            // 2 sources

                            if (var10_37 >= 10) ** GOTO lbl128
                            var11_6 = this.cursor.getCurrentType();
                            var12_38 = this.cursor.getTimeMillis();
                            if (var12_38 <= 0L) ** break;
                            ** continue;
                            if (var11_6 != 18 && var11_6 != 15) continue;
                            {
                                var14_43 = this.cursor.getFileLoc();
                                var16_44 = this.cursor.getSize();
                                if (var16_44 <= 0L) continue;
                                var18_23 /* !! */  = new byte[(int)var16_44];
                                var19_25 = 0;
                                var20_28 = this.videoFileStream;
                                synchronized (var20_28) {
                                    this.videoFileStream.seek(var14_43);
                                    var19_25 = this.videoFileStream.read(var18_23 /* !! */ , 0, (int)var16_44);
                                }
                                if ((long)var19_25 != var16_44 || (var20_28 = new AMFDataList(var18_23 /* !! */ )).size() <= 1 || var20_28.get(0).getType() != 2) continue;
                                var21_46 = var20_28.getString(0);
                                if (var21_46.equals(JSON.regionMatches((String)"Tfsc\\xnzZo\u007fre", (int)(23 + -3)))) {
                                    var20_28.remove(0);
                                }
                                if (var20_28.size() <= 1 || var20_28.get(0).getType() != 2 || !(var21_46 = var20_28.getString(0)).equalsIgnoreCase(Base64.toString((int)(52 + -16), (String)"kkKb|hNjxl")) || (var22_48 = var20_28.get(1).getType()) != 3 && var22_48 != 8) continue;
                                if (var22_48 == 3) {
                                    var23_50 = (AMFDataObj)var20_28.get(1);
                                    var24_51 = var23_50.getKeys();
                                    for (String var26_53 : var24_51) {
                                        var27_54 = var23_50.get(var26_53);
                                        var1_1.put(var26_53, var27_54);
                                    }
                                } else if (var22_48 == 8) {
                                    var23_50 = (AMFDataMixedArray)var20_28.get(1);
                                    var24_51 = var23_50.getKeys();
                                    for (String var26_53 : var24_51) {
                                        var27_54 = var23_50.get(var26_53);
                                        var1_1.put(var26_53, var27_54);
                                    }
                                }
                                this.onMetadataSample = this.cursor.getSample();
                                continue;
                            }
                            break;
                        }
                        ** while (this.d != null)
                    }
lbl203:
                    // 2 sources

                    while (!var18_23 /* !! */ .hasNext()) {
                        if (!var16_45) ** GOTO lbl96
                        var14_42.put(JSON.regionMatches((String)"dytjwyy{lcsksplii", (int)(33 * 55)), (AMFData)var15_16);
                        var8_55.add((AMFData)var14_42);
                        ** continue;
lbl208:
                        // 1 sources

                        ** GOTO lbl96
                    }
                    break block40;
                }
lbl211:
                // 2 sources

                ** while (!var20_29)
lbl212:
                // 1 sources

                var21_46.put(Base64.toString((int)(14 - 37), (String)":+&<!+;)!7"), (AMFData)new AMFDataItem(JSON.regionMatches((String)"7.59%0(2;,.", (int)(41 - -55))));
            }
            var15_16.add((AMFData)var21_46);
            var16_45 = true;
            ** GOTO lbl203
        }
        var19_26 = (String)var18_23 /* !! */ .next();
        var10_37 = var12_39.getTrackIndex();
        var20_29 = false;
        var21_46 = new AMFDataObj();
        if (!var19_26.equals(Base64.toString((int)(61 * 63), (String)"w|6a"))) ** GOTO lbl211
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private final boolean a(QTAtommoov qTAtommoov, int n) {
        block3: {
            String string;
            Iterator<String> iterator;
            boolean bl;
            block2: {
                bl = false;
                QTAtomtrak qTAtomtrak = qTAtommoov.getDataTrack(n);
                QTAtomstbl qTAtomstbl = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
                if (qTAtomstbl == null) return bl;
                List<String> list = qTAtomstbl.getDataTypes();
                iterator = list.iterator();
                if (!true) break block2;
                if (!iterator.hasNext()) return bl;
                if ((string = iterator.next()).toLowerCase().indexOf(JSON.regionMatches((String)"|syp", (int)(-41 - 26))) >= 0) break block3;
            }
            do {
                if (string.toLowerCase().indexOf(Base64.toString((int)(11 - 20), (String)"65?i")) >= 0) return true;
                if (!iterator.hasNext()) return bl;
            } while ((string = iterator.next()).toLowerCase().indexOf(JSON.regionMatches((String)"|syp", (int)(-41 - 26))) < 0);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean b(QTAtommoov qTAtommoov, int n) {
        String string;
        boolean bl = false;
        QTAtomtrak qTAtomtrak = qTAtommoov.getDataTrack(n);
        QTAtomstbl qTAtomstbl = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
        if (qTAtomstbl == null) return bl;
        List<String> list = qTAtomstbl.getDataTypes();
        Iterator<String> iterator = list.iterator();
        do {
            if (!iterator.hasNext()) return bl;
        } while ((string = iterator.next()).toLowerCase().indexOf(Base64.toString((int)(58 + 112), (String)"~s?j")) < 0);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private final AMFDataObj a(QTTX3GData qTTX3GData, String string) {
        AMFDataObj aMFDataObj = new AMFDataObj();
        aMFDataObj.put(JSON.regionMatches((String)" 58&;=-#+9", (int)(19 * 33)), (AMFData)new AMFDataItem(string));
        if (qTTX3GData == null) return aMFDataObj;
        AMFDataObj aMFDataObj2 = new AMFDataObj();
        aMFDataObj.put(Base64.toString((int)(59 * 9), (String)"wqswbtmioeq{"), (AMFData)aMFDataObj2);
        AMFDataObj aMFDataObj3 = new AMFDataObj();
        aMFDataObj.put(Base64.toString((int)(1268 / 207), (String)"bbnh\u007fgxykwds}k"), (AMFData)aMFDataObj3);
        aMFDataObj.put(Base64.toString((int)(101 + -67), (String)"fjwujfqofjk~"), (AMFData)new AMFDataItem(qTTX3GData.displayFlags));
        aMFDataObj.put(Base64.toString((int)(837 / 174), (String)"ljtnrfd\u007fmadzce{u}vwcqvt"), (AMFData)new AMFDataItem(qTTX3GData.justificationHoriz));
        aMFDataObj.put(JSON.regionMatches((String)"k{m4(!\"(/34< ,\"/,:&??", (int)(7 * 27)), (AMFData)new AMFDataItem(qTTX3GData.justificationVert));
        aMFDataObj.put(Base64.toString((int)(53 * 27), (String)"uyzq|nrkqdbmokw"), (AMFData)new AMFDataItem(qTTX3GData.backgroundColor));
        aMFDataObj3.put(JSON.regionMatches((String)"wku", (int)(15 * 45)), (AMFData)new AMFDataItem(qTTX3GData.textBox[0]));
        aMFDataObj3.put(JSON.regionMatches((String)"qmbns", (int)(352 / 105)), (AMFData)new AMFDataItem(qTTX3GData.textBox[3]));
        aMFDataObj3.put(JSON.regionMatches((String)"jbn}", (int)(534 / 85)), (AMFData)new AMFDataItem(qTTX3GData.textBox[1]));
        aMFDataObj3.put(Base64.toString((int)(61 * 11), (String)"}ouvli"), (AMFData)new AMFDataItem(qTTX3GData.textBox[2]));
        aMFDataObj2.put(Base64.toString((int)(44 - 15), (String)"nj~ruakew"), (AMFData)new AMFDataItem(qTTX3GData.startChar));
        aMFDataObj2.put(Base64.toString((int)(71 + 91), (String)"gm`fnfz"), (AMFData)new AMFDataItem(qTTX3GData.endChar));
        aMFDataObj2.put(JSON.regionMatches((String)"oeexdj", (int)(5 * 53)), (AMFData)new AMFDataItem(qTTX3GData.fontId));
        aMFDataObj2.put(Base64.toString((int)(39 * 29), (String)"--.+<$(>62970+"), (AMFData)new AMFDataItem(qTTX3GData.faceStyleFlags));
        aMFDataObj2.put(JSON.regionMatches((String)"177.(5';", (int)(122 + 93)), (AMFData)new AMFDataItem(qTTX3GData.fontSize));
        aMFDataObj2.put(Base64.toString((int)(300 / 94), (String)"wa}rdgeey"), (AMFData)new AMFDataItem(qTTX3GData.textColor));
        if (qTTX3GData.fonts.size() <= 0) return aMFDataObj;
        AMFDataObj aMFDataObj4 = new AMFDataObj();
        aMFDataObj.put(Base64.toString((int)(43 * 11), (String)"?55(17,4"), (AMFData)aMFDataObj4);
        Iterator<Integer> iterator = qTTX3GData.fonts.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            QTTX3GFont qTTX3GFont = qTTX3GData.fonts.get(n);
            aMFDataObj4.put(qTTX3GFont.fontId + "", (AMFData)new AMFDataItem(qTTX3GFont.fontName));
        }
        return aMFDataObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDuration() {
        if (this.duration >= 0L) {
            return this.duration;
        }
        double d = 0.0;
        IRandomAccessReader iRandomAccessReader = null;
        try {
            long l;
            iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
            iRandomAccessReader.open();
            QTParseContext qTParseContext = new QTParseContext();
            qTParseContext.setClientId(this.stream.getClientId());
            qTParseContext.setIndexFilePtr(iRandomAccessReader);
            IRandomAccessReader iRandomAccessReader2 = iRandomAccessReader;
            QTMediaContainer qTMediaContainer = QTUtils.parseQTMediaContainer(iRandomAccessReader2, iRandomAccessReader2.length(), qTParseContext);
            QTAtomtrak qTAtomtrak = qTMediaContainer.getMoovAtom().getVideoTrack(this.trackIndexVideo);
            QTAtomtrak qTAtomtrak2 = qTMediaContainer.getMoovAtom().getAudioTrack(this.trackIndexAudio);
            double d2 = 0.0;
            if (qTAtomtrak2 != null) {
                long l2 = qTAtomtrak2.getMdiaAtom().getTimescale();
                l = qTAtomtrak2.getMdiaAtom().getDuration();
                d2 = (double)l / (double)l2;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.toString((int)(53 * 23), (String)"\"1!/(\f<8*8$!!j") + d2 + ":" + l2 + ":" + l);
            }
            double d3 = 0.0;
            if (qTAtomtrak != null) {
                l = qTAtomtrak.getMdiaAtom().getTimescale();
                long l3 = qTAtomtrak.getMdiaAtom().getDuration();
                d3 = (double)l3 / (double)l;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(JSON.regionMatches((String)"socmfN~~lzf\u007f\u007f(", (int)(562 / 103)) + d3 + ":" + l + ":" + l3);
            }
            d = Math.max(d2, d3);
        }
        catch (Exception exception) {}
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {}
        }
        iRandomAccessReader = null;
        return Math.round(d * 1000.0);
    }

    public IMediaReaderStreamPosition getStreamPosition() {
        if (this.container != null) {
            return new H264StreamPosition(this.cursor.getAudioSample(), this.cursor.getVideoSample(), !this.cursor.isAtDataEnd() ? this.cursor.getDataSample() : -1L);
        }
        return new H264StreamPosition();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        if (this.container == null) {
            return;
        }
        H264StreamPosition h264StreamPosition = (H264StreamPosition)iMediaReaderStreamPosition;
        long l = h264StreamPosition.getAudioSample();
        long l2 = h264StreamPosition.getVideoSample();
        long l3 = h264StreamPosition.getDataSample();
        if (l >= 0L) {
            this.cursor.setAudioSample(l);
        }
        if (l2 >= 0L) {
            this.cursor.setVideoSample(l2);
        }
        if (l3 < 0L) {
            this.cursor.setDataAtEnd();
            return;
        }
        this.cursor.setDataSample(l3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() {
        if (this.videoFileStream == null) return 0L;
        long l = this.videoFileStream.length();
        return l;
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public List getMetadata() {
        return this.metaData;
    }

    public String getPath() {
        return this.videoFileStream.getPath();
    }

    public void rewind() {
        if (this.container != null) {
            this.cursor.setAudioSample(0L);
            this.cursor.setVideoSample(0L);
            this.cursor.setDataSample(0L);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlaylistSeekResult seek(long l, int n) {
        if (l > 0L) {
            return this.internalSeek(l, n);
        }
        l = 0L;
        return this.internalSeek(l, n);
    }

    /*
     * Unable to fully structure code
     */
    protected PlaylistSeekResult internalSeek(long var1_1, int var3_2) {
        block41: {
            block43: {
                block42: {
                    block34: {
                        block39: {
                            block40: {
                                block38: {
                                    block37: {
                                        block35: {
                                            block33: {
                                                block32: {
                                                    block36: {
                                                        var4_3 = new PlaylistSeekResult(var1_1);
                                                        if (this.container != null) break block36;
                                                        ** GOTO lbl126
lbl4:
                                                        // 1 sources

                                                        while (true) {
                                                            ++var11_8;
                                                            break block32;
                                                            break;
                                                        }
lbl7:
                                                        // 1 sources

                                                        while (true) {
                                                            var25_19 = 0;
                                                            ** GOTO lbl68
                                                            break;
                                                        }
lbl10:
                                                        // 1 sources

                                                        while (true) {
                                                            continue;
                                                            break;
                                                        }
lbl12:
                                                        // 2 sources

                                                        while (true) {
                                                            var4_3.setResults((IMediaReaderStreamPosition)new H264StreamPosition(var5_5, var9_7, var11_8), var13_11, 8, 1);
                                                            var4_3.setResultTimecode(var13_11);
                                                            var4_3.setSearchTimecode(var1_1);
                                                            return var4_3;
                                                        }
lbl17:
                                                        // 1 sources

                                                        while (true) {
                                                            var26_21 = this.cursor.dataSampleToTimecode(var23_18);
                                                            var28_22 = this.cursor.dataTimecodeToTimeMillis(var26_21);
                                                            if (var28_22 < var15_14) ** GOTO lbl123
                                                            ** GOTO lbl108
                                                            break;
                                                        }
lbl22:
                                                        // 1 sources

                                                        while (true) {
                                                            v0 = this.cursor;
                                                            var5_5 = v0.audioTimecodeToSample(v0.audioTimeMillisToTimecode(var1_1));
                                                            break block33;
                                                            break;
                                                        }
lbl26:
                                                        // 1 sources

                                                        while (true) {
                                                            var15_14 = this.cursor.videoSampleToTimecode(var9_7);
                                                            var13_11 = this.cursor.videoTimecodeToTimeMillis(var15_14);
                                                            this.cursor.resetVideoAtEnd();
                                                            break block34;
                                                            break;
                                                        }
                                                    }
                                                    var5_5 = -1L;
                                                    var7_6 = -1L;
                                                    var9_7 = -1L;
                                                    var11_8 = -1L;
                                                    if (!this.cursor.containsAudio()) break block33;
                                                    ** while (true)
lbl38:
                                                    // 1 sources

                                                    while (true) {
                                                        ++var25_19;
                                                        ** GOTO lbl68
                                                        break;
                                                    }
lbl41:
                                                    // 1 sources

                                                    while (true) {
                                                        var15_14 = this.cursor.audioSampleToTimecode(var5_5);
                                                        var13_11 = this.cursor.audioTimecodeToTimeMillis(var15_14);
                                                        this.cursor.resetAudioAtEnd();
                                                        break block34;
                                                        break;
                                                    }
                                                }
                                                ++var13_9;
                                                ** GOTO lbl117
                                            }
                                            if (!this.cursor.containsData()) break block37;
                                            break block38;
                                            v1 = this.cursor;
                                            var9_7 = v1.videoTimecodeToSample(v1.videoTimeMillisToTimecode(var1_1));
                                            block0 : switch (var3_2) {
                                                case 3: {
                                                    var7_6 = this.cursor.videoFindKeySample(var9_7, 3);
                                                    ** GOTO lbl141
                                                }
lbl58:
                                                // 1 sources

                                                while (true) {
                                                    if (!this.cursor.getDataSampleValid(var11_8 + 1L)) break block0;
                                                    ** continue;
                                                    break;
                                                }
lbl61:
                                                // 1 sources

                                                while (var5_5 >= 0L) {
                                                    ** continue;
lbl63:
                                                    // 1 sources

                                                    ** GOTO lbl41
                                                }
                                                break block34;
lbl65:
                                                // 1 sources

                                                while (this.cursor.getAudioSampleValid(var19_16 + 1L)) {
                                                    ** GOTO lbl113
                                                }
                                                ** GOTO lbl127
lbl68:
                                                // 2 sources

                                                if (var25_19 >= 10) ** GOTO lbl108
                                                ** continue;
lbl70:
                                                // 1 sources

                                                while (true) {
                                                    ++var23_18;
                                                    ** continue;
                                                    break;
                                                }
lbl73:
                                                // 1 sources

                                                while (true) {
                                                    var15_14 = this.cursor.audioSampleToTimecode(var5_5);
                                                    var17_15 = this.cursor.audioTimecodeToTimeMillis(var15_14);
                                                    var19_16 = this.cursor.videoSampleToTimecode(var9_7);
                                                    var21_17 = this.cursor.videoTimecodeToTimeMillis(var19_16);
                                                    if (!this.onSeekUseVideoTimecode) ** GOTO lbl130
                                                    ** GOTO lbl115
                                                    break;
                                                }
lbl80:
                                                // 2 sources

                                                while (true) {
                                                    var4_3.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(-1L, -1L, -1L));
                                                    ** GOTO lbl102
                                                    break;
                                                }
                                                while (true) {
                                                    var4_3.setResultVideoTimecode(var15_14);
                                                    ** GOTO lbl96
                                                    break;
                                                }
lbl86:
                                                // 1 sources

                                                while (true) {
                                                    var13_10 = this.cursor.videoSampleToTimecode(var7_6);
                                                    var15_14 = this.cursor.videoTimecodeToTimeMillis(var13_10);
                                                    var17_15 = this.cursor.audioTimeMillisToTimecode(var15_14);
                                                    var19_16 = this.cursor.audioTimecodeToSample(var17_15);
                                                    var21_17 = this.cursor.dataTimeMillisToTimecode(var15_14);
                                                    var23_18 = this.cursor.dataTimecodeToSample(var21_17);
                                                    if (var23_18 >= 0L) {
                                                        ** continue;
                                                    }
                                                    ** GOTO lbl108
                                                    break;
                                                }
lbl96:
                                                // 2 sources

                                                while (true) {
                                                    this.cursor.resetVideoAtEnd();
                                                    ** GOTO lbl102
                                                    break;
                                                }
                                                case 1: {
                                                    var7_6 = this.cursor.videoFindKeySample(var9_7, 1);
                                                    ** GOTO lbl141
                                                }
lbl102:
                                                // 2 sources

                                                var13_11 = 0L;
                                                if (var5_5 < 0L) break block39;
                                                break block40;
                                                case 2: {
                                                    var7_6 = this.cursor.videoFindKeySample(var9_7, 2);
                                                    ** GOTO lbl141
                                                }
lbl108:
                                                // 4 sources

                                                while (true) {
                                                    var17_15 = this.cursor.audioSampleToTimecode(var19_16);
                                                    var25_20 = this.cursor.audioTimecodeToTimeMillis(var17_15);
                                                    if (var25_20 >= var15_14) ** GOTO lbl127
                                                    ** GOTO lbl65
                                                    break;
                                                }
lbl113:
                                                // 1 sources

                                                var17_15 = this.cursor.audioSampleToTimecode(++var19_16);
                                                ** GOTO lbl127
lbl115:
                                                // 1 sources

                                                var13_11 = var21_17;
                                                break block41;
lbl117:
                                                // 2 sources

                                                while (var13_9 < 10) {
                                                    break block35;
                                                }
                                                break block37;
lbl120:
                                                // 1 sources

                                                while (true) {
                                                    var13_9 = 0;
                                                    ** GOTO lbl117
                                                    break;
                                                }
lbl123:
                                                // 1 sources

                                                if (this.cursor.getDataSampleValid(var23_18 + 1L)) {
                                                    ** continue;
                                                }
                                                break block42;
lbl126:
                                                // 1 sources

                                                return var4_3;
lbl127:
                                                // 3 sources

                                                var4_3.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(var19_16, var7_6, var23_18));
                                                if (var5_5 < 0L) ** continue;
                                                break block43;
lbl130:
                                                // 1 sources

                                                var13_11 = Math.min(var17_15, var21_17);
                                                break block41;
                                                case 4: {
                                                    ** GOTO lbl141
                                                }
                                                default: {
                                                    if (var7_6 < 0L) ** continue;
                                                }
                                            }
                                            var11_8 = -1L;
                                            break block37;
                                        }
                                        ** while ((var16_4 = this.cursor.dataTimecodeToTimeMillis((long)(var14_13 = this.cursor.dataSampleToTimecode((long)var11_8)))) < var1_1)
lbl140:
                                        // 1 sources

                                        break block37;
lbl141:
                                        // 5 sources

                                        if (var7_6 < 0L) ** GOTO lbl80
                                        ** while (true)
                                    }
lbl144:
                                    // 2 sources

                                    while (true) {
                                        if (!this.cursor.containsVideo()) ** GOTO lbl141
                                        ** continue;
                                        break;
                                    }
lbl147:
                                    // 1 sources

                                    while (true) {
                                        this.cursor.resetDataAtEnd();
                                        ** GOTO lbl12
                                        break;
                                    }
                                }
                                v2 = this.cursor;
                                ** while ((var11_8 = v2.dataTimecodeToSample((long)v2.dataTimeMillisToTimecode((long)var1_1))) < 0L)
lbl153:
                                // 1 sources

                                ** while (true)
                            }
                            ** while (var9_7 >= 0L)
                        }
                        if (var9_7 < 0L) ** GOTO lbl61
                        ** while (true)
                    }
lbl160:
                    // 2 sources

                    while (true) {
                        if (var11_8 >= 0L) ** break;
                        ** continue;
                        ** continue;
                        break;
                    }
                }
                var23_18 = -1L;
                ** while (true)
            }
            var27_23 = this.cursor.audioTimecodeToTimeMillis(var17_15);
            var4_3.setResultVideoTimecode(Math.min(var27_23, var15_14));
            ** while (true)
        }
        this.cursor.resetAudioAtEnd();
        this.cursor.resetVideoAtEnd();
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.chunkWorkBuffer == null) {
            bl = true;
        } else if (this.chunkWorkBuffer.length < n) {
            bl = true;
        }
        if (!bl) return;
        this.chunkWorkBuffer = new byte[n];
    }

    public void startPlayback() {
        this.doSendVideoTrakInfo = true;
        this.doSendAudioTrakInfo = true;
        this.doSendEnhanceSeek = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        if (iClient.testFlashVersion(nArray) < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long getSampleDesc(H264Cursor h264Cursor, long l, int n) {
        long l2 = 0L;
        H264ReadAheadPacket h264ReadAheadPacket = this.getReadAheadPacket(n, l);
        if (h264ReadAheadPacket == null) return h264Cursor.getSampleDesc();
        return h264ReadAheadPacket.getSampleDesc();
    }

    /*
     * Exception decompiling
     */
    public int writeGeneratedKeyFrame(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 711->734)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte getFirstByte(H264Cursor h264Cursor) {
        byte by = 0;
        int n = h264Cursor.getCurrentType();
        switch (n) {
            case 9: {
                if (!h264Cursor.isKeyFrame()) return 39;
                return 23;
            }
            case 15: 
            case 18: {
                by = 0;
            }
            default: {
                return by;
            }
            case 8: 
        }
        return (byte)this.audioType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int writeEnhancedCmd(int n, int n2, int n3, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, long[] lArray, int n4) {
        int n5 = 0;
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return 0;
        try {
            int[] nArray = new int[5];
            nArray[1] = 0;
            nArray[2] = n3;
            nArray[0] = 9;
            byte[] byArray = new byte[]{(byte)n, (byte)(0xFF & n2)};
            nArray[1] = 2;
            int n6 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, byArray);
            n5 += n6;
            lArray[2] = lArray[2] + (long)n6;
            lArray[3] = lArray[3] + 1L;
            return n5;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(JSON.regionMatches((String)"HccahXnmik}X#$':px\u007fywy~x^s{:!", (int)(419 / 83)) + exception.toString());
            return n5;
        }
    }

    /*
     * WARNING - bad return control flow
     * Enabled aggressive block sorting
     */
    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        Object object;
        Object object2;
        int n3;
        block9: {
            QTAtommdia qTAtommdia;
            QTAtommoov qTAtommoov;
            byte[] byArray;
            QTAtomstbl qTAtomstbl;
            block8: {
                n3 = 0;
                switch (n) {
                    case 9: {
                        qTAtomstbl = null;
                        byArray = null;
                        qTAtommoov = this.container.getMoovAtom();
                        if (qTAtommoov == null) {
                            break;
                        }
                        break block8;
                    }
                    case 8: {
                        return n3;
                    }
                }
                break block9;
            }
            object2 = qTAtommoov.getVideoTrack(this.trackIndexVideo);
            if (object2 != null && (qTAtommdia = ((QTAtomtrak)object2).getMdiaAtom()) != null && (object = qTAtommdia.getMinfAtom()) != null && (qTAtomstbl = ((QTAtomminf)object).getStblAtom()) != null) {
                AVCCData aVCCData;
                long l = playlistCursor.getVideoSampleDesc();
                if (l < 0L) {
                    l = 0L;
                }
                if ((aVCCData = qTAtomstbl.getAVCCData((int)l)) != null) {
                    byArray = aVCCData.getAvccBytes();
                }
            }
        }
        int n4 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n4);
        object2 = new byte[5];
        int n5 = 0;
        object = new int[5];
        object[1] = false;
        object[2] = n2;
        object[0] = 9;
        object2[0] = 23;
        object2[1] = 2;
        object2[2] = false;
        object2[3] = false;
        object2[4] = false;
        object[1] = 5;
        n5 = this.directOutputBuf((int[])object, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, (byte[])object2);
        lArray[2] = lArray[2] + (long)n5;
        lArray[3] = lArray[3] + 1L;
        return n3 += n5;
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected byte[] getVideoCodecConfig(long l) {
        byte[] byArray = null;
        QTAtomstbl qTAtomstbl = null;
        Object var5_4 = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return byArray;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getVideoTrack(this.trackIndexVideo);
        if (qTAtomtrak == null) {
            return byArray;
        }
        QTAtommdia qTAtommdia = qTAtomtrak.getMdiaAtom();
        if (qTAtommdia == null) {
            return byArray;
        }
        QTAtomminf qTAtomminf = qTAtommdia.getMinfAtom();
        if (qTAtomminf == null) {
            return byArray;
        }
        qTAtomstbl = qTAtomminf.getStblAtom();
        if (qTAtomstbl == null) return byArray;
        AVCCData aVCCData = qTAtomstbl.getAVCCData((int)l);
        if (aVCCData == null) return byArray;
        return aVCCData.getAvccBytes();
    }

    /*
     * Unable to fully structure code
     */
    public int sendVideoTrakData(int var1_1, boolean var2_2, IMediaStream var3_3, OutputStream var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10, byte[] var11_11) {
        block11: {
            block7: {
                block9: {
                    block10: {
                        block6: {
                            block8: {
                                var12_12 = 0;
                                var13_13 = false;
                                var14_14 = var6_6.getWriteControl().getChunkSize();
                                this.checkWorkBuffer(var14_14);
                                if (var11_11 != null) break block8;
                                break block9;
lbl7:
                                // 2 sources

                                return var12_12;
lbl9:
                                // 1 sources

                                while (true) {
                                    var16_16 = this.directOutputBuf(var17_17, var2_2, var3_3.getSrc(), var4_4, var5_5, this.chunkWorkBuffer, var14_14, var15_15);
                                    var12_12 += var16_16;
                                    var9_9[2] = var9_9[2] + (long)var16_16;
                                    var9_9[3] = var9_9[3] + 1L;
                                    ++var18_18;
                                    break block6;
                                    break;
                                }
lbl16:
                                // 2 sources

                                while (true) {
                                    if (var18_18 >= v0) ** GOTO lbl7
                                    ** continue;
                                    break;
                                }
lbl19:
                                // 1 sources

                                while (true) {
                                    v0 = 2;
                                    ** GOTO lbl16
                                    break;
                                }
                            }
                            v1 = var11_11.length;
                            break block10;
                        }
lbl26:
                        // 2 sources

                        while (var13_13) {
                            ** continue;
lbl28:
                            // 1 sources

                            ** GOTO lbl19
                        }
                        break block11;
                    }
lbl31:
                    // 2 sources

                    while (true) {
                        var15_15 = new byte[v1 + 5];
                        var16_16 = 0;
                        var17_17 = new int[5];
                        var17_17[1] = 0;
                        var17_17[2] = var1_1;
                        var17_17[0] = 9;
                        if (var11_11 != null) ** break;
                        ** continue;
                        break block7;
                        break;
                    }
                }
                v1 = 0;
                ** while (true)
            }
            var15_15[0] = 23;
            var15_15[1] = 0;
            var15_15[2] = 0;
            var15_15[3] = 0;
            var15_15[4] = 0;
            System.arraycopy(var11_11, 0, var15_15, 5, var11_11.length);
            var17_17[1] = var11_11.length + 5;
            var17_17[2] = 0;
            var2_2 = false;
            var18_18 = 0;
            ** GOTO lbl26
        }
        v0 = 1;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected byte[] getAudioCodecConfig(long l) {
        byte[] byArray = null;
        QTAtomstbl qTAtomstbl = null;
        ESDSData eSDSData = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return byArray;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getAudioTrack(this.trackIndexAudio);
        if (qTAtomtrak == null) {
            return byArray;
        }
        QTAtommdia qTAtommdia = qTAtomtrak.getMdiaAtom();
        if (qTAtommdia == null) {
            return byArray;
        }
        QTAtomminf qTAtomminf = qTAtommdia.getMinfAtom();
        if (qTAtomminf == null) {
            return byArray;
        }
        qTAtomstbl = qTAtomminf.getStblAtom();
        if (qTAtomstbl == null) {
            return byArray;
        }
        eSDSData = qTAtomstbl.getESDSData((int)l);
        if (eSDSData != null) return eSDSData.specData;
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int sendAudioTrakData(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, byte[] byArray) {
        int n2 = 0;
        if (byArray == null) {
            return n2;
        }
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        int[] nArray = new int[5];
        nArray[1] = 0;
        nArray[2] = n;
        nArray[0] = 8;
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = -81;
        byArray2[1] = 0;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        nArray[1] = byArray.length + 2;
        int n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, byArray2);
        n2 += n4;
        lArray[0] = lArray[0] + (long)n4;
        lArray[1] = lArray[1] + 1L;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        if (this.container == null) {
            return 0;
        }
        if (fastPlaySettings == null) return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
        if (fastPlaySettings.getDirection() >= 0) return this.writePacketsFastPlay(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
        return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int writePackets(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10) {
        block39: {
            var11_11 = 0;
            var12_12 = false;
            var13_13 = false;
            var14_14 = false;
            var15_15 = 0;
            var16_16 = var7_7.getMaxTC();
            this.videoFileStream.setDirecton(1);
            var18_17 = var6_6.getWriteControl().getChunkSize();
            this.checkWorkBuffer(var18_17);
            var19_18 = 0L;
            var21_19 = 0L;
            ** GOTO lbl189
lbl-1000:
            // 1 sources

            {
                block42: {
                    block43: {
                        block40: {
                            block41: {
                                block50: {
                                    block44: {
                                        while (var27_23 >= var16_16) {
                                            // MONITOREXIT : var23_20
                                            break block39;
                                        }
                                        break block43;
                                        while (true) {
                                            this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastVideoTC() & 0xFFFFFFFFL);
                                            ** GOTO lbl94
                                            break;
                                        }
                                        while (true) {
                                            var6_6.setSendAbsBroadcastTC(false);
                                            ** GOTO lbl109
                                            break;
                                        }
lbl23:
                                        // 2 sources

                                        while (true) {
                                            var11_11 += var33_33;
                                            ** GOTO lbl51
lbl26:
                                            // 1 sources

                                            while (this.videoCodec == 7) {
                                                v0 = true;
                                                ** GOTO lbl69
                                            }
                                            ** GOTO lbl63
                                            break;
                                        }
lbl30:
                                        // 1 sources

                                        while (this.videoCodec != 7) {
                                            break block40;
                                        }
                                        break block44;
                                        while (true) {
                                            this.chunkHeaderValues[2] = 0;
                                            ** GOTO lbl131
                                            break;
                                        }
lbl36:
                                        // 1 sources

                                        while (true) {
                                            var9_9[6] = var9_9[6] + (long)this.chunkHeaderValues[1];
                                            var9_9[7] = var9_9[7] + 1L;
                                            ** break;
                                            break;
                                        }
                                        while (true) {
                                            this.chunkHeaderValues[2] = (int)(var30_26 + var6_6.getStartTCOffset());
                                            var27_23 = var30_26;
                                            ** GOTO lbl91
                                            break;
                                        }
                                        while (true) {
                                            block48: {
                                                block47: {
                                                    block45: {
                                                        block46: {
                                                            if (var10_10) {
                                                                this.chunkHeaderValues[2] = 0;
                                                            }
                                                            if (var21_19 == var6_6.getVideoSampleDesc()) break block45;
                                                            var31_28 = this.getVideoCodecConfig(var21_19);
                                                            var32_30 = var6_6.compareAndSetVideoCodecConfig(var31_28);
                                                            if (var32_30 == 0) break block46;
lbl51:
                                                            // 2 sources

                                                            var6_6.setVideoSampleDesc(var21_19);
                                                            break block45;
                                                        }
                                                        v1 = this;
                                                        var33_33 = v1.sendVideoTrakData(v1.chunkHeaderValues[2], (boolean)var29_24, var1_1, var2_2, var4_4, var6_6, var7_7, var8_8, var9_9, var10_10, var31_28);
                                                        if (var33_33 <= 0) ** GOTO lbl23
                                                        break block47;
                                                    }
                                                    var6_6.setLastVideoTC(var27_23);
                                                    var6_6.incVideoPacketCount();
                                                    var25_22 = var27_23;
                                                    if (!var1_1.isReceiveVideo()) ** GOTO lbl26
lbl63:
                                                    // 2 sources

                                                    v0 = false;
                                                    break block48;
                                                }
                                                var29_24 = 0;
                                                this.chunkHeaderValues[2] = 0;
                                                ** continue;
                                            }
                                            var31_27 = v0;
                                            v2 = this;
                                            var32_30 = v2.directOutput(v2.chunkHeaderValues, var19_18, (boolean)var29_24, var1_1.getSrc(), var2_2, var4_4, this.chunkWorkBuffer, var18_17, this.cursor, var31_27);
                                            var11_11 += var32_30;
                                            var24_21 = true;
                                            var8_8.incVideoPackets();
                                            if (this.videoSampleCount > 0L && var19_18 == this.videoSampleCount - 1L) {
                                                v3 = this;
                                                var33_33 = v3.directOutput(v3.chunkHeaderValues, var19_18, (boolean)var29_24, var1_1.getSrc(), var2_2, var4_4, this.chunkWorkBuffer, var18_17, this.cursor, true);
                                                var11_11 += var33_33;
                                                var8_8.incVideoPackets();
                                            }
                                            var12_12 = true;
                                            var13_13 = true;
                                            var9_9[2] = var9_9[2] + (long)var32_30;
                                            var9_9[3] = var9_9[3] + 1L;
                                            break block40;
                                            break;
                                        }
lbl86:
                                        // 2 sources

                                        while (true) {
                                            var29_24 = var6_6.isSendAbsVideoTC();
                                            if (!var6_6.isSendAbsVideoTC()) ** continue;
                                            if ((var30_26 = var6_6.getForceVideoTC()) >= 0L) ** continue;
                                            this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
lbl91:
                                            // 2 sources

                                            if (this.chunkHeaderValues[2] < 0) break block40;
                                            var6_6.setForceVideoTC(-1L);
                                            var6_6.setSendAbsVideoTC(false);
lbl94:
                                            // 2 sources

                                            var30_25 = var7_7.testVideoFrame(this.chunkHeaderValues[3]);
                                            if (this.chunkHeaderValues[2] >= 0 && var30_25) ** continue;
                                            if (var30_25) ** break;
                                            ** continue;
                                            break;
                                        }
                                        while (true) {
                                            var31_27 = false;
                                            this.chunkHeaderValues[2] = 0;
                                            ** GOTO lbl137
                                            break;
                                        }
lbl102:
                                        // 2 sources

                                        while (true) {
                                            var32_30 = var6_6.isSendAbsBroadcastTC();
                                            if (var6_6.isSendAbsBroadcastTC()) {
                                                this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                                if (this.chunkHeaderValues[2] >= 0) ** continue;
                                                break block40;
                                            } else {
                                                this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastBroadcastTC() & 0xFFFFFFFFL);
lbl109:
                                                // 2 sources

                                                var6_6.setLastBroadcastTC(var27_23);
                                                var6_6.incDataPacketCount();
                                                var25_22 = var27_23;
                                                if (var10_10) {
                                                    this.chunkHeaderValues[2] = 0;
                                                }
                                                v4 = this;
                                                var33_33 = v4.directOutput(v4.chunkHeaderValues, var19_18, (boolean)var32_30, var1_1.getSrc(), var2_2, var5_5, this.chunkWorkBuffer, var18_17, this.cursor, false);
                                                var11_11 += var33_33;
                                                var9_9[4] = var9_9[4] + (long)var33_33;
                                                var9_9[5] = var9_9[5] + 1L;
                                                var24_21 = true;
                                            }
                                            break block40;
                                            break;
                                        }
lbl121:
                                        // 1 sources

                                        while (!var7_7.isAudioFilter()) {
                                            block49: {
                                                var31_27 = var6_6.isSendAbsAudioTC();
                                                if (var6_6.isSendAbsAudioTC()) {
                                                    this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                                    if (this.chunkHeaderValues[2] < 0) break block40;
                                                    var6_6.setSendAbsAudioTC(false);
                                                } else {
                                                    this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastAudioTC() & 0xFFFFFFFFL);
                                                }
                                                if (this.chunkHeaderValues[2] < 0) ** break;
                                                if (var10_10) ** continue;
lbl131:
                                                // 2 sources

                                                if (var21_19 == var6_6.getAudioSampleDesc()) break block49;
                                                var32_31 = this.getAudioCodecConfig(var21_19);
                                                var33_33 = var6_6.compareAndSetAudioCodecConfig(var32_31);
                                                if (var33_33 == 0) {
                                                    v5 = this;
                                                    if ((var34_34 = v5.sendAudioTrakData(v5.chunkHeaderValues[2], var31_27, var1_1, var2_2, var3_3, var6_6, var7_7, var8_8, var9_9, var10_10, var32_31)) > 0) ** continue;
                                                }
lbl137:
                                                // 4 sources

                                                var6_6.setAudioSampleDesc(var21_19);
                                            }
                                            var6_6.setLastAudioTC(var27_23);
                                            var6_6.incAudioPacketCount();
                                            var25_22 = var27_23;
                                            v6 = this;
                                            var32_30 = v6.directOutput(v6.chunkHeaderValues, var19_18, var31_27, var1_1.getSrc(), var2_2, var3_3, this.chunkWorkBuffer, var18_17, this.cursor, false);
                                            var11_11 += var32_30;
                                            var24_21 = true;
                                            var8_8.incAudioPackets();
                                            var12_12 = true;
                                            var14_14 = true;
                                            var9_9[0] = var9_9[0] + (long)var32_30;
                                            var9_9[1] = var9_9[1] + 1L;
                                            break block40;
                                        }
                                        break block40;
                                        block24: while (true) {
                                            switch (this.chunkHeaderValues[0]) {
                                                case 8: {
                                                    if (var1_1.isReceiveAudio()) break;
                                                    break block40;
                                                }
                                                case 9: {
                                                    if (var1_1.isReceiveVideo()) break block24;
                                                    ** GOTO lbl30
                                                }
                                                case 15: 
                                                case 18: {
                                                    if (this.onMetadataSample < 0L) ** GOTO lbl102
                                                    break block41;
                                                }
                                            }
                                            if (!var7_7.isSkipAudio()) ** GOTO lbl121
                                            break block40;
                                            break;
                                        }
                                    }
                                    if (!var6_6.isWaitForKeyFrame()) ** GOTO lbl86
                                    var29_24 = FLVUtils.getFrameType((int)this.chunkHeaderValues[3]);
                                    if (var29_24) break block50;
                                    break block40;
                                }
                                var6_6.setWaitForKeyFrame(false);
                                ** continue;
                            }
                            if (var19_18 == this.onMetadataSample) ** break;
                            ** continue;
                        }
                        var8_8.setLastTC(var27_23);
                        ++var15_15;
                        this.cursor.moveNextSample();
                        if (var16_16 != 0L) ** GOTO lbl-1000
                        if (var13_13 || var15_15 > 20) {
                            // MONITOREXIT : var23_20
                            break block39;
                        }
                    }
                    // MONITOREXIT : var23_20
lbl189:
                    // 2 sources

                    var23_20 = this.lock;
                    // MONITORENTER : var23_20
                    if (var6_6.isBreakLoop()) {
                        // MONITOREXIT : var23_20
                        break block39;
                    }
                    if (!this.cursor.isAtEnd()) break block42;
                    var8_8.setHitEnd(true);
                    // MONITOREXIT : var23_20
                    break block39;
                }
                this.chunkHeaderValues[2] = (int)this.cursor.getTimeMillis();
                this.chunkHeaderValues[0] = this.cursor.getCurrentType();
                v7 = this;
                this.chunkHeaderValues[3] = v7.getFirstByte(v7.cursor);
                var19_18 = this.cursor.getSample();
                v8 = this;
                var21_19 = v8.getSampleDesc(v8.cursor, var19_18, this.chunkHeaderValues[0]);
                var24_21 = false;
                var25_22 = 0L;
                var27_23 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                if (var16_16 <= 0L || var27_23 < var16_16) ** continue;
                // MONITOREXIT : var23_20
            }
        }
        var8_8.setTotalSize(var11_11);
        return var11_11;
        catch (Throwable var35_35) {
            // MONITOREXIT : var23_20
            throw var35_35;
        }
    }

    /*
     * Exception decompiling
     */
    public int writePacketsFastPlay(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [41[UNCONDITIONALDOLOOP], 42[UNCONDITIONALDOLOOP]], but top level block is 4[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected int directOutput(int[] var1_1, long var2_2, boolean var4_3, int var5_4, OutputStream var6_5, AMFObj var7_6, byte[] var8_7, int var9_8, H264Cursor var10_9, boolean var11_10) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [0 : 294->467)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int directOutputBuf(int[] var1_1, boolean var2_2, int var3_3, OutputStream var4_4, AMFObj var5_5, byte[] var6_6, int var7_7, byte[] var8_8) {
        block23: {
            block22: {
                block21: {
                    var9_9 = 0;
                    try {
                        var10_11 = (long)var1_1[2] & 0xFFFFFFFFL;
                        var12_12 = var1_1[1];
                        var13_13 = var1_1[0];
                        var14_14 = IFasterByteArrayOutputStream.getProtocol((OutputStream)var4_4);
                        var15_15 = var5_5.getId();
                        var16_16 = var5_5.isNew();
                        var17_17 = var16_16 | var2_2;
                        var18_18 = false;
                        var5_5.setNew(false);
                        if (var14_14 != 4) break block21;
                        var19_20 = IFasterByteArrayOutputStream.getWOWZSession((OutputStream)var4_4);
                        var20_22 = new WOWZHeader();
                        var20_22.cid = var15_15;
                        var20_22.timecode = var10_11;
                        var20_22.isTimecodeAbs = var17_17;
                        var20_22.size = var12_12;
                        var20_22.type = var13_13;
                        var20_22.src = var3_3;
                        var20_22.updateFlags();
                        var5_5.setSize(var12_12);
                        var5_5.setType(var13_13);
                        var5_5.setTimecode(var10_11);
                        var5_5.setLastSentAbsTimecode(var16_16);
                        var5_5.setSrc(var3_3);
                        var9_9 += var19_20.sendStart(var4_4);
                        var9_9 += var19_20.writeHeader(var4_4, var20_22);
                        if (var12_12 <= 0) return var9_9 += var19_20.sendStop(var4_4);
                    }
                    catch (Exception var10_10) {
                        WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.toString((int)(800 / 147), (String)"HccahXnmik}X#$':q\u007fe}znTiinjtCwe>%") + var10_10.toString());
                        var10_10.printStackTrace();
                        return var9_9;
                    }
                    var4_4.write(var8_8, 0, var12_12);
                    var9_9 += var12_12;
                    return var9_9 += var19_20.sendStop(var4_4);
                }
                var19_19 = 0;
                var6_6[0] = (byte)(255 & var15_15);
                if (var10_11 >= 0xFFFFFFL) {
                    var6_6[1] = -1;
                    var6_6[2] = -1;
                    var6_6[3] = -1;
                    var18_18 = true;
                } else {
                    var6_6[1] = (byte)(255L & var10_11 >> 16);
                    var6_6[2] = (byte)(255L & var10_11 >> 8);
                    var6_6[3] = (byte)(255L & var10_11);
                }
                var6_6[4] = (byte)(255 & var12_12 >> 16);
                var6_6[5] = (byte)(255 & var12_12 >> 8);
                var6_6[6] = (byte)(255 & var12_12);
                var6_6[7] = (byte)var13_13;
                var19_19 += 8;
                var5_5.setSize(var12_12);
                var5_5.setType(var13_13);
                var5_5.setTimecode(var10_11);
                if (var17_17 || var5_5.getSrc() != var3_3) {
                    var6_6[8] = (byte)(255 & var3_3);
                    var6_6[9] = (byte)(255 & var3_3 >> 8);
                    var6_6[10] = (byte)(255 & var3_3 >> 16);
                    var6_6[11] = (byte)(255 & var3_3 >> 24);
                    var19_19 += 4;
                    var5_5.setSrc(var3_3);
                }
                if (var15_15 < 64) break block22;
            }
            if (var19_19 < 12) {
                var6_6[0] = (byte)(var6_6[0] | 64);
            }
            var4_4.write(var6_6, 0, var19_19);
            var9_9 += var19_19;
            break block23;
            var20_21 = var15_15 - 64;
            var21_23 = var20_21 <= 255 ? 2 : 3;
            var22_25 = new byte[var21_23];
            if (var19_19 < 12) {
                var22_25[0] = (byte)(64 + (var21_23 - 2));
            }
            var22_25[1] = (byte)(255 & var20_21);
            if (var21_23 == 3) {
                var22_25[2] = (byte)(255 & var20_21 >> 8);
            }
            var4_4.write(var22_25, 0, var21_23);
            var4_4.write(var6_6, 1, var19_19 - 1);
            var9_9 += var19_19 + 1;
        }
        if (var18_18) {
            var6_6[0] = (byte)(255L & var10_11 >> 24);
            var6_6[1] = (byte)(255L & var10_11 >> 16);
            var6_6[2] = (byte)(255L & var10_11 >> 8);
            var6_6[3] = (byte)(255L & var10_11);
            var4_4.write(var6_6, 0, 4);
            var9_9 = 4;
        }
        if (var12_12 <= 0) return var9_9;
        var20_21 = var12_12;
        var21_23 = 0;
        var22_24 = 0;
        ** GOTO lbl-1000
        while (true) {
            var23_27 = var15_15 - 64;
            var24_28 = var23_27 > 255 ? 3 : 2;
            var6_6[0] = (byte)(192 + (var24_28 - 2));
            var6_6[1] = (byte)(255 & var23_27);
            if (var24_28 == 3) {
                var6_6[2] = (byte)(255 & var23_27 >> 8);
            }
            var4_4.write(var6_6, 0, var24_28);
            var9_9 += var24_28;
            ** if (true) goto lbl110
            break;
        }
lbl-1000:
        // 1 sources

        {
            while (true) {
                var9_9 += var22_24;
                if ((var21_23 += var22_24) == var20_21) {
                    return var9_9;
                } else {
                    ** GOTO lbl-1000
                }
                break;
            }
        }
lbl110:
        // 1 sources

        ** GOTO lbl116
lbl-1000:
        // 3 sources

        {
            block24: {
                if (var21_23 <= 0) break block24;
                if (var15_15 >= 64) ** continue;
                var6_6[0] = (byte)(255 & var15_15 | 192);
                var4_4.write(var6_6, 0, 1);
                ++var9_9;
lbl116:
                // 2 sources

                if (var18_18) {
                    var6_6[0] = (byte)(255L & var10_11 >> 24);
                    var6_6[1] = (byte)(255L & var10_11 >> 16);
                    var6_6[2] = (byte)(255L & var10_11 >> 8);
                    var6_6[3] = (byte)(255L & var10_11);
                    var4_4.write(var6_6, 0, 4);
                    var9_9 = 4;
                }
            }
            if ((var22_24 = var7_7) <= var20_21 - var21_23) ** GOTO lbl-1000
            var22_24 = var20_21 - var21_23;
lbl-1000:
            // 2 sources

            {
                var4_4.write(var8_8, var21_23, var22_24);
                continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void debugPackets(int n) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(MediaReaderH264.class);
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
        QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
        QTAtomtrak qTAtomtrak3 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
        H264Cursor h264Cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, qTAtomtrak3, 1);
        int n2 = 0;
        while (true) {
            int n3 = (int)h264Cursor.getSize();
            long l = h264Cursor.getTimeMillis();
            if (n3 <= 0 || n3 >= n) {
                wMSLogger.info(Base64.toString((int)(279 / 56), (String)"tdelm}0+") + n3 + ":" + n);
            }
            h264Cursor.moveNextSample();
            if (h264Cursor.isAtEnd()) {
                wMSLogger.info(JSON.regionMatches((String)"=23izqmrzcnwmp?&", (int)(38 + -15)) + n2);
                return;
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected H264ReadAheadRequest tiggerNextReadAhead(H264ReadAheadRequest var1_1) {
        block17: {
            block13: {
                block19: {
                    block18: {
                        block21: {
                            block14: {
                                block15: {
                                    block20: {
                                        block16: {
                                            var2_2 = null;
                                            var3_3 = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
                                            var4_4 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
                                            var5_5 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
                                            if (this.cursorReadAhead != null) break block14;
                                            break block20;
                                            while (true) {
                                                var2_2 = new H264ReadAheadRequest();
                                                var2_2.setDataTrack(var5_5);
                                                var2_2.setDataDataToAMFHandler(this.dataDataToAMFHandler);
                                                break block13;
                                                break;
                                            }
lbl12:
                                            // 1 sources

                                            while (true) {
                                                var2_2 = this.readAheadCache.remove(0);
                                                var2_2.clear();
                                                break block13;
                                                break;
                                            }
lbl16:
                                            // 1 sources

                                            while (true) {
                                                this.cursorReadAhead = new H264Cursor(var3_3, var4_4, var5_5);
                                                break block14;
                                                break;
                                            }
lbl19:
                                            // 1 sources

                                            while (true) {
                                                var2_2.setCursorPosition(this.cursorReadAhead.getCurrentPosition());
                                                if (this.stream == null) break block15;
                                                break block16;
                                                break;
                                            }
lbl23:
                                            // 2 sources

                                            while (true) {
                                                if (var2_2 != null) {
                                                    ** continue;
                                                }
                                                break block15;
                                                break;
                                            }
                                        }
                                        this.stream.getStreams().getVHost().getIOScheduler().executeRaw((Runnable)var2_2);
                                        break block15;
                                        while (true) {
                                            this.cursorReadAhead.setCurrentPosition(this.cursor.getCurrentPosition());
                                            break block17;
                                            break;
                                        }
                                    }
                                    if (this.d == null) {
                                        ** continue;
                                    }
                                    break block21;
                                }
lbl38:
                                // 2 sources

                                return var2_2;
                                while (true) {
                                    if (!this.cursorReadAhead.isAtEnd()) break block18;
                                    ** GOTO lbl23
                                    break;
                                }
                            }
lbl44:
                            // 2 sources

                            while (true) {
                                if (var1_1 == null) ** continue;
                                break block19;
                                break;
                            }
                        }
                        this.cursorReadAhead = new H264CursorCaptionProvider(this.d, this.c, var3_3, var4_4);
                        this.dataDataToAMFHandler = (IQTDataDataToAMF)this.cursorReadAhead;
                        ** while (true)
                    }
lbl52:
                    // 2 sources

                    while (true) {
                        var8_7 = this.cursorReadAhead.getSize();
                        var10_8 = this.cursorReadAhead.getCurrentType();
                        var11_9 = this.cursorReadAhead.getSample();
                        var13_10 = this.cursorReadAhead.getSampleDesc();
                        var2_2.addPacket(var10_8, var11_9, this.cursorReadAhead.getFileLoc(), var8_7, var13_10);
                        this.cursorReadAhead.moveNextSample();
                        if ((var6_6 += var8_7) <= (long)this.readAheadSize) ** continue;
                        ** continue;
                        break;
                    }
lbl62:
                    // 1 sources

                    while (true) {
                        if (this.readAheadCache.size() <= 0) ** continue;
                        ** continue;
                        break;
                    }
                }
                this.cursorReadAhead.setCurrentPosition(var1_1.getCursorPosition());
                break block17;
            }
            var2_2.setFileStream(this.videoFileStream);
            var2_2.setReadAheadTrigger(this.readAheadTrigger);
            var6_6 = 0L;
            ** while (true)
        }
        ** while (!this.cursorReadAhead.isAtEnd())
lbl75:
        // 1 sources

        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected H264ReadAheadPacket getReadAheadPacket(int n, long l) {
        H264ReadAheadPacket h264ReadAheadPacket = null;
        Object object = this.readAheadLock;
        synchronized (object) {
            block12: {
                block13: {
                    block11: {
                        if (this.currReadAhead == null) break block11;
                        this.currReadAhead.waitForComplete();
                        h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                        if (h264ReadAheadPacket != null) break block12;
                        if (this.cacheReadAhead) {
                            this.readAheadCache.add(this.currReadAhead);
                        }
                        this.currReadAhead = null;
                    }
                    this.currReadAhead = this.nextReadAhead;
                    this.nextReadAhead = null;
                    if (this.currReadAhead == null) break block13;
                    this.currReadAhead.waitForComplete();
                    h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                    if (h264ReadAheadPacket != null) break block12;
                    if (this.cacheReadAhead) {
                        this.readAheadCache.add(this.currReadAhead);
                    }
                    this.currReadAhead = null;
                }
                this.currReadAhead = this.tiggerNextReadAhead(null);
                if (this.currReadAhead != null) {
                    this.currReadAhead.waitForComplete();
                    h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                    if (h264ReadAheadPacket == null) {
                        if (this.cacheReadAhead) {
                            this.readAheadCache.add(this.currReadAhead);
                        }
                        this.currReadAhead = null;
                    }
                }
            }
            if (h264ReadAheadPacket == null) return h264ReadAheadPacket;
            if (this.nextReadAhead != null) return h264ReadAheadPacket;
            if (!h264ReadAheadPacket.isAfterTrigger) return h264ReadAheadPacket;
            MediaReaderH264 mediaReaderH264 = this;
            mediaReaderH264.nextReadAhead = mediaReaderH264.tiggerNextReadAhead(mediaReaderH264.currReadAhead);
            return h264ReadAheadPacket;
        }
    }

    /*
     * Exception decompiling
     */
    public int writePackets(List<AMFPacket> var1_1, PlaylistCursor var2_2, PlaylistWriteControl var3_3, PlaylistReaderWriteResults var4_4, long[] var5_5, FastPlaySettings var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 191->1048)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AMFPacket a(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray == null) {
            return aMFPacket;
        }
        aMFPacket = new AMFPacket(9, 0, byArray.length + 5);
        byte[] byArray2 = aMFPacket.getData();
        byArray2[0] = 23;
        byArray2[1] = 0;
        byArray2[2] = 0;
        byArray2[3] = 0;
        byArray2[4] = 0;
        aMFPacket.addDataEx(byArray, 0, 5, byArray.length);
        return aMFPacket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AMFPacket b(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray == null) {
            return aMFPacket;
        }
        aMFPacket = new AMFPacket(8, 0, byArray.length + 2);
        byte[] byArray2 = aMFPacket.getData();
        byArray2[0] = -81;
        byArray2[1] = 0;
        aMFPacket.addDataEx(byArray, 0, 2, byArray.length);
        return aMFPacket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AMFPacket getFramePacket(int[] nArray, long l) {
        H264ReadAheadPacket h264ReadAheadPacket;
        int n;
        int n2;
        AMFPacket aMFPacket = null;
        try {
            n2 = nArray[0];
            n = 0;
            h264ReadAheadPacket = this.getReadAheadPacket(n2, l);
            if (h264ReadAheadPacket != null) {
                n = (int)h264ReadAheadPacket.getSize();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.toString((int)(46 - 23), (String)"Z}}szNx\u007f{esJ121(`m}Lym`k_qryv`/6") + exception.toString());
            exception.printStackTrace();
            return aMFPacket;
        }
        if (n <= 0) return aMFPacket;
        int n3 = 5;
        if (n2 != 8) {
            if (n2 == 18 || n2 == 15) {
                n3 = 0;
            }
        } else {
            n3 = this.audioExtraSize;
        }
        aMFPacket = new AMFPacket(nArray[0], 0, n + n3);
        byte[] byArray = aMFPacket.getData();
        byArray[0] = (byte)this.chunkHeaderValues[3];
        if (n3 > 1) {
            byArray[1] = 1;
        }
        if (n3 == 5) {
            int n4 = this.cursor.getCTTSMillis();
            byArray[2] = (byte)(n4 >> 16 & 0xFF);
            byArray[3] = (byte)(n4 >> 8 & 0xFF);
            byArray[4] = (byte)(n4 & 0xFF);
        }
        byte[] byArray2 = null;
        int n5 = 0;
        if (h264ReadAheadPacket != null) {
            byArray2 = h264ReadAheadPacket.getBuffer();
            n5 = h264ReadAheadPacket.boffset;
        }
        aMFPacket.addDataEx(byArray2, n5, n3, n);
        return aMFPacket;
    }

    public int getTrackIndexVideo() {
        return this.trackIndexVideo;
    }

    public void setTrackIndexVideo(int n) {
        this.trackIndexVideo = n;
    }

    public int getTrackIndexAudio() {
        return this.trackIndexAudio;
    }

    public void setTrackIndexAudio(int n) {
        this.trackIndexAudio = n;
    }

    public int getTrackIndexData() {
        return this.trackIndexData;
    }

    public void setTrackIndexData(int n) {
        this.trackIndexData = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountVideo() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getVideoTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountAudio() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getAudioTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountData() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getDataTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTrackLanguageAudio(int n) {
        String string = "";
        if (this.container == null) return string;
        return this.container.getMoovAtom().getAudioTrackLanguage(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTrackLanguageData(int n) {
        String string = "";
        if (this.container == null) return string;
        return this.container.getMoovAtom().getDataTrackLanguage(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackDataTrackId(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_DATA, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackAudioTrackId(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_AUDIO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackDataAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_DATA, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackAudioAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_AUDIO, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackVideoAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoTrackId(int n) {
        long l = -1L;
        if (this.container == null) {
            return l;
        }
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoWidth(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackWidth();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoHeight(int n) {
        long l = -1L;
        if (this.container == null) {
            return l;
        }
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackHeight();
        return l;
    }

    public String getTrackDataCharSet() {
        return this.trackDataCharSet;
    }

    public void setTrackDataCharSet(String string) {
        this.trackDataCharSet = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] dataDataToAMF(long l, QTAtomtrak qTAtomtrak, byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = null;
        AMFDataList aMFDataList = null;
        QTAtomstbl qTAtomstbl = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
        if (qTAtomstbl != null && (n3 = qTAtomstbl.getDataTrackType()) == 2) {
            aMFDataList = new AMFDataList();
            AMFDataObj aMFDataObj = new AMFDataObj();
            aMFDataList.add((AMFData)new AMFDataItem(Base64.toString((int)(484 / 86), (String)"jhSmq~Omyo")));
            aMFDataList.add((AMFData)aMFDataObj);
            String string = qTAtomtrak.getLanguageStr();
            aMFDataObj.put(JSON.regionMatches((String)"ykwd", (int)(-37 + 50)), (AMFData)new AMFDataItem(""));
            aMFDataObj.put(Base64.toString((int)(-17 - -34), (String)"e`rw~\u007fs"), (AMFData)new AMFDataItem(qTAtomtrak.getTrackIndex()));
            aMFDataObj.put(JSON.regionMatches((String)"kigm~mjk", (int)(-51 - -58)), (AMFData)new AMFDataItem(string));
            if (n2 >= 2) {
                int n4 = 0;
                int n5 = BufferUtils.byteArrayToInt((byte[])byArray, (int)n, (int)2);
                if (n5 > 0 && n5 <= n2 - (n4 += 2)) {
                    String string2 = "";
                    try {
                        string2 = new String(byArray, n + n4, n2 - n4, this.trackDataCharSet);
                    }
                    catch (Exception exception) {}
                    aMFDataObj.put(Base64.toString((int)(29 * 23), (String)"oyej"), (AMFData)new AMFDataItem(string2));
                }
            }
        }
        if (aMFDataList == null) return byArray2;
        return aMFDataList.serialize(0);
    }

    public int getCursorType() {
        return this.cursorType;
    }

    public void setCursorType(int n) {
        this.cursorType = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlayReadySampleInfo getPlayReadyAudioTrackInfo(int n) {
        PlayReadySampleInfo playReadySampleInfo = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return playReadySampleInfo;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getAudioTrack(n);
        if (qTAtomtrak != null) return qTAtomtrak.getPlayReadySampleInfo(this.metaFileStream, 0L);
        return playReadySampleInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlayReadySampleInfo getPlayReadyVideoTrackInfo(int n) {
        PlayReadySampleInfo playReadySampleInfo = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return playReadySampleInfo;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getVideoTrack(n);
        if (qTAtomtrak != null) return qTAtomtrak.getPlayReadySampleInfo(this.metaFileStream, 0L);
        return playReadySampleInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlayReadyMediaInfo getPlayReadyInfo() {
        PlayReadyMediaInfo playReadyMediaInfo = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov != null) return this.container.getMoovAtom().getPlayReadyInfo();
        return playReadyMediaInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final TimedTextRequest a(Map<String, String> map) {
        String string;
        TimedTextRequest timedTextRequest = new TimedTextRequest();
        String string2 = map.get(this.captionLanguageQueryParameter);
        if (StringUtils.isNotEmpty((String)string2)) {
            string2 = string2.toLowerCase();
            try {
                List list = TimedTextRequest.parseTimedTextLanguageIDs((String)string2);
                timedTextRequest.setLanguageURLRequestName(this.captionLanguageQueryParameter);
                timedTextRequest.setLanguageRequestStr(string2);
                timedTextRequest.setLanguageIDs(list);
            }
            catch (Exception exception) {}
        }
        if (!StringUtils.isNotEmpty((String)(string = map.get(this.captionFilenameQueryParameter)))) return timedTextRequest;
        timedTextRequest.setFilenameQueryParam(this.captionFilenameQueryParameter);
        timedTextRequest.setFilename(string);
        return timedTextRequest;
    }

    public MediaReaderEncInfo getEncInfo() {
        return this.encInfo;
    }
}

