/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonNode
implements TreeNode,
Iterable<JsonNode> {
    protected static final List<JsonNode> NO_NODES = Collections.emptyList();
    protected static final List<String> NO_STRINGS = Collections.emptyList();

    protected JsonNode() {
    }

    public abstract <T extends JsonNode> T deepCopy();

    public boolean isValueNode() {
        return false;
    }

    public boolean isContainerNode() {
        return false;
    }

    public boolean isMissingNode() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isPojo() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isIntegralNumber() {
        return false;
    }

    public boolean isFloatingPointNumber() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isBigDecimal() {
        return false;
    }

    public boolean isBigInteger() {
        return false;
    }

    public boolean isTextual() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isBinary() {
        return false;
    }

    public abstract JsonToken asToken();

    public abstract JsonParser.NumberType numberType();

    public boolean canConvertToInt() {
        return false;
    }

    public boolean canConvertToLong() {
        return false;
    }

    public String textValue() {
        return null;
    }

    public byte[] binaryValue() throws IOException {
        return null;
    }

    public boolean booleanValue() {
        return false;
    }

    public Number numberValue() {
        return null;
    }

    public int intValue() {
        return 0;
    }

    public long longValue() {
        return 0L;
    }

    public double doubleValue() {
        return 0.0;
    }

    public BigDecimal decimalValue() {
        return BigDecimal.ZERO;
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.ZERO;
    }

    public JsonNode get(int n) {
        return null;
    }

    public JsonNode get(String string) {
        return null;
    }

    public abstract String asText();

    public int asInt() {
        return this.asInt(0);
    }

    public int asInt(int n) {
        return n;
    }

    public long asLong() {
        return this.asLong(0L);
    }

    public long asLong(long l) {
        return l;
    }

    public double asDouble() {
        return this.asDouble(0.0);
    }

    public double asDouble(double d) {
        return d;
    }

    public boolean asBoolean() {
        return this.asBoolean(false);
    }

    public boolean asBoolean(boolean bl) {
        return bl;
    }

    public boolean has(String string) {
        return this.get(string) != null;
    }

    public boolean has(int n) {
        return this.get(n) != null;
    }

    public boolean hasNonNull(String string) {
        JsonNode jsonNode = this.get(string);
        return jsonNode != null && !jsonNode.isNull();
    }

    public boolean hasNonNull(int n) {
        JsonNode jsonNode = this.get(n);
        return jsonNode != null && !jsonNode.isNull();
    }

    public abstract JsonNode findValue(String var1);

    public final List<JsonNode> findValues(String string) {
        List<JsonNode> list = this.findValues(string, null);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final List<String> findValuesAsText(String string) {
        List<String> list = this.findValuesAsText(string, null);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public abstract JsonNode findPath(String var1);

    public abstract JsonNode findParent(String var1);

    public final List<JsonNode> findParents(String string) {
        List<JsonNode> list = this.findParents(string, null);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public abstract List<JsonNode> findValues(String var1, List<JsonNode> var2);

    public abstract List<String> findValuesAsText(String var1, List<String> var2);

    public abstract List<JsonNode> findParents(String var1, List<JsonNode> var2);

    public int size() {
        return 0;
    }

    @Override
    public final Iterator<JsonNode> iterator() {
        return this.elements();
    }

    public Iterator<JsonNode> elements() {
        return NO_NODES.iterator();
    }

    public Iterator<String> fieldNames() {
        return NO_STRINGS.iterator();
    }

    public Iterator<Map.Entry<String, JsonNode>> fields() {
        List list = Collections.emptyList();
        return list.iterator();
    }

    public abstract JsonNode path(String var1);

    public abstract JsonNode path(int var1);

    public JsonNode with(String string) {
        throw new UnsupportedOperationException("JsonNode not of type ObjectNode (but " + this.getClass().getName() + "), can not call with() on it");
    }

    public JsonNode withArray(String string) {
        throw new UnsupportedOperationException("JsonNode not of type ObjectNode (but " + this.getClass().getName() + "), can not call withArray() on it");
    }

    public abstract JsonParser traverse();

    public abstract String toString();

    public abstract boolean equals(Object var1);
}

