/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateDeserializers {
    public static StdDeserializer<?>[] all() {
        return new StdDeserializer[]{new CalendarDeserializer(), new DateDeserializer(), new CalendarDeserializer((Class<? extends Calendar>)GregorianCalendar.class), new SqlDateDeserializer(), new TimestampDeserializer(), new TimeZoneDeserializer()};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static class CalendarDeserializer
    extends DateBasedDeserializer<Calendar> {
        protected final Class<? extends Calendar> _calendarClass;

        public CalendarDeserializer() {
            super(Calendar.class);
            this._calendarClass = null;
        }

        public CalendarDeserializer(Class<? extends Calendar> clazz) {
            super(clazz);
            this._calendarClass = clazz;
        }

        public CalendarDeserializer(CalendarDeserializer calendarDeserializer, DateFormat dateFormat, String string) {
            super(calendarDeserializer, dateFormat, string);
            this._calendarClass = calendarDeserializer._calendarClass;
        }

        protected CalendarDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new CalendarDeserializer(this, dateFormat, string);
        }

        @Override
        public Calendar deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            java.util.Date date = this._parseDate(jsonParser, deserializationContext);
            if (date == null) {
                return null;
            }
            if (this._calendarClass == null) {
                return deserializationContext.constructCalendar(date);
            }
            try {
                Calendar calendar = this._calendarClass.newInstance();
                calendar.setTimeInMillis(date.getTime());
                return calendar;
            }
            catch (Exception exception) {
                throw deserializationContext.instantiationException(this._calendarClass, exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class DateBasedDeserializer<T>
    extends StdScalarDeserializer<T>
    implements ContextualDeserializer {
        protected final DateFormat _customFormat;
        protected final String _formatString;

        protected DateBasedDeserializer(Class<?> clazz) {
            super(clazz);
            this._customFormat = null;
            this._formatString = null;
        }

        protected DateBasedDeserializer(DateBasedDeserializer<T> dateBasedDeserializer, DateFormat dateFormat, String string) {
            super(dateBasedDeserializer._valueClass);
            this._customFormat = dateFormat;
            this._formatString = string;
        }

        protected abstract DateBasedDeserializer<T> withDateFormat(DateFormat var1, String var2);

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
            JsonFormat.Value value;
            if (beanProperty != null && (value = deserializationContext.getAnnotationIntrospector().findFormat((Annotated)beanProperty.getMember())) != null) {
                TimeZone timeZone = value.getTimeZone();
                String string = value.getPattern();
                if (string.length() > 0) {
                    Locale locale = value.getLocale();
                    if (locale == null) {
                        locale = deserializationContext.getLocale();
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
                    if (timeZone == null) {
                        timeZone = deserializationContext.getTimeZone();
                    }
                    simpleDateFormat.setTimeZone(timeZone);
                    return this.withDateFormat(simpleDateFormat, string);
                }
                if (timeZone != null) {
                    DateFormat dateFormat = deserializationContext.getConfig().getDateFormat();
                    if (dateFormat.getClass() == StdDateFormat.class) {
                        dateFormat = ((StdDateFormat)dateFormat).withTimeZone(timeZone);
                    } else {
                        dateFormat = (DateFormat)dateFormat.clone();
                        dateFormat.setTimeZone(timeZone);
                    }
                    return this.withDateFormat(dateFormat, string);
                }
            }
            return this;
        }

        @Override
        protected java.util.Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (this._customFormat != null && jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return (java.util.Date)this.getEmptyValue();
                }
                DateFormat dateFormat = this._customFormat;
                synchronized (dateFormat) {
                    try {
                        return this._customFormat.parse(string);
                    }
                    catch (ParseException parseException) {
                        throw new IllegalArgumentException("Failed to parse Date value '" + string + "' (format: \"" + this._formatString + "\"): " + parseException.getMessage());
                    }
                }
            }
            return super._parseDate(jsonParser, deserializationContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateDeserializer
    extends DateBasedDeserializer<java.util.Date> {
        public DateDeserializer() {
            super(java.util.Date.class);
        }

        public DateDeserializer(DateDeserializer dateDeserializer, DateFormat dateFormat, String string) {
            super(dateDeserializer, dateFormat, string);
        }

        protected DateDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new DateDeserializer(this, dateFormat, string);
        }

        @Override
        public java.util.Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return this._parseDate(jsonParser, deserializationContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SqlDateDeserializer
    extends DateBasedDeserializer<Date> {
        public SqlDateDeserializer() {
            super(Date.class);
        }

        public SqlDateDeserializer(SqlDateDeserializer sqlDateDeserializer, DateFormat dateFormat, String string) {
            super(sqlDateDeserializer, dateFormat, string);
        }

        protected SqlDateDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new SqlDateDeserializer(this, dateFormat, string);
        }

        @Override
        public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            java.util.Date date = this._parseDate(jsonParser, deserializationContext);
            return date == null ? null : new Date(date.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TimeZoneDeserializer
    extends FromStringDeserializer<TimeZone> {
        public TimeZoneDeserializer() {
            super(TimeZone.class);
        }

        @Override
        protected TimeZone _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            return TimeZone.getTimeZone(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimestampDeserializer
    extends DateBasedDeserializer<Timestamp> {
        public TimestampDeserializer() {
            super(Timestamp.class);
        }

        public TimestampDeserializer(TimestampDeserializer timestampDeserializer, DateFormat dateFormat, String string) {
            super(timestampDeserializer, dateFormat, string);
        }

        protected TimestampDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new TimestampDeserializer(this, dateFormat, string);
        }

        @Override
        public Timestamp deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return new Timestamp(this._parseDate(jsonParser, deserializationContext).getTime());
        }
    }
}

