/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNodeFactory
implements Serializable {
    private static final long serialVersionUID = 2323165117839546871L;
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    protected JsonNodeFactory(boolean bl) {
        this._cfgBigDecimalExact = bl;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public static JsonNodeFactory withExactBigDecimals(boolean bl) {
        return bl ? decimalsAsIs : decimalsNormalized;
    }

    public BooleanNode booleanNode(boolean bl) {
        return bl ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public NumericNode numberNode(byte by) {
        return IntNode.valueOf(by);
    }

    public ValueNode numberNode(Byte by) {
        return by == null ? this.nullNode() : IntNode.valueOf(by.intValue());
    }

    public NumericNode numberNode(short s) {
        return IntNode.valueOf(s);
    }

    public ValueNode numberNode(Short s) {
        return s == null ? this.nullNode() : IntNode.valueOf(s.shortValue());
    }

    public NumericNode numberNode(int n) {
        return IntNode.valueOf(n);
    }

    public ValueNode numberNode(Integer n) {
        return n == null ? this.nullNode() : IntNode.valueOf(n);
    }

    public NumericNode numberNode(long l) {
        return LongNode.valueOf(l);
    }

    public ValueNode numberNode(Long l) {
        return l == null ? this.nullNode() : LongNode.valueOf(l);
    }

    public NumericNode numberNode(BigInteger bigInteger) {
        return BigIntegerNode.valueOf(bigInteger);
    }

    public NumericNode numberNode(float f) {
        return DoubleNode.valueOf(f);
    }

    public ValueNode numberNode(Float f) {
        return f == null ? this.nullNode() : DoubleNode.valueOf(f.doubleValue());
    }

    public NumericNode numberNode(double d) {
        return DoubleNode.valueOf(d);
    }

    public ValueNode numberNode(Double d) {
        return d == null ? this.nullNode() : DoubleNode.valueOf(d);
    }

    public NumericNode numberNode(BigDecimal bigDecimal) {
        return DecimalNode.valueOf(this._cfgBigDecimalExact ? bigDecimal : bigDecimal.stripTrailingZeros());
    }

    public TextNode textNode(String string) {
        return TextNode.valueOf(string);
    }

    public BinaryNode binaryNode(byte[] byArray) {
        return BinaryNode.valueOf(byArray);
    }

    public BinaryNode binaryNode(byte[] byArray, int n, int n2) {
        return BinaryNode.valueOf(byArray, n, n2);
    }

    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    public POJONode POJONode(Object object) {
        return new POJONode(object);
    }
}

