/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectNode
extends ContainerNode<ObjectNode> {
    protected Map<String, JsonNode> _children = null;

    public ObjectNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
    }

    protected ObjectNode(JsonNodeFactory jsonNodeFactory, Map<String, JsonNode> map) {
        super(jsonNodeFactory);
        this._children = map;
    }

    public ObjectNode deepCopy() {
        if (this.getClass() != ObjectNode.class) {
            throw new IllegalStateException("ObjectNode subtype (" + this.getClass().getName() + " does not override deepCopy(), needs to");
        }
        return this._defaultDeepCopy();
    }

    protected ObjectNode _defaultDeepCopy() {
        if (this._children == null) {
            return new ObjectNode(this._nodeFactory);
        }
        int n = this._children.size();
        Map<String, JsonNode> map = this._createMap(Math.max(4, n));
        for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
            map.put(entry.getKey(), (JsonNode)entry.getValue().deepCopy());
        }
        return new ObjectNode(this._nodeFactory, map);
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public int size() {
        return this._children == null ? 0 : this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children == null ? ContainerNode.NoNodesIterator.instance() : this._children.values().iterator();
    }

    @Override
    public JsonNode get(int n) {
        return null;
    }

    @Override
    public JsonNode get(String string) {
        if (this._children != null) {
            return this._children.get(string);
        }
        return null;
    }

    @Override
    public Iterator<String> fieldNames() {
        return this._children == null ? ContainerNode.NoStringsIterator.instance() : this._children.keySet().iterator();
    }

    @Override
    public JsonNode path(int n) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(String string) {
        JsonNode jsonNode;
        if (this._children != null && (jsonNode = this._children.get(string)) != null) {
            return jsonNode;
        }
        return MissingNode.getInstance();
    }

    @Override
    public Iterator<Map.Entry<String, JsonNode>> fields() {
        if (this._children == null) {
            return NoFieldsIterator.instance;
        }
        return this._children.entrySet().iterator();
    }

    @Override
    public ObjectNode with(String string) {
        JsonNode jsonNode;
        if (this._children == null) {
            this._children = this._createMap();
        } else {
            jsonNode = this._children.get(string);
            if (jsonNode != null) {
                if (jsonNode instanceof ObjectNode) {
                    return (ObjectNode)jsonNode;
                }
                throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type ObjectNode (but " + jsonNode.getClass().getName() + ")");
            }
        }
        jsonNode = this.objectNode();
        this._children.put(string, jsonNode);
        return jsonNode;
    }

    @Override
    public ArrayNode withArray(String string) {
        JsonNode jsonNode;
        if (this._children == null) {
            this._children = this._createMap();
        } else {
            jsonNode = this._children.get(string);
            if (jsonNode != null) {
                if (jsonNode instanceof ArrayNode) {
                    return (ArrayNode)jsonNode;
                }
                throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type ArrayNode (but " + jsonNode.getClass().getName() + ")");
            }
        }
        jsonNode = this.arrayNode();
        this._children.put(string, jsonNode);
        return jsonNode;
    }

    @Override
    public JsonNode findValue(String string) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (string.equals(entry.getKey())) {
                    return entry.getValue();
                }
                JsonNode jsonNode = entry.getValue().findValue(string);
                if (jsonNode == null) continue;
                return jsonNode;
            }
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string, List<JsonNode> list) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (string.equals(entry.getKey())) {
                    if (list == null) {
                        list = new ArrayList<JsonNode>();
                    }
                    list.add(entry.getValue());
                    continue;
                }
                list = entry.getValue().findValues(string, list);
            }
        }
        return list;
    }

    @Override
    public List<String> findValuesAsText(String string, List<String> list) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (string.equals(entry.getKey())) {
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(entry.getValue().asText());
                    continue;
                }
                list = entry.getValue().findValuesAsText(string, list);
            }
        }
        return list;
    }

    @Override
    public ObjectNode findParent(String string) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (string.equals(entry.getKey())) {
                    return this;
                }
                JsonNode jsonNode = entry.getValue().findParent(string);
                if (jsonNode == null) continue;
                return (ObjectNode)jsonNode;
            }
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string, List<JsonNode> list) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (string.equals(entry.getKey())) {
                    if (list == null) {
                        list = new ArrayList<JsonNode>();
                    }
                    list.add(this);
                    continue;
                }
                list = entry.getValue().findParents(string, list);
            }
        }
        return list;
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                jsonGenerator.writeFieldName(entry.getKey());
                ((BaseJsonNode)entry.getValue()).serialize(jsonGenerator, serializerProvider);
            }
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        typeSerializer.writeTypePrefixForObject(this, jsonGenerator);
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                jsonGenerator.writeFieldName(entry.getKey());
                ((BaseJsonNode)entry.getValue()).serialize(jsonGenerator, serializerProvider);
            }
        }
        typeSerializer.writeTypeSuffixForObject(this, jsonGenerator);
    }

    public JsonNode set(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._put(string, jsonNode);
        return this;
    }

    public JsonNode setAll(Map<String, JsonNode> map) {
        if (this._children == null) {
            this._children = this._createMap();
        }
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            JsonNode jsonNode = entry.getValue();
            if (jsonNode == null) {
                jsonNode = this.nullNode();
            }
            this._children.put(entry.getKey(), jsonNode);
        }
        return this;
    }

    public JsonNode setAll(ObjectNode objectNode) {
        int n = objectNode.size();
        if (n > 0) {
            if (this._children == null) {
                this._children = this._createMap(n);
            }
            objectNode.putContentsTo(this._children);
        }
        return this;
    }

    public JsonNode replace(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._put(string, jsonNode);
    }

    public JsonNode without(String string) {
        if (this._children != null) {
            this._children.remove(string);
        }
        return this;
    }

    public ObjectNode without(Collection<String> collection) {
        if (this._children != null) {
            for (String string : collection) {
                this._children.remove(string);
            }
        }
        return this;
    }

    public JsonNode put(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._put(string, jsonNode);
    }

    public JsonNode remove(String string) {
        if (this._children != null) {
            return this._children.remove(string);
        }
        return null;
    }

    public ObjectNode remove(Collection<String> collection) {
        if (this._children != null) {
            for (String string : collection) {
                this._children.remove(string);
            }
        }
        return this;
    }

    @Override
    public ObjectNode removeAll() {
        this._children = null;
        return this;
    }

    public JsonNode putAll(Map<String, JsonNode> map) {
        return this.setAll(map);
    }

    public JsonNode putAll(ObjectNode objectNode) {
        return this.setAll(objectNode);
    }

    public ObjectNode retain(Collection<String> collection) {
        if (this._children != null) {
            Iterator<Map.Entry<String, JsonNode>> iterator = this._children.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                if (collection.contains(entry.getKey())) continue;
                iterator.remove();
            }
        }
        return this;
    }

    public ObjectNode retain(String ... stringArray) {
        return this.retain(Arrays.asList(stringArray));
    }

    public ArrayNode putArray(String string) {
        ArrayNode arrayNode = this.arrayNode();
        this._put(string, arrayNode);
        return arrayNode;
    }

    public ObjectNode putObject(String string) {
        ObjectNode objectNode = this.objectNode();
        this._put(string, objectNode);
        return objectNode;
    }

    public ObjectNode putPOJO(String string, Object object) {
        this._put(string, this.POJONode(object));
        return this;
    }

    public ObjectNode putNull(String string) {
        this._put(string, this.nullNode());
        return this;
    }

    public ObjectNode put(String string, int n) {
        this._put(string, this.numberNode(n));
        return this;
    }

    public ObjectNode put(String string, Integer n) {
        if (n == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.numberNode(n));
        }
        return this;
    }

    public ObjectNode put(String string, long l) {
        this._put(string, this.numberNode(l));
        return this;
    }

    public ObjectNode put(String string, Long l) {
        if (l == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.numberNode(l));
        }
        return this;
    }

    public ObjectNode put(String string, float f) {
        this._put(string, this.numberNode(f));
        return this;
    }

    public ObjectNode put(String string, Float f) {
        if (f == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.numberNode(f.floatValue()));
        }
        return this;
    }

    public ObjectNode put(String string, double d) {
        this._put(string, this.numberNode(d));
        return this;
    }

    public ObjectNode put(String string, Double d) {
        if (d == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.numberNode(d));
        }
        return this;
    }

    public ObjectNode put(String string, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.putNull(string);
        } else {
            this._put(string, this.numberNode(bigDecimal));
        }
        return this;
    }

    public ObjectNode put(String string, String string2) {
        if (string2 == null) {
            this.putNull(string);
        } else {
            this._put(string, this.textNode(string2));
        }
        return this;
    }

    public ObjectNode put(String string, boolean bl) {
        this._put(string, this.booleanNode(bl));
        return this;
    }

    public ObjectNode put(String string, Boolean bl) {
        if (bl == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.booleanNode(bl));
        }
        return this;
    }

    public ObjectNode put(String string, byte[] byArray) {
        if (byArray == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.binaryNode(byArray));
        }
        return this;
    }

    protected Map<String, JsonNode> _createMap() {
        return new LinkedHashMap<String, JsonNode>();
    }

    protected Map<String, JsonNode> _createMap(int n) {
        return new LinkedHashMap<String, JsonNode>(n);
    }

    protected void putContentsTo(Map<String, JsonNode> map) {
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ObjectNode objectNode = (ObjectNode)object;
        if (objectNode.size() != this.size()) {
            return false;
        }
        if (this._children != null) {
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                String string = entry.getKey();
                JsonNode jsonNode = entry.getValue();
                JsonNode jsonNode2 = objectNode.get(string);
                if (jsonNode2 != null && jsonNode2.equals(jsonNode)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this._children == null ? -1 : ((Object)this._children).hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32 + (this.size() << 4));
        stringBuilder.append("{");
        if (this._children != null) {
            int n = 0;
            for (Map.Entry<String, JsonNode> entry : this._children.entrySet()) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                ++n;
                TextNode.appendQuoted(stringBuilder, entry.getKey());
                stringBuilder.append(':');
                stringBuilder.append(entry.getValue().toString());
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private final JsonNode _put(String string, JsonNode jsonNode) {
        if (this._children == null) {
            this._children = this._createMap();
        }
        return this._children.put(string, jsonNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NoFieldsIterator
    implements Iterator<Map.Entry<String, JsonNode>> {
        static final NoFieldsIterator instance = new NoFieldsIterator();

        private NoFieldsIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Map.Entry<String, JsonNode> next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

