/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.lang.reflect.Type;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StaticListSerializerBase<T extends Collection<?>>
extends StdSerializer<T> {
    protected StaticListSerializerBase(Class<?> clazz) {
        super(clazz, false);
    }

    @Override
    public boolean isEmpty(T t) {
        return t == null || t.size() == 0;
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        ObjectNode objectNode = this.createSchemaNode("array", true);
        objectNode.put("items", this.contentSchema());
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        this.acceptContentVisitor(jsonFormatVisitorWrapper.expectArrayFormat(javaType));
    }

    protected abstract JsonNode contentSchema();

    protected abstract void acceptContentVisitor(JsonArrayFormatVisitor var1);
}

