/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumValues {
    private final EnumMap<?, SerializedString> _values;

    private EnumValues(Map<Enum<?>, SerializedString> map) {
        this._values = new EnumMap(map);
    }

    public static EnumValues construct(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        return EnumValues.constructFromName(clazz, annotationIntrospector);
    }

    public static EnumValues constructFromName(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz2 = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = clazz2.getEnumConstants();
        if (enumArray != null) {
            HashMap hashMap = new HashMap();
            for (Enum<?> enum_ : enumArray) {
                String string = annotationIntrospector.findEnumValue(enum_);
                hashMap.put(enum_, new SerializedString(string));
            }
            return new EnumValues(hashMap);
        }
        throw new IllegalArgumentException("Can not determine enum constants for Class " + clazz.getName());
    }

    public static EnumValues constructFromToString(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz2 = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = clazz2.getEnumConstants();
        if (enumArray != null) {
            HashMap hashMap = new HashMap();
            for (Enum<?> enum_ : enumArray) {
                hashMap.put(enum_, new SerializedString(enum_.toString()));
            }
            return new EnumValues(hashMap);
        }
        throw new IllegalArgumentException("Can not determine enum constants for Class " + clazz.getName());
    }

    public SerializedString serializedValueFor(Enum<?> enum_) {
        return this._values.get(enum_);
    }

    public Collection<SerializedString> values() {
        return this._values.values();
    }

    public EnumMap<?, SerializedString> internalMap() {
        return this._values;
    }
}

