/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.chainsaw.ControlPanel;
import org.apache.log4j.chainsaw.DetailPanel;
import org.apache.log4j.chainsaw.ExitAction;
import org.apache.log4j.chainsaw.LoadXMLAction;
import org.apache.log4j.chainsaw.LoggingReceiver;
import org.apache.log4j.chainsaw.MyTableModel;

public class Main
extends JFrame {
    private static final int DEFAULT_PORT = 4445;
    public static final String PORT_PROP_NAME = "chainsaw.port";
    private static final Logger LOG = Logger.getLogger(Main.class);

    private Main() {
        super("CHAINSAW - Log4J Log Viewer");
        JComponent jComponent;
        Serializable serializable;
        MyTableModel myTableModel = new MyTableModel();
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        try {
            serializable = new LoadXMLAction(this, myTableModel);
            jComponent = new JMenuItem("Load file...");
            jMenu.add((JMenuItem)jComponent);
            jComponent.addActionListener((ActionListener)((Object)serializable));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            LOG.info("Missing classes for XML parser", noClassDefFoundError);
            JOptionPane.showMessageDialog(this, "XML parser not in classpath - unable to load XML events.", "CHAINSAW", 0);
        }
        catch (Exception exception) {
            LOG.info("Unable to create the action to load XML files", exception);
            JOptionPane.showMessageDialog(this, "Unable to create a XML parser - unable to load XML events.", "CHAINSAW", 0);
        }
        serializable = new JMenuItem("Exit");
        jMenu.add((JMenuItem)serializable);
        ((AbstractButton)serializable).addActionListener(ExitAction.INSTANCE);
        jComponent = new ControlPanel(myTableModel);
        this.getContentPane().add((Component)jComponent, "North");
        JTable jTable = new JTable(myTableModel);
        jTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Events: "));
        jScrollPane.setPreferredSize(new Dimension(900, 300));
        DetailPanel detailPanel = new DetailPanel(jTable, myTableModel);
        detailPanel.setPreferredSize(new Dimension(900, 300));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, detailPanel);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ExitAction.INSTANCE.actionPerformed(null);
            }
        });
        this.pack();
        this.setVisible(true);
        this.setupReceiver(myTableModel);
    }

    private void setupReceiver(MyTableModel myTableModel) {
        int n = 4445;
        String string = System.getProperty(PORT_PROP_NAME);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.fatal("Unable to parse chainsaw.port property with value " + string + ".");
                JOptionPane.showMessageDialog(this, "Unable to parse port number from '" + string + "', quitting.", "CHAINSAW", 0);
                System.exit(1);
            }
        }
        try {
            LoggingReceiver loggingReceiver = new LoggingReceiver(myTableModel, n);
            loggingReceiver.start();
        }
        catch (IOException iOException) {
            LOG.fatal("Unable to connect to socket server, quiting", iOException);
            JOptionPane.showMessageDialog(this, "Unable to create socket on port " + n + ", quitting.", "CHAINSAW", 0);
            System.exit(1);
        }
    }

    private static void initLog4J() {
        Properties properties = new Properties();
        properties.setProperty("log4j.rootLogger", "DEBUG, A1");
        properties.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.A1.layout", "org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure(properties);
    }

    public static void main(String[] stringArray) {
        Main.initLog4J();
        new Main();
    }
}

