/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.lf5.LogRecordFilter;
import org.apache.log4j.lf5.util.DateFormatManager;
import org.apache.log4j.lf5.util.LogFileParser;
import org.apache.log4j.lf5.viewer.FilteredLogTableModel;
import org.apache.log4j.lf5.viewer.LF5SwingUtils;
import org.apache.log4j.lf5.viewer.LogFactor5ErrorDialog;
import org.apache.log4j.lf5.viewer.LogFactor5InputDialog;
import org.apache.log4j.lf5.viewer.LogTable;
import org.apache.log4j.lf5.viewer.LogTableColumn;
import org.apache.log4j.lf5.viewer.TrackingAdjustmentListener;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerTree;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryPath;
import org.apache.log4j.lf5.viewer.configure.ConfigurationManager;
import org.apache.log4j.lf5.viewer.configure.MRUFileManager;

public class LogBrokerMonitor {
    public static final String DETAILED_VIEW = "Detailed";
    protected JFrame _logMonitorFrame;
    protected int _logMonitorFrameWidth = 550;
    protected int _logMonitorFrameHeight = 500;
    protected LogTable _table;
    protected CategoryExplorerTree _categoryExplorerTree;
    protected String _searchText;
    protected String _NDCTextFilter = "";
    protected LogLevel _leastSevereDisplayedLogLevel = LogLevel.DEBUG;
    protected JScrollPane _logTableScrollPane;
    protected JLabel _statusLabel;
    protected Object _lock = new Object();
    protected JComboBox _fontSizeCombo;
    protected int _fontSize = 10;
    protected String _fontName = "Dialog";
    protected String _currentView = "Detailed";
    protected boolean _loadSystemFonts = false;
    protected boolean _trackTableScrollPane = true;
    protected Dimension _lastTableViewportSize;
    protected boolean _callSystemExitOnClose = false;
    protected List _displayedLogBrokerProperties = new Vector();
    protected Map _logLevelMenuItems = new HashMap();
    protected Map _logTableColumnMenuItems = new HashMap();
    protected List _levels = null;
    protected List _columns = null;
    protected boolean _isDisposed = false;
    protected ConfigurationManager _configurationManager = null;
    protected MRUFileManager _mruFileManager = null;
    protected File _fileLocation = null;

    public LogBrokerMonitor(List list) {
        this._levels = list;
        this._columns = LogTableColumn.getLogTableColumns();
        String string = System.getProperty("monitor.exit");
        if (string == null) {
            string = "false";
        }
        if ((string = string.trim().toLowerCase()).equals("true")) {
            this._callSystemExitOnClose = true;
        }
        this.initComponents();
        this._logMonitorFrame.addWindowListener(new LogBrokerMonitorWindowAdaptor(this));
    }

    public void show(final int n) {
        if (this._logMonitorFrame.isVisible()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Thread.yield();
                LogBrokerMonitor.this.pause(n);
                LogBrokerMonitor.this._logMonitorFrame.setVisible(true);
            }
        });
    }

    public void show() {
        this.show(0);
    }

    public void dispose() {
        this._logMonitorFrame.dispose();
        this._isDisposed = true;
        if (this._callSystemExitOnClose) {
            System.exit(0);
        }
    }

    public void hide() {
        this._logMonitorFrame.setVisible(false);
    }

    public DateFormatManager getDateFormatManager() {
        return this._table.getDateFormatManager();
    }

    public void setDateFormatManager(DateFormatManager dateFormatManager) {
        this._table.setDateFormatManager(dateFormatManager);
    }

    public boolean getCallSystemExitOnClose() {
        return this._callSystemExitOnClose;
    }

    public void setCallSystemExitOnClose(boolean bl) {
        this._callSystemExitOnClose = bl;
    }

    public void addMessage(final LogRecord logRecord) {
        if (this._isDisposed) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogBrokerMonitor.this._categoryExplorerTree.getExplorerModel().addLogRecord(logRecord);
                LogBrokerMonitor.this._table.getFilteredLogTableModel().addLogRecord(logRecord);
                LogBrokerMonitor.this.updateStatusLabel();
            }
        });
    }

    public void setMaxNumberOfLogRecords(int n) {
        this._table.getFilteredLogTableModel().setMaxNumberOfLogRecords(n);
    }

    public JFrame getBaseFrame() {
        return this._logMonitorFrame;
    }

    public void setTitle(String string) {
        this._logMonitorFrame.setTitle(string + " - LogFactor5");
    }

    public void setFrameSize(int n, int n2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (0 < n && n < dimension.width) {
            this._logMonitorFrameWidth = n;
        }
        if (0 < n2 && n2 < dimension.height) {
            this._logMonitorFrameHeight = n2;
        }
        this.updateFrameSize();
    }

    public void setFontSize(int n) {
        this.changeFontSizeCombo(this._fontSizeCombo, n);
    }

    public void addDisplayedProperty(Object object) {
        this._displayedLogBrokerProperties.add(object);
    }

    public Map getLogLevelMenuItems() {
        return this._logLevelMenuItems;
    }

    public Map getLogTableColumnMenuItems() {
        return this._logTableColumnMenuItems;
    }

    public JCheckBoxMenuItem getTableColumnMenuItem(LogTableColumn logTableColumn) {
        return this.getLogTableColumnMenuItem(logTableColumn);
    }

    public CategoryExplorerTree getCategoryExplorerTree() {
        return this._categoryExplorerTree;
    }

    public String getNDCTextFilter() {
        return this._NDCTextFilter;
    }

    public void setNDCLogRecordFilter(String string) {
        this._table.getFilteredLogTableModel().setLogRecordFilter(this.createNDCLogRecordFilter(string));
    }

    protected void setSearchText(String string) {
        this._searchText = string;
    }

    protected void setNDCTextFilter(String string) {
        this._NDCTextFilter = string == null ? "" : string;
    }

    protected void sortByNDC() {
        String string = this._NDCTextFilter;
        if (string == null || string.length() == 0) {
            return;
        }
        this._table.getFilteredLogTableModel().setLogRecordFilter(this.createNDCLogRecordFilter(string));
    }

    protected void findSearchText() {
        String string = this._searchText;
        if (string == null || string.length() == 0) {
            return;
        }
        int n = this.getFirstSelectedRow();
        int n2 = this.findRecord(n, string, this._table.getFilteredLogTableModel().getFilteredRecords());
        this.selectRow(n2);
    }

    protected int getFirstSelectedRow() {
        return this._table.getSelectionModel().getMinSelectionIndex();
    }

    protected void selectRow(int n) {
        if (n == -1) {
            String string = this._searchText + " not found.";
            JOptionPane.showMessageDialog(this._logMonitorFrame, string, "Text not found", 1);
            return;
        }
        LF5SwingUtils.selectRow(n, this._table, this._logTableScrollPane);
    }

    protected int findRecord(int n, String string, List list) {
        int n2;
        n = n < 0 ? 0 : ++n;
        int n3 = list.size();
        for (n2 = n; n2 < n3; ++n2) {
            if (!this.matches((LogRecord)list.get(n2), string)) continue;
            return n2;
        }
        n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.matches((LogRecord)list.get(n2), string)) continue;
            return n2;
        }
        return -1;
    }

    protected boolean matches(LogRecord logRecord, String string) {
        String string2 = logRecord.getMessage();
        String string3 = logRecord.getNDC();
        if (string2 == null && string3 == null || string == null) {
            return false;
        }
        return string2.toLowerCase().indexOf(string.toLowerCase()) != -1 || string3.toLowerCase().indexOf(string.toLowerCase()) != -1;
    }

    protected void refresh(JTextArea jTextArea) {
        String string = jTextArea.getText();
        jTextArea.setText("");
        jTextArea.setText(string);
    }

    protected void refreshDetailTextArea() {
        this.refresh(this._table._detailTextArea);
    }

    protected void clearDetailTextArea() {
        this._table._detailTextArea.setText("");
    }

    protected int changeFontSizeCombo(JComboBox jComboBox, int n) {
        int n2 = jComboBox.getItemCount();
        Object e = jComboBox.getItemAt(0);
        int n3 = Integer.parseInt(String.valueOf(e));
        for (int i = 0; i < n2; ++i) {
            Object e2 = jComboBox.getItemAt(i);
            int n4 = Integer.parseInt(String.valueOf(e2));
            if (n3 >= n4 || n4 > n) continue;
            n3 = n4;
            e = e2;
        }
        jComboBox.setSelectedItem(e);
        return n3;
    }

    protected void setFontSizeSilently(int n) {
        this._fontSize = n;
        this.setFontSize(this._table._detailTextArea, n);
        this.selectRow(0);
        this.setFontSize(this._table, n);
    }

    protected void setFontSize(Component component, int n) {
        Font font = component.getFont();
        Font font2 = new Font(font.getFontName(), font.getStyle(), n);
        component.setFont(font2);
    }

    protected void updateFrameSize() {
        this._logMonitorFrame.setSize(this._logMonitorFrameWidth, this._logMonitorFrameHeight);
        this.centerFrame(this._logMonitorFrame);
    }

    protected void pause(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void initComponents() {
        this._logMonitorFrame = new JFrame("LogFactor5");
        this._logMonitorFrame.setDefaultCloseOperation(0);
        String string = "/org/apache/log4j/lf5/viewer/images/lf5_small_icon.gif";
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            this._logMonitorFrame.setIconImage(new ImageIcon(uRL).getImage());
        }
        this.updateFrameSize();
        JTextArea jTextArea = this.createDetailTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        this._table = new LogTable(jTextArea);
        this.setView(this._currentView, this._table);
        this._table.setFont(new Font(this._fontName, 0, this._fontSize));
        this._logTableScrollPane = new JScrollPane(this._table);
        if (this._trackTableScrollPane) {
            this._logTableScrollPane.getVerticalScrollBar().addAdjustmentListener(new TrackingAdjustmentListener());
        }
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setOrientation(0);
        jSplitPane.setLeftComponent(this._logTableScrollPane);
        jSplitPane.setRightComponent(jScrollPane);
        jSplitPane.setDividerLocation(350);
        this._categoryExplorerTree = new CategoryExplorerTree();
        this._table.getFilteredLogTableModel().setLogRecordFilter(this.createLogRecordFilter());
        JScrollPane jScrollPane2 = new JScrollPane(this._categoryExplorerTree);
        jScrollPane2.setPreferredSize(new Dimension(130, 400));
        this._mruFileManager = new MRUFileManager();
        JSplitPane jSplitPane2 = new JSplitPane();
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setRightComponent(jSplitPane);
        jSplitPane2.setLeftComponent(jScrollPane2);
        jSplitPane2.setDividerLocation(130);
        this._logMonitorFrame.getRootPane().setJMenuBar(this.createMenuBar());
        this._logMonitorFrame.getContentPane().add((Component)jSplitPane2, "Center");
        this._logMonitorFrame.getContentPane().add((Component)this.createToolBar(), "North");
        this._logMonitorFrame.getContentPane().add((Component)this.createStatusArea(), "South");
        this.makeLogTableListenToCategoryExplorer();
        this.addTableModelProperties();
        this._configurationManager = new ConfigurationManager(this, this._table);
    }

    protected LogRecordFilter createLogRecordFilter() {
        LogRecordFilter logRecordFilter = new LogRecordFilter(){

            public boolean passes(LogRecord logRecord) {
                CategoryPath categoryPath = new CategoryPath(logRecord.getCategory());
                return LogBrokerMonitor.this.getMenuItem(logRecord.getLevel()).isSelected() && LogBrokerMonitor.this._categoryExplorerTree.getExplorerModel().isCategoryPathActive(categoryPath);
            }
        };
        return logRecordFilter;
    }

    protected LogRecordFilter createNDCLogRecordFilter(String string) {
        this._NDCTextFilter = string;
        LogRecordFilter logRecordFilter = new LogRecordFilter(){

            public boolean passes(LogRecord logRecord) {
                String string = logRecord.getNDC();
                CategoryPath categoryPath = new CategoryPath(logRecord.getCategory());
                if (string == null || LogBrokerMonitor.this._NDCTextFilter == null) {
                    return false;
                }
                if (string.toLowerCase().indexOf(LogBrokerMonitor.this._NDCTextFilter.toLowerCase()) == -1) {
                    return false;
                }
                return LogBrokerMonitor.this.getMenuItem(logRecord.getLevel()).isSelected() && LogBrokerMonitor.this._categoryExplorerTree.getExplorerModel().isCategoryPathActive(categoryPath);
            }
        };
        return logRecordFilter;
    }

    protected void updateStatusLabel() {
        this._statusLabel.setText(this.getRecordsDisplayedMessage());
    }

    protected String getRecordsDisplayedMessage() {
        FilteredLogTableModel filteredLogTableModel = this._table.getFilteredLogTableModel();
        return this.getStatusText(filteredLogTableModel.getRowCount(), filteredLogTableModel.getTotalRowCount());
    }

    protected void addTableModelProperties() {
        final FilteredLogTableModel filteredLogTableModel = this._table.getFilteredLogTableModel();
        this.addDisplayedProperty(new Object(){

            public String toString() {
                return LogBrokerMonitor.this.getRecordsDisplayedMessage();
            }
        });
        this.addDisplayedProperty(new Object(){

            public String toString() {
                return "Maximum number of displayed LogRecords: " + filteredLogTableModel._maxNumberOfLogRecords;
            }
        });
    }

    protected String getStatusText(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Displaying: ");
        stringBuffer.append(n);
        stringBuffer.append(" records out of a total of: ");
        stringBuffer.append(n2);
        stringBuffer.append(" records.");
        return stringBuffer.toString();
    }

    protected void makeLogTableListenToCategoryExplorer() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this._table.getFilteredLogTableModel().refresh();
                LogBrokerMonitor.this.updateStatusLabel();
            }
        };
        this._categoryExplorerTree.getExplorerModel().addActionListener(actionListener);
    }

    protected JPanel createStatusArea() {
        JLabel jLabel;
        JPanel jPanel = new JPanel();
        this._statusLabel = jLabel = new JLabel("No log records to display.");
        jLabel.setHorizontalAlignment(2);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(jLabel);
        return jPanel;
    }

    protected JTextArea createDetailTextArea() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Monospaced", 0, 14));
        jTextArea.setTabSize(3);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(false);
        return jTextArea;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.createEditMenu());
        jMenuBar.add(this.createLogLevelMenu());
        jMenuBar.add(this.createViewMenu());
        jMenuBar.add(this.createConfigureMenu());
        jMenuBar.add(this.createHelpMenu());
        return jMenuBar;
    }

    protected JMenu createLogLevelMenu() {
        JMenu jMenu = new JMenu("Log Level");
        jMenu.setMnemonic('l');
        Iterator iterator = this.getLogLevels();
        while (iterator.hasNext()) {
            jMenu.add(this.getMenuItem((LogLevel)iterator.next()));
        }
        jMenu.addSeparator();
        jMenu.add(this.createAllLogLevelsMenuItem());
        jMenu.add(this.createNoLogLevelsMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createLogLevelColorMenu());
        jMenu.add(this.createResetLogLevelColorMenuItem());
        return jMenu;
    }

    protected JMenuItem createAllLogLevelsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Show all LogLevels");
        jMenuItem.setMnemonic('s');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.selectAllLogLevels(true);
                LogBrokerMonitor.this._table.getFilteredLogTableModel().refresh();
                LogBrokerMonitor.this.updateStatusLabel();
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createNoLogLevelsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Hide all LogLevels");
        jMenuItem.setMnemonic('h');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.selectAllLogLevels(false);
                LogBrokerMonitor.this._table.getFilteredLogTableModel().refresh();
                LogBrokerMonitor.this.updateStatusLabel();
            }
        });
        return jMenuItem;
    }

    protected JMenu createLogLevelColorMenu() {
        JMenu jMenu = new JMenu("Configure LogLevel Colors");
        jMenu.setMnemonic('c');
        Iterator iterator = this.getLogLevels();
        while (iterator.hasNext()) {
            jMenu.add(this.createSubMenuItem((LogLevel)iterator.next()));
        }
        return jMenu;
    }

    protected JMenuItem createResetLogLevelColorMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Reset LogLevel Colors");
        jMenuItem.setMnemonic('r');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogLevel.resetLogLevelColorMap();
                LogBrokerMonitor.this._table.getFilteredLogTableModel().refresh();
            }
        });
        return jMenuItem;
    }

    protected void selectAllLogLevels(boolean bl) {
        Iterator iterator = this.getLogLevels();
        while (iterator.hasNext()) {
            this.getMenuItem((LogLevel)iterator.next()).setSelected(bl);
        }
    }

    protected JCheckBoxMenuItem getMenuItem(LogLevel logLevel) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this._logLevelMenuItems.get(logLevel);
        if (jCheckBoxMenuItem == null) {
            jCheckBoxMenuItem = this.createMenuItem(logLevel);
            this._logLevelMenuItems.put(logLevel, jCheckBoxMenuItem);
        }
        return jCheckBoxMenuItem;
    }

    protected JMenuItem createSubMenuItem(LogLevel logLevel) {
        final JMenuItem jMenuItem = new JMenuItem(logLevel.toString());
        final LogLevel logLevel2 = logLevel;
        jMenuItem.setMnemonic(logLevel.toString().charAt(0));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.showLogLevelColorChangeDialog(jMenuItem, logLevel2);
            }
        });
        return jMenuItem;
    }

    protected void showLogLevelColorChangeDialog(JMenuItem jMenuItem, LogLevel logLevel) {
        JMenuItem jMenuItem2 = jMenuItem;
        Color color = JColorChooser.showDialog(this._logMonitorFrame, "Choose LogLevel Color", jMenuItem.getForeground());
        if (color != null) {
            logLevel.setLogLevelColorMap(logLevel, color);
            this._table.getFilteredLogTableModel().refresh();
        }
    }

    protected JCheckBoxMenuItem createMenuItem(LogLevel logLevel) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(logLevel.toString());
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.setMnemonic(logLevel.toString().charAt(0));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this._table.getFilteredLogTableModel().refresh();
                LogBrokerMonitor.this.updateStatusLabel();
            }
        });
        return jCheckBoxMenuItem;
    }

    protected JMenu createViewMenu() {
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic('v');
        Iterator iterator = this.getLogTableColumns();
        while (iterator.hasNext()) {
            jMenu.add(this.getLogTableColumnMenuItem((LogTableColumn)iterator.next()));
        }
        jMenu.addSeparator();
        jMenu.add(this.createAllLogTableColumnsMenuItem());
        jMenu.add(this.createNoLogTableColumnsMenuItem());
        return jMenu;
    }

    protected JCheckBoxMenuItem getLogTableColumnMenuItem(LogTableColumn logTableColumn) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this._logTableColumnMenuItems.get(logTableColumn);
        if (jCheckBoxMenuItem == null) {
            jCheckBoxMenuItem = this.createLogTableColumnMenuItem(logTableColumn);
            this._logTableColumnMenuItems.put(logTableColumn, jCheckBoxMenuItem);
        }
        return jCheckBoxMenuItem;
    }

    protected JCheckBoxMenuItem createLogTableColumnMenuItem(LogTableColumn logTableColumn) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(logTableColumn.toString());
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.setMnemonic(logTableColumn.toString().charAt(0));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List list = LogBrokerMonitor.this.updateView();
                LogBrokerMonitor.this._table.setView(list);
            }
        });
        return jCheckBoxMenuItem;
    }

    protected List updateView() {
        ArrayList<LogTableColumn> arrayList = new ArrayList<LogTableColumn>();
        Iterator iterator = this._columns.iterator();
        while (iterator.hasNext()) {
            LogTableColumn logTableColumn = (LogTableColumn)iterator.next();
            JCheckBoxMenuItem jCheckBoxMenuItem = this.getLogTableColumnMenuItem(logTableColumn);
            if (!jCheckBoxMenuItem.isSelected()) continue;
            arrayList.add(logTableColumn);
        }
        return arrayList;
    }

    protected JMenuItem createAllLogTableColumnsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Show all Columns");
        jMenuItem.setMnemonic('s');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.selectAllLogTableColumns(true);
                List list = LogBrokerMonitor.this.updateView();
                LogBrokerMonitor.this._table.setView(list);
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createNoLogTableColumnsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Hide all Columns");
        jMenuItem.setMnemonic('h');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.selectAllLogTableColumns(false);
                List list = LogBrokerMonitor.this.updateView();
                LogBrokerMonitor.this._table.setView(list);
            }
        });
        return jMenuItem;
    }

    protected void selectAllLogTableColumns(boolean bl) {
        Iterator iterator = this.getLogTableColumns();
        while (iterator.hasNext()) {
            this.getLogTableColumnMenuItem((LogTableColumn)iterator.next()).setSelected(bl);
        }
    }

    protected JMenu createFileMenu() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('f');
        jMenu.add(this.createOpenMI());
        jMenu.add(this.createOpenURLMI());
        jMenu.addSeparator();
        jMenu.add(this.createCloseMI());
        this.createMRUFileListMI(jMenu);
        jMenu.addSeparator();
        jMenu.add(this.createExitMI());
        return jMenu;
    }

    protected JMenuItem createOpenMI() {
        JMenuItem jMenuItem = new JMenuItem("Open...");
        jMenuItem.setMnemonic('o');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.requestOpen();
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createOpenURLMI() {
        JMenuItem jMenuItem = new JMenuItem("Open URL...");
        jMenuItem.setMnemonic('u');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.requestOpenURL();
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createCloseMI() {
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setMnemonic('c');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control Q"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.requestClose();
            }
        });
        return jMenuItem;
    }

    protected void createMRUFileListMI(JMenu jMenu) {
        String[] stringArray = this._mruFileManager.getMRUFileList();
        if (stringArray != null) {
            jMenu.addSeparator();
            for (int i = 0; i < stringArray.length; ++i) {
                JMenuItem jMenuItem = new JMenuItem(i + 1 + " " + stringArray[i]);
                jMenuItem.setMnemonic(i + 1);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        LogBrokerMonitor.this.requestOpenMRU(actionEvent);
                    }
                });
                jMenu.add(jMenuItem);
            }
        }
    }

    protected JMenuItem createExitMI() {
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic('x');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.requestExit();
            }
        });
        return jMenuItem;
    }

    protected JMenu createConfigureMenu() {
        JMenu jMenu = new JMenu("Configure");
        jMenu.setMnemonic('c');
        jMenu.add(this.createConfigureSave());
        jMenu.add(this.createConfigureReset());
        jMenu.add(this.createConfigureMaxRecords());
        return jMenu;
    }

    protected JMenuItem createConfigureSave() {
        JMenuItem jMenuItem = new JMenuItem("Save");
        jMenuItem.setMnemonic('s');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.saveConfiguration();
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createConfigureReset() {
        JMenuItem jMenuItem = new JMenuItem("Reset");
        jMenuItem.setMnemonic('r');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.resetConfiguration();
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createConfigureMaxRecords() {
        JMenuItem jMenuItem = new JMenuItem("Set Max Number of Records");
        jMenuItem.setMnemonic('m');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.setMaxRecordConfiguration();
            }
        });
        return jMenuItem;
    }

    protected void saveConfiguration() {
        this._configurationManager.save();
    }

    protected void resetConfiguration() {
        this._configurationManager.reset();
    }

    protected void setMaxRecordConfiguration() {
        LogFactor5InputDialog logFactor5InputDialog = new LogFactor5InputDialog(this.getBaseFrame(), "Set Max Number of Records", "", 10);
        String string = logFactor5InputDialog.getText();
        if (string != null) {
            try {
                this.setMaxNumberOfLogRecords(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                LogFactor5ErrorDialog logFactor5ErrorDialog = new LogFactor5ErrorDialog(this.getBaseFrame(), "'" + string + "' is an invalid parameter.\nPlease try again.");
                this.setMaxRecordConfiguration();
            }
        }
    }

    protected JMenu createHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        jMenu.setMnemonic('h');
        jMenu.add(this.createHelpProperties());
        return jMenu;
    }

    protected JMenuItem createHelpProperties() {
        String string = "LogFactor5 Properties";
        JMenuItem jMenuItem = new JMenuItem("LogFactor5 Properties");
        jMenuItem.setMnemonic('l');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.showPropertiesDialog("LogFactor5 Properties");
            }
        });
        return jMenuItem;
    }

    protected void showPropertiesDialog(String string) {
        JOptionPane.showMessageDialog(this._logMonitorFrame, this._displayedLogBrokerProperties.toArray(), string, -1);
    }

    protected JMenu createEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic('e');
        jMenu.add(this.createEditFindMI());
        jMenu.add(this.createEditFindNextMI());
        jMenu.addSeparator();
        jMenu.add(this.createEditSortNDCMI());
        jMenu.add(this.createEditRestoreAllNDCMI());
        return jMenu;
    }

    protected JMenuItem createEditFindNextMI() {
        JMenuItem jMenuItem = new JMenuItem("Find Next");
        jMenuItem.setMnemonic('n');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("F3"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this.findSearchText();
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createEditFindMI() {
        JMenuItem jMenuItem = new JMenuItem("Find");
        jMenuItem.setMnemonic('f');
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control F"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(LogBrokerMonitor.this._logMonitorFrame, "Find text: ", "Search Record Messages", 3);
                LogBrokerMonitor.this.setSearchText(string);
                LogBrokerMonitor.this.findSearchText();
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createEditSortNDCMI() {
        JMenuItem jMenuItem = new JMenuItem("Sort by NDC");
        jMenuItem.setMnemonic('s');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(LogBrokerMonitor.this._logMonitorFrame, "Sort by this NDC: ", "Sort Log Records by NDC", 3);
                LogBrokerMonitor.this.setNDCTextFilter(string);
                LogBrokerMonitor.this.sortByNDC();
                LogBrokerMonitor.this._table.getFilteredLogTableModel().refresh();
                LogBrokerMonitor.this.updateStatusLabel();
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createEditRestoreAllNDCMI() {
        JMenuItem jMenuItem = new JMenuItem("Restore all NDCs");
        jMenuItem.setMnemonic('r');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this._table.getFilteredLogTableModel().setLogRecordFilter(LogBrokerMonitor.this.createLogRecordFilter());
                LogBrokerMonitor.this.setNDCTextFilter("");
                LogBrokerMonitor.this._table.getFilteredLogTableModel().refresh();
                LogBrokerMonitor.this.updateStatusLabel();
            }
        });
        return jMenuItem;
    }

    protected JToolBar createToolBar() {
        JComboBox<String> jComboBox;
        JToolBar jToolBar = new JToolBar();
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        JComboBox<String> jComboBox2 = new JComboBox<String>();
        this._fontSizeCombo = jComboBox = new JComboBox<String>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        URL uRL = classLoader.getResource("org/apache/log4j/lf5/viewer/images/channelexplorer_new.gif");
        ImageIcon imageIcon = null;
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        }
        JButton jButton = new JButton("Clear Log Table");
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
        }
        jButton.setToolTipText("Clear Log Table.");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogBrokerMonitor.this._table.clearLogRecords();
                LogBrokerMonitor.this._categoryExplorerTree.getExplorerModel().resetAllNodeCounts();
                LogBrokerMonitor.this.updateStatusLabel();
                LogBrokerMonitor.this.clearDetailTextArea();
                LogRecord.resetSequenceNumber();
            }
        });
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String[] stringArray = this._loadSystemFonts ? GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames() : toolkit.getFontList();
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox2.addItem(stringArray[i]);
        }
        jComboBox2.setSelectedItem(this._fontName);
        jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                LogBrokerMonitor.this._table.setFont(new Font(string, 0, LogBrokerMonitor.this._fontSize));
                LogBrokerMonitor.this._fontName = string;
            }
        });
        jComboBox.addItem("8");
        jComboBox.addItem("9");
        jComboBox.addItem("10");
        jComboBox.addItem("12");
        jComboBox.addItem("14");
        jComboBox.addItem("16");
        jComboBox.addItem("18");
        jComboBox.addItem("24");
        jComboBox.setSelectedItem(String.valueOf(this._fontSize));
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                int n = Integer.valueOf(string);
                LogBrokerMonitor.this.setFontSizeSilently(n);
                LogBrokerMonitor.this.refreshDetailTextArea();
                LogBrokerMonitor.this._fontSize = n;
            }
        });
        jToolBar.add(new JLabel(" Font: "));
        jToolBar.add(jComboBox2);
        jToolBar.add(jComboBox);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.add(jButton);
        jButton.setAlignmentY(0.5f);
        jButton.setAlignmentX(0.5f);
        jComboBox2.setMaximumSize(jComboBox2.getPreferredSize());
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        return jToolBar;
    }

    protected void setView(String string, LogTable logTable) {
        if (!DETAILED_VIEW.equals(string)) {
            String string2 = string + "does not match a supported view.";
            throw new IllegalArgumentException(string2);
        }
        logTable.setDetailedView();
        this._currentView = string;
    }

    protected JComboBox createLogLevelCombo() {
        JComboBox jComboBox = new JComboBox();
        Iterator iterator = this.getLogLevels();
        while (iterator.hasNext()) {
            jComboBox.addItem(iterator.next());
        }
        jComboBox.setSelectedItem(this._leastSevereDisplayedLogLevel);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                LogLevel logLevel = (LogLevel)jComboBox.getSelectedItem();
                LogBrokerMonitor.this.setLeastSevereDisplayedLogLevel(logLevel);
            }
        });
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        return jComboBox;
    }

    protected void setLeastSevereDisplayedLogLevel(LogLevel logLevel) {
        if (logLevel == null || this._leastSevereDisplayedLogLevel == logLevel) {
            return;
        }
        this._leastSevereDisplayedLogLevel = logLevel;
        this._table.getFilteredLogTableModel().refresh();
        this.updateStatusLabel();
    }

    protected void trackTableScrollPane() {
    }

    protected void centerFrame(JFrame jFrame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jFrame.getSize();
        jFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    protected void requestOpen() {
        File file;
        JFileChooser jFileChooser = this._fileLocation == null ? new JFileChooser() : new JFileChooser(this._fileLocation);
        int n = jFileChooser.showOpenDialog(this._logMonitorFrame);
        if (n == 0 && this.loadLogFile(file = jFileChooser.getSelectedFile())) {
            this._fileLocation = jFileChooser.getSelectedFile();
            this._mruFileManager.set(file);
            this.updateMRUList();
        }
    }

    protected void requestOpenURL() {
        LogFactor5InputDialog logFactor5InputDialog = new LogFactor5InputDialog(this.getBaseFrame(), "Open URL", "URL:");
        String string = logFactor5InputDialog.getText();
        if (string != null) {
            if (string.indexOf("://") == -1) {
                string = "http://" + string;
            }
            try {
                URL uRL = new URL(string);
                if (this.loadLogFile(uRL)) {
                    this._mruFileManager.set(uRL);
                    this.updateMRUList();
                }
            }
            catch (MalformedURLException malformedURLException) {
                LogFactor5ErrorDialog logFactor5ErrorDialog = new LogFactor5ErrorDialog(this.getBaseFrame(), "Error reading URL.");
            }
        }
    }

    protected void updateMRUList() {
        JMenu jMenu = this._logMonitorFrame.getJMenuBar().getMenu(0);
        jMenu.removeAll();
        jMenu.add(this.createOpenMI());
        jMenu.add(this.createOpenURLMI());
        jMenu.addSeparator();
        jMenu.add(this.createCloseMI());
        this.createMRUFileListMI(jMenu);
        jMenu.addSeparator();
        jMenu.add(this.createExitMI());
    }

    protected void requestClose() {
        this.setCallSystemExitOnClose(false);
        this.closeAfterConfirm();
    }

    protected void requestOpenMRU(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken().trim();
        string = stringTokenizer.nextToken("\n");
        try {
            int n = Integer.parseInt(string2) - 1;
            InputStream inputStream = this._mruFileManager.getInputStream(n);
            LogFileParser logFileParser = new LogFileParser(inputStream);
            logFileParser.parse(this);
            this._mruFileManager.moveToTop(n);
            this.updateMRUList();
        }
        catch (Exception exception) {
            LogFactor5ErrorDialog logFactor5ErrorDialog = new LogFactor5ErrorDialog(this.getBaseFrame(), "Unable to load file " + string);
        }
    }

    protected void requestExit() {
        this._mruFileManager.save();
        this.setCallSystemExitOnClose(true);
        this.closeAfterConfirm();
    }

    protected void closeAfterConfirm() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (!this._callSystemExitOnClose) {
            stringBuffer.append("Are you sure you want to close the logging ");
            stringBuffer.append("console?\n");
            stringBuffer.append("(Note: This will not shut down the Virtual Machine,\n");
            stringBuffer.append("or the Swing event thread.)");
        } else {
            stringBuffer.append("Are you sure you want to exit?\n");
            stringBuffer.append("This will shut down the Virtual Machine.\n");
        }
        String string = "Are you sure you want to dispose of the Logging Console?";
        if (this._callSystemExitOnClose) {
            string = "Are you sure you want to exit?";
        }
        if ((n = JOptionPane.showConfirmDialog(this._logMonitorFrame, stringBuffer.toString(), string, 2, 3, null)) == 0) {
            this.dispose();
        }
    }

    protected Iterator getLogLevels() {
        return this._levels.iterator();
    }

    protected Iterator getLogTableColumns() {
        return this._columns.iterator();
    }

    protected boolean loadLogFile(File file) {
        boolean bl = false;
        try {
            LogFileParser logFileParser = new LogFileParser(file);
            logFileParser.parse(this);
            bl = true;
        }
        catch (IOException iOException) {
            LogFactor5ErrorDialog logFactor5ErrorDialog = new LogFactor5ErrorDialog(this.getBaseFrame(), "Error reading " + file.getName());
        }
        return bl;
    }

    protected boolean loadLogFile(URL uRL) {
        boolean bl = false;
        try {
            LogFileParser logFileParser = new LogFileParser(uRL.openStream());
            logFileParser.parse(this);
            bl = true;
        }
        catch (IOException iOException) {
            LogFactor5ErrorDialog logFactor5ErrorDialog = new LogFactor5ErrorDialog(this.getBaseFrame(), "Error reading URL:" + uRL.getFile());
        }
        return bl;
    }

    class LogBrokerMonitorWindowAdaptor
    extends WindowAdapter {
        protected LogBrokerMonitor _monitor;

        public LogBrokerMonitorWindowAdaptor(LogBrokerMonitor logBrokerMonitor2) {
            this._monitor = logBrokerMonitor2;
        }

        public void windowClosing(WindowEvent windowEvent) {
            this._monitor.requestClose();
        }
    }
}

