/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

public class PropertyName {
    public static final PropertyName USE_DEFAULT = new PropertyName("", null);
    public static final PropertyName NO_NAME = new PropertyName(new String("#disabled"), null);
    protected final String _simpleName;
    protected final String _namespace;

    public PropertyName(String string) {
        this(string, null);
    }

    public PropertyName(String string, String string2) {
        this._simpleName = string == null ? "" : string;
        this._namespace = string2;
    }

    public static PropertyName construct(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null && string.length() == 0) {
            return USE_DEFAULT;
        }
        return new PropertyName(string, string2);
    }

    public PropertyName withSimpleName(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this._simpleName)) {
            return this;
        }
        return new PropertyName(string, this._namespace);
    }

    public PropertyName withNamespace(String string) {
        if (string == null ? this._namespace == null : string.equals(this._namespace)) {
            return this;
        }
        return new PropertyName(this._simpleName, string);
    }

    public String getSimpleName() {
        return this._simpleName;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public boolean hasSimpleName() {
        return this._simpleName.length() > 0;
    }

    public boolean hasNamespace() {
        return this._namespace != null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != PropertyName.class) {
            return false;
        }
        if (USE_DEFAULT == object) {
            return this == USE_DEFAULT;
        }
        PropertyName propertyName = this;
        if (this._simpleName == null ? propertyName._simpleName != null : !this._simpleName.equals(propertyName._simpleName)) {
            return false;
        }
        if (this._namespace == null) {
            return null == propertyName._namespace;
        }
        return this._namespace.equals(propertyName._namespace);
    }

    public int hashCode() {
        if (this._namespace == null) {
            return this._simpleName.hashCode();
        }
        return this._namespace.hashCode() ^ this._simpleName.hashCode();
    }

    public String toString() {
        if (this._namespace == null) {
            return this._simpleName;
        }
        return "{" + this._namespace + "}" + this._simpleName;
    }
}

