/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ClassDeserializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkDeserializers {
    public static StdDeserializer<?>[] all() {
        return new StdDeserializer[]{new StringDeserializer(), new UUIDDeserializer(), new URLDeserializer(), new URIDeserializer(), new CurrencyDeserializer(), new PatternDeserializer(), new LocaleDeserializer(), new InetAddressDeserializer(), new CharsetDeserializer(), new AtomicBooleanDeserializer(), new ClassDeserializer(), new StackTraceElementDeserializer()};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomicBooleanDeserializer
    extends StdScalarDeserializer<AtomicBoolean> {
        public AtomicBooleanDeserializer() {
            super(AtomicBoolean.class);
        }

        @Override
        public AtomicBoolean deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return new AtomicBoolean(this._parseBooleanPrimitive(jsonParser, deserializationContext));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomicReferenceDeserializer
    extends StdScalarDeserializer<AtomicReference<?>>
    implements ContextualDeserializer {
        protected final JavaType _referencedType;
        protected final JsonDeserializer<?> _valueDeserializer;

        public AtomicReferenceDeserializer(JavaType javaType) {
            this(javaType, null);
        }

        public AtomicReferenceDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
            super(AtomicReference.class);
            this._referencedType = javaType;
            this._valueDeserializer = jsonDeserializer;
        }

        @Override
        public AtomicReference<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return new AtomicReference(this._valueDeserializer.deserialize(jsonParser, deserializationContext));
        }

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
            JsonDeserializer<?> jsonDeserializer = this._valueDeserializer;
            if (jsonDeserializer != null) {
                return this;
            }
            return new AtomicReferenceDeserializer(this._referencedType, deserializationContext.findContextualValueDeserializer(this._referencedType, beanProperty));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CharsetDeserializer
    extends FromStringDeserializer<Charset> {
        public CharsetDeserializer() {
            super(Charset.class);
        }

        @Override
        protected Charset _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            return Charset.forName(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurrencyDeserializer
    extends FromStringDeserializer<Currency> {
        public CurrencyDeserializer() {
            super(Currency.class);
        }

        @Override
        protected Currency _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return Currency.getInstance(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InetAddressDeserializer
    extends FromStringDeserializer<InetAddress> {
        public InetAddressDeserializer() {
            super(InetAddress.class);
        }

        @Override
        protected InetAddress _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            return InetAddress.getByName(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LocaleDeserializer
    extends FromStringDeserializer<Locale> {
        public LocaleDeserializer() {
            super(Locale.class);
        }

        @Override
        protected Locale _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            int n = string.indexOf(95);
            if (n < 0) {
                return new Locale(string);
            }
            String string2 = string.substring(0, n);
            if ((n = (string = string.substring(n + 1)).indexOf(95)) < 0) {
                return new Locale(string2, string);
            }
            String string3 = string.substring(0, n);
            return new Locale(string2, string3, string.substring(n + 1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PatternDeserializer
    extends FromStringDeserializer<Pattern> {
        public PatternDeserializer() {
            super(Pattern.class);
        }

        @Override
        protected Pattern _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return Pattern.compile(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StackTraceElementDeserializer
    extends StdScalarDeserializer<StackTraceElement> {
        public StackTraceElementDeserializer() {
            super(StackTraceElement.class);
        }

        @Override
        public StackTraceElement deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.START_OBJECT) {
                String string = "";
                String string2 = "";
                String string3 = "";
                int n = -1;
                while ((jsonToken = jsonParser.nextValue()) != JsonToken.END_OBJECT) {
                    String string4 = jsonParser.getCurrentName();
                    if ("className".equals(string4)) {
                        string = jsonParser.getText();
                        continue;
                    }
                    if ("fileName".equals(string4)) {
                        string3 = jsonParser.getText();
                        continue;
                    }
                    if ("lineNumber".equals(string4)) {
                        if (jsonToken.isNumeric()) {
                            n = jsonParser.getIntValue();
                            continue;
                        }
                        throw JsonMappingException.from(jsonParser, "Non-numeric token (" + jsonToken + ") for property 'lineNumber'");
                    }
                    if ("methodName".equals(string4)) {
                        string2 = jsonParser.getText();
                        continue;
                    }
                    if ("nativeMethod".equals(string4)) continue;
                    this.handleUnknownProperty(jsonParser, deserializationContext, this._valueClass, string4);
                }
                return new StackTraceElement(string, string2, string3, n);
            }
            throw deserializationContext.mappingException(this._valueClass, jsonToken);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URIDeserializer
    extends FromStringDeserializer<URI> {
        public URIDeserializer() {
            super(URI.class);
        }

        @Override
        protected URI _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return URI.create(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URLDeserializer
    extends FromStringDeserializer<URL> {
        public URLDeserializer() {
            super(URL.class);
        }

        @Override
        protected URL _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            return new URL(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UUIDDeserializer
    extends FromStringDeserializer<UUID> {
        public UUIDDeserializer() {
            super(UUID.class);
        }

        @Override
        protected UUID _deserialize(String string, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return UUID.fromString(string);
        }

        @Override
        protected UUID _deserializeEmbedded(Object object, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                if (byArray.length != 16) {
                    deserializationContext.mappingException("Can only construct UUIDs from 16 byte arrays; got " + byArray.length + " bytes");
                }
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                long l = dataInputStream.readLong();
                long l2 = dataInputStream.readLong();
                return new UUID(l, l2);
            }
            super._deserializeEmbedded(object, deserializationContext);
            return null;
        }
    }
}

