/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.IndexedStringListSerializer;
import com.fasterxml.jackson.databind.ser.impl.StringArraySerializer;
import com.fasterxml.jackson.databind.ser.impl.StringCollectionSerializer;
import com.fasterxml.jackson.databind.ser.std.BooleanSerializer;
import com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumMapSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.InetAddressSerializer;
import com.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.NullSerializer;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import com.fasterxml.jackson.databind.ser.std.ObjectArraySerializer;
import com.fasterxml.jackson.databind.ser.std.SerializableSerializer;
import com.fasterxml.jackson.databind.ser.std.SqlDateSerializer;
import com.fasterxml.jackson.databind.ser.std.SqlTimeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import com.fasterxml.jackson.databind.ser.std.StdContainerSerializers;
import com.fasterxml.jackson.databind.ser.std.StdJdkSerializers;
import com.fasterxml.jackson.databind.ser.std.StringSerializer;
import com.fasterxml.jackson.databind.ser.std.TimeZoneSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.ser.std.TokenBufferSerializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumValues;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicSerializerFactory
extends SerializerFactory
implements Serializable {
    private static final long serialVersionUID = -1416617628045738132L;
    protected static final HashMap<String, JsonSerializer<?>> _concrete = new HashMap();
    protected static final HashMap<String, Class<? extends JsonSerializer<?>>> _concreteLazy = new HashMap();
    protected final SerializerFactoryConfig _factoryConfig;
    protected OptionalHandlerFactory optionalHandlers = OptionalHandlerFactory.instance;

    protected BasicSerializerFactory(SerializerFactoryConfig serializerFactoryConfig) {
        this._factoryConfig = serializerFactoryConfig == null ? new SerializerFactoryConfig() : serializerFactoryConfig;
    }

    public SerializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    public abstract SerializerFactory withConfig(SerializerFactoryConfig var1);

    @Override
    public final SerializerFactory withAdditionalSerializers(Serializers serializers) {
        return this.withConfig(this._factoryConfig.withAdditionalSerializers(serializers));
    }

    @Override
    public final SerializerFactory withAdditionalKeySerializers(Serializers serializers) {
        return this.withConfig(this._factoryConfig.withAdditionalKeySerializers(serializers));
    }

    @Override
    public final SerializerFactory withSerializerModifier(BeanSerializerModifier beanSerializerModifier) {
        return this.withConfig(this._factoryConfig.withSerializerModifier(beanSerializerModifier));
    }

    @Override
    public abstract JsonSerializer<Object> createSerializer(SerializerProvider var1, JavaType var2) throws JsonMappingException;

    @Override
    public JsonSerializer<Object> createKeySerializer(SerializationConfig serializationConfig, JavaType javaType) {
        Serializers serializers;
        if (!this._factoryConfig.hasKeySerializers()) {
            return null;
        }
        BeanDescription beanDescription = serializationConfig.introspectClassAnnotations(javaType.getRawClass());
        JsonSerializer<?> jsonSerializer = null;
        Iterator<Serializers> iterator = this._factoryConfig.keySerializers().iterator();
        while (iterator.hasNext() && (jsonSerializer = (serializers = iterator.next()).findSerializer(serializationConfig, javaType, beanDescription)) == null) {
        }
        return jsonSerializer;
    }

    @Override
    public TypeSerializer createTypeSerializer(SerializationConfig serializationConfig, JavaType javaType) {
        BeanDescription beanDescription = serializationConfig.introspectClassAnnotations(javaType.getRawClass());
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder<?> typeResolverBuilder = annotationIntrospector.findTypeResolver(serializationConfig, annotatedClass, javaType);
        Collection<NamedType> collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = serializationConfig.getDefaultTyper(javaType);
        } else {
            collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypes(annotatedClass, serializationConfig, annotationIntrospector);
        }
        if (typeResolverBuilder == null) {
            return null;
        }
        return typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType, collection);
    }

    public final JsonSerializer<?> getNullSerializer() {
        return NullSerializer.instance;
    }

    protected abstract Iterable<Serializers> customSerializers();

    protected final JsonSerializer<?> findSerializerByLookup(JavaType javaType, SerializationConfig serializationConfig, BeanDescription beanDescription, boolean bl) {
        Class<?> clazz = javaType.getRawClass();
        String string = clazz.getName();
        JsonSerializer<?> jsonSerializer = _concrete.get(string);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        Class<JsonSerializer<?>> clazz2 = _concreteLazy.get(string);
        if (clazz2 != null) {
            try {
                return clazz2.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to instantiate standard serializer (of type " + clazz2.getName() + "): " + exception.getMessage(), exception);
            }
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByAnnotations(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(clazz)) {
            return SerializableSerializer.instance;
        }
        AnnotatedMethod annotatedMethod = beanDescription.findJsonValueMethod();
        if (annotatedMethod != null) {
            Method method = annotatedMethod.getAnnotated();
            if (serializerProvider.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(method);
            }
            JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMethod);
            return new JsonValueSerializer(method, jsonSerializer);
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByPrimaryType(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        Class<Enum<?>> clazz = javaType.getRawClass();
        if (InetAddress.class.isAssignableFrom(clazz)) {
            return InetAddressSerializer.instance;
        }
        if (TimeZone.class.isAssignableFrom(clazz)) {
            return TimeZoneSerializer.instance;
        }
        if (Charset.class.isAssignableFrom(clazz)) {
            return ToStringSerializer.instance;
        }
        JsonSerializer<?> jsonSerializer = this.optionalHandlers.findSerializer(serializerProvider.getConfig(), javaType);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return NumberSerializers.NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            JsonFormat.Value value = beanDescription.findExpectedFormat(null);
            if (value != null && value.getShape() == JsonFormat.Shape.OBJECT) {
                ((BasicBeanDescription)beanDescription).removeProperty("declaringClass");
            } else {
                Class<Enum<?>> clazz2 = clazz;
                return EnumSerializer.construct(clazz2, serializerProvider.getConfig(), beanDescription, value);
            }
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return CalendarSerializer.instance;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return DateSerializer.instance;
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByAddonType(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (Iterator.class.isAssignableFrom(clazz)) {
            return this.buildIteratorSerializer(serializationConfig, javaType, beanDescription, bl);
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return this.buildIterableSerializer(serializationConfig, javaType, beanDescription, bl);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer<Object> findSerializerFromAnnotation(SerializerProvider serializerProvider, Annotated annotated) throws JsonMappingException {
        Object object = serializerProvider.getAnnotationIntrospector().findSerializer(annotated);
        if (object == null) {
            return null;
        }
        return serializerProvider.serializerInstance(annotated, object);
    }

    @Deprecated
    protected final JsonSerializer<?> buildContainerSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, BeanProperty beanProperty, boolean bl) throws JsonMappingException {
        return this.buildContainerSerializer(serializerProvider, javaType, beanDescription, bl);
    }

    protected JsonSerializer<?> buildContainerSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        JavaType javaType2;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType2 = javaType.getContentType());
        if (typeSerializer != null) {
            bl = false;
        }
        JsonSerializer<Object> jsonSerializer = this._findContentSerializer(serializerProvider, beanDescription.getClassInfo());
        if (javaType.isMapLikeType()) {
            MapLikeType mapLikeType = (MapLikeType)javaType;
            JsonSerializer<Object> jsonSerializer2 = this._findKeySerializer(serializerProvider, beanDescription.getClassInfo());
            if (mapLikeType.isTrueMapType()) {
                return this.buildMapSerializer(serializationConfig, (MapType)mapLikeType, beanDescription, bl, jsonSerializer2, typeSerializer, jsonSerializer);
            }
            for (Serializers serializers : this.customSerializers()) {
                JsonSerializer<?> jsonSerializer3 = serializers.findMapLikeSerializer(serializationConfig, (MapLikeType)javaType, beanDescription, jsonSerializer2, typeSerializer, jsonSerializer);
                if (jsonSerializer3 == null) continue;
                return jsonSerializer3;
            }
            return null;
        }
        if (javaType.isCollectionLikeType()) {
            CollectionLikeType collectionLikeType = (CollectionLikeType)javaType;
            if (collectionLikeType.isTrueCollectionType()) {
                CollectionType collectionType = (CollectionType)collectionLikeType;
                for (Serializers serializers : this.customSerializers()) {
                    JsonSerializer<?> jsonSerializer4 = serializers.findCollectionSerializer(serializationConfig, collectionType, beanDescription, typeSerializer, jsonSerializer);
                    if (jsonSerializer4 == null) continue;
                    return jsonSerializer4;
                }
                JsonFormat.Value value = beanDescription.findExpectedFormat(null);
                if (value == null || value.getShape() != JsonFormat.Shape.OBJECT) {
                    return this.buildCollectionSerializer(serializationConfig, collectionType, beanDescription, bl, typeSerializer, jsonSerializer);
                }
            } else {
                for (Serializers serializers : this.customSerializers()) {
                    JsonSerializer<?> jsonSerializer5 = serializers.findCollectionLikeSerializer(serializationConfig, (CollectionLikeType)javaType, beanDescription, typeSerializer, jsonSerializer);
                    if (jsonSerializer5 == null) continue;
                    return jsonSerializer5;
                }
                return null;
            }
        }
        if (javaType.isArrayType()) {
            return this.buildArraySerializer(serializationConfig, (ArrayType)javaType, beanDescription, bl, typeSerializer, jsonSerializer);
        }
        return null;
    }

    @Deprecated
    protected final JsonSerializer<?> buildCollectionSerializer(SerializationConfig serializationConfig, CollectionType collectionType, BeanDescription beanDescription, BeanProperty beanProperty, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) throws JsonMappingException {
        return this.buildCollectionSerializer(serializationConfig, collectionType, beanDescription, bl, typeSerializer, jsonSerializer);
    }

    protected JsonSerializer<?> buildCollectionSerializer(SerializationConfig serializationConfig, CollectionType collectionType, BeanDescription beanDescription, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) throws JsonMappingException {
        Class<?> clazz = collectionType.getRawClass();
        if (EnumSet.class.isAssignableFrom(clazz)) {
            JavaType javaType = collectionType.getContentType();
            if (!javaType.isEnumType()) {
                javaType = null;
            }
            return StdContainerSerializers.enumSetSerializer(javaType);
        }
        Class<?> clazz2 = collectionType.getContentType().getRawClass();
        if (this.isIndexedList(clazz)) {
            if (clazz2 == String.class && (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer))) {
                return IndexedStringListSerializer.instance;
            }
            return StdContainerSerializers.indexedListSerializer(collectionType.getContentType(), bl, typeSerializer, jsonSerializer);
        }
        if (clazz2 == String.class && (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer))) {
            return StringCollectionSerializer.instance;
        }
        return StdContainerSerializers.collectionSerializer(collectionType.getContentType(), bl, typeSerializer, jsonSerializer);
    }

    protected boolean isIndexedList(Class<?> clazz) {
        return RandomAccess.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - void declaration
     */
    protected JsonSerializer<?> buildMapSerializer(SerializationConfig serializationConfig, MapType mapType, BeanDescription beanDescription, boolean bl, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) throws JsonMappingException {
        JsonSerializer<?> jsonSerializer3;
        for (Serializers object : this.customSerializers()) {
            jsonSerializer3 = object.findMapSerializer(serializationConfig, mapType, beanDescription, jsonSerializer, typeSerializer, jsonSerializer2);
            if (jsonSerializer3 == null) continue;
            return jsonSerializer3;
        }
        if (EnumMap.class.isAssignableFrom(mapType.getRawClass())) {
            void var9_12;
            JavaType javaType = mapType.getKeyType();
            Object var9_10 = null;
            if (javaType.isEnumType()) {
                jsonSerializer3 = javaType.getRawClass();
                EnumValues enumValues = EnumValues.construct(jsonSerializer3, serializationConfig.getAnnotationIntrospector());
            }
            return new EnumMapSerializer(mapType.getContentType(), bl, (EnumValues)var9_12, typeSerializer, jsonSerializer2);
        }
        return MapSerializer.construct(serializationConfig.getAnnotationIntrospector().findPropertiesToIgnore(beanDescription.getClassInfo()), mapType, bl, typeSerializer, jsonSerializer, jsonSerializer2);
    }

    protected JsonSerializer<?> buildArraySerializer(SerializationConfig serializationConfig, ArrayType arrayType, BeanDescription beanDescription, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) throws JsonMappingException {
        for (Serializers jsonSerializer2 : this.customSerializers()) {
            JsonSerializer<?> jsonSerializer3 = jsonSerializer2.findArraySerializer(serializationConfig, arrayType, beanDescription, typeSerializer, jsonSerializer);
            if (jsonSerializer3 == null) continue;
            return jsonSerializer3;
        }
        Class<?> clazz = arrayType.getRawClass();
        if (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer)) {
            if (String[].class == clazz) {
                return StringArraySerializer.instance;
            }
            JsonSerializer<?> jsonSerializer4 = StdArraySerializers.findStandardImpl(clazz);
            if (jsonSerializer4 != null) {
                return jsonSerializer4;
            }
        }
        return new ObjectArraySerializer(arrayType.getContentType(), bl, typeSerializer, jsonSerializer);
    }

    protected JsonSerializer<?> buildIteratorSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        JavaType javaType2 = javaType.containedType(0);
        if (javaType2 == null) {
            javaType2 = TypeFactory.unknownType();
        }
        TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType2);
        return StdContainerSerializers.iteratorSerializer(javaType2, this.usesStaticTyping(serializationConfig, beanDescription, typeSerializer), typeSerializer);
    }

    protected JsonSerializer<?> buildIterableSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        JavaType javaType2 = javaType.containedType(0);
        if (javaType2 == null) {
            javaType2 = TypeFactory.unknownType();
        }
        TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType2);
        return StdContainerSerializers.iterableSerializer(javaType2, this.usesStaticTyping(serializationConfig, beanDescription, typeSerializer), typeSerializer);
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(SerializationConfig serializationConfig, Annotated annotated, T object) {
        Class<?> clazz = serializationConfig.getAnnotationIntrospector().findSerializationType(annotated);
        if (clazz != null) {
            try {
                object = object.widenBy(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Failed to widen type " + object + " with concrete-type annotation (value " + clazz.getName() + "), method '" + annotated.getName() + "': " + illegalArgumentException.getMessage());
            }
        }
        return BasicSerializerFactory.modifySecondaryTypesByAnnotation(serializationConfig, annotated, object);
    }

    protected static <T extends JavaType> T modifySecondaryTypesByAnnotation(SerializationConfig serializationConfig, Annotated annotated, T object) {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        if (((JavaType)object).isContainerType()) {
            Class<?> clazz;
            Class<?> clazz2 = annotationIntrospector.findSerializationKeyType(annotated, ((JavaType)object).getKeyType());
            if (clazz2 != null) {
                if (!(object instanceof MapType)) {
                    throw new IllegalArgumentException("Illegal key-type annotation: type " + object + " is not a Map type");
                }
                try {
                    object = ((MapType)object).widenKey(clazz2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Failed to narrow key type " + object + " with key-type annotation (" + clazz2.getName() + "): " + illegalArgumentException.getMessage());
                }
            }
            if ((clazz = annotationIntrospector.findSerializationContentType(annotated, ((JavaType)object).getContentType())) != null) {
                try {
                    object = ((JavaType)object).widenContentsBy(clazz);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Failed to narrow content type " + object + " with content-type annotation (" + clazz.getName() + "): " + illegalArgumentException.getMessage());
                }
            }
        }
        return (T)object;
    }

    protected JsonSerializer<Object> _findKeySerializer(SerializerProvider serializerProvider, Annotated annotated) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        Object object = annotationIntrospector.findKeySerializer(annotated);
        if (object != null) {
            return serializerProvider.serializerInstance(annotated, object);
        }
        return null;
    }

    protected JsonSerializer<Object> _findContentSerializer(SerializerProvider serializerProvider, Annotated annotated) throws JsonMappingException {
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        Object object = annotationIntrospector.findContentSerializer(annotated);
        if (object != null) {
            return serializerProvider.serializerInstance(annotated, object);
        }
        return null;
    }

    @Deprecated
    protected final boolean usesStaticTyping(SerializationConfig serializationConfig, BeanDescription beanDescription, TypeSerializer typeSerializer, BeanProperty beanProperty) {
        return this.usesStaticTyping(serializationConfig, beanDescription, typeSerializer);
    }

    protected boolean usesStaticTyping(SerializationConfig serializationConfig, BeanDescription beanDescription, TypeSerializer typeSerializer) {
        if (typeSerializer != null) {
            return false;
        }
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        JsonSerialize.Typing typing = annotationIntrospector.findSerializationTyping(beanDescription.getClassInfo());
        return typing != null ? typing == JsonSerialize.Typing.STATIC : serializationConfig.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    protected Class<?> _verifyAsClass(Object object, String string, Class<?> clazz) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + string + "() returned value of type " + object.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class clazz2 = (Class)object;
        if (clazz2 == clazz || clazz2 == NoClass.class) {
            return null;
        }
        return clazz2;
    }

    static {
        _concrete.put(String.class.getName(), new StringSerializer());
        ToStringSerializer toStringSerializer = ToStringSerializer.instance;
        _concrete.put(StringBuffer.class.getName(), toStringSerializer);
        _concrete.put(StringBuilder.class.getName(), toStringSerializer);
        _concrete.put(Character.class.getName(), toStringSerializer);
        _concrete.put(Character.TYPE.getName(), toStringSerializer);
        NumberSerializers.addAll(_concrete);
        _concrete.put(Boolean.TYPE.getName(), new BooleanSerializer(true));
        _concrete.put(Boolean.class.getName(), new BooleanSerializer(false));
        NumberSerializers.NumberSerializer numberSerializer = new NumberSerializers.NumberSerializer();
        _concrete.put(BigInteger.class.getName(), numberSerializer);
        _concrete.put(BigDecimal.class.getName(), numberSerializer);
        _concrete.put(Calendar.class.getName(), CalendarSerializer.instance);
        DateSerializer dateSerializer = DateSerializer.instance;
        _concrete.put(java.util.Date.class.getName(), dateSerializer);
        _concrete.put(Timestamp.class.getName(), dateSerializer);
        _concrete.put(Date.class.getName(), new SqlDateSerializer());
        _concrete.put(Time.class.getName(), new SqlTimeSerializer());
        for (Map.Entry<Class<?>, Object> entry : new StdJdkSerializers().provide()) {
            Object object = entry.getValue();
            if (object instanceof JsonSerializer) {
                _concrete.put(entry.getKey().getName(), (JsonSerializer)object);
                continue;
            }
            if (object instanceof Class) {
                Class clazz = (Class)object;
                _concreteLazy.put(entry.getKey().getName(), clazz);
                continue;
            }
            throw new IllegalStateException("Internal error: unrecognized value of type " + entry.getClass().getName());
        }
        _concreteLazy.put(TokenBuffer.class.getName(), TokenBufferSerializer.class);
    }
}

