/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StaticListSerializerBase;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public final class IndexedStringListSerializer
extends StaticListSerializerBase<List<String>>
implements ContextualSerializer {
    public static final IndexedStringListSerializer instance = new IndexedStringListSerializer();
    protected final JsonSerializer<String> _serializer;

    protected IndexedStringListSerializer() {
        this((JsonSerializer<?>)null);
    }

    public IndexedStringListSerializer(JsonSerializer<?> jsonSerializer) {
        super(List.class);
        this._serializer = jsonSerializer;
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor jsonArrayFormatVisitor) {
        jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        JsonSerializer<Object> jsonSerializer = null;
        if (beanProperty != null && (annotatedMember = beanProperty.getMember()) != null && (object = serializerProvider.getAnnotationIntrospector().findContentSerializer(annotatedMember)) != null) {
            jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._serializer;
        }
        if (jsonSerializer == null) {
            jsonSerializer = serializerProvider.findValueSerializer(String.class, beanProperty);
        } else if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(serializerProvider, beanProperty);
        }
        if (this.isDefaultSerializer(jsonSerializer)) {
            jsonSerializer = null;
        }
        if (jsonSerializer == this._serializer) {
            return this;
        }
        return new IndexedStringListSerializer(jsonSerializer);
    }

    @Override
    public void serialize(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeStartArray();
        if (this._serializer == null) {
            this.serializeContents(list, jsonGenerator, serializerProvider);
        } else {
            this.serializeUsingCustom(list, jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeWithType(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForArray(list, jsonGenerator);
        if (this._serializer == null) {
            this.serializeContents(list, jsonGenerator, serializerProvider);
        } else {
            this.serializeUsingCustom(list, jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffixForArray(list, jsonGenerator);
    }

    private final void serializeContents(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n;
        try {
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                String string = list.get(n);
                if (string == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                jsonGenerator.writeString(string);
            }
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, list, n);
        }
    }

    private final void serializeUsingCustom(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n = 0;
        try {
            int n2 = list.size();
            JsonSerializer<String> jsonSerializer = this._serializer;
            for (n = 0; n < n2; ++n) {
                String string = list.get(n);
                if (string == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                jsonSerializer.serialize(string, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, list, n);
        }
    }
}

