/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBase;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapLikeType
extends TypeBase {
    private static final long serialVersionUID = -4720638149668688793L;
    protected final JavaType _keyType;
    protected final JavaType _valueType;

    protected MapLikeType(Class<?> clazz, JavaType javaType, JavaType javaType2, Object object, Object object2) {
        super(clazz, javaType.hashCode() ^ javaType2.hashCode(), object, object2);
        this._keyType = javaType;
        this._valueType = javaType2;
    }

    public static MapLikeType construct(Class<?> clazz, JavaType javaType, JavaType javaType2) {
        return new MapLikeType(clazz, javaType, javaType2, null, null);
    }

    @Override
    protected JavaType _narrow(Class<?> clazz) {
        return new MapLikeType(clazz, this._keyType, this._valueType, this._valueHandler, this._typeHandler);
    }

    @Override
    public JavaType narrowContentsBy(Class<?> clazz) {
        if (clazz == this._valueType.getRawClass()) {
            return this;
        }
        return new MapLikeType(this._class, this._keyType, this._valueType.narrowBy(clazz), this._valueHandler, this._typeHandler);
    }

    @Override
    public JavaType widenContentsBy(Class<?> clazz) {
        if (clazz == this._valueType.getRawClass()) {
            return this;
        }
        return new MapLikeType(this._class, this._keyType, this._valueType.widenBy(clazz), this._valueHandler, this._typeHandler);
    }

    public JavaType narrowKey(Class<?> clazz) {
        if (clazz == this._keyType.getRawClass()) {
            return this;
        }
        return new MapLikeType(this._class, this._keyType.narrowBy(clazz), this._valueType, this._valueHandler, this._typeHandler);
    }

    public JavaType widenKey(Class<?> clazz) {
        if (clazz == this._keyType.getRawClass()) {
            return this;
        }
        return new MapLikeType(this._class, this._keyType.widenBy(clazz), this._valueType, this._valueHandler, this._typeHandler);
    }

    @Override
    public MapLikeType withTypeHandler(Object object) {
        return new MapLikeType(this._class, this._keyType, this._valueType, this._valueHandler, object);
    }

    @Override
    public MapLikeType withContentTypeHandler(Object object) {
        return new MapLikeType(this._class, this._keyType, this._valueType.withTypeHandler(object), this._valueHandler, this._typeHandler);
    }

    @Override
    public MapLikeType withValueHandler(Object object) {
        return new MapLikeType(this._class, this._keyType, this._valueType, object, this._typeHandler);
    }

    @Override
    public MapLikeType withContentValueHandler(Object object) {
        return new MapLikeType(this._class, this._keyType, this._valueType.withValueHandler(object), this._valueHandler, this._typeHandler);
    }

    @Override
    protected String buildCanonicalName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._class.getName());
        if (this._keyType != null) {
            stringBuilder.append('<');
            stringBuilder.append(this._keyType.toCanonical());
            stringBuilder.append(',');
            stringBuilder.append(this._valueType.toCanonical());
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    @Override
    public boolean isMapLikeType() {
        return true;
    }

    @Override
    public JavaType getKeyType() {
        return this._keyType;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public int containedTypeCount() {
        return 2;
    }

    @Override
    public JavaType containedType(int n) {
        if (n == 0) {
            return this._keyType;
        }
        if (n == 1) {
            return this._valueType;
        }
        return null;
    }

    @Override
    public String containedTypeName(int n) {
        if (n == 0) {
            return "K";
        }
        if (n == 1) {
            return "V";
        }
        return null;
    }

    @Override
    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        return MapLikeType._classSignature(this._class, stringBuilder, true);
    }

    @Override
    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        MapLikeType._classSignature(this._class, stringBuilder, false);
        stringBuilder.append('<');
        this._keyType.getGenericSignature(stringBuilder);
        this._valueType.getGenericSignature(stringBuilder);
        stringBuilder.append(">;");
        return stringBuilder;
    }

    public MapLikeType withKeyTypeHandler(Object object) {
        return new MapLikeType(this._class, this._keyType.withTypeHandler(object), this._valueType, this._valueHandler, this._typeHandler);
    }

    public MapLikeType withKeyValueHandler(Object object) {
        return new MapLikeType(this._class, this._keyType.withValueHandler(object), this._valueType, this._valueHandler, this._typeHandler);
    }

    public boolean isTrueMapType() {
        return Map.class.isAssignableFrom(this._class);
    }

    @Override
    public String toString() {
        return "[map-like type; class " + this._class.getName() + ", " + this._keyType + " -> " + this._valueType + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        MapLikeType mapLikeType = (MapLikeType)object;
        return this._class == mapLikeType._class && this._keyType.equals(mapLikeType._keyType) && this._valueType.equals(mapLikeType._valueType);
    }
}

