/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.modules;

import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.ConstructorInfo;
import org.apache.commons.modeler.FeatureInfo;
import org.apache.commons.modeler.FieldInfo;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.NotificationInfo;
import org.apache.commons.modeler.OperationInfo;
import org.apache.commons.modeler.ParameterInfo;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.ModelerSource;
import org.apache.commons.modeler.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MbeansDescriptorsDOMSource
extends ModelerSource {
    Registry registry;
    String location;
    String type;
    Object source;
    List mbeans = new ArrayList();

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public List loadDescriptors(Registry registry, String string, String string2, Object object) throws Exception {
        this.setRegistry(registry);
        this.setLocation(string);
        this.setType(string2);
        this.setSource(object);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        try {
            InputStream inputStream = (InputStream)this.source;
            long l = System.currentTimeMillis();
            Document document = DomUtil.readXml(inputStream);
            Element element = document.getDocumentElement();
            if (element == null) {
                WMSLoggerFactory.getLogger(MbeansDescriptorsDOMSource.class).error("No descriptors found");
                return;
            }
            Node node = null;
            node = "mbean".equals(element.getNodeName()) ? element : DomUtil.getChild((Node)element, "mbean");
            if (node == null) {
                WMSLoggerFactory.getLogger(MbeansDescriptorsDOMSource.class).error(" No mbean tags ");
                return;
            }
            Node node2 = node;
            while (node2 != null) {
                Serializable serializable;
                Node node3;
                Node node4;
                Node node5;
                Object object;
                Object object2;
                Node node6;
                ManagedBean managedBean = new ManagedBean();
                DomUtil.setAttributes(managedBean, node2);
                Node node7 = DomUtil.getChild(node2, "descriptor");
                if (node7 != null) {
                    node6 = DomUtil.getChild(node7, "field");
                    object2 = node6;
                    while (object2 != null) {
                        object = new FieldInfo();
                        DomUtil.setAttributes(object, (Node)object2);
                        managedBean.addField((FieldInfo)object);
                        object2 = DomUtil.getNext((Node)object2);
                    }
                }
                node6 = node5 = DomUtil.getChild(node2, "attribute");
                while (node6 != null) {
                    object2 = new AttributeInfo();
                    DomUtil.setAttributes(object2, node6);
                    object = DomUtil.getChild(node6, "descriptor");
                    if (object != null) {
                        node3 = node4 = DomUtil.getChild((Node)object, "field");
                        while (node3 != null) {
                            serializable = new FieldInfo();
                            DomUtil.setAttributes(serializable, node3);
                            ((FeatureInfo)object2).addField((FieldInfo)serializable);
                            node3 = DomUtil.getNext(node3);
                        }
                    }
                    managedBean.addAttribute((AttributeInfo)object2);
                    node6 = DomUtil.getNext(node6);
                }
                node6 = node5 = DomUtil.getChild(node2, "constructor");
                while (node6 != null) {
                    object2 = new ConstructorInfo();
                    DomUtil.setAttributes(object2, node6);
                    object = DomUtil.getChild(node6, "descriptor");
                    if (object != null) {
                        node3 = node4 = DomUtil.getChild((Node)object, "field");
                        while (node3 != null) {
                            serializable = new FieldInfo();
                            DomUtil.setAttributes(serializable, node3);
                            ((FeatureInfo)object2).addField((FieldInfo)serializable);
                            node3 = DomUtil.getNext(node3);
                        }
                    }
                    node3 = node4 = DomUtil.getChild(node6, "parameter");
                    while (node3 != null) {
                        serializable = new ParameterInfo();
                        DomUtil.setAttributes(serializable, node3);
                        ((ConstructorInfo)object2).addParameter((ParameterInfo)serializable);
                        node3 = DomUtil.getNext(node3);
                    }
                    managedBean.addConstructor((ConstructorInfo)object2);
                    node6 = DomUtil.getNext(node6);
                }
                node6 = node5 = DomUtil.getChild(node2, "notification");
                while (node6 != null) {
                    object2 = new NotificationInfo();
                    DomUtil.setAttributes(object2, node6);
                    object = DomUtil.getChild(node6, "descriptor");
                    if (object != null) {
                        node3 = node4 = DomUtil.getChild((Node)object, "field");
                        while (node3 != null) {
                            serializable = new FieldInfo();
                            DomUtil.setAttributes(serializable, node3);
                            ((FeatureInfo)object2).addField((FieldInfo)serializable);
                            node3 = DomUtil.getNext(node3);
                        }
                    }
                    node3 = node4 = DomUtil.getChild(node6, "notification-type");
                    while (node3 != null) {
                        ((NotificationInfo)object2).addNotifType(DomUtil.getContent(node3));
                        node3 = DomUtil.getNext(node3);
                    }
                    managedBean.addNotification((NotificationInfo)object2);
                    node6 = DomUtil.getNext(node6);
                }
                node6 = node5 = DomUtil.getChild(node2, "operation");
                while (node6 != null) {
                    object2 = new OperationInfo();
                    DomUtil.setAttributes(object2, node6);
                    object = DomUtil.getChild(node6, "descriptor");
                    if (object != null) {
                        node3 = node4 = DomUtil.getChild((Node)object, "field");
                        while (node3 != null) {
                            serializable = new FieldInfo();
                            DomUtil.setAttributes(serializable, node3);
                            ((FeatureInfo)object2).addField((FieldInfo)serializable);
                            node3 = DomUtil.getNext(node3);
                        }
                    }
                    node3 = node4 = DomUtil.getChild(node6, "parameter");
                    while (node3 != null) {
                        serializable = new ParameterInfo();
                        DomUtil.setAttributes(serializable, node3);
                        ((OperationInfo)object2).addParameter((ParameterInfo)serializable);
                        node3 = DomUtil.getNext(node3);
                    }
                    managedBean.addOperation((OperationInfo)object2);
                    node6 = DomUtil.getNext(node6);
                }
                this.mbeans.add(managedBean);
                node2 = DomUtil.getNext(node2);
            }
            long l2 = System.currentTimeMillis();
            WMSLoggerFactory.getLogger(MbeansDescriptorsDOMSource.class).debug("Reading descriptors ( dom ) " + (l2 - l));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MbeansDescriptorsDOMSource.class).error("Error reading descriptors ", (Throwable)exception);
        }
    }
}

