/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.util;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.JSON;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.speex.SpeexUtils;
import java.util.ArrayList;
import java.util.List;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTWriterContextTrackCodecConfig {
    private byte[] a = null;
    private byte[] b = null;
    private H264CodecConfigInfo c = null;
    private AACFrame d = null;
    private byte[] e = null;
    private List<String> f = new ArrayList<String>();
    private int g = -1;
    private int h = -1;
    private int i = 0;
    private int j = 2;
    private int k = 1;

    public void addDataType(String string) {
        this.f.add(string);
        this.k = this.f.size();
    }

    public List<String> getDataTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.f);
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPreFormatted() {
        if (this.e == null) return false;
        return true;
    }

    public byte[] getBytes() {
        return this.e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int a(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        do {
            if (n2 + 4 > byArray.length) {
                return n;
            }
            long l = BufferUtils.byteArrayToLong((byte[])byArray, (int)n2, (int)4);
            n2 = (int)((long)n2 + l);
            ++n;
        } while (n2 < byArray.length);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBytes(byte[] byArray) {
        this.e = byArray;
        if (byArray == null) {
            return;
        }
        this.k = this.a(byArray);
    }

    public H264CodecConfigInfo getH264CodecConfigInfo() {
        return this.c;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setH264CodecConfig(byte[] byArray) {
        this.a = byArray;
        this.c = byArray != null ? H264Utils.decodeAVCC((byte[])byArray) : null;
        if (this.c == null) return;
        this.h = this.c.width;
        this.g = this.c.height;
        WMSLoggerFactory.getLogger(QTWriterContextTrackCodecConfig.class).debug(Base64.indexOf((int)(59 * 7), (String)"LJHrhvfvFii|lr\u007fX\u007fol{R}wqvUxv\u007fs|2n{k\bstw\u0007*\"\"+\n%%*$)up") + this.c.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAACCodecConfig(byte[] byArray) {
        this.b = byArray;
        this.d = byArray != null ? AACUtils.decodeAACCodecConfig((byte[])byArray, (int)0) : null;
        if (this.d == null) return;
        this.j = this.d.getChannels();
        this.i = this.d.getSampleRate();
        WMSLoggerFactory.getLogger(QTWriterContextTrackCodecConfig.class).debug(JSON.split((String)"\u0018\u001e\u001c>$:*\"\u0012== 0.#\f+;87\u001e1;%\"\u0001,*#/ f:/?\r\f\r\f?570\u0017:811>`{", (int)(51 * 19)) + this.d.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractAudioDataFromMP3Frame(byte[] byArray) {
        try {
            MP3HeaderData mP3HeaderData = new MP3HeaderData();
            int n = MP3BufferedDecoder.syncHeader((byte)0, (byte[])byArray, (MP3HeaderData)mP3HeaderData);
            if (n == 0) return;
            MP3BufferedDecoder.decodeHeader((int)n, (int)0, (MP3HeaderData)mP3HeaderData);
            this.j = mP3HeaderData.h_mode == 3 ? 1 : 2;
            this.i = MP3BufferedDecoder.frequency((MP3HeaderData)mP3HeaderData);
            WMSLoggerFactory.getLogger(QTWriterContextTrackCodecConfig.class).debug(Base64.indexOf((int)(5 * 59), (String)"V\\^xbxh|L\u007f\u007ffvlaBeyzqXsy{|\u0003.,%-\"h\"0=8*/9\u000f:48=\u00175!7\u0011*67\u0016\fn\u0018-!,'yd$3#!&\t#-# *<\u0012=&:!l") + this.j + Base64.indexOf((int)(61 * 51), (String)"'i|nbc^ob`}wAuas-") + this.i);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterContextTrackCodecConfig.class).error(JSON.split((String)"\u0004\u0002\u0000*0.>.\u001e114$:7\u00107'$#\n%/).\r >7;4z0.#*89/\u001d(:6oEcweCtheDZ8J\u007fobu+2", (int)(9 + 76)) + exception.toString());
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void extractAudioDataFromSpeexFrame(byte[] byArray) {
        try {
            if (SpeexUtils.validatePacket((byte[])byArray, (int)0, (int)byArray.length)) {
                this.j = 1;
                this.i = 16000;
                WMSLoggerFactory.getLogger(QTWriterContextTrackCodecConfig.class).debug(Base64.indexOf((int)(27 * 43), (String)"X^\\~dzjbR}}`pncLk{xw^q{ebAljco`&lr\u007f~lm{Qdvz{Qwcy_htqNnz%9\u00041%(#}h(?/%\"\r'1?<68\u00169\"6-`") + this.j + Base64.indexOf((int)(28 + 40), (String)"d$3#!&\u0019*!=\"*\u00020&6n") + this.i);
            }
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterContextTrackCodecConfig.class).error(JSON.split((String)"MIImiugqGjhsmq~_~lmdS~vvwVyy~p}5yejm!\"6\u00021!/(\f(>*\n?!\"\u0003!76,\u0013$65<`{", (int)(26 - -2)) + exception.toString());
            exception.printStackTrace();
            return;
        }
    }

    public byte[] getH264CodecConfig() {
        return this.a;
    }

    public byte[] getAACCodecConfig() {
        return this.b;
    }

    public int getVideoHeight() {
        return this.g;
    }

    public void setVideoHeight(int n) {
        this.g = n;
    }

    public int getVideoWidth() {
        return this.h;
    }

    public void setVideoWidth(int n) {
        this.h = n;
    }

    public int getAudioSampleRate() {
        return this.i;
    }

    public void setAudioSampleRate(int n) {
        this.i = n;
    }

    public int getAudioChannelCount() {
        return this.j;
    }

    public void setAudioChannelCount(int n) {
        this.j = n;
    }

    public int getItemCount() {
        return this.k;
    }

    public void setItemCount(int n) {
        this.k = n;
    }
}

