/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.h264.util;

import com.wowza.util.Base64;
import com.wowza.util.JSON;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediawriter.h264.codecconfig.QTWriterTrackCodecConfig;
import com.wowza.wms.mediawriter.h264.codecconfig.QTWriterTrackCodecConfigVideo;
import com.wowza.wms.mediawriter.h264.util.QTWriterContext;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackCTTS;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTCO;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSC;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSS;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTSZ;
import com.wowza.wms.mediawriter.h264.util.QTWriterContextTrackSTTS;
import com.wowza.wms.mediawriter.h264.util.QTWriterTmpItem;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QTWriterContextTrack {
    public static final int TRACK_UNKNOWN = -1;
    public static final int TRACK_VIDEO = 0;
    public static final int TRACK_AUDIO = 1;
    public static final int TRACK_DATA = 2;
    public static final int SAMPLE_UNKNOWN = -1;
    public static final int SAMPLE_H264 = 0;
    public static final int SAMPLE_AAC = 1;
    public static final int SAMPLE_MP3 = 2;
    public static final int SAMPLE_AMF0 = 3;
    public static final int SAMPLE_AMF3 = 4;
    public static final int SAMPLE_SPEEX = 5;
    public static final String DATATYPE_AMF0 = "amf0";
    public static final String DATATYPE_AMF3 = "amf3";
    private int a = -1;
    private int b = -1;
    private int c = -1;
    private int d = 0;
    private QTWriterContext e = null;
    private long f = 90000L;
    private long g = 0L;
    private long h = 0L;
    private long i = 0L;
    private long j = 0L;
    private long k = 0L;
    private long l = -1L;
    private long m = 0L;
    private long n = -1L;
    private List<PacketHolder> o = new ArrayList<PacketHolder>();
    private QTWriterTmpItem p = null;
    private long q = -1L;
    private long r = 0L;
    private long s = 0L;
    private QTWriterContextTrackCTTS t = null;
    private QTWriterContextTrackSTCO u = null;
    private QTWriterContextTrackSTSC v = null;
    private QTWriterContextTrackSTSS w = null;
    private QTWriterContextTrackSTSZ x = null;
    private QTWriterContextTrackSTTS y = null;
    private List<QTWriterTrackCodecConfig> z = new ArrayList<QTWriterTrackCodecConfig>();

    /*
     * Enabled aggressive block sorting
     */
    public QTWriterContextTrack(QTWriterContext qTWriterContext, int n) {
        this.e = qTWriterContext;
        this.c = n;
        switch (this.c) {
            case 1: {
                this.d = 1;
                break;
            }
            case 0: {
                this.d = 0;
                break;
            }
            case 2: {
                this.d = 3;
                break;
            }
        }
        this.t = new QTWriterContextTrackCTTS(this);
        this.u = new QTWriterContextTrackSTCO(this);
        this.v = new QTWriterContextTrackSTSC(this);
        this.w = new QTWriterContextTrackSTSS(this);
        this.x = new QTWriterContextTrackSTSZ(this);
        this.y = new QTWriterContextTrackSTTS(this);
    }

    public int getCodecConfigCount() {
        int n = 0;
        Iterator<QTWriterTrackCodecConfig> iterator = this.z.iterator();
        while (iterator.hasNext()) {
            QTWriterTrackCodecConfig qTWriterTrackCodecConfig = iterator.next();
            n += qTWriterTrackCodecConfig.getItemCount();
        }
        return n;
    }

    public List<QTWriterTrackCodecConfig> getCodecConfigs() {
        ArrayList<QTWriterTrackCodecConfig> arrayList = new ArrayList<QTWriterTrackCodecConfig>();
        arrayList.addAll(this.z);
        return arrayList;
    }

    public void setCodecConfigs(List<QTWriterTrackCodecConfig> list) {
        this.z = list;
    }

    public void addCodecConfig(QTWriterTrackCodecConfig qTWriterTrackCodecConfig) {
        this.addCodecConfig(qTWriterTrackCodecConfig, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addCodecConfig(QTWriterTrackCodecConfig qTWriterTrackCodecConfig, boolean bl) {
        QTWriterTrackCodecConfig qTWriterTrackCodecConfig2;
        boolean bl2 = true;
        int n = this.z.size() - 1;
        if (n >= 0 && bl && (qTWriterTrackCodecConfig2 = this.z.get(n)).equals(qTWriterTrackCodecConfig)) {
            bl2 = false;
        }
        if (!bl2) return;
        this.z.add(qTWriterTrackCodecConfig);
    }

    public QTWriterContextTrackCTTS getCTTS() {
        return this.t;
    }

    public QTWriterContextTrackSTCO getSTCO() {
        return this.u;
    }

    public QTWriterContextTrackSTSC getSTSC() {
        return this.v;
    }

    public QTWriterContextTrackSTSS getSTSS() {
        return this.w;
    }

    public QTWriterContextTrackSTSZ getSTSZ() {
        return this.x;
    }

    public QTWriterContextTrackSTTS getSTTS() {
        return this.y;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isVideo() {
        if (this.c != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAudio() {
        if (this.c != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isData() {
        if (this.c != 2) return false;
        return true;
    }

    public int getTrackType() {
        return this.c;
    }

    public void setTrackType(int n) {
        this.c = n;
    }

    public QTWriterContext getContext() {
        return this.e;
    }

    public void setContext(QTWriterContext qTWriterContext) {
        this.e = qTWriterContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getOnTimeCoordInfoPacket(double d) {
        byte[] byArray = null;
        try {
            AMFDataObj aMFDataObj = new AMFDataObj();
            aMFDataObj.put(Base64.lastIndexOf((int)(55 * 11), (String)".*-% /n%'5($<>."), (AMFData)new AMFDataItem(d));
            AMFDataList aMFDataList = new AMFDataList();
            aMFDataList.add((AMFData)new AMFDataItem(Base64.lastIndexOf((int)(-22 - -60), (String)"ii\\`gnOba}tX|u{")));
            aMFDataList.add((AMFData)aMFDataObj);
            return aMFDataList.serialize(0);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(QTWriterContextTrack.class).error(JSON.endsWith((String)"JHJlvtdp@kkrbp}^ymne!wtf\\zA\u007fz}ZutnyWq&.\u0012\"'.#3\u0013", (int)(31 * 5)) + this.e.getOutPath() + Base64.lastIndexOf((int)(-18 - -27), (String)"3}yeykR*1") + exception.toString());
            return byArray;
        }
    }

    public void addPacket(RandomAccessFile randomAccessFile, byte[] byArray, int n, int n2, boolean bl, long l) {
        this.addPacket(randomAccessFile, byArray, n, n2, bl, l, 0L);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addPacket(RandomAccessFile randomAccessFile, byte[] byArray, int n, int n2, boolean bl, long l, long l2) {
        this.o.add(new PacketHolder(byArray, n, n2));
        long l3 = l * this.e.getTimescale() / this.f;
        this.e.addPacket(randomAccessFile, n2, l3);
        if (bl) {
            this.w.addSyncSample(this.r + this.k + 1L);
        }
        this.x.addSize(n2);
        this.t.addOffset(l2);
        if (this.l != -1L) {
            this.n = l - this.l;
            this.y.addDuration(this.n);
        }
        this.m = this.l = l;
        ++this.k;
    }

    /*
     * Unable to fully structure code
     */
    public void flush(RandomAccessFile var1_1, boolean var2_2) {
        block15: {
            block12: {
                block13: {
                    block11: {
                        block14: {
                            if (this.o.size() <= 0) break block13;
                            break block14;
lbl3:
                            // 1 sources

                            while (this.n != -1L) {
                                break block11;
lbl5:
                                // 2 sources

                                return;
                            }
                            break block15;
lbl8:
                            // 1 sources

                            while (true) {
                                var3_3 = var1_1.getFilePointer();
lbl11:
                                // 2 sources

                                while (true) {
                                    this.u.addOffset(var3_3);
                                    this.v.addChunk(this.s + this.g + 1L, this.o.size(), this.z.size());
                                    var5_5 = this.o.iterator();
                                    break block12;
                                    break;
                                }
                                break;
                            }
                        }
                        var3_3 = 0L;
                        ** while (true)
                    }
                    this.y.addDuration(this.n);
                    this.m += this.n;
lbl22:
                    // 2 sources

                    while (true) {
                        this.t.flush();
                        this.u.flush();
                        this.v.flush();
                        this.w.flush();
                        this.x.flush();
                        this.y.flush();
                        ** GOTO lbl5
                        break;
                    }
lbl30:
                    // 1 sources

                    while (true) {
                        ++this.g;
                        this.o.clear();
                        break block13;
                        break;
                    }
lbl34:
                    // 1 sources

                    while (true) {
                        continue;
                        break;
                    }
                    catch (Exception var5_4) {
                        WMSLoggerFactory.getLogger(QTWriterContextTrack.class).error(Base64.lastIndexOf((int)(71 + -44), (String)"JHJlvtdp@kkrbp}^ymne!v}g`|N") + this.e.getOutPath() + Base64.lastIndexOf((int)(27 * 59), (String)"#}~h[ws%\u0011-**1#5\u0015sj") + var5_4.toString());
                        ** continue;
                    }
                    var6_6 = var5_5.next();
                    try {
                        var1_1.write(var6_6.buffer, var6_6.offset, var6_6.size);
                    }
                    catch (Exception var7_7) {
                        WMSLoggerFactory.getLogger(QTWriterContextTrack.class).error(JSON.endsWith((String)"\u0006\f\u000e(2(8,\u001coovf|qRuija%ja{|xJ", (int)(33 * 23)) + this.e.getOutPath() + JSON.endsWith((String)"|0: >.\u0011wn", (int)(98 + -28)) + var7_7.toString());
                    }
                }
                if (var2_2) ** break;
                ** while (true)
                ** GOTO lbl3
            }
            ** while (!var5_5.hasNext())
lbl51:
            // 1 sources

            ** while (true)
        }
        this.y.addDuration(0L);
        ** while (true)
    }

    public long getDuration() {
        long l = this.e.getAppendDuration();
        l = l * this.f / this.e.getTimescale();
        return l + this.m;
    }

    public long getDuration(long l) {
        return this.getDuration() * l / this.f;
    }

    public long getTimescale() {
        return this.f;
    }

    public void setTimescale(long l) {
        this.f = l;
    }

    public long millisToTimecode(long l) {
        return l * this.f / 1000L;
    }

    public long getTotalSampleCount() {
        return this.r + this.k;
    }

    public long getSampleCount() {
        return this.k;
    }

    public int getSampleType() {
        return this.d;
    }

    public void setSampleType(int n) {
        this.d = n;
    }

    public long getAudESDSBufferSize() {
        return this.h;
    }

    public void setAudESDSBufferSize(long l) {
        this.h = l;
    }

    public long getAudESDSMaxRate() {
        return this.i;
    }

    public void setAudESDSMaxRate(long l) {
        this.i = l;
    }

    public long getAudESDSAvgRate() {
        return this.j;
    }

    public void setAudESDSAvgRate(long l) {
        this.j = l;
    }

    public void setWidth(int n) {
        this.a = n;
    }

    public void setHeight(int n) {
        this.b = n;
    }

    /*
     * Unable to fully structure code
     */
    public int getWidth() {
        block6: {
            block4: {
                block3: {
                    block5: {
                        if (this.a < 0) break block4;
                        break block5;
lbl3:
                        // 1 sources

                        while (((QTWriterTrackCodecConfigVideo)var3_3).getVideoWidth() >= 0) {
                            break block3;
                        }
                        break block6;
                    }
                    return this.a;
                }
                var1_1 = ((QTWriterTrackCodecConfigVideo)var3_3).getVideoWidth();
lbl10:
                // 2 sources

                return var1_1;
            }
            var1_1 = 0;
            var2_2 = this.z.iterator();
            break block6;
lbl16:
            // 1 sources

            ** while (!((var3_3 = var2_2.next()) instanceof QTWriterTrackCodecConfigVideo))
lbl17:
            // 1 sources

            ** GOTO lbl3
        }
        ** while (!var2_2.hasNext())
lbl20:
        // 1 sources

        ** GOTO lbl16
    }

    /*
     * Unable to fully structure code
     */
    public int getHeight() {
        block5: {
            block7: {
                block6: {
                    if (this.b < 0) break block5;
                    break block6;
lbl3:
                    // 2 sources

                    return var1_1;
lbl5:
                    // 1 sources

                    while (true) {
                        var1_1 = ((QTWriterTrackCodecConfigVideo)var3_3).getVideoHeight();
                        ** GOTO lbl3
                        break;
                    }
                }
                return this.b;
lbl10:
                // 1 sources

                while (((QTWriterTrackCodecConfigVideo)var3_3).getVideoHeight() >= 0) {
                    ** continue;
lbl12:
                    // 1 sources

                    ** GOTO lbl5
                }
                break block7;
lbl14:
                // 1 sources

                ** while (!((var3_3 = var2_2.next()) instanceof QTWriterTrackCodecConfigVideo))
lbl15:
                // 1 sources

                ** GOTO lbl10
            }
lbl17:
            // 2 sources

            while (true) {
                if (var2_2.hasNext()) ** break;
                ** continue;
                ** GOTO lbl14
                break;
            }
        }
        var1_1 = 0;
        var2_2 = this.z.iterator();
        ** while (true)
    }

    public QTWriterTmpItem getTrakAtomTmpItem() {
        return this.p;
    }

    public void setTrakAtomTmpItem(QTWriterTmpItem qTWriterTmpItem) {
        this.p = qTWriterTmpItem;
    }

    public long getAppendDuration() {
        return this.q;
    }

    public void setAppendDuration(long l) {
        this.q = l;
    }

    public long getAppendSampleCount() {
        return this.r;
    }

    public void setAppendSampleCount(long l) {
        this.r = l;
    }

    public long getAppendChunkCount() {
        return this.s;
    }

    public void setAppendChunkCount(long l) {
        this.s = l;
    }

    class PacketHolder {
        public byte[] buffer = null;
        public int offset = 0;
        public int size = 0;

        public PacketHolder(byte[] byArray, int n, int n2) {
            this.buffer = byArray;
            this.offset = n;
            this.size = n2;
        }
    }
}

