/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.RegistryMBean;
import org.apache.commons.modeler.modules.ModelerSource;

public class Registry
implements RegistryMBean,
MBeanRegistration {
    public static String MODELER_MANIFEST = "/META-INF/mbeans-descriptors.xml";
    private static HashMap perLoaderRegistries = null;
    private static Registry registry = null;
    private MBeanServer server = null;
    private final HashMap descriptors = new HashMap();
    private final HashMap descriptorsByClass = new HashMap();
    private final Map searchedPaths = Collections.synchronizedMap(new HashMap());
    private Object guard;
    private Hashtable idDomains = new Hashtable();
    private Hashtable ids = new Hashtable();

    public static synchronized Registry getRegistry(Object object, Object object2) {
        if (perLoaderRegistries != null) {
            if (object == null) {
                object = Thread.currentThread().getContextClassLoader();
            }
            if (object != null) {
                Registry registry = (Registry)perLoaderRegistries.get(object);
                if (registry == null) {
                    registry = new Registry();
                    registry.guard = object2;
                    perLoaderRegistries.put(object, registry);
                    return registry;
                }
                if (registry.guard != null && registry.guard != object2) {
                    return null;
                }
                return registry;
            }
        }
        if (registry == null) {
            registry = new Registry();
        }
        if (Registry.registry.guard != null && Registry.registry.guard != object2) {
            return null;
        }
        return registry;
    }

    public static void setUseContextClassLoader(boolean bl) {
        if (bl) {
            perLoaderRegistries = new HashMap();
        }
    }

    public void setGuard(Object object) {
        if (this.guard != null) {
            return;
        }
        this.guard = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashMap hashMap = this.descriptors;
        synchronized (hashMap) {
            this.descriptorsByClass.clear();
            this.descriptors.clear();
            this.searchedPaths.clear();
        }
    }

    public List loadMBeans(Object object, ClassLoader classLoader) throws Exception {
        return this.load("MbeansSource", object, null);
    }

    public void loadMetadata(Object object) throws Exception {
        if (object instanceof ClassLoader) {
            this.loadMetaInfDescriptors((ClassLoader)object);
        } else {
            this.loadDescriptors(null, object, null);
        }
    }

    public void registerComponent(Object object, String string, String string2) throws Exception {
        this.registerComponent(object, new ObjectName(string), string2);
    }

    public void unregisterComponent(String string) {
        try {
            this.unregisterComponent(new ObjectName(string));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            WMSLoggerFactory.getLogger(Registry.class).info("Error creating object name " + malformedObjectNameException);
        }
    }

    public void invoke(List list, String string, boolean bl) throws Exception {
        if (list == null) {
            return;
        }
        for (Object e : list) {
            ObjectName objectName = null;
            try {
                if (e instanceof ObjectName) {
                    objectName = (ObjectName)e;
                }
                if (e instanceof String) {
                    objectName = new ObjectName((String)e);
                }
                if (objectName == null || this.getMethodInfo(objectName, string) == null) continue;
                this.getMBeanServer().invoke(objectName, string, new Object[0], new String[0]);
            }
            catch (Exception exception) {
                if (bl) {
                    throw exception;
                }
                WMSLoggerFactory.getLogger(Registry.class).info("Error initializing " + e + " " + exception.toString());
            }
        }
    }

    public synchronized int getId(String string, String string2) {
        Integer n;
        Hashtable<String, Integer> hashtable;
        if (string == null) {
            string = "";
        }
        if ((hashtable = (Hashtable<String, Integer>)this.idDomains.get(string)) == null) {
            hashtable = new Hashtable<String, Integer>();
            this.idDomains.put(string, hashtable);
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((n = (Integer)hashtable.get(string2)) != null) {
            return n;
        }
        int[] nArray = (int[])this.ids.get(string);
        if (nArray == null) {
            nArray = new int[1];
            this.ids.put(string, nArray);
        }
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        int n3 = n2;
        hashtable.put(string2, new Integer(n3));
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedBean(ManagedBean managedBean) {
        HashMap hashMap = this.descriptors;
        synchronized (hashMap) {
            this.descriptors.put(managedBean.getName(), managedBean);
            if (managedBean.getType() != null) {
                this.descriptorsByClass.put(managedBean.getType(), managedBean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedBean findManagedBean(String string) {
        HashMap hashMap = this.descriptors;
        synchronized (hashMap) {
            ManagedBean managedBean = (ManagedBean)this.descriptors.get(string);
            if (managedBean == null) {
                managedBean = (ManagedBean)this.descriptorsByClass.get(string);
            }
            return managedBean;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findManagedBeans() {
        HashMap hashMap = this.descriptors;
        synchronized (hashMap) {
            return this.descriptors.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findManagedBeans(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.descriptors;
        synchronized (this.descriptors) {
            for (ManagedBean managedBean : this.descriptors.values()) {
                if (string == null) {
                    if (managedBean.getGroup() != null) continue;
                    arrayList.add(managedBean.getName());
                    continue;
                }
                if (!string.equals(managedBean.getGroup())) continue;
                arrayList.add(managedBean.getName());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            stringArray = new String[arrayList.size()];
            return arrayList.toArray(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedBean(ManagedBean managedBean) {
        HashMap hashMap = this.descriptors;
        synchronized (hashMap) {
            this.descriptors.remove(managedBean.getName());
            this.descriptorsByClass.remove(managedBean.getType());
        }
    }

    public static MBeanServer getServer() {
        return Registry.getRegistry().getMBeanServer();
    }

    public static void setServer(MBeanServer mBeanServer) {
        Registry.getRegistry().setMBeanServer(mBeanServer);
    }

    public static void loadRegistry(InputStream inputStream) throws Exception {
        Registry registry = Registry.getRegistry();
        registry.loadMetadata(inputStream);
    }

    public static synchronized Registry getRegistry() {
        return Registry.getRegistry(null, null);
    }

    public String getType(ObjectName objectName, String string) {
        MBeanInfo mBeanInfo;
        String string2 = null;
        try {
            mBeanInfo = this.server.getMBeanInfo(objectName);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Registry.class).info("Can't find metadata for object" + objectName);
            return null;
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            if (!string.equals(mBeanAttributeInfoArray[i].getName())) continue;
            string2 = mBeanAttributeInfoArray[i].getType();
            return string2;
        }
        return null;
    }

    public MBeanOperationInfo getMethodInfo(ObjectName objectName, String string) {
        MBeanInfo mBeanInfo;
        Object var3_3 = null;
        try {
            mBeanInfo = this.server.getMBeanInfo(objectName);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Registry.class).info("Can't find metadata " + objectName);
            return null;
        }
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            if (!string.equals(mBeanOperationInfoArray[i].getName())) continue;
            return mBeanOperationInfoArray[i];
        }
        return null;
    }

    public void unregisterComponent(ObjectName objectName) {
        try {
            if (this.getMBeanServer().isRegistered(objectName)) {
                this.getMBeanServer().unregisterMBean(objectName);
            }
        }
        catch (Throwable throwable) {
            WMSLoggerFactory.getLogger(Registry.class).error("Error unregistering mbean ", throwable);
        }
    }

    public synchronized MBeanServer getMBeanServer() {
        long l = System.currentTimeMillis();
        if (this.server == null) {
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(Registry.class);
            if (MBeanServerFactory.findMBeanServer(null).size() > 0) {
                this.server = MBeanServerFactory.findMBeanServer(null).get(0);
                if (wMSLogger.isDebugEnabled()) {
                    wMSLogger.debug("Using existing MBeanServer " + (System.currentTimeMillis() - l));
                }
            } else {
                this.server = MBeanServerFactory.createMBeanServer();
                if (wMSLogger.isDebugEnabled()) {
                    wMSLogger.debug("Creating MBeanServer" + (System.currentTimeMillis() - l));
                }
            }
        }
        return this.server;
    }

    public ManagedBean findManagedBean(Object object, Class clazz, String string) throws Exception {
        if (object != null && clazz == null) {
            clazz = object.getClass();
        }
        if (string == null) {
            string = clazz.getName();
        }
        ManagedBean managedBean = this.findManagedBean(string);
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(Registry.class);
        if (managedBean == null) {
            this.findDescriptor(clazz, string);
            managedBean = this.findManagedBean(string);
        }
        if (object instanceof DynamicMBean) {
            this.loadDescriptors("MbeansDescriptorsDynamicMBeanSource", object, string);
            managedBean = this.findManagedBean(string);
        }
        if (managedBean == null) {
            this.loadDescriptors("MbeansDescriptorsIntrospectionSource", clazz, string);
            managedBean = this.findManagedBean(string);
            if (managedBean == null) {
                wMSLogger.warn("No metadata found for " + string);
                return null;
            }
            managedBean.setName(string);
            this.addManagedBean(managedBean);
        }
        return managedBean;
    }

    public Object convertValue(String string, String string2) {
        Object object = string2;
        if (string == null || "java.lang.String".equals(string)) {
            object = string2;
        } else if ("javax.management.ObjectName".equals(string) || "ObjectName".equals(string)) {
            try {
                object = new ObjectName(string2);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                return null;
            }
        } else if ("java.lang.Integer".equals(string) || "int".equals(string)) {
            object = new Integer(string2);
        } else if ("java.lang.Long".equals(string) || "long".equals(string)) {
            object = new Long(string2);
        } else if ("java.lang.Boolean".equals(string) || "boolean".equals(string)) {
            object = Boolean.valueOf(string2);
        }
        return object;
    }

    public List load(String string, Object object, String string2) throws Exception {
        Object object2;
        String string3 = null;
        String string4 = null;
        Object object3 = null;
        if (object instanceof DynamicMBean) {
            string = "MbeansDescriptorsDynamicMBeanSource";
            object3 = object;
        } else if (object instanceof URL) {
            object2 = (URL)object;
            string3 = ((URL)object2).toString();
            string4 = string2;
            object3 = ((URL)object2).openStream();
            if (string == null) {
                string = this.sourceTypeFromExt(string3);
            }
        } else if (object instanceof File) {
            string3 = ((File)object).getAbsolutePath();
            object3 = new FileInputStream((File)object);
            string4 = string2;
            if (string == null) {
                string = this.sourceTypeFromExt(string3);
            }
        } else if (object instanceof InputStream) {
            string4 = string2;
            object3 = object;
        } else if (object instanceof Class) {
            string3 = ((Class)object).getName();
            string4 = string2;
            object3 = object;
            if (string == null) {
                string = "MbeansDescriptorsIntrospectionSource";
            }
        }
        if (string == null) {
            string = "MbeansDescriptorsDOMSource";
        }
        object2 = this.getModelerSource(string);
        List list = ((ModelerSource)object2).loadDescriptors(this, string3, string4, object3);
        return list;
    }

    private String sourceTypeFromExt(String string) {
        if (string.endsWith(".ser")) {
            return "MbeansDescriptorsSerSource";
        }
        if (string.endsWith(".xml")) {
            return "MbeansDescriptorsDOMSource";
        }
        return null;
    }

    public void registerComponent(Object object, ObjectName objectName, String string) throws Exception {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(Registry.class);
        if (object == null) {
            wMSLogger.error("Null component " + objectName);
            return;
        }
        try {
            if (string == null) {
                string = object.getClass().getName();
            }
            ManagedBean managedBean = this.findManagedBean(object.getClass(), string);
            ModelMBean modelMBean = managedBean.createMBean(object);
            if (this.getMBeanServer().isRegistered(objectName)) {
                if (wMSLogger.isDebugEnabled()) {
                    wMSLogger.debug("Unregistering existing component " + objectName);
                }
                this.getMBeanServer().unregisterMBean(objectName);
            }
            this.getMBeanServer().registerMBean(modelMBean, objectName);
        }
        catch (Exception exception) {
            wMSLogger.error("Error registering " + objectName, (Throwable)exception);
            throw exception;
        }
    }

    public synchronized void loadDescriptors(String string, ClassLoader classLoader) {
        String string2 = string.replace('.', '/');
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(Registry.class);
        if (this.searchedPaths.get(string) != null) {
            return;
        }
        String string3 = string2 + "/mbeans-descriptors.ser";
        URL uRL = classLoader.getResource(string3);
        if (uRL == null) {
            string3 = string2 + "/mbeans-descriptors.xml";
            uRL = classLoader.getResource(string3);
        }
        if (uRL == null) {
            return;
        }
        wMSLogger.debug("Found " + uRL);
        this.searchedPaths.put(string, uRL);
        try {
            if (string3.endsWith(".xml")) {
                this.loadDescriptors("MbeansDescriptorsDOMSource", uRL, null);
            } else {
                this.loadDescriptors("MbeansDescriptorsSerSource", uRL, null);
            }
        }
        catch (Exception exception) {
            wMSLogger.error("Error loading " + uRL);
        }
    }

    public void loadDescriptors(String string, Object object, String string2) throws Exception {
        List list = this.load(string, object, string2);
        if (list == null) {
            return;
        }
        for (Object e : list) {
            if (!(e instanceof ManagedBean)) continue;
            this.addManagedBean((ManagedBean)e);
        }
    }

    private void loadMetaInfDescriptors(ClassLoader classLoader) {
        try {
            Enumeration<URL> enumeration = classLoader.getResources(MODELER_MANIFEST);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = uRL.openStream();
                this.loadDescriptors("MBeansDescriptorDOMSource", inputStream, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void findDescriptor(Class clazz, String string) {
        if (string == null) {
            string = clazz.getName();
        }
        ClassLoader classLoader = null;
        if (clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String string2 = string;
        while (string2.indexOf(".") > 0) {
            int n = string2.lastIndexOf(".");
            if (n <= 0) {
                return;
            }
            if (this.searchedPaths.get(string2 = string2.substring(0, n)) != null) {
                return;
            }
            this.loadDescriptors(string2, classLoader);
        }
    }

    private ModelerSource getModelerSource(String string) throws Exception {
        if (string == null) {
            string = "MbeansDescriptorsDOMSource";
        }
        if (string.indexOf(".") < 0) {
            string = "org.apache.commons.modeler.modules." + string;
        }
        Class<?> clazz = Class.forName(string);
        ModelerSource modelerSource = (ModelerSource)clazz.newInstance();
        return modelerSource;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.server = mBeanServer;
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void unregisterRegistry(ClassLoader classLoader) {
        perLoaderRegistries.remove(classLoader);
    }

    public ManagedBean findManagedBean(Class clazz, String string) throws Exception {
        return this.findManagedBean(null, clazz, string);
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.server = mBeanServer;
    }

    public void resetMetadata() {
        this.stop();
    }

    public void loadDescriptors(Object object) throws Exception {
        this.loadDescriptors("MbeansDescriptorsDOMSource", object, null);
    }

    public void registerComponent(Object object, String string, String string2, String string3) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(":");
        stringBuffer.append(string3);
        String string4 = stringBuffer.toString();
        ObjectName objectName = new ObjectName(string4);
        this.registerComponent(object, objectName, string2);
    }

    public void unregisterComponent(String string, String string2) {
        try {
            ObjectName objectName = new ObjectName(string + ":" + string2);
            this.getMBeanServer().unregisterMBean(objectName);
        }
        catch (Throwable throwable) {
            WMSLoggerFactory.getLogger(Registry.class).error("Error unregistering mbean ", throwable);
        }
    }

    public List loadMBeans(Object object) throws Exception {
        return this.loadMBeans(object, null);
    }

    public void loadCachedDescriptors(Object object) throws Exception {
        this.loadDescriptors("MbeansDescriptorsSerSource", object, null);
    }
}

