/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.mbeans;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.mbeans.MBeanProxy;

public class SimpleRemoteConnector {
    String webServerHost = "localhost";
    int webServerPort = 8080;
    String statusPath = "/jkstatus";
    String user;
    String pass;
    String domain;
    String localDomain;
    String filter;
    long lastRefresh = 0L;
    long updateInterval = 5000L;
    String prefix = "";
    Registry reg;
    MBeanServer mserver;
    HashMap mbeans = new HashMap();

    public String getWebServerHost() {
        return this.webServerHost;
    }

    public void setWebServerHost(String string) {
        this.webServerHost = string;
    }

    public int getWebServerPort() {
        return this.webServerPort;
    }

    public void setWebServerPort(int n) {
        this.webServerPort = n;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(long l) {
        this.updateInterval = l;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPass() {
        return this.pass;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public void setPass(String string) {
        this.pass = string;
    }

    public String getStatusPath() {
        return this.statusPath;
    }

    public void setStatusPath(String string) {
        this.statusPath = string;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String string) {
        this.filter = string;
    }

    public void destroy() {
        try {
            for (MBeanProxy mBeanProxy : this.mbeans.values()) {
                ObjectName objectName = mBeanProxy.getJmxName();
                Registry.getRegistry().getMBeanServer().unregisterMBean(objectName);
            }
        }
        catch (Throwable throwable) {
            WMSLoggerFactory.getLogger(SimpleRemoteConnector.class).error("Destroy error", throwable);
        }
    }

    public void init() throws IOException {
        try {
            WMSLoggerFactory.getLogger(SimpleRemoteConnector.class).info("init " + this.webServerHost + " " + this.webServerPort);
            this.reg = Registry.getRegistry();
            this.refreshAttributes();
        }
        catch (Throwable throwable) {
            WMSLoggerFactory.getLogger(SimpleRemoteConnector.class).error("Init error", throwable);
        }
    }

    public void start() throws IOException {
        System.out.println("XXX start");
        if (this.reg == null) {
            this.init();
        }
    }

    public void refresh() {
        long l = System.currentTimeMillis();
        if (l - this.lastRefresh < this.updateInterval) {
            return;
        }
        System.out.println("refresh... ");
        this.lastRefresh = l;
        this.refreshAttributes();
    }

    public void refreshAttributes() {
        try {
            InputStream inputStream;
            int n = 0;
            if (this.filter == null) {
                this.filter = this.domain + ":*";
            }
            if ((inputStream = this.getStream("qry=" + this.filter)) == null) {
                return;
            }
            Manifest manifest = new Manifest(inputStream);
            WMSLogger wMSLogger = WMSLoggerFactory.getLogger(SimpleRemoteConnector.class);
            HashMap<ObjectName, String> hashMap = new HashMap<ObjectName, String>();
            Map<String, Attributes> map = manifest.getEntries();
            for (String object : map.keySet()) {
                Object object2 = map.get(object);
                ObjectName throwable = new ObjectName(object);
                hashMap.put(throwable, "");
                MBeanProxy mBeanProxy = (MBeanProxy)this.mbeans.get(throwable);
                if (mBeanProxy == null) {
                    wMSLogger.debug("New object " + object);
                    String string = ((Attributes)object2).getValue("modelerType");
                    if (wMSLogger.isDebugEnabled()) {
                        wMSLogger.debug("Register " + object + " " + (String)string);
                    }
                    mBeanProxy = new MBeanProxy(this, string);
                    this.mbeans.put(throwable, mBeanProxy);
                    Object object3 = Registry.getRegistry().getMBeanServer();
                    if (!object3.isRegistered(throwable)) {
                        object3.registerMBean(mBeanProxy, throwable);
                    }
                }
                for (Object object3 : ((Attributes)object2).keySet()) {
                    String string;
                    String string2 = string = object3 == null ? null : object3.toString();
                    if ("modelerType".equals(string)) continue;
                    String string3 = ((Attributes)object2).getValue(string);
                    mBeanProxy.update(string, string3);
                    ++n;
                }
            }
            for (Object object2 : this.mbeans.keySet()) {
                if (hashMap.get(object2) != null) continue;
                if (wMSLogger.isDebugEnabled()) {
                    wMSLogger.debug("No longer alive " + object2);
                }
                try {
                    this.mserver.unregisterMBean((ObjectName)object2);
                }
                catch (Throwable throwable) {
                    wMSLogger.info("Error unregistering " + object2 + " " + throwable.toString());
                }
            }
            wMSLogger.info("Refreshing attributes " + n);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SimpleRemoteConnector.class).info("Error ", (Throwable)exception);
        }
    }

    public void refreshMetadata() {
        try {
            int n = 0;
            int n2 = 0;
            InputStream inputStream = this.getStream("getMetadata=" + this.domain + ":*");
            if (inputStream == null) {
                return;
            }
            WMSLoggerFactory.getLogger(SimpleRemoteConnector.class).info("Refreshing metadata " + n + " " + n2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SimpleRemoteConnector.class).info("Error ", (Throwable)exception);
        }
    }

    public Object invoke(Object object, String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        try {
            InputStream inputStream = this.getStream("invoke=" + string + "&name=" + object.toString());
            if (inputStream == null) {
                return null;
            }
            this.refreshAttributes();
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
        return null;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            String string = (String)attribute.getValue();
            String string2 = attribute.getName();
            InputStream inputStream = this.getStream("set=" + string2 + "&name=" + objectName.toString() + "&value=" + string);
            if (inputStream == null) {
                return;
            }
            this.refreshAttributes();
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    protected InputStream getStream(String string) throws Exception {
        try {
            String string2 = this.statusPath + "?" + string;
            URL uRL = new URL("http", this.webServerHost, this.webServerPort, string2);
            WMSLoggerFactory.getLogger(SimpleRemoteConnector.class).debug("Connecting to " + uRL);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            return inputStream;
        }
        catch (IOException iOException) {
            WMSLoggerFactory.getLogger(SimpleRemoteConnector.class).info("Can't connect to jkstatus " + this.webServerHost + ":" + this.webServerPort + " " + iOException.toString());
            return null;
        }
    }
}

