/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonDeserializers {
    public static StdDeserializer<?>[] all() {
        return new StdDeserializer[]{new JavaTypeDeserializer(), new TokenBufferDeserializer()};
    }

    public static ValueInstantiator findValueInstantiator(DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        if (beanDescription.getBeanClass() == JsonLocation.class) {
            return new JsonLocationInstantiator();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaTypeDeserializer
    extends StdScalarDeserializer<JavaType> {
        public JavaTypeDeserializer() {
            super(JavaType.class);
        }

        @Override
        public JavaType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_STRING) {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return (JavaType)this.getEmptyValue();
                }
                return deserializationContext.getTypeFactory().constructFromCanonical(string);
            }
            if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return (JavaType)jsonParser.getEmbeddedObject();
            }
            throw deserializationContext.mappingException(this._valueClass);
        }
    }

    public static class JsonLocationInstantiator
    extends ValueInstantiator {
        public String getValueTypeDesc() {
            return JsonLocation.class.getName();
        }

        public boolean canCreateFromObjectWith() {
            return true;
        }

        public CreatorProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
            JavaType javaType = deserializationConfig.constructType(Integer.TYPE);
            JavaType javaType2 = deserializationConfig.constructType(Long.TYPE);
            return new CreatorProperty[]{new CreatorProperty("sourceRef", deserializationConfig.constructType(Object.class), null, null, null, 0, null), new CreatorProperty("byteOffset", javaType2, null, null, null, 1, null), new CreatorProperty("charOffset", javaType2, null, null, null, 2, null), new CreatorProperty("lineNr", javaType, null, null, null, 3, null), new CreatorProperty("columnNr", javaType, null, null, null, 4, null)};
        }

        public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) {
            return new JsonLocation(objectArray[0], JsonLocationInstantiator._long(objectArray[1]), JsonLocationInstantiator._long(objectArray[2]), JsonLocationInstantiator._int(objectArray[3]), JsonLocationInstantiator._int(objectArray[4]));
        }

        private static final long _long(Object object) {
            return object == null ? 0L : ((Number)object).longValue();
        }

        private static final int _int(Object object) {
            return object == null ? 0 : ((Number)object).intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JacksonStdImpl
    public static class TokenBufferDeserializer
    extends StdScalarDeserializer<TokenBuffer> {
        public TokenBufferDeserializer() {
            super(TokenBuffer.class);
        }

        @Override
        public TokenBuffer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
            tokenBuffer.copyCurrentStructure(jsonParser);
            return tokenBuffer;
        }
    }
}

