/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;

public final class POJONode
extends ValueNode {
    protected final Object _value;

    public POJONode(Object object) {
        this._value = object;
    }

    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    public boolean isPojo() {
        return true;
    }

    public byte[] binaryValue() throws IOException {
        if (this._value instanceof byte[]) {
            return (byte[])this._value;
        }
        return super.binaryValue();
    }

    public String asText() {
        return this._value == null ? "null" : this._value.toString();
    }

    public boolean asBoolean(boolean bl) {
        if (this._value != null && this._value instanceof Boolean) {
            return (Boolean)this._value;
        }
        return bl;
    }

    public int asInt(int n) {
        if (this._value instanceof Number) {
            return ((Number)this._value).intValue();
        }
        return n;
    }

    public long asLong(long l) {
        if (this._value instanceof Number) {
            return ((Number)this._value).longValue();
        }
        return l;
    }

    public double asDouble(double d) {
        if (this._value instanceof Number) {
            return ((Number)this._value).doubleValue();
        }
        return d;
    }

    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        if (this._value == null) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeObject(this._value);
        }
    }

    public Object getPojo() {
        return this._value;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        POJONode pOJONode = (POJONode)object;
        if (this._value == null) {
            return pOJONode._value == null;
        }
        return this._value.equals(pOJONode._value);
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

