/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.Comparators;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBuilder {
    protected final SerializationConfig _config;
    protected final BeanDescription _beanDesc;
    protected final JsonInclude.Include _outputProps;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected Object _defaultBean;

    public PropertyBuilder(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        this._config = serializationConfig;
        this._beanDesc = beanDescription;
        this._outputProps = beanDescription.findSerializationInclusion(serializationConfig.getSerializationInclusion());
        this._annotationIntrospector = this._config.getAnnotationIntrospector();
    }

    public Annotations getClassAnnotations() {
        return this._beanDesc.getClassAnnotations();
    }

    protected BeanPropertyWriter buildWriter(BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, TypeSerializer typeSerializer2, AnnotatedMember annotatedMember, boolean bl) {
        Object object;
        JavaType javaType2 = this.findSerializationType(annotatedMember, bl, javaType);
        if (typeSerializer2 != null) {
            if (javaType2 == null) {
                javaType2 = javaType;
            }
            if ((object = javaType2.getContentType()) == null) {
                throw new IllegalStateException("Problem trying to create BeanPropertyWriter for property '" + beanPropertyDefinition.getName() + "' (of type " + this._beanDesc.getType() + "); serialization type " + javaType2 + " has no content");
            }
            javaType2 = javaType2.withContentTypeHandler(typeSerializer2);
            object = javaType2.getContentType();
        }
        object = null;
        boolean bl2 = false;
        JsonInclude.Include include = this._annotationIntrospector.findSerializationInclusion(annotatedMember, this._outputProps);
        if (include != null) {
            switch (include) {
                case NON_DEFAULT: {
                    object = this.getDefaultValue(beanPropertyDefinition.getName(), annotatedMember);
                    if (object == null) {
                        bl2 = true;
                        break;
                    }
                    if (!object.getClass().isArray()) break;
                    object = Comparators.getArrayComparator(object);
                    break;
                }
                case NON_EMPTY: {
                    bl2 = true;
                    object = BeanPropertyWriter.MARKER_FOR_EMPTY;
                    break;
                }
                case NON_NULL: {
                    bl2 = true;
                }
                case ALWAYS: {
                    if (!javaType.isContainerType() || this._config.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS)) break;
                    object = BeanPropertyWriter.MARKER_FOR_EMPTY;
                }
            }
        }
        BeanPropertyWriter beanPropertyWriter = new BeanPropertyWriter(beanPropertyDefinition, annotatedMember, this._beanDesc.getClassAnnotations(), javaType, jsonSerializer, typeSerializer, javaType2, bl2, object);
        NameTransformer nameTransformer = this._annotationIntrospector.findUnwrappingNameTransformer(annotatedMember);
        if (nameTransformer != null) {
            beanPropertyWriter = beanPropertyWriter.unwrappingWriter(nameTransformer);
        }
        return beanPropertyWriter;
    }

    protected JavaType findSerializationType(Annotated annotated, boolean bl, JavaType serializable) {
        JsonSerialize.Typing typing;
        Serializable serializable2;
        Class<?> clazz = this._annotationIntrospector.findSerializationType(annotated);
        if (clazz != null) {
            serializable2 = serializable.getRawClass();
            if (clazz.isAssignableFrom((Class<?>)serializable2)) {
                serializable = serializable.widenBy(clazz);
            } else {
                if (!((Class)serializable2).isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("Illegal concrete-type annotation for method '" + annotated.getName() + "': class " + clazz.getName() + " not a super-type of (declared) class " + ((Class)serializable2).getName());
                }
                serializable = this._config.constructSpecializedType((JavaType)serializable, clazz);
            }
            bl = true;
        }
        if ((serializable2 = BeanSerializerFactory.modifySecondaryTypesByAnnotation(this._config, annotated, serializable)) != serializable) {
            bl = true;
            serializable = serializable2;
        }
        if (!bl && (typing = this._annotationIntrospector.findSerializationTyping(annotated)) != null) {
            bl = typing == JsonSerialize.Typing.STATIC;
        }
        return bl ? serializable : null;
    }

    protected Object getDefaultBean() {
        if (this._defaultBean == null) {
            this._defaultBean = this._beanDesc.instantiateBean(this._config.canOverrideAccessModifiers());
            if (this._defaultBean == null) {
                AnnotatedElement annotatedElement = this._beanDesc.getClassInfo().getAnnotated();
                throw new IllegalArgumentException("Class " + ((Class)annotatedElement).getName() + " has no default constructor; can not instantiate default bean value to support 'properties=JsonSerialize.Inclusion.NON_DEFAULT' annotation");
            }
        }
        return this._defaultBean;
    }

    protected Object getDefaultValue(String string, AnnotatedMember annotatedMember) {
        Object object = this.getDefaultBean();
        try {
            return annotatedMember.getValue(object);
        }
        catch (Exception exception) {
            return this._throwWrapped(exception, string, object);
        }
    }

    protected Object _throwWrapped(Exception exception, String string, Object object) {
        Throwable throwable = exception;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new IllegalArgumentException("Failed to get property '" + string + "' of default " + object.getClass().getName() + " instance");
    }
}

