/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;

public class SimpleBeanPropertyDefinition
extends BeanPropertyDefinition {
    protected final AnnotatedMember _member;
    protected final String _name;

    public SimpleBeanPropertyDefinition(AnnotatedMember annotatedMember) {
        this(annotatedMember, annotatedMember.getName());
    }

    public SimpleBeanPropertyDefinition(AnnotatedMember annotatedMember, String string) {
        this._member = annotatedMember;
        this._name = string;
    }

    public SimpleBeanPropertyDefinition withName(String string) {
        if (this._name.equals(string)) {
            return this;
        }
        return new SimpleBeanPropertyDefinition(this._member, string);
    }

    public String getName() {
        return this._name;
    }

    public String getInternalName() {
        return this.getName();
    }

    public boolean isExplicitlyIncluded() {
        return false;
    }

    public boolean hasGetter() {
        return this.getGetter() != null;
    }

    public boolean hasSetter() {
        return this.getSetter() != null;
    }

    public boolean hasField() {
        return this._member instanceof AnnotatedField;
    }

    public boolean hasConstructorParameter() {
        return this._member instanceof AnnotatedParameter;
    }

    public AnnotatedMethod getGetter() {
        if (this._member instanceof AnnotatedMethod && ((AnnotatedMethod)this._member).getParameterCount() == 0) {
            return (AnnotatedMethod)this._member;
        }
        return null;
    }

    public AnnotatedMethod getSetter() {
        if (this._member instanceof AnnotatedMethod && ((AnnotatedMethod)this._member).getParameterCount() == 1) {
            return (AnnotatedMethod)this._member;
        }
        return null;
    }

    public AnnotatedField getField() {
        return this._member instanceof AnnotatedField ? (AnnotatedField)this._member : null;
    }

    public AnnotatedParameter getConstructorParameter() {
        return this._member instanceof AnnotatedParameter ? (AnnotatedParameter)this._member : null;
    }

    public AnnotatedMember getAccessor() {
        AnnotatedMember annotatedMember = this.getGetter();
        if (annotatedMember == null) {
            annotatedMember = this.getField();
        }
        return annotatedMember;
    }

    public AnnotatedMember getMutator() {
        AnnotatedMember annotatedMember = this.getConstructorParameter();
        if (annotatedMember == null && (annotatedMember = this.getSetter()) == null) {
            annotatedMember = this.getField();
        }
        return annotatedMember;
    }

    public AnnotatedMember getPrimaryMember() {
        return this._member;
    }
}

