/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;

public class PropertyGetter {
    protected static final Object[] NULL_ARG = new Object[0];
    protected Object obj;
    protected PropertyDescriptor[] props;

    public PropertyGetter(Object object) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        this.props = beanInfo.getPropertyDescriptors();
        this.obj = object;
    }

    public static void getProperties(Object object, PropertyCallback propertyCallback, String string) {
        try {
            new PropertyGetter(object).getProperties(propertyCallback, string);
        }
        catch (IntrospectionException introspectionException) {
            LogLog.error("Failed to introspect object " + object, introspectionException);
        }
    }

    public void getProperties(PropertyCallback propertyCallback, String string) {
        for (int i = 0; i < this.props.length; ++i) {
            Method method = this.props[i].getReadMethod();
            if (method == null || !this.isHandledType(method.getReturnType())) continue;
            String string2 = this.props[i].getName();
            try {
                Object object = method.invoke(this.obj, NULL_ARG);
                if (object == null) continue;
                propertyCallback.foundProperty(this.obj, string, string2, object);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                LogLog.warn("Failed to get value of property " + string2);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof InterruptedException || invocationTargetException.getTargetException() instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.warn("Failed to get value of property " + string2);
                continue;
            }
            catch (RuntimeException runtimeException) {
                LogLog.warn("Failed to get value of property " + string2);
            }
        }
    }

    protected boolean isHandledType(Class clazz) {
        return String.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz) || Priority.class.isAssignableFrom(clazz);
    }

    public static interface PropertyCallback {
        public void foundProperty(Object var1, String var2, String var3, Object var4);
    }
}

