/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.ZeroConfSupport;
import org.apache.log4j.spi.LoggingEvent;

public class SocketHubAppender
extends AppenderSkeleton {
    static final int DEFAULT_PORT = 4560;
    private int port = 4560;
    private Vector oosList = new Vector();
    private ServerMonitor serverMonitor = null;
    private boolean locationInfo = false;
    private CyclicBuffer buffer = null;
    private String application;
    private boolean advertiseViaMulticastDNS;
    private ZeroConfSupport zeroConf;
    public static final String ZONE = "_log4j_obj_tcpaccept_appender.local.";
    private ServerSocket serverSocket;

    public SocketHubAppender() {
    }

    public SocketHubAppender(int n) {
        this.port = n;
        this.startServer();
    }

    public void activateOptions() {
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf = new ZeroConfSupport(ZONE, this.port, this.getName());
            this.zeroConf.advertise();
        }
        this.startServer();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug("closing SocketHubAppender " + this.getName());
        this.closed = true;
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf.unadvertise();
        }
        this.cleanUp();
        LogLog.debug("SocketHubAppender " + this.getName() + " closed");
    }

    public void cleanUp() {
        LogLog.debug("stopping ServerSocket");
        this.serverMonitor.stopMonitor();
        this.serverMonitor = null;
        LogLog.debug("closing client connections");
        while (this.oosList.size() != 0) {
            ObjectOutputStream objectOutputStream = (ObjectOutputStream)this.oosList.elementAt(0);
            if (objectOutputStream == null) continue;
            try {
                objectOutputStream.close();
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.currentThread().interrupt();
                LogLog.error("could not close oos.", interruptedIOException);
            }
            catch (IOException iOException) {
                LogLog.error("could not close oos.", iOException);
            }
            this.oosList.removeElementAt(0);
        }
    }

    public void append(LoggingEvent loggingEvent) {
        if (loggingEvent != null) {
            if (this.locationInfo) {
                loggingEvent.getLocationInformation();
            }
            if (this.application != null) {
                loggingEvent.setProperty("application", this.application);
            }
            loggingEvent.getNDC();
            loggingEvent.getThreadName();
            loggingEvent.getMDCCopy();
            loggingEvent.getRenderedMessage();
            loggingEvent.getThrowableStrRep();
            if (this.buffer != null) {
                this.buffer.add(loggingEvent);
            }
        }
        if (loggingEvent == null || this.oosList.size() == 0) {
            return;
        }
        for (int i = 0; i < this.oosList.size(); ++i) {
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = (ObjectOutputStream)this.oosList.elementAt(i);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (objectOutputStream == null) break;
            try {
                objectOutputStream.writeObject(loggingEvent);
                objectOutputStream.flush();
                objectOutputStream.reset();
                continue;
            }
            catch (IOException iOException) {
                if (iOException instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                this.oosList.removeElementAt(i);
                LogLog.debug("dropped connection");
                --i;
            }
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setApplication(String string) {
        this.application = string;
    }

    public String getApplication() {
        return this.application;
    }

    public int getPort() {
        return this.port;
    }

    public void setBufferSize(int n) {
        this.buffer = new CyclicBuffer(n);
    }

    public int getBufferSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.getMaxSize();
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setAdvertiseViaMulticastDNS(boolean bl) {
        this.advertiseViaMulticastDNS = bl;
    }

    public boolean isAdvertiseViaMulticastDNS() {
        return this.advertiseViaMulticastDNS;
    }

    private void startServer() {
        this.serverMonitor = new ServerMonitor(this.port, this.oosList);
    }

    protected ServerSocket createServerSocket(int n) throws IOException {
        return new ServerSocket(n);
    }

    private class ServerMonitor
    implements Runnable {
        private int port;
        private Vector oosList;
        private boolean keepRunning;
        private Thread monitorThread;

        public ServerMonitor(int n, Vector vector) {
            this.port = n;
            this.oosList = vector;
            this.keepRunning = true;
            this.monitorThread = new Thread(this);
            this.monitorThread.setDaemon(true);
            this.monitorThread.setName("SocketHubAppender-Monitor-" + this.port);
            this.monitorThread.start();
        }

        public synchronized void stopMonitor() {
            if (this.keepRunning) {
                LogLog.debug("server monitor thread shutting down");
                this.keepRunning = false;
                try {
                    if (SocketHubAppender.this.serverSocket != null) {
                        SocketHubAppender.this.serverSocket.close();
                        SocketHubAppender.this.serverSocket = null;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.monitorThread.join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.monitorThread = null;
                LogLog.debug("server monitor thread shut down");
            }
        }

        private void sendCachedEvents(ObjectOutputStream objectOutputStream) throws IOException {
            if (SocketHubAppender.this.buffer != null) {
                for (int i = 0; i < SocketHubAppender.this.buffer.length(); ++i) {
                    objectOutputStream.writeObject(SocketHubAppender.this.buffer.get(i));
                }
                objectOutputStream.flush();
                objectOutputStream.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SocketHubAppender.this.serverSocket = null;
            try {
                SocketHubAppender.this.serverSocket = SocketHubAppender.this.createServerSocket(this.port);
                SocketHubAppender.this.serverSocket.setSoTimeout(1000);
            }
            catch (Exception exception) {
                if (exception instanceof InterruptedIOException || exception instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error("exception setting timeout, shutting down server socket.", exception);
                this.keepRunning = false;
                return;
            }
            try {
                try {
                    SocketHubAppender.this.serverSocket.setSoTimeout(1000);
                }
                catch (SocketException socketException) {
                    LogLog.error("exception setting timeout, shutting down server socket.", socketException);
                    try {
                        SocketHubAppender.this.serverSocket.close();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        Thread.currentThread().interrupt();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                while (this.keepRunning) {
                    Socket socket = null;
                    try {
                        socket = SocketHubAppender.this.serverSocket.accept();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    catch (SocketException socketException) {
                        LogLog.error("exception accepting socket, shutting down server socket.", socketException);
                        this.keepRunning = false;
                    }
                    catch (IOException iOException) {
                        LogLog.error("exception accepting socket.", iOException);
                    }
                    if (socket == null) continue;
                    try {
                        InetAddress inetAddress = socket.getInetAddress();
                        LogLog.debug("accepting connection from " + inetAddress.getHostName() + " (" + inetAddress.getHostAddress() + ")");
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                        if (SocketHubAppender.this.buffer != null && SocketHubAppender.this.buffer.length() > 0) {
                            this.sendCachedEvents(objectOutputStream);
                        }
                        this.oosList.addElement(objectOutputStream);
                    }
                    catch (IOException iOException) {
                        if (iOException instanceof InterruptedIOException) {
                            Thread.currentThread().interrupt();
                        }
                        LogLog.error("exception creating output stream on socket.", iOException);
                    }
                }
            }
            finally {
                try {
                    SocketHubAppender.this.serverSocket.close();
                }
                catch (InterruptedIOException interruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

