/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.or;

import java.util.Hashtable;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.DefaultRenderer;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.spi.RendererSupport;

public class RendererMap {
    Hashtable map = new Hashtable();
    static ObjectRenderer defaultRenderer = new DefaultRenderer();

    public static void addRenderer(RendererSupport rendererSupport, String string, String string2) {
        LogLog.debug("Rendering class: [" + string2 + "], Rendered class: [" + string + "].");
        ObjectRenderer objectRenderer = (ObjectRenderer)OptionConverter.instantiateByClassName(string2, ObjectRenderer.class, null);
        if (objectRenderer == null) {
            LogLog.error("Could not instantiate renderer [" + string2 + "].");
            return;
        }
        try {
            Class clazz = Loader.loadClass(string);
            rendererSupport.setRenderer(clazz, objectRenderer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogLog.error("Could not find class [" + string + "].", classNotFoundException);
        }
    }

    public String findAndRender(Object object) {
        if (object == null) {
            return null;
        }
        return this.get(object.getClass()).doRender(object);
    }

    public ObjectRenderer get(Object object) {
        if (object == null) {
            return null;
        }
        return this.get(object.getClass());
    }

    public ObjectRenderer get(Class clazz) {
        ObjectRenderer objectRenderer = null;
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            objectRenderer = (ObjectRenderer)this.map.get(clazz2);
            if (objectRenderer != null) {
                return objectRenderer;
            }
            objectRenderer = this.searchInterfaces(clazz2);
            if (objectRenderer == null) continue;
            return objectRenderer;
        }
        return defaultRenderer;
    }

    ObjectRenderer searchInterfaces(Class clazz) {
        ObjectRenderer objectRenderer = (ObjectRenderer)this.map.get(clazz);
        if (objectRenderer != null) {
            return objectRenderer;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            objectRenderer = this.searchInterfaces(classArray[i]);
            if (objectRenderer == null) continue;
            return objectRenderer;
        }
        return null;
    }

    public ObjectRenderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public void clear() {
        this.map.clear();
    }

    public void put(Class clazz, ObjectRenderer objectRenderer) {
        this.map.put(clazz, objectRenderer);
    }
}

