/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.util.JSON;
import com.wowza.util.StringUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.protocol.wowz.WOWZSession;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.ILivePlayer;
import com.wowza.wms.stream.live.LivePlayerSwitch;
import com.wowza.wms.stream.live.MediaStreamLivePlay;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LivePlayer
implements ILivePlayer {
    protected long trackerSeqSource = 0L;
    protected IMediaStreamPlay stream = null;
    protected byte[] workBuffer = null;
    protected boolean isDebugLog = false;
    protected long lastSeq = -1L;
    protected long lastAudioTC = -1L;
    protected long lastVideoTC = -1L;
    protected long lastDataTC = -1L;
    protected long lastTC = -1L;
    protected long firstPacketTC = -1L;
    protected boolean isEnhancedSeekCapable = false;
    protected boolean isBurstCapable = false;
    protected boolean sendFirstKeyFrame = true;
    protected boolean checkStreamProperties = true;
    protected boolean sendFirstVideoFrame = true;
    protected boolean sendFirstAudioFrame = true;
    protected boolean sentPlayStart = false;
    protected boolean sendPlayStop = false;
    protected boolean sendPlaySwitch = false;
    protected long lastSendTime = -1L;
    protected boolean waitForKeyFrame = true;
    protected long lastTCOffset = 0L;
    protected int lastTCFilter = 7;
    protected LiveTracker lastSentLiveTracker = null;
    protected long trackerBufferTime = 0L;
    protected long trackerStartSeq = -1L;
    protected boolean sendStreamNotFound = true;
    protected boolean waitForBufferFill = true;
    protected boolean waitForBufferKeyFrame = false;
    protected long waitForBufferFillStarTime = -1L;
    protected int maximumLiveLatency = 8000;
    protected boolean disableLowBandwidthThrottling = false;
    protected boolean instantOn = false;
    protected int instantOnBufferTime = 0;
    protected int behindDropDFrames = 500;
    protected int behindDropPFrames = 1500;
    protected int behindDropKFrames = 3000;
    protected int behindDropAudio = 3000;
    protected boolean lastReceiveAudio = true;
    protected boolean lastReceiveVideo = true;
    protected int lastReceiveVideoFPS = -1;
    protected double playStart = 0.0;
    protected double playLen = -1.0;
    protected int playTransition = 0;
    protected boolean playlistEnd = false;
    protected boolean bufferEmptyOnce = false;
    protected Object lock = new Object();
    protected AtomicReference<LivePlayerSwitch> liveSwitch = new AtomicReference<Object>(null);
    protected boolean sendOriginalTimecodes = false;
    protected int packetsSent = 0;
    protected int startPacketsSent = 0;
    protected boolean referenceWrite = true;
    protected int[] avgPacketSizes = new int[8];
    protected long avgPacketSizeCount = 0L;
    protected long avgPacketSizeTotal = 0L;
    protected int referenceWritePacketSizeThreshold = 500;
    private boolean a = true;
    private PacketTimecodeDebug b = null;

    public LivePlayer(IMediaStreamPlay iMediaStreamPlay) {
        this.stream = iMediaStreamPlay;
    }

    public Object getLock() {
        return this.lock;
    }

    public void setLock(Object object) {
        this.lock = object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        int n = iClient.testFlashVersion(nArray);
        if (n < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isBurstCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{10, 0, 0, 0};
        int n = iClient.testFlashVersion(nArray);
        if (n < 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBurstStart(OutputStream outputStream, IMediaStream iMediaStream) {
        if (!this.isBurstCapable) return;
        byte[] byArray = iMediaStream.getBurstStartStop(true);
        try {
            int n = IFasterByteArrayOutputStream.getProtocol((OutputStream)outputStream);
            if (n == 4) {
                WOWZSession wOWZSession = IFasterByteArrayOutputStream.getWOWZSession((OutputStream)outputStream);
                wOWZSession.wrapWrite(outputStream, byArray, 0, byArray.length);
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        outputStream.write(byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendBurstEnd(OutputStream outputStream, IMediaStream iMediaStream) {
        if (!this.isBurstCapable) return;
        byte[] byArray = iMediaStream.getBurstStartStop(false);
        try {
            int n = IFasterByteArrayOutputStream.getProtocol((OutputStream)outputStream);
            if (n == 4) {
                WOWZSession wOWZSession = IFasterByteArrayOutputStream.getWOWZSession((OutputStream)outputStream);
                wOWZSession.wrapWrite(outputStream, byArray, 0, byArray.length);
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        outputStream.write(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int packetOutput(OutputStream outputStream, IMediaStream iMediaStream, AMFPacket aMFPacket, long l, AMFObj aMFObj, byte[] byArray, int n) {
        if (this.startPacketsSent == this.packetsSent) {
            this.sendBurstStart(outputStream, iMediaStream);
        }
        ++this.packetsSent;
        return StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket, (long)l, (AMFObj)aMFObj, (byte[])byArray, (int)n, (boolean)this.referenceWrite);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int doSwitch(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray, long l, byte by, AMFPacket aMFPacket, AMFPacket aMFPacket2, AMFPacket aMFPacket3) {
        AMFPacket aMFPacket4;
        int n = 0;
        Client client = (Client)iMediaStream.getClient();
        int n2 = client.getSendChunkSize();
        this.checkWorkBuffer(n2);
        AMFPacket aMFPacket5 = new AMFPacket(8, iMediaStream.getSrc(), 0);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        AMFPacket aMFPacket6 = null;
        if ((by & 0xF) == 7 && (aMFPacket6 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            byte[] byArray = new byte[]{(byte)(16 + (byte)(by & 0xF)), 2, 0, 0, 0};
            aMFPacket6.addData(byArray, 0, byArray.length);
        }
        if (aMFPacket6 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket6.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket6, l, aMFObj2, this.workBuffer, n2);
            aMFObj2.setNew(true);
        }
        n += iMediaStream.sendPlayStatus(outputStream, l, 1, 0.0, 0.0);
        n += iMediaStream.sendPlayStart(outputStream, iMediaStream.getName(), true, true, l, null);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        if (aMFPacket != null) {
            Object var18_19 = null;
            aMFPacket4 = null;
            ResponseFunction responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
            responseFunction.createSeekMessage(Base64.lastIndexOf((int)(1243 / 217), (String)"jhT|h~~\u007f"));
            responseFunction.setSrc(iMediaStream.getSrc());
            responseFunction.setType(18);
            responseFunction.setTimecode(l);
            aMFPacket4 = new AMFDataObj();
            aMFPacket4.put(JSON.endsWith((String)"0;13", (int)(57 * 11)), (AMFData)new AMFDataItem(Base64.lastIndexOf((int)(801 / 180), (String)"J`rT|{oja#Jndp<@`tdc")));
            responseFunction.addBody((AMFData)aMFPacket4);
            n += responseFunction.write(outputStream, true, n2);
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket, l, aMFObj3, this.workBuffer, n2);
        }
        if (aMFPacket3 == null) return n;
        byte by2 = (byte)aMFPacket3.getFirstByte();
        aMFPacket4 = null;
        if ((by2 & 0xF) == 7 && (aMFPacket4 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            byte[] byArray = new byte[]{(byte)(16 + (byte)(by2 & 0xF)), 2, 0, 0, 0};
            aMFPacket4.addData(byArray, 0, byArray.length);
        }
        if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
            n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, true), l, aMFObj2, this.workBuffer, n2);
        }
        if (aMFPacket4 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket4.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket4, l, aMFObj2, this.workBuffer, n2);
        }
        lArray[2] = lArray[2] + (long)aMFPacket3.getSize();
        lArray[3] = lArray[3] + 1L;
        n += this.packetOutput(outputStream, iMediaStream, aMFPacket3, l, aMFObj2, this.workBuffer, n2);
        if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
            n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, false), l, aMFObj2, this.workBuffer, n2);
        }
        if (aMFPacket2 == null) return n;
        return n += this.packetOutput(outputStream, iMediaStream, aMFPacket2, l, aMFObj2, this.workBuffer, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        WMSProperties wMSProperties = this.stream.getParent().getProperties();
        this.isDebugLog = WMSLoggerFactory.getLogger(LivePlayer.class).isDebugEnabled();
        if (wMSProperties == null) return;
        this.disableLowBandwidthThrottling = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(425 / 83), (String)"aotikfn@byMq\u007fvd}qb\u007fLqhthirvnf"), this.disableLowBandwidthThrottling);
        this.instantOn = wMSProperties.getPropertyBoolean(JSON.endsWith((String)"agy\u007fmcz@~", (int)(-58 - 62)), this.instantOn);
        this.instantOnBufferTime = wMSProperties.getPropertyInt(JSON.endsWith((String)"$ <$0<'\u001b;\u0014\">??)\b43:", (int)(85 + 120)), this.instantOnBufferTime);
        this.waitForBufferFill = wMSProperties.getPropertyBoolean(JSON.endsWith((String)"avqm\\tn_ky&$0\u0005-)*", (int)(42 - -12)), this.waitForBufferFill);
        this.waitForBufferKeyFrame = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(28 + 62), (String)"-:5)\u001802\u00037%\" 4\f-0\f9- +"), this.waitForBufferKeyFrame);
        this.behindDropDFrames = wMSProperties.getPropertyInt(JSON.endsWith((String)"+/#%#*\u000b\">\"\u0017\u0012'7:=*", (int)(39 * 15)), this.behindDropDFrames);
        this.behindDropPFrames = wMSProperties.getPropertyInt(Base64.lastIndexOf((int)(93 + 69), (String)"`fllhcL{e{\\K|n}ta"), this.behindDropPFrames);
        this.behindDropAudio = this.behindDropKFrames = wMSProperties.getPropertyInt(Base64.lastIndexOf((int)(107 + 50), (String)"\u007f{wiofGvjvLN{kfi~"), this.behindDropKFrames);
        this.behindDropAudio = wMSProperties.getPropertyInt(Base64.lastIndexOf((int)(867 / 224), (String)"aamoilMxd|L{ky~"), this.behindDropAudio);
        this.maximumLiveLatency = wMSProperties.getPropertyInt(Base64.lastIndexOf((int)(192 / 35), (String)"hg\u007fd`|nmxjf\u007f}sgq{un"), this.maximumLiveLatency);
        this.sendOriginalTimecodes = wMSProperties.getPropertyBoolean(JSON.endsWith((String)" 1;2\u0018*0=22<2\u000b),' +!#4", (int)(25 - -58)), this.sendOriginalTimecodes);
        this.referenceWritePacketSizeThreshold = wMSProperties.getPropertyInt(Base64.lastIndexOf((int)(37 * 63), (String)"iy{{meoafSwosmYkhghz\\ykwG|gsdpvv\u007f"), this.referenceWritePacketSizeThreshold);
        this.referenceWrite = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(833 / 215), (String)"qaccumgin[\u007fg{u"), this.referenceWrite);
        this.a = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(83 + -23), (String)"ys\u007f},$\u0006:*$+.+\u001a>9),#\u00021#96&&"), this.a);
        boolean bl = false;
        bl = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(23 * 13), (String)"oio{h_dft{|xpJMWKL|}t%5\u0016*) 5"), bl);
        if (!bl) {
            if (!this.isDebugLog) return;
        }
        this.b = new PacketTimecodeDebug();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean testVideoFrame(int n, int n2) {
        if ((n & 1 << ((n2 & 0x30) >> 4) - 1) == 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.workBuffer == null) {
            bl = true;
        } else if (this.workBuffer.length < n) {
            bl = true;
        }
        if (!bl) return;
        this.workBuffer = new byte[n];
    }

    /*
     * Enabled aggressive block sorting
     */
    protected AMFPacket getEnhanceSeekPacket(IMediaStream iMediaStream, int n, boolean bl) {
        AMFPacket aMFPacket = new AMFPacket(9, iMediaStream.getSrc(), 2);
        byte[] byArray = new byte[]{(byte)(0x50 | (byte)(n & 0xF)), (byte)(!bl ? 1 : 0)};
        aMFPacket.addData(byArray, 0, byArray.length);
        return aMFPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int playKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        this.startPacketsSent = this.packetsSent;
        synchronized (this.lock) {
            Client client = (Client)this.stream.getParent().getClient();
            int n2 = client.getSendChunkSize();
            this.checkWorkBuffer(n2);
            LivePlayer livePlayer = this;
            livePlayer.isEnhancedSeekCapable = livePlayer.isEnhancedSeekCapable(livePlayer.stream.getParent());
            if (this.a) {
                LivePlayer livePlayer2 = this;
                livePlayer2.isBurstCapable = livePlayer2.isBurstCapable(livePlayer2.stream.getParent());
            }
            int n3 = -1;
            AMFPacket aMFPacket = this.getLastKeyFrame(iMediaStream);
            if (aMFPacket != null) {
                long l = 0L;
                int n4 = aMFPacket.getFirstByte();
                n3 = FLVUtils.getVideoCodec((int)n4);
                if (!this.sentPlayStart) {
                    if (this.sendPlayStop) {
                        n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                        this.sendPlayStop = false;
                    }
                    n += this.stream.getParent().sendLivePlayStart(outputStream, this.stream.getParent().getName(), l, this.firstPacketTC);
                    this.sentPlayStart = true;
                    this.sendPlayStop = true;
                    this.stream.getParent().setSendPlayStopLogEvent(true);
                    WMSLoggerFactory.putGlobalLogValue((String)Base64.lastIndexOf((int)(48 - 17), (String)"g-rrlw"), (Object)new Long(0L));
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), Base64.lastIndexOf((int)(627 / 178), (String)"ppwcfe"), "play", 200, this.stream.getParent().getName());
                    this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playTransition);
                    aMFObj3.setNew(true);
                    aMFObj.setNew(true);
                    aMFObj2.setNew(true);
                }
                if (this.sendFirstKeyFrame) {
                    AMFPacket aMFPacket2;
                    AMFPacket aMFPacket3;
                    Object object;
                    IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                    if (iMediaStreamMetaDataProvider != null) {
                        ArrayList arrayList = new ArrayList();
                        long l2 = 0L;
                        iMediaStreamMetaDataProvider.onStreamStart(arrayList, l2);
                        if (arrayList.size() > 0) {
                            object = null;
                            AMFDataObj aMFDataObj = null;
                            object = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                            object.createSeekMessage(Base64.lastIndexOf((int)(105 + 122), (String)",*\u00162&<<9"));
                            object.setSrc(this.stream.getParent().getSrc());
                            object.setType(18);
                            object.setTimecode(l);
                            aMFDataObj = new AMFDataObj();
                            aMFDataObj.put(Base64.lastIndexOf((int)(19 + 122), (String)"naku"), (AMFData)new AMFDataItem(Base64.lastIndexOf((int)(18 + -10), (String)"Fl~Xx\u007fkn}?Vr`t8Dlxho")));
                            object.addBody((AMFData)aMFDataObj);
                            n += object.write(outputStream, true, n2);
                            for (AMFPacket aMFPacket4 : arrayList) {
                                n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket4, l, aMFObj3, this.workBuffer, n2);
                            }
                        }
                    }
                    boolean bl = false;
                    if (this.sendFirstVideoFrame) {
                        AMFPacket aMFPacket5 = iMediaStream.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                        if (aMFPacket5 != null) {
                            n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket5, l, aMFObj2, this.workBuffer, n2);
                        }
                        this.sendFirstVideoFrame = false;
                        bl = true;
                    }
                    if (bl && this.isEnhancedSeekCapable) {
                        LivePlayer livePlayer3 = this;
                        n += this.packetOutput(outputStream, this.stream.getParent(), livePlayer3.getEnhanceSeekPacket(livePlayer3.stream.getParent(), aMFPacket.getFirstByte(), true), l, aMFObj2, this.workBuffer, n2);
                    }
                    lArray[2] = lArray[2] + (long)aMFPacket.getSize();
                    lArray[3] = lArray[3] + 1L;
                    n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket, l, aMFObj2, this.workBuffer, n2);
                    if (bl && this.isEnhancedSeekCapable) {
                        LivePlayer livePlayer4 = this;
                        n += this.packetOutput(outputStream, this.stream.getParent(), livePlayer4.getEnhanceSeekPacket(livePlayer4.stream.getParent(), aMFPacket.getFirstByte(), false), l, aMFObj2, this.workBuffer, n2);
                    }
                    if ((aMFPacket3 = new AMFPacket(8, iMediaStream.getSrc(), 0)) != null) {
                        lArray[0] = lArray[0] + 0L;
                        lArray[1] = lArray[1] + 1L;
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket3, l, aMFObj, this.workBuffer, n2);
                        aMFObj.setNew(true);
                    }
                    if (n3 == 7 && (aMFPacket2 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
                        lArray[2] = lArray[2] + 5L;
                        lArray[3] = lArray[3] + 1L;
                        object = new byte[5];
                        object[0] = (ResponseFunction)23;
                        object[1] = (ResponseFunction)2;
                        object[2] = (ResponseFunction)false;
                        object[3] = (ResponseFunction)false;
                        object[4] = (ResponseFunction)false;
                        aMFPacket2.addData((byte[])object, 0, ((ResponseFunction)object).length);
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket2, l, aMFObj2, this.workBuffer, n2);
                    }
                    if (this.stream.getParent().isSendPlayStopLogEvent()) {
                        this.stream.getParent().setSendPlayStopLogEvent(false);
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), JSON.endsWith((String)"vrumhg", (int)(1351 / 248)), "stop", 200, this.stream.getParent().getName());
                        this.stream.getParent().notifyActionStop();
                    }
                    n += this.stream.getParent().sendPlayStatus(outputStream, l, 2, 0.0, 0.0);
                    n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                    this.sendPlayStop = false;
                    this.sendFirstKeyFrame = false;
                }
                this.playlistEnd = true;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (this.startPacketsSent == this.packetsSent) return n;
            this.sendBurstEnd(outputStream, this.stream.getParent());
            return n;
        }
    }

    protected List getPlayPackets(IMediaStream iMediaStream) {
        return iMediaStream.getPlayPackets();
    }

    protected AMFPacket getLastKeyFrame(IMediaStream iMediaStream) {
        return iMediaStream.getLastKeyFrame();
    }

    protected AMFPacket getLastPacket(IMediaStream iMediaStream) {
        return iMediaStream.getLastPacket();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected long[] getLastPacketTimecodes(List<AMFPacket> var1_1) {
        var2_2 = new long[]{-1L, -1L};
        var3_3 = var1_1.size() - 1;
        if (true) ** GOTO lbl8
        block0: while (true) {
            var2_2[1] = var6_6;
            while (var2_2[0] < 0L || var2_2[1] < 0L) {
                --var3_3;
lbl8:
                // 2 sources

                if (var3_3 < 0) return var2_2;
                var4_4 = var1_1.get(var3_3);
                var5_5 = var4_4.getType();
                var6_6 = var4_4.getAbsTimecode();
                if (var5_5 != 8) {
                    if (var5_5 != 9 || var2_2[1] != -1L) continue;
                    continue block0;
                }
                if (var2_2[0] != -1L) continue;
                var2_2[0] = var6_6;
            }
            break;
        }
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int playAll(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        this.startPacketsSent = this.packetsSent;
        n += this.playAllInternal(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        IMediaStream iMediaStream2 = null;
        LivePlayerSwitch livePlayerSwitch = this.liveSwitch.get();
        if (livePlayerSwitch != null && livePlayerSwitch.switchTimecodeFound) {
            this.sendPlaySwitch = true;
            this.sendFirstAudioFrame = true;
            this.sendFirstVideoFrame = true;
            this.lastSeq = livePlayerSwitch.switchVideoKeyFrameSeq;
            ((MediaStream)this.stream.getParent()).setJustName(livePlayerSwitch.getName());
            iMediaStream2 = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
            this.stream.getParent().getPlayer().switchPlay();
            this.liveSwitch.set(null);
        }
        if (iMediaStream2 != null) {
            n += this.playAllInternal(iMediaStream2, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        if (this.startPacketsSent == this.packetsSent) return n;
        this.sendBurstEnd(outputStream, this.stream.getParent());
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int playAllInternal(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, long[] var6_6) {
        var7_7 = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        var8_8 = true;
        var9_9 = true;
        var10_10 = -1;
        synchronized (this.stream.getParent()) {
            var8_8 = this.stream.getParent().isReceiveAudio();
            var9_9 = this.stream.getParent().isReceiveVideo();
            var10_10 = this.stream.getParent().getReceiveVideoFPS();
            // ** MonitorExit[var11_12] (shouldn't be in output)
            var11_11 = System.currentTimeMillis();
            if (this.b != null) {
                var13_13 = 0L;
                if (this.b.i >= 0L) {
                    var13_13 = var11_11 - this.b.i;
                }
                this.b.i = var11_11;
                var15_15 = JSON.endsWith((String)"\u0019?!=\t6:%8,qrrgm`^", (int)(2 - 13)) + this.stream.getParent().getContextStr() + JSON.endsWith((String)"\u0004`{.)d", (int)(33 * 57)) + var13_13;
                if (this.isDebugLog) {
                    WMSLoggerFactory.getLogger(null).debug((String)var15_15);
                } else {
                    WMSLoggerFactory.getLogger(null).info((String)var15_15);
                }
            }
            var13_14 = this.lock;
            synchronized (var13_14) {
                block139: {
                    block153: {
                        block151: {
                            block155: {
                                block149: {
                                    block186: {
                                        block185: {
                                            block187: {
                                                block152: {
                                                    block141: {
                                                        block147: {
                                                            block144: {
                                                                block184: {
                                                                    block135: {
                                                                        block180: {
                                                                            block143: {
                                                                                block148: {
                                                                                    block142: {
                                                                                        block183: {
                                                                                            block182: {
                                                                                                block181: {
                                                                                                    block150: {
                                                                                                        block156: {
                                                                                                            block146: {
                                                                                                                block145: {
                                                                                                                    block136: {
                                                                                                                        block138: {
                                                                                                                            block137: {
                                                                                                                                block158: {
                                                                                                                                    block159: {
                                                                                                                                        block157: {
                                                                                                                                            block154: {
                                                                                                                                                var14_18 = this.liveSwitch.get();
                                                                                                                                                var15_15 = this.getPlayPackets(var1_1);
                                                                                                                                                var16_19 = var1_1.getLastKeyFrame();
                                                                                                                                                if (this.checkStreamProperties) {
                                                                                                                                                    v0 = this;
                                                                                                                                                    v0.isEnhancedSeekCapable = v0.isEnhancedSeekCapable(v0.stream.getParent());
                                                                                                                                                    if (this.a) {
                                                                                                                                                        v1 = this;
                                                                                                                                                        v1.isBurstCapable = v1.isBurstCapable(v1.stream.getParent());
                                                                                                                                                    }
                                                                                                                                                    if ((var17_20 = this.stream.getParent().getClient()) != null && var17_20.getLiveRepeaterCapabilities() > 0) {
                                                                                                                                                        this.sendOriginalTimecodes = true;
                                                                                                                                                    }
                                                                                                                                                    this.checkStreamProperties = false;
                                                                                                                                                }
                                                                                                                                                var17_20 = (Client)this.stream.getParent().getClient();
                                                                                                                                                var18_21 = var17_20.getSendChunkSize();
                                                                                                                                                var19_22 = 7;
                                                                                                                                                var20_23 = false;
                                                                                                                                                var21_24 = 0L;
                                                                                                                                                var23_25 = null;
                                                                                                                                                var24_26 = null;
                                                                                                                                                var25_27 = var17_20.getWriteListener();
                                                                                                                                                var26_28 = Base64.lastIndexOf((int)(14 + 60), (String)"9?>(/\"") + this.stream.getParent().getSrc();
                                                                                                                                                var27_29 = var15_15.size();
                                                                                                                                                if (var27_29 != 0) break block154;
                                                                                                                                                this.bufferEmptyOnce = true;
                                                                                                                                                break block155;
                                                                                                                                            }
                                                                                                                                            var28_31 = (AMFPacket)var15_15.get(0);
                                                                                                                                            if (!this.waitForBufferFill || !this.sendFirstKeyFrame) break block156;
                                                                                                                                            var29_34 = true;
                                                                                                                                            var30_35 = Math.min((long)this.stream.getParent().getBufferTime(), (long)this.maximumLiveLatency);
                                                                                                                                            if (this.waitForBufferFillStarTime == -1L) break block157;
                                                                                                                                            if (var11_11 - this.waitForBufferFillStarTime <= var30_35 || this.waitForBufferKeyFrame) break block158;
                                                                                                                                            break block159;
                                                                                                                                        }
                                                                                                                                        this.waitForBufferFillStarTime = var11_11;
                                                                                                                                        break block158;
                                                                                                                                    }
                                                                                                                                    var29_34 = false;
                                                                                                                                }
                                                                                                                                if (!var29_34 || var30_35 <= 0L) break block156;
                                                                                                                                var32_40 = (AMFPacket)var15_15.get(var27_29 - 1);
                                                                                                                                if (var32_40.getAbsTimecode() - var28_31.getAbsTimecode() < var30_35) break block155;
                                                                                                                                if (!this.waitForBufferKeyFrame || var16_19 != null) break block156;
                                                                                                                                var33_42 = 0;
                                                                                                                                var34_44 = 0;
                                                                                                                                ** GOTO lbl519
lbl79:
                                                                                                                                // 1 sources

                                                                                                                                while ((var28_31 = (AMFPacket)var15_15.get(var31_36)).getSeq() != this.lastSeq + 1L) {
                                                                                                                                    this.waitForKeyFrame = true;
                                                                                                                                    break block135;
                                                                                                                                }
                                                                                                                                break block135;
                                                                                                                                while (true) {
                                                                                                                                    if (var49_97 != 7 || var55_124.getSize() < 5) {
                                                                                                                                        var56_128 = var55_124.getFirstByte();
                                                                                                                                        if (FLVUtils.getFrameType((int)var56_128) == 3) {
                                                                                                                                            break block136;
                                                                                                                                        }
                                                                                                                                    } else {
                                                                                                                                        var55_124 = var55_124.clone(true);
                                                                                                                                        var56_130 = var55_124.getData();
                                                                                                                                        var57_131 = FLVUtils.getVideoTimecodeOffset((byte[])var56_130);
                                                                                                                                        var57_131 = (int)((long)var57_131 + (var55_124.getAbsTimecode() - var28_31.getAbsTimecode()));
                                                                                                                                        BufferUtils.intToByteArray((int)var57_131, (byte[])var56_130, (int)2, (int)3);
                                                                                                                                    }
                                                                                                                                    var6_6[2] = var6_6[2] + (long)var55_124.getSize();
                                                                                                                                    var6_6[3] = var6_6[3] + 1L;
                                                                                                                                    var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var55_124, var42_69, var4_4, this.workBuffer, var18_21);
                                                                                                                                    ++var53_113;
                                                                                                                                    break block136;
                                                                                                                                    break;
                                                                                                                                }
lbl99:
                                                                                                                                // 1 sources

                                                                                                                                while (true) {
                                                                                                                                    v2 = 0L;
                                                                                                                                    ** GOTO lbl492
                                                                                                                                    break;
                                                                                                                                }
lbl102:
                                                                                                                                // 1 sources

                                                                                                                                while (true) {
                                                                                                                                    this.stream.getParent().setSendPlayStopLogEvent(false);
                                                                                                                                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), JSON.endsWith((String)"uszlkf", (int)(198 / 32)), "stop", 200, this.stream.getParent().getName());
                                                                                                                                    this.stream.getParent().notifyActionStop();
                                                                                                                                    ** GOTO lbl382
                                                                                                                                    break;
                                                                                                                                }
lbl107:
                                                                                                                                // 2 sources

                                                                                                                                while (true) {
                                                                                                                                    if (var42_69 < 0L) break block137;
                                                                                                                                    var39_61 = var4_4;
                                                                                                                                    this.lastTC = var42_69;
                                                                                                                                    this.lastVideoTC = var42_69;
                                                                                                                                    if (!var9_9 && var47_84 == 7) {
                                                                                                                                        var49_103 = Math.min(var28_31.getSize(), 5);
                                                                                                                                        var28_31 = var28_31.clone();
                                                                                                                                        var28_31.truncatePacket(var49_103);
                                                                                                                                    }
                                                                                                                                    var45_75 = var28_31.getSize();
                                                                                                                                    var6_6[2] = var6_6[2] + (long)var45_75;
                                                                                                                                    var6_6[3] = var6_6[3] + 1L;
                                                                                                                                    break block137;
lbl120:
                                                                                                                                    // 2 sources

                                                                                                                                    while (true) {
                                                                                                                                        var47_86 = new AMFPacket(8, var1_1.getSrc(), 0);
                                                                                                                                        if (var47_86 != null) {
                                                                                                                                            var6_6[0] = var6_6[0] + 0L;
                                                                                                                                            var6_6[1] = var6_6[1] + 1L;
                                                                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var47_86, var42_69, var3_3, this.workBuffer, var18_21);
                                                                                                                                        }
                                                                                                                                        this.lastReceiveAudio = var8_8;
                                                                                                                                        ** GOTO lbl267
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    break;
                                                                                                                                }
lbl128:
                                                                                                                                // 1 sources

                                                                                                                                while (true) {
                                                                                                                                    if (var39_60 != -1L) break block138;
                                                                                                                                    var39_60 = var49_98;
                                                                                                                                    break block138;
                                                                                                                                    break;
                                                                                                                                }
lbl132:
                                                                                                                                // 2 sources

                                                                                                                                while (true) {
                                                                                                                                    if (var14_18.switchMode == -1) {
                                                                                                                                        if (var14_18.getPlayerTransition() == 12) {
                                                                                                                                            var14_18.switchMode = 1;
                                                                                                                                        }
                                                                                                                                        var38_53 = 0L;
                                                                                                                                        if (var14_18.switchMode == -1) {
                                                                                                                                            var40_67 = 1;
                                                                                                                                            if (var37_52 != null && var37_52.size() > 0) {
                                                                                                                                                var41_66 = this.getLastPacketTimecodes((List<AMFPacket>)var15_15);
                                                                                                                                                var42_71 = this.getLastPacketTimecodes(var37_52);
                                                                                                                                                var43_73 = -1L;
                                                                                                                                                var45_77 = false;
                                                                                                                                                var46_80 = -1L;
                                                                                                                                                var48_92 = 0;
                                                                                                                                                if (var41_66[0] >= 0L && var42_71[0] >= 0L) {
                                                                                                                                                    var43_73 = var42_71[0] - var41_66[0];
                                                                                                                                                    var45_77 = true;
                                                                                                                                                }
                                                                                                                                                if (var41_66[1] >= 0L && var42_71[1] >= 0L) {
                                                                                                                                                    var46_80 = var42_71[1] - var41_66[1];
                                                                                                                                                    var48_92 = 1;
                                                                                                                                                }
                                                                                                                                                var38_53 = !var45_77 || var48_92 == 0 ? (var48_92 != 0 ? var46_80 : var43_73) : (Math.abs(var46_80) >= Math.abs(var43_73) ? var43_73 : var46_80);
                                                                                                                                                if (Math.abs(var38_53) <= (long)var35_46) {
                                                                                                                                                    var40_67 = 0;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            var14_18.switchMode = var40_67;
                                                                                                                                        }
                                                                                                                                        switch (var14_18.switchMode) {
                                                                                                                                            case 0: {
                                                                                                                                                var14_18.switchTimecodeOffset = 0L;
                                                                                                                                                ** break;
                                                                                                                                            }
                                                                                                                                            case 1: {
                                                                                                                                                var14_18.switchTimecodeOffset = var38_53;
                                                                                                                                                ** break;
                                                                                                                                            }
                                                                                                                                            default: {
                                                                                                                                                if (var14_18.lastSeq != -1L) break block139;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    } else if (var14_18.lastSeq != -1L) break block139;
                                                                                                                                    if (var37_52 == null || (var38_57 = var37_52.size()) <= 0) break block139;
                                                                                                                                    var39_60 = -1L;
                                                                                                                                    var41_65 = -1L;
                                                                                                                                    var43_73 = -1L;
                                                                                                                                    var45_76 = -1L;
                                                                                                                                    var47_87 = var31_36;
                                                                                                                                    ** GOTO lbl421
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                while (true) {
                                                                                                                                    var53_113 = 0;
                                                                                                                                    var54_119 = var52_111;
                                                                                                                                    ** GOTO lbl505
                                                                                                                                    break;
                                                                                                                                }
lbl178:
                                                                                                                                // 2 sources

                                                                                                                                while (true) {
                                                                                                                                    this.trackerStartSeq = var24_26.trackerSeq;
                                                                                                                                    this.sendFirstKeyFrame = false;
                                                                                                                                    this.lastReceiveAudio = var8_8;
                                                                                                                                    this.lastReceiveVideo = var9_9;
                                                                                                                                    this.lastReceiveVideoFPS = var10_10;
                                                                                                                                    ** GOTO lbl267
                                                                                                                                    break;
                                                                                                                                }
lbl185:
                                                                                                                                // 2 sources

                                                                                                                                while (true) {
                                                                                                                                    if (var48_90 && var52_111 >= 0 && var52_111 < var27_29) ** continue;
lbl187:
                                                                                                                                    // 3 sources

                                                                                                                                    while (true) {
                                                                                                                                        if (var46_78 && this.isEnhancedSeekCapable) {
                                                                                                                                            v3 = this;
                                                                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v3.getEnhanceSeekPacket(v3.stream.getParent(), var23_25.getFirstByte(), false), var42_69, var39_61, this.workBuffer, var18_21);
                                                                                                                                        }
                                                                                                                                        var46_78 = false;
                                                                                                                                        ** GOTO lbl178
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                while (true) {
                                                                                                                                    var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var47_86, var42_69, var39_61, this.workBuffer, var18_21);
                                                                                                                                    ** GOTO lbl312
                                                                                                                                    break;
                                                                                                                                }
lbl196:
                                                                                                                                // 2 sources

                                                                                                                                while (true) {
                                                                                                                                    if (!var9_9) {
                                                                                                                                        var23_25 = null;
                                                                                                                                    }
                                                                                                                                    if (var23_25 != null) ** break;
                                                                                                                                    ** continue;
                                                                                                                                    if (this.sendFirstVideoFrame) {
                                                                                                                                        var49_101 = var1_1.getVideoCodecConfigPacket(var23_25.getAbsTimecode());
                                                                                                                                        if (var49_101 != null) {
                                                                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var49_101, var42_69, var39_61, this.workBuffer, var18_21);
                                                                                                                                        }
                                                                                                                                        this.sendFirstVideoFrame = false;
                                                                                                                                        var46_78 = true;
                                                                                                                                    }
                                                                                                                                    if (var46_78 && this.isEnhancedSeekCapable) {
                                                                                                                                        v4 = this;
                                                                                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v4.getEnhanceSeekPacket(v4.stream.getParent(), var23_25.getFirstByte(), true), var42_69, var39_61, this.workBuffer, var18_21);
                                                                                                                                    }
                                                                                                                                    var6_6[2] = var6_6[2] + (long)var23_25.getSize();
                                                                                                                                    var6_6[3] = var6_6[3] + 1L;
                                                                                                                                    var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var23_25, var42_69, var4_4, this.workBuffer, var18_21);
                                                                                                                                    var4_4.setNew(true);
                                                                                                                                    var49_97 = FLVUtils.getVideoCodec((AMFPacket)var23_25);
                                                                                                                                    if (!this.isEnhancedSeekCapable) ** GOTO lbl187
                                                                                                                                    var50_104 = var23_25.getSeq();
                                                                                                                                    var52_111 = (int)(var50_104 - var29_32 + 1L);
                                                                                                                                    if (!var48_90) ** GOTO lbl185
                                                                                                                                    this.waitForKeyFrame = false;
                                                                                                                                    ** continue;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                            }
lbl222:
                                                                                                                            // 10 sources

                                                                                                                            while (true) {
                                                                                                                                block173: {
                                                                                                                                    block172: {
                                                                                                                                        block160: {
                                                                                                                                            block140: {
                                                                                                                                                block171: {
                                                                                                                                                    block170: {
                                                                                                                                                        block166: {
                                                                                                                                                            block165: {
                                                                                                                                                                block169: {
                                                                                                                                                                    block168: {
                                                                                                                                                                        block167: {
                                                                                                                                                                            block162: {
                                                                                                                                                                                block163: {
                                                                                                                                                                                    block164: {
                                                                                                                                                                                        block161: {
                                                                                                                                                                                            if (var45_75 > 0) {
                                                                                                                                                                                                this.avgPacketSizeTotal -= (long)this.avgPacketSizes[(int)(this.avgPacketSizeCount % (long)this.avgPacketSizes.length)];
                                                                                                                                                                                                this.avgPacketSizeTotal += (long)var45_75;
                                                                                                                                                                                                this.avgPacketSizes[(int)(this.avgPacketSizeCount % (long)this.avgPacketSizes.length)] = var45_75;
                                                                                                                                                                                                ++this.avgPacketSizeCount;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (var39_61 == null) break block160;
                                                                                                                                                                                            if (!this.sentPlayStart) {
                                                                                                                                                                                                if (this.sendPlayStop) {
                                                                                                                                                                                                    var7_7 += this.stream.getParent().sendPlayStop(var2_2, var42_69, this.stream.getParent().getName());
                                                                                                                                                                                                    this.sendPlayStop = false;
                                                                                                                                                                                                }
                                                                                                                                                                                                var7_7 += this.stream.getParent().sendLivePlayStart(var2_2, this.stream.getParent().getName(), var42_69, this.sendOriginalTimecodes != false ? 0L : this.firstPacketTC);
                                                                                                                                                                                                this.sentPlayStart = true;
                                                                                                                                                                                                this.sendPlayStop = true;
                                                                                                                                                                                                this.stream.getParent().setSendPlayStopLogEvent(true);
                                                                                                                                                                                                WMSLoggerFactory.putGlobalLogValue((String)Base64.lastIndexOf((int)(24 - 19), (String)"}+txfy"), (Object)new Long(0L));
                                                                                                                                                                                                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), JSON.endsWith((String)"vrumhg", (int)(863 / 170)), "play", 200, this.stream.getParent().getName());
                                                                                                                                                                                                this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playTransition);
                                                                                                                                                                                                var5_5.setNew(true);
                                                                                                                                                                                                var3_3.setNew(true);
                                                                                                                                                                                                var4_4.setNew(true);
                                                                                                                                                                                            }
                                                                                                                                                                                            if (this.sendPlaySwitch) {
                                                                                                                                                                                                this.sendPlaySwitch = false;
                                                                                                                                                                                                var7_7 += this.stream.getParent().sendLivePlaySwitch(var2_2, var1_1.getName(), var42_69);
                                                                                                                                                                                                var46_81 = var1_1.getMetaDataProvider();
                                                                                                                                                                                                var47_88 = new ArrayList<E>();
                                                                                                                                                                                                var48_95 = var28_31.getAbsTimecode();
                                                                                                                                                                                                var46_81.onStreamStart(var47_88, var48_95);
                                                                                                                                                                                                if (var47_88.size() > 0) {
                                                                                                                                                                                                    for (AMFPacket var51_108 : var47_88) {
                                                                                                                                                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var51_108, var42_69, var5_5, this.workBuffer, var18_21);
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                            if (var24_26 == null) {
                                                                                                                                                                                                var24_26 = new LiveTracker();
                                                                                                                                                                                                var24_26.firstTC = var40_68;
                                                                                                                                                                                            }
                                                                                                                                                                                            var24_26.lastTC = var40_68;
                                                                                                                                                                                            var46_78 = false;
                                                                                                                                                                                            if (!this.sendFirstKeyFrame) break block161;
                                                                                                                                                                                            var47_83 = var1_1.getMetaDataProvider();
                                                                                                                                                                                            if (var47_83 == null) break block162;
                                                                                                                                                                                            break block163;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (this.lastReceiveAudio == var8_8) break block164;
                                                                                                                                                                                        if (!var8_8) ** GOTO lbl120
                                                                                                                                                                                        break block165;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (!this.sendFirstAudioFrame && !this.sendFirstVideoFrame) break block166;
                                                                                                                                                                                    break block167;
                                                                                                                                                                                }
                                                                                                                                                                                var48_96 = new ArrayList<E>();
                                                                                                                                                                                var49_99 = var28_31.getAbsTimecode();
                                                                                                                                                                                var47_83.onStreamStart(var48_96, var49_99);
                                                                                                                                                                                if (var48_96.size() > 0) {
                                                                                                                                                                                    var51_110 = null;
                                                                                                                                                                                    var52_112 = null;
                                                                                                                                                                                    var51_110 = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                                                                                                                                                                                    var51_110.createSeekMessage(Base64.lastIndexOf((int)(1064 / 166), (String)"ii[}k\u007fy~"));
                                                                                                                                                                                    var51_110.setSrc(this.stream.getParent().getSrc());
                                                                                                                                                                                    var51_110.setType(18);
                                                                                                                                                                                    var51_110.setTimecode(var42_69);
                                                                                                                                                                                    var52_112 = new AMFDataObj();
                                                                                                                                                                                    var52_112.put(Base64.lastIndexOf((int)(39 * 37), (String)"`kac"), (AMFData)new AMFDataItem(JSON.endsWith((String)"\r!1\u00153:,+&b\t/;1\u007f\u0001'5'\"", (int)(21 - -46))));
                                                                                                                                                                                    var51_110.addBody((AMFData)var52_112);
                                                                                                                                                                                    var7_7 += var51_110.write(var2_2, true, var18_21);
                                                                                                                                                                                    for (AMFPacket var54_123 : var48_96) {
                                                                                                                                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var54_123, var42_69, var5_5, this.workBuffer, var18_21);
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            var48_90 = true;
                                                                                                                                                                            if (var23_25 != null) ** GOTO lbl196
                                                                                                                                                                            var23_25 = this.getLastKeyFrame(var1_1);
                                                                                                                                                                            var48_90 = false;
                                                                                                                                                                            ** continue;
                                                                                                                                                                        }
                                                                                                                                                                        if (var44_74 == 8 && this.sendFirstAudioFrame) break block168;
                                                                                                                                                                        if (var44_74 != 9 || !this.sendFirstVideoFrame) break block166;
                                                                                                                                                                        break block169;
                                                                                                                                                                    }
                                                                                                                                                                    var47_86 = new AMFPacket(8, var1_1.getSrc(), 0);
                                                                                                                                                                    if (var47_86 != null) {
                                                                                                                                                                        var6_6[0] = var6_6[0] + 0L;
                                                                                                                                                                        var6_6[1] = var6_6[1] + 1L;
                                                                                                                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var47_86, var42_69, var3_3, this.workBuffer, var18_21);
                                                                                                                                                                        var3_3.setNew(true);
                                                                                                                                                                    }
                                                                                                                                                                    if ((var48_94 = var1_1.getAudioCodecConfigPacket(var28_31.getAbsTimecode())) != null) {
                                                                                                                                                                        var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var48_94, var42_69, var39_61, this.workBuffer, var18_21);
                                                                                                                                                                    }
                                                                                                                                                                    this.sendFirstAudioFrame = false;
                                                                                                                                                                    break block166;
                                                                                                                                                                }
                                                                                                                                                                if ((var47_86 = var1_1.getVideoCodecConfigPacket(var28_31.getAbsTimecode())) != null) ** continue;
lbl312:
                                                                                                                                                                // 2 sources

                                                                                                                                                                this.sendFirstVideoFrame = false;
                                                                                                                                                                var46_78 = true;
                                                                                                                                                                break block166;
                                                                                                                                                            }
                                                                                                                                                            var7_7 += this.stream.getParent().sendLivePlaySeek(var2_2, this.stream.getParent().getName(), var42_69);
                                                                                                                                                            ** continue;
                                                                                                                                                        }
                                                                                                                                                        if (this.b == null) break block140;
                                                                                                                                                        var47_89 = System.currentTimeMillis();
                                                                                                                                                        if (var44_74 == 8) break block170;
                                                                                                                                                        if (var44_74 != 9) break block140;
                                                                                                                                                        if (this.b.d < 30) break block171;
                                                                                                                                                        var49_100 = StringUtils.intToHexStr((int)(var28_31.getFirstByte() & 255), (int)2);
                                                                                                                                                        var50_105 = StringUtils.intToStr((int)var28_31.getSize(), (int)5);
                                                                                                                                                        var51_106 = this.b.a + (var42_69 - this.b.b) - var47_89;
                                                                                                                                                        var53_116 = var51_106 + "";
                                                                                                                                                        if (var51_106 > 0L) {
                                                                                                                                                            var53_116 = " " + var51_106;
                                                                                                                                                        }
                                                                                                                                                        var54_120 = var42_69 - this.b.c;
                                                                                                                                                        var56_126 = Base64.lastIndexOf((int)(31 * 23), (String)"\u0005#=)\u001d\".)4 }\"<227\u0002") + this.stream.getParent().getContextStr() + JSON.endsWith((String)"V6-fkb+\"k", (int)(9 + 2)) + var49_100 + Base64.lastIndexOf((int)(-65 - -64), (String)"\u007fs{8") + (String)var50_105 + Base64.lastIndexOf((int)(32 - 46), (String)"r'7") + var42_69 + "/" + var54_120 + ":" + var47_89 + ":" + var53_116;
                                                                                                                                                        if (this.isDebugLog) {
                                                                                                                                                            WMSLoggerFactory.getLogger(null).debug(var56_126);
                                                                                                                                                        } else {
                                                                                                                                                            WMSLoggerFactory.getLogger(null).info(var56_126);
                                                                                                                                                        }
                                                                                                                                                        this.b.c = var42_69;
                                                                                                                                                        break block140;
                                                                                                                                                    }
                                                                                                                                                    if (this.b.h >= 30) {
                                                                                                                                                        var49_102 = StringUtils.intToHexStr((int)(var28_31.getFirstByte() & 255), (int)2);
                                                                                                                                                        var50_105 = StringUtils.intToStr((int)var28_31.getSize(), (int)5);
                                                                                                                                                        var51_109 = this.b.e + (var42_69 - this.b.f) - var47_89;
                                                                                                                                                        var53_117 = var51_109 + "";
                                                                                                                                                        if (var51_109 > 0L) {
                                                                                                                                                            var53_117 = " " + var51_109;
                                                                                                                                                        }
                                                                                                                                                        var54_122 = var42_69 - this.b.g;
                                                                                                                                                        var56_129 = JSON.endsWith((String)"Ge{k_|pkvf;wb|pu@", (int)(29 - 18)) + this.stream.getParent().getContextStr() + Base64.lastIndexOf((int)(680 / 105), (String)"[=(any6=v") + var49_102 + Base64.lastIndexOf((int)(63 * 57), (String)"'{s0") + (String)var50_105 + JSON.endsWith((String)"w,:", (int)(59 - -28)) + var42_69 + "/" + var54_122 + ":" + var47_89 + ":" + var53_117;
                                                                                                                                                        if (this.isDebugLog) {
                                                                                                                                                            WMSLoggerFactory.getLogger(null).debug(var56_129);
                                                                                                                                                        } else {
                                                                                                                                                            WMSLoggerFactory.getLogger(null).info(var56_129);
                                                                                                                                                        }
                                                                                                                                                        this.b.g = var42_69;
                                                                                                                                                        break block140;
                                                                                                                                                    } else {
                                                                                                                                                        this.b.e = var47_89;
                                                                                                                                                        this.b.f = var42_69;
                                                                                                                                                        ++this.b.h;
                                                                                                                                                        this.b.g = var42_69;
                                                                                                                                                    }
                                                                                                                                                    break block140;
                                                                                                                                                }
                                                                                                                                                this.b.a = var47_89;
                                                                                                                                                this.b.b = var42_69;
                                                                                                                                                this.b.c = var42_69;
                                                                                                                                                ++this.b.d;
                                                                                                                                            }
                                                                                                                                            if (var46_78 && this.isEnhancedSeekCapable) {
                                                                                                                                                v5 = this;
                                                                                                                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v5.getEnhanceSeekPacket(v5.stream.getParent(), var28_31.getFirstByte(), true), var42_69, var39_61, this.workBuffer, var18_21);
                                                                                                                                            }
                                                                                                                                            var7_7 += this.packetOutput(var2_2, this.stream.getParent(), var28_31, var42_69, var39_61, this.workBuffer, var18_21);
                                                                                                                                            if (var46_78 && this.isEnhancedSeekCapable) {
                                                                                                                                                v6 = this;
                                                                                                                                                var7_7 += this.packetOutput(var2_2, this.stream.getParent(), v6.getEnhanceSeekPacket(v6.stream.getParent(), var28_31.getFirstByte(), false), var42_69, var39_61, this.workBuffer, var18_21);
                                                                                                                                            }
                                                                                                                                            var46_78 = false;
                                                                                                                                        }
                                                                                                                                        var36_51 = var28_31.getSeq();
                                                                                                                                        if (!(this.playLen > 0.0) || var42_69 < Math.round(this.playLen)) break block172;
                                                                                                                                        if (this.stream.getParent().isSendPlayStopLogEvent()) {
                                                                                                                                            ** continue;
                                                                                                                                        }
                                                                                                                                        break block173;
                                                                                                                                    }
                                                                                                                                    ++var38_55;
                                                                                                                                    ** GOTO lbl662
                                                                                                                                }
                                                                                                                                var7_7 += this.stream.getParent().sendPlayStatus(var2_2, var42_69, 2, 0.0, 0.0);
                                                                                                                                var7_7 += this.stream.getParent().sendPlayStop(var2_2, var42_69, this.stream.getParent().getName());
                                                                                                                                this.playlistEnd = true;
                                                                                                                                break block141;
                                                                                                                                break;
                                                                                                                            }
lbl387:
                                                                                                                            // 1 sources

                                                                                                                            while (var41_62) {
                                                                                                                                var23_25 = var28_31;
                                                                                                                                if (this.instantOnBufferTime > 0 && var32_39 - var39_60 < (long)this.instantOnBufferTime) break block142;
                                                                                                                                break block143;
                                                                                                                            }
                                                                                                                            break block142;
lbl392:
                                                                                                                            // 1 sources

                                                                                                                            while (true) {
                                                                                                                                var41_65 = var56_127;
                                                                                                                                ** GOTO lbl729
                                                                                                                                break;
                                                                                                                            }
lbl395:
                                                                                                                            // 2 sources

                                                                                                                            while (true) {
                                                                                                                                block175: {
                                                                                                                                    block176: {
                                                                                                                                        block174: {
                                                                                                                                            if (!var48_93) break block174;
                                                                                                                                            if (!this.waitForKeyFrame) break block175;
                                                                                                                                            break block176;
                                                                                                                                        }
                                                                                                                                        var45_75 = var28_31.getSize();
                                                                                                                                        var6_6[6] = var6_6[6] + (long)var45_75;
                                                                                                                                        var6_6[7] = var6_6[7] + 1L;
                                                                                                                                        ** GOTO lbl222
                                                                                                                                    }
                                                                                                                                    if (!FLVUtils.isVideoKeyFrame((AMFPacket)var28_31)) ** GOTO lbl222
                                                                                                                                    WMSLoggerFactory.getLogger(LivePlayer.class).debug(JSON.endsWith((String)"rgn|OeyGhwIbp\u007fv.5pxmw~", (int)(893 / 177)));
                                                                                                                                    this.waitForKeyFrame = false;
                                                                                                                                }
                                                                                                                                if (this.firstPacketTC == -1L) {
                                                                                                                                    var42_69 = 0L;
                                                                                                                                    this.firstPacketTC = var40_68;
                                                                                                                                } else {
                                                                                                                                    var42_69 = var40_68 - this.firstPacketTC;
                                                                                                                                }
                                                                                                                                if (!this.sendOriginalTimecodes) ** GOTO lbl107
                                                                                                                                var42_69 = var40_68;
                                                                                                                                ** continue;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        var41_65 = var49_98;
                                                                                                                        while (true) {
                                                                                                                            block178: {
                                                                                                                                block177: {
                                                                                                                                    ++var47_87;
lbl421:
                                                                                                                                    // 2 sources

                                                                                                                                    if (var47_87 >= var27_29) break block177;
                                                                                                                                    var28_31 = (AMFPacket)var15_15.get(var47_87);
                                                                                                                                    var48_92 = var28_31.getType();
                                                                                                                                    var49_98 = var28_31.getAbsTimecode();
                                                                                                                                    if (var48_92 == 8) {
                                                                                                                                        ** continue;
                                                                                                                                    }
                                                                                                                                    break block178;
                                                                                                                                }
                                                                                                                                var47_85 = var45_76 - var43_73;
                                                                                                                                var49_98 = var41_65 - var39_60;
                                                                                                                                var51_107 = Math.max(var47_85, var49_98);
                                                                                                                                var39_60 = -1L;
                                                                                                                                var41_65 = -1L;
                                                                                                                                var43_73 = -1L;
                                                                                                                                var45_76 = -1L;
                                                                                                                                var53_115 = -1;
                                                                                                                                var54_121 = var38_57 - 1;
                                                                                                                                ** GOTO lbl730
                                                                                                                            }
                                                                                                                            if (var48_92 != 9) continue;
                                                                                                                            if (var43_73 == -1L) {
                                                                                                                                var43_73 = var49_98;
                                                                                                                            }
                                                                                                                            var45_76 = var49_98;
                                                                                                                        }
lbl445:
                                                                                                                        // 2 sources

                                                                                                                        while (true) {
                                                                                                                            var39_61 = var5_5;
                                                                                                                            this.lastTC = var42_69;
                                                                                                                            this.lastDataTC = var42_69;
                                                                                                                            var6_6[4] = var6_6[4] + (long)var28_31.getSize();
                                                                                                                            var6_6[5] = var6_6[5] + 1L;
                                                                                                                            ** GOTO lbl222
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        while (true) {
                                                                                                                            v7 = (int)(var14_18.lastSeq - var39_60 + 1L);
                                                                                                                            ** GOTO lbl553
                                                                                                                            break;
                                                                                                                        }
lbl455:
                                                                                                                        // 2 sources

                                                                                                                        while (true) {
                                                                                                                            var48_93 = v8;
                                                                                                                            if (var48_93) ** GOTO lbl395
                                                                                                                            var48_93 = this.testVideoFrame(var19_22, var46_79);
                                                                                                                            ** continue;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        while (true) {
                                                                                                                            block179: {
                                                                                                                                if (var21_24 <= (long)this.behindDropPFrames) break block179;
                                                                                                                                var19_22 = 1;
                                                                                                                                ** GOTO lbl570
                                                                                                                            }
                                                                                                                            if (var21_24 <= (long)this.behindDropDFrames) ** GOTO lbl570
                                                                                                                            var19_22 = 3;
                                                                                                                            ** GOTO lbl570
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        while (true) {
                                                                                                                            if (var9_9) {
                                                                                                                                this.waitForKeyFrame = true;
                                                                                                                            }
                                                                                                                            this.lastReceiveVideo = var9_9;
                                                                                                                            ** GOTO lbl659
                                                                                                                            break;
                                                                                                                        }
lbl473:
                                                                                                                        // 2 sources

                                                                                                                        while (true) {
                                                                                                                            this.lastTCOffset = var21_24;
                                                                                                                            var34_43 = var10_10;
                                                                                                                            if (var34_43 < -1) {
                                                                                                                                if (var34_43 != -2 || var19_22 != 7) {
                                                                                                                                    if (var34_43 == -3 && (var19_22 == 7 || var19_22 == 3)) {
                                                                                                                                        var19_22 = 1;
                                                                                                                                        this.waitForKeyFrame = true;
                                                                                                                                    }
                                                                                                                                } else {
                                                                                                                                    var19_22 = 3;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            var35_46 = 300;
                                                                                                                            if (var14_18 == null) break block144;
                                                                                                                            var36_49 = this.stream.getParent().getStreams().getStream(var14_18.getName());
                                                                                                                            var37_52 = null;
                                                                                                                            if (var36_49 == null) ** GOTO lbl132
                                                                                                                            var37_52 = var36_49.getPlayPackets();
                                                                                                                            ** continue;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        while (true) {
                                                                                                                            v2 = var29_33 - this.lastSendTime;
lbl492:
                                                                                                                            // 2 sources

                                                                                                                            var31_37 = v2;
                                                                                                                            this.lastSendTime = var29_33;
                                                                                                                            WMSLoggerFactory.getLogger(LivePlayer.class).debug(JSON.endsWith((String)">+!4\n", (int)(-64 - -13)) + this.stream.getParent().getClientId() + JSON.endsWith((String)"\u000enu%>\"<`", (int)(94 + 21)) + var7_7 + ":" + var27_30 + JSON.endsWith((String)"d#/+<,8q", (int)(-18 - 10)) + var19_22 + Base64.lastIndexOf((int)(22 - 50), (String)"d1/*-s") + var31_37 + JSON.endsWith((String)"7lV|}oxj%", (int)(97 + 54)) + var21_24 + JSON.endsWith((String)"#vrts2", (int)(821 / 225)) + this.referenceWrite);
                                                                                                                            ** GOTO lbl650
                                                                                                                            break;
                                                                                                                        }
lbl496:
                                                                                                                        // 2 sources

                                                                                                                        while (true) {
                                                                                                                            this.lastTCFilter = var19_22;
                                                                                                                            ** GOTO lbl473
                                                                                                                            break;
                                                                                                                        }
lbl499:
                                                                                                                        // 1 sources

                                                                                                                        while (true) {
                                                                                                                            if (++var33_42 <= 2) break block145;
                                                                                                                            break block146;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    while (true) {
                                                                                                                        ++var54_119;
lbl505:
                                                                                                                        // 2 sources

                                                                                                                        if (var54_119 < var38_55) ** break;
                                                                                                                        ** continue;
                                                                                                                        if ((var55_124 = (AMFPacket)var15_15.get(var54_119)).getType() == 9) ** continue;
                                                                                                                    }
                                                                                                                    while (true) {
                                                                                                                        var45_76 = var56_127;
                                                                                                                        ** GOTO lbl729
                                                                                                                        break;
                                                                                                                    }
lbl512:
                                                                                                                    // 2 sources

                                                                                                                    while (true) {
                                                                                                                        if (var42_69 >= 0L) ** GOTO lbl445
                                                                                                                        var42_69 = 0L;
                                                                                                                        ** continue;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                }
                                                                                                                do {
                                                                                                                    ++var34_44;
lbl519:
                                                                                                                    // 2 sources

                                                                                                                    if (var34_44 >= var27_29) break block146;
                                                                                                                } while ((var35_47 = (AMFPacket)var15_15.get(var34_44)).getType() != 9);
                                                                                                                ** continue;
                                                                                                            }
                                                                                                            if (var33_42 > 2) break block155;
                                                                                                        }
                                                                                                        var29_32 = var28_31.getSeq();
                                                                                                        var31_36 = this.lastSeq == -1L ? 0 : (int)(this.lastSeq - var29_32 + 1L);
                                                                                                        if (var31_36 < 0) {
                                                                                                            var31_36 = 0;
                                                                                                        }
                                                                                                        if (var31_36 >= var27_29) break block155;
                                                                                                        if (this.bufferEmptyOnce && !this.waitForBufferFill || !this.instantOn || !this.sendFirstKeyFrame) break block180;
                                                                                                        var32_39 = -1L;
                                                                                                        var34_44 = var27_29 - 1;
                                                                                                        var35_48 = -1;
                                                                                                        this.trackerBufferTime = 0L;
                                                                                                        var36_50 = this.stream.getParent().getBufferTime();
                                                                                                        break block181;
lbl537:
                                                                                                        // 1 sources

                                                                                                        while (var40_68 >= var14_18.switchTimecodeTarget && !var14_18.switchTimecodeFound) {
                                                                                                            var14_18.switchTimecodeFound = true;
                                                                                                            break block147;
                                                                                                        }
                                                                                                        break block147;
lbl541:
                                                                                                        // 1 sources

                                                                                                        while (var38_54 != 8) {
                                                                                                            break block148;
                                                                                                        }
                                                                                                        break block182;
lbl544:
                                                                                                        // 1 sources

                                                                                                        while (true) {
                                                                                                            this.waitForKeyFrame = true;
                                                                                                            break block149;
                                                                                                            break;
                                                                                                        }
lbl547:
                                                                                                        // 1 sources

                                                                                                        while (true) {
                                                                                                            if (var37_52 == null || (var38_56 = var37_52.size()) <= 0) break block144;
                                                                                                            var28_31 = (AMFPacket)var37_52.get(0);
                                                                                                            var39_60 = var28_31.getSeq();
                                                                                                            if (var14_18.lastSeq != -1L) ** continue;
                                                                                                            v7 = 0;
lbl553:
                                                                                                            // 2 sources

                                                                                                            if ((var41_64 = v7) < 0) {
                                                                                                                var41_64 = 0;
                                                                                                            }
                                                                                                            if (var41_64 >= var38_56) break block144;
                                                                                                            break block150;
                                                                                                            break;
                                                                                                        }
lbl557:
                                                                                                        // 2 sources

                                                                                                        while (true) {
                                                                                                            var33_41 = v9;
                                                                                                            if (var33_41 != null && this.lastSentLiveTracker != null && var33_41.trackerSeq >= this.trackerStartSeq) ** break;
                                                                                                            ** continue;
                                                                                                            var34_45 = var32_38.getSent();
                                                                                                            var36_50 = var32_38.getSize();
                                                                                                            var38_59 = var33_41.firstTC + (var33_41.lastTC - var33_41.firstTC) * var34_45 / var36_50;
                                                                                                            var21_24 = this.lastSentLiveTracker.lastTC - var38_59 - this.trackerBufferTime;
                                                                                                            if (!this.disableLowBandwidthThrottling) {
                                                                                                                if (var21_24 > (long)this.behindDropAudio) {
                                                                                                                    var20_23 = true;
                                                                                                                }
                                                                                                                if (var21_24 <= (long)this.behindDropKFrames) ** continue;
                                                                                                                var19_22 = 0;
                                                                                                            }
lbl570:
                                                                                                            // 6 sources

                                                                                                            if (this.lastTCFilter == var19_22) ** GOTO lbl496
                                                                                                            WMSLoggerFactory.getLogger(LivePlayer.class).debug(JSON.endsWith((String)"\b&<%7!\u000f", (int)(-7 - 43)) + var26_28 + JSON.endsWith((String)"\u001e~e .$=/9ve", (int)(53 * 23)) + this.lastTCFilter + "-" + var19_22 + Base64.lastIndexOf((int)(-8 - 28), (String)"u}19&2'7~") + var21_24 + JSON.endsWith((String)"$vci|]I1", (int)(414 / 89)) + this.lastSentLiveTracker.lastTC + JSON.endsWith((String)"t'34=0,>8\t\u001de", (int)(-28 - -16)) + var33_41.lastTC + JSON.endsWith((String)"k.8()5#\u0006:90l", (int)(35 * 25)) + this.trackerBufferTime + JSON.endsWith((String)"&sk3", (int)(650 / 103)) + this.lastTC);
                                                                                                            ** continue;
                                                                                                            break;
                                                                                                        }
                                                                                                    }
                                                                                                    for (var42_70 = var41_64; var42_70 < var38_56; ++var42_70) {
                                                                                                        var28_31 = (AMFPacket)var37_52.get(var42_70);
                                                                                                        var43_73 = var28_31.getSeq();
                                                                                                        var45_75 = var28_31.getType();
                                                                                                        var14_18.lastSeq = var43_73;
                                                                                                        if (var45_75 != 9 || !FLVUtils.isVideoKeyFrame((AMFPacket)var28_31)) continue;
                                                                                                        var46_82 = var28_31.getFirstByte();
                                                                                                        var47_85 = var28_31.getAbsTimecode();
                                                                                                        var14_18.switchVideoKeyFrameSeq = var43_73 - 1L;
                                                                                                        var14_18.switchTimecodeTarget = var47_85 + var14_18.switchTimecodeOffset;
                                                                                                    }
                                                                                                    break block144;
                                                                                                    while (true) {
                                                                                                        if (var20_23) ** GOTO lbl222
                                                                                                        if (this.firstPacketTC == -1L) {
                                                                                                            var42_69 = 0L;
                                                                                                            this.firstPacketTC = var40_68;
                                                                                                        } else {
                                                                                                            var42_69 = var40_68 - this.firstPacketTC;
                                                                                                        }
                                                                                                        if (this.sendOriginalTimecodes) {
                                                                                                            var42_69 = var40_68;
                                                                                                        }
                                                                                                        if (var42_69 < 0L) ** GOTO lbl222
                                                                                                        var39_61 = var3_3;
                                                                                                        this.lastTC = var42_69;
                                                                                                        this.lastAudioTC = var42_69;
                                                                                                        var45_75 = var28_31.getSize();
                                                                                                        var6_6[0] = var6_6[0] + (long)var45_75;
                                                                                                        var6_6[1] = var6_6[1] + 1L;
                                                                                                        ** GOTO lbl222
                                                                                                        break;
                                                                                                    }
                                                                                                }
lbl604:
                                                                                                // 2 sources

                                                                                                while (var34_44 >= 0) {
                                                                                                    var28_31 = (AMFPacket)var15_15.get(var34_44);
                                                                                                    var38_54 = var28_31.getType();
                                                                                                    if (var38_54 != 9) ** GOTO lbl541
                                                                                                }
                                                                                                break block143;
                                                                                            }
                                                                                            var39_60 = var28_31.getAbsTimecode();
                                                                                            if (var32_39 == -1L) {
                                                                                                var32_39 = var39_60;
                                                                                            } else {
                                                                                                if (var35_48 == -1) {
                                                                                                    this.trackerBufferTime = var32_39 - var39_60;
                                                                                                }
                                                                                                if (var35_48 == -1 && var32_39 - var39_60 > var36_50) {
                                                                                                    var35_48 = var34_44;
                                                                                                }
                                                                                            }
                                                                                            if (var38_54 != 9) break block142;
                                                                                            var41_62 = FLVUtils.isVideoKeyFrame((AMFPacket)var28_31);
                                                                                            if (!this.isEnhancedSeekCapable) break block183;
                                                                                            if (var35_48 == -1) break block142;
                                                                                            ** GOTO lbl387
                                                                                        }
                                                                                        if (var41_62) {
                                                                                            var23_25 = var28_31;
                                                                                        }
                                                                                    }
                                                                                    if (!this.isEnhancedSeekCapable && var35_48 != -1) break block143;
                                                                                }
                                                                                --var34_44;
                                                                                ** GOTO lbl604
                                                                            }
                                                                            v10 = var31_36 = var35_48 < 0 ? 0 : var35_48;
                                                                        }
                                                                        if (var31_36 == 0 && this.lastSeq != -1L) ** GOTO lbl79
                                                                    }
                                                                    if ((var32_38 = var25_27.getLastTracker()) != null) break block184;
                                                                    v9 = null;
                                                                    ** GOTO lbl557
                                                                }
                                                                v9 = (LiveTracker)var32_38.getInfo(var26_28);
                                                                ** continue;
                                                                while (true) {
                                                                    v11 = false;
                                                                    break block151;
                                                                    break;
                                                                }
lbl645:
                                                                // 3 sources

                                                                while (true) {
                                                                    if (this.isDebugLog) {
                                                                        var29_33 = System.currentTimeMillis();
                                                                        if (this.lastSendTime != -1L) ** continue;
                                                                        ** continue;
                                                                    }
lbl650:
                                                                    // 3 sources

                                                                    if (var24_26 == null) return var7_7;
                                                                    var24_26.totalLen = var7_7;
                                                                    this.lastSentLiveTracker = var24_26;
                                                                    var25_27.getPendingTracker().putInfo(var26_28, var24_26);
                                                                    return var7_7;
                                                                }
                                                            }
                                                            while (true) {
                                                                if (!this.sendFirstKeyFrame && this.lastReceiveVideo != var9_9) ** continue;
lbl659:
                                                                // 2 sources

                                                                this.checkWorkBuffer(var18_21);
                                                                var36_51 = -1L;
                                                                var38_55 = var31_36;
lbl662:
                                                                // 2 sources

                                                                if (var38_55 >= var27_29) break block141;
                                                                var28_31 = (AMFPacket)var15_15.get(var38_55);
                                                                var39_61 = null;
                                                                var40_68 = var28_31.getAbsTimecode();
                                                                var42_69 = 0L;
                                                                var44_74 = var28_31.getType();
                                                                var45_75 = 0;
                                                                if (var14_18 == null) break block152;
                                                                if (var44_74 == 9 && var14_18.switchVideoKeyFrameSeq >= 0L) ** GOTO lbl537
                                                                break;
                                                            }
                                                        }
                                                        if (!var14_18.switchTimecodeFound) break block152;
                                                    }
                                                    if (var19_22 == 0 || var19_22 == 1) {
                                                        ** continue;
                                                    }
                                                    break block149;
                                                }
                                                switch (var44_74) {
                                                    case 15: 
                                                    case 18: {
                                                        if (this.firstPacketTC != -1L) break block185;
                                                        var42_69 = 0L;
                                                        this.firstPacketTC = var40_68;
                                                        break block186;
                                                    }
                                                    default: {
                                                        WMSLoggerFactory.getLogger(MediaStreamLivePlay.class).info(Base64.lastIndexOf((int)(53 * 29), (String)"Hlek?&PEZXn\u007f}]{bts~g/6xmmjnhNwqgmg9$phlg~d+|lmdue2gmes-8") + var28_31.getType());
                                                        ** GOTO lbl222
                                                    }
                                                    case 9: {
                                                        var46_79 = var28_31.getFirstByte();
                                                        var47_84 = FLVUtils.getVideoCodec((int)var46_79);
                                                        if (var9_9 || var47_84 == 7) break;
                                                        ** GOTO lbl222
                                                    }
                                                    case 8: {
                                                        if (var8_8) ** continue;
                                                        ** continue;
                                                    }
                                                }
                                                if (var19_22 != 7) break block187;
                                                v8 = true;
                                                ** GOTO lbl455
                                            }
                                            v8 = false;
                                            ** continue;
                                        }
                                        var42_69 = var40_68 - this.firstPacketTC;
                                    }
                                    if (!this.sendOriginalTimecodes) ** GOTO lbl512
                                    var42_69 = var40_68;
                                    ** continue;
                                }
                                if (var36_51 != -1L) {
                                    this.lastSeq = var36_51;
                                }
                            }
                            var27_30 = 0L;
                            if (this.avgPacketSizeCount <= (long)(this.avgPacketSizes.length << 1)) ** GOTO lbl645
                            var27_30 = this.avgPacketSizeTotal / (long)this.avgPacketSizes.length;
                            if (this.referenceWritePacketSizeThreshold <= 0) ** GOTO lbl645
                            if (var27_30 < (long)this.referenceWritePacketSizeThreshold) ** continue;
                            v11 = true;
                        }
                        this.referenceWrite = v11;
                        ** continue;
                        while (true) {
                            if (var55_125 != 9) ** GOTO lbl729
                            if (var45_76 == -1L) ** continue;
                            if (var45_76 - var56_127 < var51_107) ** GOTO lbl729
                            var53_115 = var54_121;
                            break block153;
                            break;
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (var41_65 - var56_127 >= var51_107) {
                                var53_115 = var54_121;
                                break block153;
                            }
lbl729:
                            // 6 sources

                            --var54_121;
lbl730:
                            // 2 sources

                            if (var54_121 < 0) break block153;
                            var28_31 = (AMFPacket)var37_52.get(var54_121);
                            var55_125 = var28_31.getType();
                            var56_127 = var28_31.getAbsTimecode();
                            if (var55_125 != 8) ** continue;
                            ** while (var41_65 != -1L)
                        }
lbl736:
                        // 1 sources

                        ** continue;
                    }
                    if (var53_115 < 0) {
                        var53_115 = 0;
                    }
                    var28_31 = (AMFPacket)var37_52.get(var53_115);
                    var14_18.lastSeq = var28_31.getSeq();
                }
                if (var14_18.lastSeq < 0L || var14_18.switchVideoKeyFrameSeq >= 0L) ** continue;
                ** continue;
            }
        }
    }

    @Override
    public int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        if (this.playLen != 0.0) {
            return this.playAll(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        return this.playKeyFrame(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null) return n;
        return n += this.play(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    @Override
    public boolean play(IMediaStream iMediaStream) {
        return this.stream.getParent().isOpen();
        {
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean play() {
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null && this.sendStreamNotFound) {
            this.stream.getParent().sendStreamNotFound(this.stream.getParent().getName());
        }
        this.sendStreamNotFound = false;
        if (iMediaStream != null) return true;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resetInternal(boolean bl, boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
            this.lastAudioTC = -1L;
            this.lastVideoTC = -1L;
            this.lastDataTC = -1L;
            this.lastTC = -1L;
            this.firstPacketTC = -1L;
            this.sendFirstKeyFrame = true;
            this.checkStreamProperties = true;
            this.sendFirstVideoFrame = true;
            this.sendFirstAudioFrame = true;
            this.sentPlayStart = false;
            this.lastSendTime = -1L;
            this.waitForKeyFrame = true;
            this.lastTCOffset = 0L;
            this.lastSentLiveTracker = null;
            this.trackerStartSeq = -1L;
            this.trackerBufferTime = 0L;
            this.lastReceiveAudio = true;
            this.lastReceiveVideo = true;
            this.lastReceiveVideoFPS = -1;
            this.playlistEnd = false;
            this.bufferEmptyOnce = false;
            this.sendStreamNotFound = true;
            this.waitForBufferFillStarTime = -1L;
            this.liveSwitch.set(null);
            this.sendPlaySwitch = false;
            if (!bl2) return;
            IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
            if (iMediaStream == null) return;
            AMFPacket aMFPacket = this.getLastPacket(iMediaStream);
            if (aMFPacket == null) return;
            this.lastSeq = aMFPacket.getSeq();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void resetNoLookup() {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)Base64.lastIndexOf((int)(-57 - 50), (String)"m;dhvi"), (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), Base64.lastIndexOf((int)(-64 - 57), (String)"t|{oja"), "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reset(boolean bl) {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)Base64.lastIndexOf((int)(1212 / 252), (String)"|(uwgz"), (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), Base64.lastIndexOf((int)(-53 - -4), (String)"<$#729"), "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(bl, true);
    }

    @Override
    public void pause(int n, long l) {
    }

    @Override
    public void pauseRaw(int n, long l) {
    }

    @Override
    public void seek(int n) {
    }

    @Override
    public void setBufferTime(int n) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void stopName(String string, String string2, String string3, String string4, double d, double d2, int n) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void switchName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        IMediaStream iMediaStream = this.stream.getParent();
        IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
        String string5 = this.stream.getParent().getStreamType();
        boolean bl = false;
        StreamList streamList = iApplicationInstance.getVHost().getStreamTypes();
        StreamItem streamItem = streamList.getStreamDef(string5);
        if (streamItem != null) {
            bl = streamItem.getProperties().getPropertyBoolean(Base64.lastIndexOf((int)(626 / 133), (String)"mvJn~lXn|ho{ucWwsp"), bl);
        }
        if (bl) {
            string = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, (IClient)iMediaStream.getClient(), (String)string);
        }
        this.liveSwitch.set(new LivePlayerSwitch(string, string2, n));
    }

    @Override
    public void setName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        this.playStart = d;
        this.playLen = d2;
        this.playTransition = n;
    }

    @Override
    public void interruptPlay() {
    }

    @Override
    public void startPlay() {
    }

    @Override
    public void switchPlay() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateLoggingValues() {
        long l = this.lastTC;
        if (l < 0L) {
            l = 0L;
        }
        if (WMSLoggerFactory.isGlobalLogValueSet((String)JSON.endsWith((String)"m;dhvi", (int)(43 * 63)))) return;
        WMSLoggerFactory.putGlobalLogValue((String)JSON.endsWith((String)"1g8<\"=", (int)(59 * 43)), (Object)new Long(l));
    }

    @Override
    public double length() {
        return 0.0;
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public long getLastTimecodeOffset() {
        return this.lastTCOffset;
    }

    @Override
    public long getLastSentVideoTC() {
        return this.lastVideoTC;
    }

    @Override
    public long getLastSentAudioTC() {
        return this.lastAudioTC;
    }

    @Override
    public long getLastSentDataTC() {
        return this.lastDataTC;
    }

    @Override
    public int getLastVideoFilter() {
        return this.lastTCFilter;
    }

    protected class LiveTracker {
        public long totalLen = 0L;
        public long firstTC = -1L;
        public long lastTC = -1L;
        public long trackerSeq = 0L;

        public LiveTracker() {
            this.trackerSeq = ++LivePlayer.this.trackerSeqSource;
        }
    }

    private class PacketTimecodeDebug {
        long a = -1L;
        long b = -1L;
        long c = -1L;
        int d = 0;
        long e = -1L;
        long f = -1L;
        long g = -1L;
        int h = 0;
        long i = -1L;

        private PacketTimecodeDebug() {
        }
    }
}

