/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.mpegdashstreaming.file;

import com.wowza.util.Base64;
import com.wowza.util.JSON;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.mpegdashstreaming.file.HTTPStreamerMPEGDashIndex;
import com.wowza.wms.httpstreamer.mpegdashstreaming.file.IHTTPStreamerMPEGDashIndexItem;
import com.wowza.wms.httpstreamer.mpegdashstreaming.file.IMediaReaderMPEGDash;
import com.wowza.wms.httpstreamer.mpegdashstreaming.livestreampacketizer.MPEGDashDashChunk;
import com.wowza.wms.httpstreamer.mpegdashstreaming.util.IMPEGDashEncryptor;
import com.wowza.wms.httpstreamer.mpegdashstreaming.util.MPEGDashEncInfo;
import com.wowza.wms.httpstreamer.mpegdashstreaming.util.MPEGDashEncryptorFactory;
import com.wowza.wms.httpstreamer.mpegdashstreaming.util.MPEGDashUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaReaderList;
import com.wowza.wms.timedtext.model.TimedTextRequest;
import com.wowza.wms.util.ModuleUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HTTPStreamerMPEGDashIndexItem {
    protected static final Class<HTTPStreamerMPEGDashIndexItem> CLASS = HTTPStreamerMPEGDashIndexItem.class;
    protected static final String CLASSNAME = "HTTPStreamerMPEGDashIndexItem";
    protected String metaData = null;
    protected int width = -1;
    protected int height = -1;
    protected int displayWidth = -1;
    protected int displayHeight = -1;
    protected long duration = -1L;
    protected long bitrate = 0L;
    protected long bitrateVideo = 0L;
    protected long bitrateAudio = 0L;
    protected long timescaleVideo = 0L;
    protected long timescaleAudio = 0L;
    protected double frameRate = 0.0;
    protected int sampleRate = 0;
    protected long calculatedBitrate = 0L;
    protected int avcLevel = 0;
    protected int avcProfile = 0;
    protected String streamName = null;
    protected String mimeType = JSON.endsWith((String)"\u007fcoib!b`%", (int)(81 + -72));
    protected List<IHTTPStreamerMPEGDashIndexItem> items = new ArrayList<IHTTPStreamerMPEGDashIndexItem>();
    protected HTTPStreamerMPEGDashIndex index = null;
    protected MediaCodecInfoVideo codecInfoVideo = new MediaCodecInfoVideo();
    protected MediaCodecInfoAudio codecInfoAudio = new MediaCodecInfoAudio();
    protected boolean resolvePlayAlias = false;
    protected long playStart = 0L;
    protected long playDuration = -1L;
    protected TimedTextRequest timedTextRequest = new TimedTextRequest();
    protected String vodTranscodeNGRP = null;
    protected String audioLang = null;
    protected MPEGDashEncInfo encInfo = null;
    protected IMediaReaderMPEGDash mediaReader = null;
    protected Object mediaReaderLock = new Object();
    protected int nextVideoTimecodeIndex = 0;
    protected int nextAudioTimecodeIndex = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IMPEGDashEncryptor a(IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem) {
        IMPEGDashEncryptor iMPEGDashEncryptor = null;
        MPEGDashEncInfo mPEGDashEncInfo = iHTTPStreamerMPEGDashIndexItem.getEncInfo();
        if (mPEGDashEncInfo == null) return iMPEGDashEncryptor;
        return MPEGDashEncryptorFactory.createEncryptor(mPEGDashEncInfo);
    }

    public HTTPStreamerMPEGDashIndexItem(HTTPStreamerMPEGDashIndex hTTPStreamerMPEGDashIndex) {
        this.index = hTTPStreamerMPEGDashIndex;
    }

    public HTTPStreamerMPEGDashIndex getIndex() {
        return this.index;
    }

    public int addIndexItem(IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem) {
        this.items.add(iHTTPStreamerMPEGDashIndexItem);
        return this.items.size() - 1;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public IHTTPStreamerMPEGDashIndexItem getIndexItem(int n) {
        if (n >= this.items.size()) {
            return null;
        }
        return this.items.get(n);
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String string) {
        this.metaData = string;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public long getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(long l) {
        this.bitrate = l;
    }

    public long getTrimmedDuration() {
        if (this.items.size() <= 0) {
            return this.duration;
        }
        IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = this.items.get(0);
        List<IHTTPStreamerMPEGDashIndexItem> list = this.items;
        IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem2 = list.get(list.size() - 1);
        return iHTTPStreamerMPEGDashIndexItem2.getStopTimecode() - iHTTPStreamerMPEGDashIndexItem.getStartTimecode();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public MediaCodecInfoVideo getCodecInfoVideo() {
        return this.codecInfoVideo;
    }

    public MediaCodecInfoAudio getCodecInfoAudio() {
        return this.codecInfoAudio;
    }

    public void setEncInfo(MPEGDashEncInfo mPEGDashEncInfo) {
        this.encInfo = mPEGDashEncInfo;
    }

    public MPEGDashEncInfo getEncInfo() {
        return this.encInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void indexFile(IHTTPStreamerSession iHTTPStreamerSession, String string) {
        Object object = this.mediaReaderLock;
        // MONITORENTER : object
        if (this.mediaReader != null) {
            this.mediaReader.indexFile(this);
        }
        // MONITOREXIT : object
        object = this.index.appInstance.getApplication().getName() + "/" + this.index.appInstance.getName() + "/" + string;
        this.encInfo = MPEGDashUtils.getEncInfo(this.index.appInstance, string);
        if (this.encInfo == null) return;
        if (this.encInfo.getEncryptionKey() != null && this.encInfo.getURL() != null) {
            WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).info(Base64.lastIndexOf((int)(-39 - 28), (String)"UJK\u0010\u001261!$+\":\u0004\u001a\u000e\u000b\t/<8\u0018<71-\u001f#=4t229;'\u0006(.&\u001f") + (String)object + Base64.lastIndexOf((int)(29 * 49), (String)"P4/U\u007fqameb7UI_\\X|mw rvqadk=(") + string + Base64.lastIndexOf((int)(151 / 48), (String)"#o`\u007f=(#") + this.encInfo.getEncryptionKey().substring(28) + Base64.lastIndexOf((int)(105 + 103), (String)"p$ ?nu") + this.encInfo.getURL());
        }
        Iterator<IHTTPStreamerMPEGDashIndexItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = iterator.next();
            iHTTPStreamerMPEGDashIndexItem.setEncInfo(this.encInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            Object object = this.mediaReaderLock;
            synchronized (object) {
                if (this.mediaReader != null) {
                    this.mediaReader.close();
                }
                this.mediaReader = null;
                return;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(JSON.endsWith((String)"MRSXZ~yilcjb\\BVSQwdpPt\u007fyeWkel,`hjub2)", (int)(1351 / 247)) + exception.toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open() {
        String string;
        String string2;
        Object object = this.mediaReaderLock;
        synchronized (object) {
            if (this.mediaReader != null) {
                this.close();
            }
            this.mediaReader = null;
        }
        try {
            object = this.index.getAppInstance();
            string2 = Base64.lastIndexOf((int)(5 * 15), (String)"&<y");
            string = this.streamName;
            if (this.resolvePlayAlias) {
                string = ((ApplicationInstance)object).internalResolvePlayAlias(string, this.index.getHttpStreamerSession());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(Base64.lastIndexOf((int)(37 * 3), (String)"\u0007\u0004\u0005\u0002\u0000 '365<(\u0016\f\u0018\u0019\u001barjJjac\u007fA}of\"b~j~+2") + exception.toString());
            return;
        }
        if (string == null) return;
        String[] stringArray = ModuleUtils.decodeStreamExtension((String)string, (String)string2);
        string = stringArray[0];
        string2 = stringArray[1];
        boolean bl = string.indexOf(Base64.lastIndexOf((int)(35 * 63), (String)"'10")) >= 0;
        int n = string.indexOf("?");
        if (!bl && n >= 0) {
            string = string.substring(0, n);
        }
        String string3 = string2 + Base64.lastIndexOf((int)(57 * 51), (String)"6,89;!2*");
        Object object2 = object;
        IMediaReader iMediaReader = MediaReaderFactory.getInstance((IApplicationInstance)object2, (MediaReaderList)object2.getStreams().getVHost().getMediaReaders(), (String)string3);
        if (iMediaReader == null) return;
        String string4 = object.getStreamStoragePath();
        iMediaReader.init((IApplicationInstance)object, this.index.getStream(), string3, string4, string);
        iMediaReader.open(string4, string);
        if (!(iMediaReader instanceof IMediaReaderMPEGDash)) {
            iMediaReader.close();
            WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(JSON.endsWith((String)"NS\\YY\u007f~hobuc_CQRRvkqSuxxfVtdo-kuci2)Gnhdo]upvvf5\u007fd8wuo<|p?\r\u0011\u0007\u0004\u0000$5/h\u0004//%,\u001c*157!nu", (int)(1249 / 199)) + this.index.getStreamExt() + ":" + this.streamName);
            return;
        }
        Object object3 = this.mediaReaderLock;
        synchronized (object3) {
            this.mediaReader = (IMediaReaderMPEGDash)iMediaReader;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final long a(int n, long l) {
        int n2;
        long l2;
        long l3 = -1L;
        if (n != 1 && n != 0) {
            l2 = l * 1000L / this.timescaleAudio;
            n2 = this.nextAudioTimecodeIndex;
        } else {
            l2 = l * 1000L / this.timescaleVideo;
            n2 = this.nextVideoTimecodeIndex;
        }
        int n3 = this.items.size();
        for (int i = 0; i < n3; ++i) {
            IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = this.items.get(n2);
            long l4 = iHTTPStreamerMPEGDashIndexItem.getStartTimecode();
            int n4 = n2 = n2 == n3 - 1 ? 0 : n2 + 1;
            if (l4 != l2) continue;
            l3 = iHTTPStreamerMPEGDashIndexItem.getIndex();
            break;
        }
        if (n != 1 && n != 0) {
            this.nextAudioTimecodeIndex = n2;
            return l3;
        }
        this.nextVideoTimecodeIndex = n2;
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MPEGDashDashChunk getMediaInit(int n) {
        MPEGDashDashChunk mPEGDashDashChunk = null;
        try {
            IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = this.items.get(0);
            mPEGDashDashChunk = new MPEGDashDashChunk(0, -1L);
            Object object = this.mediaReaderLock;
            synchronized (object) {
                if (this.mediaReader == null) return null;
                this.mediaReader.fillChunk(this, iHTTPStreamerMPEGDashIndexItem, mPEGDashDashChunk, this.a(iHTTPStreamerMPEGDashIndexItem));
                return mPEGDashDashChunk;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(Base64.lastIndexOf((int)(195 / 34), (String)"MRSXZ~yilcjb\\BVSQwdpPt\u007fyeWkel,daqKbl`kBbdz50") + exception.toString());
            return mPEGDashDashChunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MPEGDashDashChunk getMediaChunk(int n, long l) {
        MPEGDashDashChunk mPEGDashDashChunk = null;
        try {
            if (l > (long)this.items.size()) return mPEGDashDashChunk;
            if (l < 1L) {
                return mPEGDashDashChunk;
            }
            IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = this.items.get((int)(l - 1L));
            mPEGDashDashChunk = new MPEGDashDashChunk(0, l);
            synchronized (this.mediaReaderLock) {
                if (this.mediaReader == null) return null;
                this.mediaReader.fillChunk(this, iHTTPStreamerMPEGDashIndexItem, mPEGDashDashChunk, this.a(iHTTPStreamerMPEGDashIndexItem));
                return mPEGDashDashChunk;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(JSON.endsWith((String)"\u0016\u000b\u0014\u0011\u001176 '*-;\u0007\u001b\t\n\n.#9\u001b=00.\u001e,<7u;8*\u0012eekbGmsic3*", (int)(-65 - -31)) + exception.toString());
            return mPEGDashDashChunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MPEGDashDashChunk getMediaChunkByTime(int n, long l) {
        MPEGDashDashChunk mPEGDashDashChunk = null;
        try {
            long l2 = this.a(0, l);
            if (l2 > (long)this.items.size()) return mPEGDashDashChunk;
            if (l2 < 1L) {
                return mPEGDashDashChunk;
            }
            IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = this.items.get((int)(l2 - 1L));
            mPEGDashDashChunk = new MPEGDashDashChunk(0, l2);
            synchronized (this.mediaReaderLock) {
                if (this.mediaReader == null) return null;
                this.mediaReader.fillChunk(this, iHTTPStreamerMPEGDashIndexItem, mPEGDashDashChunk, this.a(iHTTPStreamerMPEGDashIndexItem));
                // ** MonitorExit[var8_7] (shouldn't be in output)
                return mPEGDashDashChunk;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(JSON.endsWith((String)"\u0017\u0014\u0015\u0012\u001007#&%,8\u0006\u001c\b\t\u000b1\":\u001a:13/\u0011-?6r:;+MdfjeFnrfbHrXdcj*1", (int)(49 * 15)) + exception.toString());
            return mPEGDashDashChunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MPEGDashDashChunk getVideoInit(int n) {
        MPEGDashDashChunk mPEGDashDashChunk = null;
        try {
            IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = this.items.get(0);
            mPEGDashDashChunk = new MPEGDashDashChunk(1, -1L);
            Object object = this.mediaReaderLock;
            synchronized (object) {
                if (this.mediaReader == null) return null;
                this.mediaReader.fillChunk(this, iHTTPStreamerMPEGDashIndexItem, mPEGDashDashChunk, this.a(iHTTPStreamerMPEGDashIndexItem));
                return mPEGDashDashChunk;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(Base64.lastIndexOf((int)(11 - -28), (String)"O\\]ZXx\u007fkn}t`^DPQSyjrRry{g\t5'.j\"#3\u001e ..#\u0004 &$kr") + exception.toString());
            return mPEGDashDashChunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MPEGDashDashChunk getVideoChunk(int n, long l) {
        MPEGDashDashChunk mPEGDashDashChunk = null;
        try {}
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(JSON.endsWith((String)"\u0007\u0004\u0005\u0002\u0000 '365<(\u0016\f\u0018\u0019\u001barjJjac\u007fA}of\"jk{Fxvv{V~bvr ;", (int)(-61 - -44)) + exception.toString());
            return mPEGDashDashChunk;
        }
        if (l > (long)this.items.size()) return mPEGDashDashChunk;
        if (l < 1L) return mPEGDashDashChunk;
        IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = this.items.get((int)(l - 1L));
        mPEGDashDashChunk = new MPEGDashDashChunk(1, l);
        Object object = this.mediaReaderLock;
        synchronized (object) {
            if (this.mediaReader == null) return null;
            this.mediaReader.fillChunk(this, iHTTPStreamerMPEGDashIndexItem, mPEGDashDashChunk, this.a(iHTTPStreamerMPEGDashIndexItem));
            return mPEGDashDashChunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MPEGDashDashChunk getVideoChunkByTime(int n, long l) {
        long l2;
        MPEGDashDashChunk mPEGDashDashChunk;
        block5: {
            mPEGDashDashChunk = null;
            try {
                l2 = this.a(1, l);
                if (l2 > (long)this.items.size()) return mPEGDashDashChunk;
                if (l2 >= 1L) break block5;
                return mPEGDashDashChunk;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(Base64.lastIndexOf((int)(1074 / 177), (String)"NS\\YY\u007f~hobuc_CQRRvkqSuxxfVtdo-c`rQamodOe{a{SkG}xs-8") + exception.toString());
                return mPEGDashDashChunk;
            }
        }
        IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = this.items.get((int)(l2 - 1L));
        mPEGDashDashChunk = new MPEGDashDashChunk(1, l2);
        synchronized (this.mediaReaderLock) {
            if (this.mediaReader == null) return null;
            this.mediaReader.fillChunk(this, iHTTPStreamerMPEGDashIndexItem, mPEGDashDashChunk, this.a(iHTTPStreamerMPEGDashIndexItem));
            return mPEGDashDashChunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MPEGDashDashChunk getAudioInit(int n) {
        MPEGDashDashChunk mPEGDashDashChunk = null;
        try {
            IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = this.items.get(0);
            mPEGDashDashChunk = new MPEGDashDashChunk(2, -1L);
            Object object = this.mediaReaderLock;
            synchronized (object) {
                if (this.mediaReader == null) return null;
                this.mediaReader.fillChunk(this, iHTTPStreamerMPEGDashIndexItem, mPEGDashDashChunk, this.a(iHTTPStreamerMPEGDashIndexItem));
                return mPEGDashDashChunk;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(JSON.endsWith((String)"UJK\u0010\u001261!$+\":\u0004\u001a\u000e\u000b\t/<8\u0018<71-\u001f#=4t<9)\u001f*$(-\n*,2}h", (int)(20 + 41)) + exception.toString());
            return mPEGDashDashChunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MPEGDashDashChunk getAudioChunk(int n, long l) {
        MPEGDashDashChunk mPEGDashDashChunk = null;
        try {
            if (l > (long)this.items.size()) return mPEGDashDashChunk;
            if (l < 1L) return mPEGDashDashChunk;
            IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = this.items.get((int)(l - 1L));
            mPEGDashDashChunk = new MPEGDashDashChunk(2, l);
            Object object = this.mediaReaderLock;
            synchronized (object) {
                if (this.mediaReader == null) return null;
                this.mediaReader.fillChunk(this, iHTTPStreamerMPEGDashIndexItem, mPEGDashDashChunk, this.a(iHTTPStreamerMPEGDashIndexItem));
                return mPEGDashDashChunk;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(JSON.endsWith((String)"KPQVT|{ojah|B@TUWuf~^v}\u007fcUi{r.fgwEpbngJb~bf4/", (int)(894 / 237)) + exception.toString());
            return mPEGDashDashChunk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MPEGDashDashChunk getAudioChunkByTime(int n, long l) {
        long l2;
        MPEGDashDashChunk mPEGDashDashChunk;
        block5: {
            mPEGDashDashChunk = null;
            try {
                l2 = this.a(2, l);
                if (l2 > (long)this.items.size()) return mPEGDashDashChunk;
                if (l2 >= 1L) break block5;
                return mPEGDashDashChunk;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerMPEGDashIndexItem.class).error(Base64.lastIndexOf((int)(23 * 53), (String)"\u000b\u0010\u0011\u0016\u0014<;/*!(<\u0002\u0000\u0014\u0015\u00175&>\u001e6=?#\u0015);2n&'7\u00050\".'\n\">\"&\f6\u00048?6nu") + exception.toString());
                return mPEGDashDashChunk;
            }
        }
        IHTTPStreamerMPEGDashIndexItem iHTTPStreamerMPEGDashIndexItem = this.items.get((int)l2 - 1);
        mPEGDashDashChunk = new MPEGDashDashChunk(2, l2);
        synchronized (this.mediaReaderLock) {
            if (this.mediaReader == null) return null;
            this.mediaReader.fillChunk(this, iHTTPStreamerMPEGDashIndexItem, mPEGDashDashChunk, this.a(iHTTPStreamerMPEGDashIndexItem));
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return mPEGDashDashChunk;
        }
    }

    public int getAvcLevel() {
        return this.avcLevel;
    }

    public void setAvcLevel(int n) {
        this.avcLevel = n;
    }

    public int getAvcProfile() {
        return this.avcProfile;
    }

    public void setAvcProfile(int n) {
        this.avcProfile = n;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public long getCalculatedBitrate() {
        return this.calculatedBitrate;
    }

    public void setCalculatedBitrate(long l) {
        this.calculatedBitrate = l;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public void setDisplayWidth(int n) {
        this.displayWidth = n;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public void setDisplayHeight(int n) {
        this.displayHeight = n;
    }

    public boolean isResolvePlayAlias() {
        return this.resolvePlayAlias;
    }

    public void setResolvePlayAlias(boolean bl) {
        this.resolvePlayAlias = bl;
    }

    public long getPlayStart() {
        return this.playStart;
    }

    public void setPlayStart(long l) {
        this.playStart = l;
    }

    public long getPlayDuration() {
        return this.playDuration;
    }

    public void setPlayDuration(long l) {
        this.playDuration = l;
    }

    public long getBitrateVideo() {
        return this.bitrateVideo;
    }

    public void setBitrateVideo(long l) {
        this.bitrateVideo = l;
    }

    public long getBitrateAudio() {
        return this.bitrateAudio;
    }

    public void setBitrateAudio(long l) {
        this.bitrateAudio = l;
    }

    public long getTimescaleAudio() {
        return this.timescaleAudio;
    }

    public void setTimescaleAudio(long l) {
        this.timescaleAudio = l;
    }

    public long getTimescaleVideo() {
        return this.timescaleVideo;
    }

    public void setTimescaleVideo(long l) {
        this.timescaleVideo = l;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double d) {
        this.frameRate = d;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public TimedTextRequest getCaptionRequest() {
        return this.timedTextRequest;
    }

    public void setCaptionRequest(TimedTextRequest timedTextRequest) {
        this.timedTextRequest = timedTextRequest;
    }

    public String getVODTranscodeNGRP() {
        return this.vodTranscodeNGRP;
    }

    public void setVODTranscodeNGRP(String string) {
        this.vodTranscodeNGRP = string;
    }

    public String getAudioLang() {
        return this.audioLang;
    }

    public void setAudioLang(String string) {
        this.audioLang = string;
    }
}

