/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacache.impl;

import com.wowza.io.HTTPByteReaderS3;
import com.wowza.util.Base64;
import com.wowza.util.JSON;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacache.impl.IMediaCacheHTTPByteReader;
import com.wowza.wms.mediacache.impl.MediaCacheHTTPByteReaderResult;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class MediaCacheHTTPByteReader
implements IMediaCacheHTTPByteReader {
    public static final String S3DOMAINNAME = "s3.amazonaws.com";
    public static final int MAXHEADERSIZE = 4096;
    public static final int BUFFERINCSIZE = 1024;
    public static final int TIMEOUT = 6000;
    public static final int SENDBUFFERSIZE = 8000;
    public static final int RECEIVEBUFFERSIZE = 65000;
    public static final String CRLF = "\r\n";
    protected String host = null;
    protected int port = 80;
    protected String reqPath = null;
    protected String proxyHost = null;
    protected int proxyPort = 80;
    protected FastDateFormat dateFormat = null;
    protected Socket socket = null;
    protected StringBuffer msgBuf = new StringBuffer();
    protected int maxRetries = 3;
    protected int maxUsesBeforeReconnect = 12;
    protected int uses = 0;
    protected int readTimeout = 6000;
    protected int connectionTimeout = 6000;
    protected List<String> debugInfo = null;
    protected String debugPrefix = null;
    protected boolean requestFullURL = false;
    protected String[] parseDateFormats = null;
    protected int sendBufferSize = 8000;
    protected int receiveBufferSize = 65000;
    protected String userAgent = null;
    protected WMSProperties properties = new WMSProperties();
    protected String awsSecretAccessKey = null;
    protected String awsAccessKeyId = null;
    protected SecretKeySpec signingKey = null;
    protected Mac mac = null;
    protected String bucketName = null;
    protected boolean debugHTTPRequests = false;
    protected boolean sendHTTPKeepAlive = true;
    protected boolean sendHTTPProxyKeepAlive = true;
    protected boolean bucketNameInDomain = true;
    protected boolean closeConnectOnBadStatus = false;
    protected boolean closeConnectOnBadContentLength = false;
    protected boolean logSocketWarning = true;

    public MediaCacheHTTPByteReader() {
        this.dateFormat = FastDateFormat.getInstance((String)JSON.regionMatches((String)"H\"/tu2^YX6na`c;TU$r-{10d?<=", (int)(-45 - 38)), (TimeZone)SystemUtils.defaultTimeZone, (Locale)SystemUtils.defaultLocale);
        this.parseDateFormats = new String[1];
        this.parseDateFormats[0] = JSON.regionMatches((String)"\u001fw|9:\u007f\r\f\u000fc=<?>h\u0001\u0002q! t<#q().", (int)(45 - -45));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init() {
        WMSProperties wMSProperties = this.properties;
        this.debugHTTPRequests = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"kusgt\\ABGJ|knynjl", (int)(57 - 10)), this.debugHTTPRequests);
        this.sendHTTPKeepAlive = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"w`hc@]^[Ghk\u007fQ}{eq", (int)(-59 - 33)), this.sendHTTPKeepAlive);
        this.sendHTTPProxyKeepAlive = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"ynbiF[DABa{mo\\}|jZpthz", (int)(34 + 104)), this.sendHTTPProxyKeepAlive);
        this.closeConnectOnBadStatus = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(27 + -26), (String)"bnlw`EhfgohxB`MquAguacd"), this.closeConnectOnBadStatus);
        this.closeConnectOnBadContentLength = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"}sorg@kkhbk}EeNljL\u007f\u007ffvzaZrv~ns", (int)(1 + 29)), this.closeConnectOnBadContentLength);
        this.awsSecretAccessKey = wMSProperties.getPropertyStr(Base64.lastIndexOf((int)(1 - 2), (String)">wrQfgwcsIjin\u007f~Eji"), null);
        if (this.awsSecretAccessKey != null && this.awsSecretAccessKey.length() <= 0) {
            this.awsSecretAccessKey = null;
        }
        this.awsAccessKeyId = wMSProperties.getPropertyStr(Base64.lastIndexOf((int)(114 + 32), (String)"sdgTut}jiPydW{"), null);
        if (this.awsAccessKeyId != null && this.awsAccessKeyId.length() <= 0) {
            this.awsAccessKeyId = null;
        }
        if (this.awsAccessKeyId == null || this.awsSecretAccessKey == null) {
            this.awsSecretAccessKey = null;
            this.awsAccessKeyId = null;
        }
        if (this.awsAccessKeyId == null) return;
        String string = this.host;
        String string2 = this.host.toLowerCase();
        int n = string2.indexOf(JSON.regionMatches((String)"5o.0~- 8,*$14f*%&", (int)(21 * 15)));
        if (n >= 0) {
            this.bucketName = string.substring(0, n);
            this.bucketNameInDomain = true;
        }
        try {
            this.initAuth();
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPByteReaderS3.class).info(Base64.lastIndexOf((int)(3 - 4), (String)"\u0017TURA}qcUmhnn~^=!~teZzfbvvz\u007f!<") + exception.toString());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void getHeadCommandS3(String string) {
        String string2;
        String string3 = JSON.regionMatches((String)"\u0001\u000f\n\b", (int)(59 * 43));
        String string4 = this.httpDate();
        String string5 = "";
        String string6 = null;
        if (this.mac != null) {
            string2 = string3 + JSON.regionMatches((String)"GDE", (int)(57 * 53)) + string4 + "\n" + (this.bucketName == null ? "" : "/" + this.bucketName) + string;
            MediaCacheHTTPByteReader mediaCacheHTTPByteReader = this;
            String string7 = mediaCacheHTTPByteReader.signRequest(mediaCacheHTTPByteReader.awsSecretAccessKey, string2);
            string6 = Base64.lastIndexOf((int)(414 / 136), (String)"Bqqnhz`pjxdaa*1SDG5") + this.awsAccessKeyId + ":" + string7;
        }
        string2 = string;
        this.msgBuf.setLength(0);
        this.msgBuf.append(string3 + " " + string2 + JSON.regionMatches((String)"m\u0006\u001b\u0004\u0001}bzd", (int)(36 - 55)) + Base64.lastIndexOf((int)(813 / 132), (String)"\u000b\r"));
        this.msgBuf.append(JSON.regionMatches((String)"@drb2)", (int)(457 / 99)) + string4 + JSON.regionMatches((String)"\u0014\u0010", (int)(17 * 9)));
        this.msgBuf.append(Base64.lastIndexOf((int)(17 + 63), (String)"\u0018>!'nu") + this.host + Base64.lastIndexOf((int)(495 / 132), (String)"\u000e\u000e"));
        this.msgBuf.append(Base64.lastIndexOf((int)(-49 - 25), (String)"Uxvm\u007fuh0Jf0$xc") + string5 + Base64.lastIndexOf((int)(887 / 219), (String)"\t\u000f"));
        if (this.sendHTTPKeepAlive) {
            this.msgBuf.append(JSON.regionMatches((String)"Fiifli\u007feb`50zwvd8w{qo\u007f\u0016\u0016", (int)(665 / 121)));
        }
        if (this.sendHTTPProxyKeepAlive) {
            this.msgBuf.append(JSON.regionMatches((String)"Twi\u007fq$Idbckldx}}.5}r}i7zpthzMK", (int)(9 - -27)));
        }
        if (string6 != null) {
            this.msgBuf.append(string6 + Base64.lastIndexOf((int)(213 / 42), (String)"\b\f"));
        }
        this.msgBuf.append(JSON.regionMatches((String)"\\X", (int)(45 * 53)));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void getGetCommandS3(String string, long l, int n) {
        String string2;
        String string3 = Base64.lastIndexOf((int)(3 + 13), (String)"WTF");
        String string4 = this.httpDate();
        String string5 = "";
        String string6 = null;
        if (this.mac != null) {
            string2 = string3 + JSON.regionMatches((String)"\f\r\u0002", (int)(1003 / 167)) + string4 + "\n" + (this.bucketName == null ? "" : "/" + this.bucketName) + string;
            MediaCacheHTTPByteReader mediaCacheHTTPByteReader = this;
            String string7 = mediaCacheHTTPByteReader.signRequest(mediaCacheHTTPByteReader.awsSecretAccessKey, string2);
            string6 = JSON.regionMatches((String)"I|~cc\u007fguqe{|z/6VOJ:", (int)(77 + 59)) + this.awsAccessKeyId + ":" + string7;
        }
        string2 = string;
        long l2 = l;
        long l3 = l + (long)n - 1L;
        this.msgBuf.setLength(0);
        this.msgBuf.append(string3 + " " + string2 + JSON.regionMatches((String)"2[@AF8)7+", (int)(2 + 48)) + Base64.lastIndexOf((int)(1111 / 249), (String)"\t\u000f"));
        this.msgBuf.append(Base64.lastIndexOf((int)(33 - 29), (String)"@drb2)") + string4 + JSON.regionMatches((String)"\t\u000f", (int)(2 - -34)));
        this.msgBuf.append(Base64.lastIndexOf((int)(231 / 39), (String)"Mit|3*") + this.host + Base64.lastIndexOf((int)(888 / 130), (String)"\u000b\r"));
        this.msgBuf.append(Base64.lastIndexOf((int)(-40 - -30), (String)"\u001586-?5(p\n&pd8#") + string5 + Base64.lastIndexOf((int)(17 * 57), (String)"D@"));
        this.msgBuf.append(JSON.regionMatches((String)"Wgiol0+ntzjc,", (int)(666 / 129)) + l2 + "-" + l3 + JSON.regionMatches((String)"\u0001\u0007", (int)(111 + -67)));
        if (this.sendHTTPKeepAlive) {
            this.msgBuf.append(Base64.lastIndexOf((int)(85 + 44), (String)"Bmmj`esafd1,fkj`<s\u007f}cs\u001a\u0012"));
        }
        if (this.sendHTTPProxyKeepAlive) {
            this.msgBuf.append(JSON.regionMatches((String)"^}\u007fik>Wzxy}znrss$?kdgs)djn~l\u0007\u0001", (int)(-51 - 63)));
        }
        if (string6 != null) {
            this.msgBuf.append(string6 + Base64.lastIndexOf((int)(22 - 24), (String)"SU"));
        }
        this.msgBuf.append(Base64.lastIndexOf((int)(5 + 6), (String)"\u0006\u0006"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initAuth() {
        this.signingKey = new SecretKeySpec(this.awsSecretAccessKey.getBytes(), Base64.lastIndexOf((int)(-64 - -37), (String)"\r+&+\u001a\u0002\n}"));
        try {
            this.mac = Mac.getInstance(Base64.lastIndexOf((int)(126 / 35), (String)"KideT@H;"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(Base64.lastIndexOf((int)(122 + 70), (String)"\u0003.7/ e((<i,\"\")n<80cs5918*0.31"), noSuchAlgorithmException);
        }
        try {
            this.mac.init(this.signingKey);
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(JSON.regionMatches((String)"\u0000+0*#h'%?l$ &$83?=/3w,1?{\u0011\u001c\u001d\u007famelvlroe", (int)(11 * 9)), invalidKeyException);
        }
    }

    public void addProperties(WMSProperties wMSProperties) {
        this.properties.putAll((Map)wMSProperties);
    }

    @Override
    public void setDestinationAddress(String string, int n) {
        this.host = string;
        this.port = n;
    }

    @Override
    public void setProxyAddress(String string, int n) {
        this.proxyHost = string;
        this.proxyPort = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {}
        this.socket = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() {
        if (this.socket != null) {
            this.close();
        }
        try {
            this.socket = new Socket();
            this.socket.setKeepAlive(true);
            this.socket.setSendBufferSize(this.sendBufferSize);
            this.socket.setReceiveBufferSize(this.receiveBufferSize);
            this.socket.setSoTimeout(this.readTimeout);
            this.socket.connect(new InetSocketAddress(this.proxyHost, this.proxyPort), this.connectionTimeout);
            this.logSocketWarning = true;
            return;
        }
        catch (Exception exception) {
            this.close();
            return;
        }
    }

    protected void reconnect() {
        this.connect();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOpen() {
        if (this.socket == null) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseHeader(SendResult var1_1, byte[] var2_2, int var3_3, int var4_4, boolean var5_5) {
        block29: {
            block24: {
                block27: {
                    block28: {
                        block23: {
                            try {
                                block26: {
                                    block25: {
                                        block22: {
                                            block21: {
                                                var6_6 = 0;
                                                block10: while (var6_6 < var4_4) {
                                                    if (var2_2[var6_6 + var3_3] != 13 || var6_6 + 3 >= var4_4 || var2_2[var6_6 + var3_3] != 13) {
                                                        while (true) {
                                                            ++var6_6;
                                                            continue block10;
                                                            break;
                                                        }
                                                    }
                                                    break block21;
                                                }
                                                return;
                                            }
                                            if (var2_2[var6_6 + var3_3 + 1] != 10 || var2_2[var6_6 + var3_3 + 2] != 13 || var2_2[var6_6 + var3_3 + 3] != 10) ** continue;
                                            var1_1.gotHeader = true;
                                            var1_1.headerLength = var6_6 + 4;
                                            var7_8 = new String(var2_2, var3_3, (int)var1_1.headerLength);
                                            while ((var8_9 = var7_8.substring(0, 1)).equals("\n") || var8_9.equals("\r")) {
                                                if ((var7_8 = var7_8.substring(1)).length() != 0) continue;
                                                break;
                                            }
                                            var7_8 = var7_8.replace(Base64.lastIndexOf((int)(-10 - -41), (String)"\u0012\n"), "\n").replace("\r", "\n");
                                            var8_9 = var7_8.split("\n");
                                            var1_1.headerStr = var7_8;
                                            var9_10 = 0;
                                            block13: while (var9_10 < var8_9.length) {
                                                if (var8_9[var9_10].length() == 0) lbl-1000:
                                                // 12 sources

                                                {
                                                    while (true) {
                                                        ++var9_10;
                                                        continue block13;
                                                        break;
                                                    }
                                                }
                                                break block22;
                                            }
                                            return;
                                        }
                                        if (this.debugInfo != null) {
                                            var10_13 = this.debugPrefix + var8_9[var9_10];
                                            this.debugInfo.add(var10_13);
                                        }
                                        if (var9_10 != 0) break block25;
                                        var10_12 = var8_9[var9_10].split(" ");
                                        if (var10_12.length <= 1) ** GOTO lbl-1000
                                        break block26;
                                    }
                                    var10_11 = var8_9[var9_10].indexOf(":");
                                    if (var10_11 >= 0) break block23;
                                    ** GOTO lbl-1000
                                }
                                try {}
                                catch (Exception var11_15) {}
                                break block24;
                                ** GOTO lbl-1000
                            }
                            catch (Exception var6_7) {
                                WMSLoggerFactory.getLogger(null).error(JSON.regionMatches((String)"HccahIjoekGDEBQmasE}x~~n3n~rrgKadbbzR", (int)(893 / 155)) + this.getConextPath() + JSON.regionMatches((String)"\u0013o", (int)(41 - 59)), (Throwable)var6_7);
                                return;
                            }
lbl50:
                            // 1 sources

                            while (true) {
                                var12_16 = var12_16.substring(Base64.lastIndexOf((int)(56 - 47), (String)"ks\u007fi~.").length());
                                while (true) {
                                    var13_17 = var12_16.split(JSON.regionMatches((String)"R%V", (int)(5 - -4)));
                                    var14_20 = var13_17[0].split(Base64.lastIndexOf((int)(18 - 13), (String)"^+Z"));
                                    var1_1.contentRangeStart = Long.parseLong(var14_20[0]);
                                    var1_1.contentRangeStop = Long.parseLong(var14_20[1]);
                                    var1_1.contentRangeFound = true;
                                    break;
                                }
                                break;
                            }
lbl60:
                            // 1 sources

                            while (true) {
                                if (!var11_14.equalsIgnoreCase(JSON.regionMatches((String)"@kkrbf}'Ymcij", (int)(330 / 89)))) ** GOTO lbl-1000
                                if (!(var12_16 = var12_16.trim()).startsWith(JSON.regionMatches((String)"=95'0d", (int)(-23 - 10)))) ** continue;
                                ** continue;
                                break;
                            }
                        }
                        var11_14 = var8_9[var9_10].substring(0, var10_11).trim();
                        var12_16 = var8_9[var9_10].substring(var10_11 + 1).trim();
                        if (!var11_14.equalsIgnoreCase(Base64.lastIndexOf((int)(90 + -29), (String)"^qq4$,7i\t#)/=\""))) break block27;
                        try {}
                        catch (Exception var13_18) {}
                        break block28;
                        ** GOTO lbl-1000
                    }
                    var1_1.contentLength = Long.parseLong(var12_16);
                }
                ** while (!var11_14.equalsIgnoreCase((String)Base64.lastIndexOf((int)(39 * 51), (String)"\t'4<d\u0007$($(&55")))
lbl-1000:
                // 1 sources

                try {}
                catch (Exception var13_19) {
                }
                break block29;
                catch (Exception var15_21) {}
                ** GOTO lbl-1000
            }
            var1_1.status = Integer.parseInt(var10_12[1]);
        }
        var1_1.lastModified = DateUtils.parseDate((String)var12_16, (String[])this.parseDateFormats);
        ** while (true)
    }

    @Override
    public MediaCacheHTTPByteReaderResult read(String string, long l, int n) {
        this.reqPath = string;
        return this.readDirect(string, l, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getRequestPath(String string, String string2, int n) {
        if (!this.requestFullURL) return string;
        return Base64.lastIndexOf((int)(1 + 75), (String)"$9:?j~}") + string2 + (this.port != 80 ? ":" + this.port : "") + (string.startsWith("/") ? string : "/" + string);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getConextPath() {
        String string;
        String string2 = "";
        if (this.reqPath != null) {
            string2 = this.reqPath;
        }
        StringBuilder stringBuilder = new StringBuilder().append(JSON.regionMatches((String)"yfgd/98", (int)(35 * 59))).append(this.host).append(":").append(this.port);
        if (!string2.startsWith("/")) {
            string = "/" + string2;
            return stringBuilder.append(string).toString();
        }
        string = string2;
        return stringBuilder.append(string).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getHeaderHost() {
        String string;
        StringBuilder stringBuilder;
        block2: {
            block1: {
                stringBuilder = new StringBuilder().append(this.host);
                if (this.port != 80) break block1;
                break block2;
            }
            string = ":" + this.port;
            return stringBuilder.append(string).toString();
        }
        string = "";
        return stringBuilder.append(string).toString();
    }

    protected String httpDate() {
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)JSON.regionMatches((String)"\\_^0=z{ LON$|\u007f~q)BC6`c5cb2", (int)(35 * 19)), (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.US);
        return fastDateFormat.format(new Date()) + JSON.regionMatches((String)"MFX", (int)(95 + -85));
    }

    public String signRequest(String string, String string2) {
        return Base64.encodeBytes((byte[])this.mac.doFinal(string2.getBytes()));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void getHeadCommand(String string) {
        if (this.awsAccessKeyId != null) {
            this.getHeadCommandS3(string);
        } else {
            this.msgBuf.setLength(0);
            this.msgBuf.append(Base64.lastIndexOf((int)(-10 - 3), (String)"\u001b\u0011\u0014\u0012w") + this.getRequestPath(string, this.host, this.port) + JSON.regionMatches((String)"#LQRW'8$:", (int)(851 / 223)) + Base64.lastIndexOf((int)(880 / 147), (String)"\b\f"));
            this.msgBuf.append(Base64.lastIndexOf((int)(53 * 45), (String)"\u0019=  ov") + this.getHeaderHost() + Base64.lastIndexOf((int)(-47 - -32), (String)"\\X"));
            if (this.userAgent != null) {
                this.msgBuf.append(Base64.lastIndexOf((int)(-45 - 54), (String)"Hmzr,Cdakr=(") + this.userAgent + JSON.regionMatches((String)"\u000e\u000e", (int)(592 / 153)));
            }
            if (this.sendHTTPKeepAlive) {
                this.msgBuf.append(JSON.regionMatches((String)"Bmmj`esafd1,fkj`<s\u007f}cs\u001a\u0012", (int)(15 + 18)));
            }
            if (this.sendHTTPProxyKeepAlive) {
                this.msgBuf.append(JSON.regionMatches((String)"Psm{}(Ehfgohxdaa*1yvqe;vtpl~\u0011\u0017", (int)(-15 - -47)));
            }
            this.msgBuf.append(JSON.regionMatches((String)"\b\f", (int)(691 / 122)));
        }
        if (!this.debugHTTPRequests) return;
        WMSLoggerFactory.getLogger(null).info(Base64.lastIndexOf((int)(-61 - 62), (String)"HccahIjoekGDEBQmasE}x~~n3yztIgb`FijehdoW") + this.getConextPath() + Base64.lastIndexOf((int)(-29 - -19), (String)"\u000bmx") + string + "\n" + this.msgBuf.toString());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public MediaCacheHTTPByteReaderResult head(String var1_1) {
        var2_2 = null;
        this.reqPath = var1_1;
        var3_3 = System.nanoTime();
        this.getHeadCommand(var1_1);
        var5_4 = this.msgBuf.toString().getBytes();
        var6_5 = 0;
        if (true) ** GOTO lbl40
        do {
            block11: {
                block14: {
                    block9: {
                        block10: {
                            block8: {
                                block13: {
                                    block7: {
                                        block12: {
                                            if ((var7_6 = this.sendRequest(var5_4, true)) == null) break block12;
                                            break block13;
                                            while (true) {
                                                v0 = 0L;
                                                break block7;
                                                break;
                                            }
lbl14:
                                            // 1 sources

                                            while (true) {
                                                this.uses = 0;
                                                this.close();
                                                break block8;
                                                break;
                                            }
lbl18:
                                            // 1 sources

                                            while (!this.isOpen()) {
                                                break block9;
                                            }
                                            continue;
                                        }
lbl22:
                                        // 2 sources

                                        while (true) {
                                            ++var6_5;
                                            break block10;
                                            break;
                                        }
                                    }
lbl26:
                                    // 2 sources

                                    while (true) {
                                        var2_2.lastModified = v0;
                                        var2_2.tries = var6_5;
                                        var2_2.elapseTime = (System.nanoTime() - var3_3) / 1000000L;
                                        break block11;
                                        break;
                                    }
                                }
                                var2_2 = new MediaCacheHTTPByteReaderResult();
                                var2_2.status = var7_6.status;
                                var2_2.contentLength = var7_6.contentLength;
                                if (var7_6.lastModified == null) ** continue;
                                break block14;
                            }
                            return var2_2;
                        }
                        if (var6_5 >= this.maxRetries) break block11;
                        ** GOTO lbl18
                    }
                    this.reconnect();
                    continue;
                }
                v0 = var7_6.lastModified.getTime();
                ** continue;
            }
            ++this.uses;
            if (this.uses < this.maxUsesBeforeReconnect) ** continue;
            ** continue;
        } while (this.isOpen());
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void getGetCommand(String string, long l, int n) {
        if (this.awsAccessKeyId != null) {
            this.getGetCommandS3(string, l, n);
        } else {
            long l2 = l;
            long l3 = l + (long)n - 1L;
            this.msgBuf.setLength(0);
            this.msgBuf.append(JSON.regionMatches((String)"]^H=", (int)(-47 - 23)) + this.getRequestPath(string, this.host, this.port) + JSON.regionMatches((String)"&O\\]Z$=#?", (int)(1477 / 220)) + JSON.regionMatches((String)"OI", (int)(9 - 39)));
            this.msgBuf.append(JSON.regionMatches((String)"\u00115((g~", (int)(48 - -41)) + this.getHeaderHost() + Base64.lastIndexOf((int)(1091 / 163), (String)"\u000b\r"));
            if (this.userAgent != null) {
                this.msgBuf.append(Base64.lastIndexOf((int)(65 + -64), (String)"Tqfv(G`mg~1,") + this.userAgent + Base64.lastIndexOf((int)(1020 / 207), (String)"\t\u000f"));
            }
            this.msgBuf.append(JSON.regionMatches((String)"Qekab2)hrxh}2", (int)(43 + 88)) + l2 + "-" + l3 + JSON.regionMatches((String)"\u001a\u0012", (int)(-81 + 104)));
            if (this.sendHTTPKeepAlive) {
                this.msgBuf.append(JSON.regionMatches((String)"P{{xr{mstr'>tedr.eioqm\u0004\u0000", (int)(5 * 55)));
            }
            if (this.sendHTTPProxyKeepAlive) {
                this.msgBuf.append(Base64.lastIndexOf((int)(49 * 55), (String)"Wzfrr!Naa~tqg}zx-8r\u007f~l0\u007fsiwg\u000e\u000e"));
            }
            this.msgBuf.append(Base64.lastIndexOf((int)(-53 - -20), (String)"RJ"));
        }
        if (!this.debugHTTPRequests) return;
        WMSLoggerFactory.getLogger(null).info(JSON.regionMatches((String)"\f''-$\u0005&+!/\u0003\u0018\u0019\u001e\r)%7\u00011422*w=>(\u001a;+Cnonekb\\", (int)(-52 - -21)) + this.getConextPath() + JSON.regionMatches((String)"\u001cxc", (int)(59 * 19)) + string + "\n" + this.msgBuf.toString());
    }

    /*
     * Unable to fully structure code
     */
    public MediaCacheHTTPByteReaderResult readDirect(String var1_1, long var2_2, int var4_3) {
        block19: {
            block23: {
                block22: {
                    block18: {
                        block21: {
                            block16: {
                                block12: {
                                    block17: {
                                        block13: {
                                            var5_4 = null;
                                            var6_5 = System.nanoTime();
                                            this.reqPath = var1_1;
                                            var8_6 = var2_2;
                                            var10_7 = var2_2 + (long)var4_3 - 1L;
                                            this.getGetCommand(var1_1, var2_2, var4_3);
                                            var12_8 = this.msgBuf.toString().getBytes();
                                            var13_9 = 0;
                                            break block16;
lbl10:
                                            // 3 sources

                                            while (true) {
                                                if (var5_4 == null) ** GOTO lbl19
                                                break block12;
                                                break;
                                            }
lbl13:
                                            // 2 sources

                                            while (true) {
                                                block15: {
                                                    block14: {
                                                        block20: {
                                                            if (this.isOpen()) break block13;
                                                            break block20;
lbl16:
                                                            // 1 sources

                                                            while (true) {
                                                                if (var14_10.buffer != null) break block14;
                                                                break block15;
                                                                break;
                                                            }
                                                        }
                                                        ++var13_9;
                                                        break block16;
                                                    }
                                                    if (var14_10.status < 200) break block15;
                                                    break block17;
                                                    while (true) {
                                                        this.uses = 0;
                                                        this.close();
                                                        ** GOTO lbl63
                                                        break;
                                                    }
lbl29:
                                                    // 1 sources

                                                    while (true) {
                                                        WMSLoggerFactory.getLogger(null).info(Base64.lastIndexOf((int)(61 * 15), (String)"^qq\u007fv[xysyUJKPC{waWcfllx%~hokTx`vwaM") + this.getConextPath() + JSON.regionMatches((String)"T0+kbak*", (int)(40 + -31)) + var15_11 + Base64.lastIndexOf((int)(118 + 41), (String)"?p`vk>") + var1_1 + JSON.regionMatches((String)"u%#9-/(f", (int)(82 + 35)) + var14_10.status + JSON.regionMatches((String)"&ddld1", (int)(475 / 76)) + var14_10.contentLength + "=" + var4_3 + Base64.lastIndexOf((int)(1 + 103), (String)"h;+%+(\u0015") + var14_10.contentRangeFound + Base64.lastIndexOf((int)(51 + 20), (String)"\u001ar") + var14_10.contentRangeStart + "=" + var8_6 + "-" + var14_10.contentRangeStop + "=" + var10_7 + "\n" + var14_10.headerStr);
                                                        ** GOTO lbl10
                                                        break;
                                                    }
                                                }
lbl33:
                                                // 7 sources

                                                while (true) {
                                                    if (var14_10 == null) ** GOTO lbl10
                                                    break block18;
                                                    break;
                                                }
                                                break;
                                            }
lbl36:
                                            // 2 sources

                                            while (true) {
                                                var15_11 = true;
                                                var5_4 = new MediaCacheHTTPByteReaderResult();
                                                var5_4.buffer = var14_10.buffer;
                                                var5_4.contentLength = var14_10.contentLength;
                                                var5_4.headerLength = var14_10.headerLength;
                                                var5_4.status = var14_10.status;
                                                var5_4.tries = var13_9;
                                                var5_4.roffset = var16_12;
                                                var5_4.rlen = var18_13;
                                                var5_4.elapseTime = (System.nanoTime() - var6_5) / 1000000L;
                                                ** GOTO lbl33
                                                break;
                                            }
lbl48:
                                            // 1 sources

                                            while (true) {
                                                WMSLoggerFactory.getLogger(null).debug(JSON.regionMatches((String)"aeaTffnoXxb~50", (int)(677 / 193)) + var14_10.contentRangeStop + "/" + var10_7);
                                                ** GOTO lbl33
                                                break;
                                            }
                                        }
                                        var14_10 = this.sendRequest(var12_8, var4_3, false);
                                        var15_11 = false;
                                        ** while (var14_10 != null)
lbl55:
                                        // 1 sources

                                        ** GOTO lbl33
                                    }
                                    if (var14_10.status < 300) break block21;
                                    ** GOTO lbl33
                                }
lbl60:
                                // 2 sources

                                while (true) {
                                    ++this.uses;
                                    if (this.uses >= this.maxUsesBeforeReconnect) ** continue;
lbl63:
                                    // 2 sources

                                    return var5_4;
                                }
                            }
                            ** while (var13_9 >= this.maxRetries)
lbl66:
                            // 1 sources

                            break block22;
                            while (true) {
                                if (var14_10.contentRangeStop == var10_7) ** GOTO lbl36
                                ** continue;
                                break;
                            }
                        }
                        if (var14_10.contentLength == (long)var4_3) break block23;
                        ** GOTO lbl33
                    }
                    if (this.debugHTTPRequests) ** break;
                    ** while (true)
                    ** while (true)
lbl77:
                    // 1 sources

                    while (true) {
                        this.reconnect();
                        ** GOTO lbl13
                        break;
                    }
                }
                this.debugPrefix = Base64.lastIndexOf((int)(27 * 43), (String)"{ojhIg}urfH") + var13_9 + Base64.lastIndexOf((int)(9 * 13), (String)"\blw");
                if (!this.isOpen()) ** break;
                ** while (true)
                ** while (true)
lbl85:
                // 1 sources

                while (true) {
                    var16_12 = var14_10.contentRangeStart;
                    var18_13 = var14_10.contentRangeStop - var14_10.contentRangeStart + 1L;
                    if (var14_10.contentRangeStart == var8_6) ** continue;
                    break block19;
                    break;
                }
            }
            var16_12 = 0L;
            var18_13 = 0L;
            if (var14_10.contentRangeFound) ** break;
            ** while (true)
            ** while (true)
        }
        WMSLoggerFactory.getLogger(null).debug(JSON.regionMatches((String)"`b`WgiolY\u007fm\u007fz50", (int)(-37 - -39)) + var14_10.contentRangeStart + "/" + var8_6);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void dumpDebug() {
        if (this.debugInfo == null) {
            return;
        }
        Iterator<String> iterator = this.debugInfo.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            System.out.println(string);
        }
    }

    public SendResult sendRequest(byte[] byArray, boolean bl) {
        return this.sendRequest(byArray, 0, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SendResult sendRequest(byte[] byArray, int n, boolean bl) {
        SendResult sendResult;
        block12: {
            boolean bl2;
            int n2;
            if (this.socket == null) {
                return null;
            }
            OutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                outputStream = this.socket.getOutputStream();
                inputStream = this.socket.getInputStream();
            }
            catch (Exception exception) {
                return null;
            }
            if (outputStream == null) return null;
            if (inputStream == null) {
                return null;
            }
            sendResult = new SendResult();
            sendResult.buffer = new byte[n + 4096];
            try {
                outputStream.write(byArray);
                n2 = 0;
                bl2 = true;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).error(Base64.lastIndexOf((int)(477 / 144), (String)"NaaofKhiciEZ[@SkgqGsv||h5oxp{Rdsvavr\\") + this.getConextPath() + JSON.regionMatches((String)"J8", (int)(73 + -18)), (Throwable)exception);
                sendResult = null;
                break block12;
            }
            do {
                int n3;
                int n4;
                if ((n4 = sendResult.buffer.length - n2) <= 0) {
                    byte[] byArray2 = new byte[sendResult.buffer.length + 1024];
                    System.arraycopy(sendResult.buffer, 0, byArray2, 0, sendResult.buffer.length);
                    sendResult.buffer = byArray2;
                    n4 = sendResult.buffer.length - n2;
                }
                if ((n3 = inputStream.read(sendResult.buffer, n2, n4)) == -1) {
                    sendResult = null;
                    break;
                }
                n2 += n3;
                if (!sendResult.gotHeader) {
                    SendResult sendResult2 = sendResult;
                    this.parseHeader(sendResult2, sendResult2.buffer, 0, n2, bl);
                }
                if (!sendResult.gotHeader || !bl2) continue;
                bl2 = false;
                if (bl || sendResult.status < 200 || sendResult.status >= 300 || sendResult.contentLength <= (long)n) continue;
                if (this.logSocketWarning) {
                    WMSLoggerFactory.getLogger(null).warn(Base64.lastIndexOf((int)(23 * 7), (String)"LggmdEfkaoCXY^MiewAqtrrj7i~ryLz14'00\u001e") + this.getConextPath() + Base64.lastIndexOf((int)(84 + -79), (String)"X<'Ag|j`dj/XEFC4woc}9hzrz{?rdsvavr'Kfd\u007ficz\"\\t|t`},7") + sendResult.contentLength + Base64.lastIndexOf((int)(12 + 84), (String)"`\u007fb") + n);
                    this.logSocketWarning = false;
                }
                if (!this.closeConnectOnBadContentLength) continue;
                sendResult = null;
                break;
            } while (!sendResult.gotHeader || (long)n2 < sendResult.size() && !bl);
        }
        if (sendResult != null) {
            if (sendResult.keepAlive) return sendResult;
            this.close();
            return sendResult;
        }
        this.close();
        return sendResult;
    }

    public int getMaxUsesBeforeReconnect() {
        return this.maxUsesBeforeReconnect;
    }

    public void setMaxUsesBeforeReconnect(int n) {
        this.maxUsesBeforeReconnect = n;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public boolean isRequestFullURL() {
        return this.requestFullURL;
    }

    @Override
    public void setRequestFullURL(boolean bl) {
        this.requestFullURL = bl;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    @Override
    public void setSendBufferSize(int n) {
        this.sendBufferSize = n;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Override
    public void setReceiveBufferSize(int n) {
        this.receiveBufferSize = n;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    public void setAwsSecretAccessKey(String string) {
        this.awsSecretAccessKey = string;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public void setAwsAccessKeyId(String string) {
        this.awsAccessKeyId = string;
    }

    class SendResult {
        public long contentLength = 0L;
        public long headerLength = 0L;
        public long contentRead = 0L;
        public Date lastModified = null;
        public int status = 500;
        public boolean gotHeader = false;
        public boolean gotMessage = false;
        public byte[] buffer = null;
        public boolean keepAlive = true;
        public boolean contentRangeFound = false;
        public long contentRangeStart = 0L;
        public long contentRangeStop = 0L;
        public String headerStr = "";

        SendResult() {
        }

        public long size() {
            return this.contentLength + this.headerLength;
        }
    }
}

