/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264;

import com.wowza.io.IRandomAccessReader;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.io.ScheduledRandomAccessReaderWrapper;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.HTTPUtils;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.util.JSON;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.drm.playready.PlayReadyMediaInfo;
import com.wowza.wms.drm.playready.PlayReadySampleInfo;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.h264.H264Cursor;
import com.wowza.wms.mediareader.h264.H264ReadAheadPacket;
import com.wowza.wms.mediareader.h264.H264ReadAheadRequest;
import com.wowza.wms.mediareader.h264.H264StreamPosition;
import com.wowza.wms.mediareader.h264.IQTDataDataToAMF;
import com.wowza.wms.mediareader.h264.atom.ESDSData;
import com.wowza.wms.mediareader.h264.atom.IQTCodecData;
import com.wowza.wms.mediareader.h264.atom.QTAtommdia;
import com.wowza.wms.mediareader.h264.atom.QTAtomminf;
import com.wowza.wms.mediareader.h264.atom.QTAtommoov;
import com.wowza.wms.mediareader.h264.atom.QTAtomstbl;
import com.wowza.wms.mediareader.h264.atom.QTAtomtrak;
import com.wowza.wms.mediareader.h264.atom.QTMediaContainer;
import com.wowza.wms.mediareader.h264.atom.QTTX3GData;
import com.wowza.wms.mediareader.h264.atom.QTTX3GFont;
import com.wowza.wms.mediareader.h264.util.QTParseContext;
import com.wowza.wms.mediareader.h264.util.QTUtils;
import com.wowza.wms.protocol.wowz.WOWZHeader;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderEncInfo;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderEncInfo;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import com.wowza.wms.timedtext.amf.ITimedTextProviderAMF;
import com.wowza.wms.timedtext.impl.H264CursorCaptionProvider;
import com.wowza.wms.timedtext.model.IVODTimedTextDelegate;
import com.wowza.wms.timedtext.model.IVODTimedTextProvider;
import com.wowza.wms.timedtext.model.TimedTextRequest;
import com.wowza.wms.timedtext.vod.model.TimedTextMediaReaderContext;
import com.wowza.wms.timedtext.vod.model.VODTimedTextDelegateFactory;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;

public class MediaReaderH264
implements IMediaReader,
IQTDataDataToAMF,
IMediaReaderEncInfo {
    private static final Object a = Base64.lastIndexOf((int)(27 * 33), (String)"\u0016997>RdcgawN5>=");
    private static final Class<MediaReaderH264> b = MediaReaderH264.class;
    public static final String H264_DATATYPE_3GPP = "tx3g";
    protected MediaReaderItem mediaReaderItem = null;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = JSON.regionMatches((String)"f|9", (int)(-7 - -18));
    protected String mediaReaderExt = Base64.lastIndexOf((int)(215 / 53), (String)"iu2");
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = JSON.regionMatches((String)"hv3", (int)(239 / 44));
    protected QTMediaContainer container = null;
    protected H264Cursor cursor = null;
    protected int cursorType = 2;
    protected H264Cursor cursorReadAhead = null;
    protected H264ReadAheadRequest currReadAhead = null;
    protected H264ReadAheadRequest nextReadAhead = null;
    protected boolean cacheReadAhead = false;
    protected Object readAheadLock = new Object();
    protected List<H264ReadAheadRequest> readAheadCache = new ArrayList<H264ReadAheadRequest>();
    protected int readAheadSize = 65536;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected int indexBufferSize = 65536;
    protected boolean useDisplaySize = true;
    protected IRandomAccessReader videoFileStream = null;
    protected IRandomAccessReader metaFileStream = null;
    protected List metaData = null;
    protected long duration = -1L;
    protected long length = 0L;
    protected long videoSampleCount = -1L;
    protected long audioSampleCount = -1L;
    protected long dataSampleCount = -1L;
    protected byte[] chunkWorkBuffer = null;
    protected int[] chunkHeaderValues = null;
    protected boolean doSendVideoTrakInfo = false;
    protected boolean doSendAudioTrakInfo = false;
    protected boolean doSendEnhanceSeek = false;
    protected boolean errorReported = false;
    protected int audioType = 175;
    protected int audioExtraSize = 2;
    protected String randomAccessReaderClass = JSON.regionMatches((String)",?<|$;\",6v05u\u00184,:#5\u0010\"*!)*\t*).?>\u001c*157!", (int)(35 - -44));
    protected String randomAccessReadOptimizerClass = Base64.lastIndexOf((int)(31 - 41), (String)"585w-4+'?qin,QekbheHihi~}]upv\\da\u007fzqc\u007fi");
    protected IApplicationInstance appInstance = null;
    protected int videoCodec = 7;
    protected int audioCodec = 10;
    protected boolean openAudioTrack = true;
    protected boolean openVideoTrack = true;
    protected int trackIndexVideo = 0;
    protected int trackIndexAudio = 0;
    protected int trackIndexData = -1;
    protected String trackDataCharSet = JSON.regionMatches((String)"@BQ5!", (int)(55 * 19));
    protected long onMetadataSample = -1L;
    protected boolean bufferSeekIO = false;
    protected IQTDataDataToAMF dataDataToAMFHandler = this;
    protected MediaReaderEncInfo encInfo = new MediaReaderEncInfo();
    protected boolean captionsEnabled = true;
    protected IVODTimedTextDelegate captionsDelegate = null;
    protected TimedTextRequest captionRequest = new TimedTextRequest();
    protected String captionsDelegateClass = Base64.lastIndexOf((int)(45 * 13), (String)"*%&b:!8*0|$9&x#14??(8&+n7-'j72*8g\u001c\u0004\b\u0019'\"55\u00066,!\u001224<=:(8\f+mq");
    private String c = null;
    private ITimedTextProviderAMF d = null;
    protected String captionLanguageQueryParameter = Base64.lastIndexOf((int)(414 / 132), (String)"tkr|fkhz\u007feb`cq\u007fufursd");
    protected String captionFilenameQueryParameter = Base64.lastIndexOf((int)(65 + 43), (String)";\"95123# <99>06>");
    protected boolean onSeekUseVideoTimecode = true;
    protected boolean calculateDatarate = false;
    protected long reportDirectOutputError = -1L;
    static long e = -1L;

    public MediaReaderH264() {
        this.chunkHeaderValues = new int[5];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperties(WMSProperties wMSProperties) {
        this.readAheadSize = wMSProperties.getPropertyInt(JSON.regionMatches((String)"kw<[ojhLfjquAznp", (int)(26 + -20)), this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt(JSON.regionMatches((String)"hv3ZlkoMekntE`zsrse", (int)(21 * 49)), this.readAheadTrigger);
        this.indexBufferSize = wMSProperties.getPropertyInt(JSON.regionMatches((String)"so4Hlga}Drnooy_dtj", (int)(-25 + 55)), this.indexBufferSize);
        this.cacheReadAhead = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"zh-Yz\u007fu{M% &\u0002, '#", (int)(100 + -45)), this.cacheReadAhead);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr(Base64.lastIndexOf((int)(964 / 208), (String)"vdhcgdKhoh}|BtswqgU{yji"), this.randomAccessReaderClass);
        this.randomAccessReadOptimizerClass = wMSProperties.getPropertyStr(JSON.regionMatches((String)"qekbheHihi~}]upv\\da\u007fzqc\u007fi_q\u007fls", (int)(390 / 122)), this.randomAccessReadOptimizerClass);
        this.useDisplaySize = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(19 - -1), (String)"ye\"Bk|^romr~yRkya"), this.useDisplaySize);
        this.bufferSeekIO = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(118 + -109), (String)"k\u007fmjh|\\utyZ["), this.bufferSeekIO);
        this.bufferSeekIO = wMSProperties.getPropertyBoolean(Base64.lastIndexOf((int)(110 + 36), (String)"\u007fc Wcq~|hHyxuVO"), this.bufferSeekIO);
        this.onSeekUseVideoTimecode = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"mq6LjVcbc\\ynZdjj\u007fE{~qvys}", (int)(40 + 120)), this.onSeekUseVideoTimecode);
        this.calculateDatarate = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"~d!Uvtzow}i{[!5#1%1#", (int)(43 * 25)), this.calculateDatarate);
        if (!WMSLoggerFactory.getLogger(MediaReaderH264.class).isDebugEnabled()) {
            return;
        }
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.lastIndexOf((int)(-39 - -37), (String)"\u0013:dhcQadbbzA8=8#c\u007f$CwrpT~ry}Irfx$?") + this.readAheadSize);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.lastIndexOf((int)(579 / 132), (String)"I`bni[ojhh|G\"'&=ye\"E}x~Ztx\u007f{Tskdc`t=(") + this.readAheadTrigger);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.lastIndexOf((int)(47 - -55), (String)"\u000b\", +\u0019),**\"\u0019`e`{;'l\u00104?9%\u001c*fggqWl|b2)") + this.indexBufferSize);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(JSON.regionMatches((String)"\u0015<>2=\u000f;>ddpK632)zhdoc`Olsta`Fpws}kYw}nm% ", (int)(-24 - -16)) + this.randomAccessReaderClass);
        WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(Base64.lastIndexOf((int)(-63 - 63), (String)"Of`lgUmhnn~E<9$?`rzqyzYzy~onLzaegqKurne`pn~Nbncb(3") + this.randomAccessReadOptimizerClass);
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderExt = this.mediaReaderType = this.mediaReaderType.toLowerCase();
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.metaFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        this.videoFileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string2, (String)string3, (String)this.mediaExtension, (IMediaStream)iMediaStream);
        WMSProperties wMSProperties = iApplicationInstance.getTimedTextProperties();
        WMSProperties wMSProperties2 = iApplicationInstance.getProperties();
        this.captionsEnabled = wMSProperties2.getPropertyBoolean(JSON.regionMatches((String)"hp$\u0002#30,));\f$*.!++", (int)(75 + 115)), this.captionsEnabled);
        this.captionsEnabled = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"qgmIj|yg`~bW}uwzr|", (int)(-45 - 44)), this.captionsEnabled);
        this.captionsEnabled = wMSProperties2.getPropertyBoolean(Base64.lastIndexOf((int)(23 * 27), (String)"?:\" \u0007\u001d\u0017\u00174&#164(\u00193?=ldf"), this.captionsEnabled);
        this.captionsEnabled = wMSProperties.getPropertyBoolean(JSON.regionMatches((String)"qphvQGMIj|yg`~bW}uwzr|", (int)(27 * 25)), this.captionsEnabled);
        this.captionsDelegateClass = wMSProperties2.getPropertyStr(Base64.lastIndexOf((int)(51 * 33), (String)"a`xfAW]YzliwpnrFfh`af|lIgm~}"), this.captionsDelegateClass);
        this.captionsDelegateClass = wMSProperties.getPropertyStr(JSON.regionMatches((String)"tsey\\DHNo\u007fdx}}gQs{}~{oy^r~sr", (int)(1484 / 237)), this.captionsDelegateClass);
        this.captionLanguageQueryParameter = wMSProperties2.getPropertyStr(Base64.lastIndexOf((int)(1 - 32), (String)"\"#30,))\u0004($,9,)*\u0001$7!-\u00057%94?/9/"), this.captionLanguageQueryParameter);
        this.captionLanguageQueryParameter = wMSProperties.getPropertyStr(JSON.regionMatches((String)"`eurnggFjbj{nwtCfqgoGyk{vyi{m", (int)(304 / 84)), this.captionLanguageQueryParameter);
        this.captionFilenameQueryParameter = wMSProperties2.getPropertyStr(JSON.regionMatches((String)"'$63!&$\r%!+!1<7\u0002!0$.\b8(:18*:2", (int)(-7 - 53)), this.captionFilenameQueryParameter);
        this.captionFilenameQueryParameter = wMSProperties.getPropertyStr(JSON.regionMatches((String)";8*/520\u0019imgmehcV}lxr\\l|n}tfvf", (int)(-59 - -51)), this.captionFilenameQueryParameter);
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getContextStr() {
        String string;
        StringBuilder stringBuilder;
        block2: {
            block1: {
                stringBuilder = new StringBuilder();
                if (this.appInstance == null) break block1;
                break block2;
            }
            string = "";
            return stringBuilder.append(string).append("/").append(this.mediaExtension).append(":").append(this.mediaName).toString();
        }
        string = this.appInstance.getContextStr();
        return stringBuilder.append(string).append("/").append(this.mediaExtension).append(":").append(this.mediaName).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initTimedTextOnOpen() {
        if (!this.captionsEnabled) return;
        String string = null;
        if (this.stream != null) {
            string = this.stream.getQueryStr();
        }
        Map map = HTTPUtils.splitQueryStr(string);
        this.captionRequest = this.a(map);
        MediaReaderH264 mediaReaderH264 = this;
        mediaReaderH264.initTimedTextDelegates(mediaReaderH264.captionRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initTimedTextDelegates(TimedTextRequest timedTextRequest) {
        String string;
        IVODTimedTextProvider iVODTimedTextProvider;
        if (!this.captionsEnabled) return;
        if (this.captionsDelegate != null) return;
        MediaReaderH264 mediaReaderH264 = this;
        TimedTextMediaReaderContext timedTextMediaReaderContext = new TimedTextMediaReaderContext((IMediaReader)mediaReaderH264, mediaReaderH264.randomAccessReaderClass, this.appInstance, this.basePath, this.mediaName, this.mediaExtension, this.stream, timedTextRequest);
        this.captionsDelegate = VODTimedTextDelegateFactory.createInstance((IMediaReader)this, (TimedTextMediaReaderContext)timedTextMediaReaderContext, (String)this.captionsDelegateClass);
        if (this.captionsDelegate == null) {
            WMSLoggerFactory.getLogger(b).warn(String.format(Base64.lastIndexOf((int)(641 / 103), (String)"#t&`dbxYgbuuFvlaRrt|}zhxm% Egoabgsm)-.\u007f*.a\u007fe2pfpwc}}4"), a, this.captionsDelegateClass));
            return;
        }
        this.captionsDelegate.indexTimedText();
        Map map = this.captionsDelegate.determineCaptionLanguages(timedTextRequest, ITimedTextProviderAMF.class);
        if (map == null) return;
        if (map.isEmpty()) return;
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        do {
            if (!iterator.hasNext()) return;
        } while (!((iVODTimedTextProvider = (IVODTimedTextProvider)map.get(string = (String)iterator.next())) instanceof ITimedTextProviderAMF));
        this.d = (ITimedTextProviderAMF)iVODTimedTextProvider;
        this.c = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            IRandomAccessReader iRandomAccessReader;
            IRandomAccessReader iRandomAccessReader2;
            block36: {
                block35: {
                    block41: {
                        String string3;
                        Object[] objectArray;
                        String string4;
                        WMSLogger wMSLogger;
                        Exception exception2;
                        block42: {
                            block39: {
                                block40: {
                                    block38: {
                                        if (this.metaFileStream.isOpen()) {
                                            this.close();
                                        }
                                        try {
                                            this.metaFileStream.open();
                                            this.videoFileStream.open();
                                            break block35;
                                        }
                                        catch (Exception exception2) {
                                            if (this.errorReported) break block35;
                                        }
                                        if (!(exception2 instanceof FileNotFoundException)) break block38;
                                        wMSLogger = WMSLoggerFactory.getLogger(MediaReaderH264.class);
                                        string4 = Base64.lastIndexOf((int)(16 + 31), (String)"Buu{rFpws}kR)*)0p0$,\u0018a6\u001b}h\u0007%?l+!:>5hsq&yr+w");
                                        objectArray = new Object[3];
                                        if (this.appInstance == null) break block39;
                                        break block40;
                                    }
                                    WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, Base64.lastIndexOf((int)(-58 - 50), (String)"Ypr~yK\u007fzxxlW276-kuciS8W1,") + exception2.toString(), null, Base64.lastIndexOf((int)(-62 - 53), (String)"~k}ft`"), "comment", 404, this.mediaName, (Throwable)exception2);
                                    break block41;
                                }
                                string3 = this.appInstance.getContextStr();
                                break block42;
                            }
                            string3 = "";
                        }
                        objectArray[0] = string3;
                        objectArray[1] = string;
                        objectArray[2] = this.mediaName;
                        wMSLogger.warn(String.format(string4, objectArray), (Throwable)exception2);
                    }
                    this.errorReported = true;
                }
                iRandomAccessReader2 = null;
                iRandomAccessReader = null;
                if (this.metaFileStream != null && this.metaFileStream.isOpen()) {
                    block37: {
                        try {
                            this.length = this.metaFileStream.length();
                            QTParseContext qTParseContext = new QTParseContext();
                            qTParseContext.setClientId(this.stream.getClientId());
                            qTParseContext.setIndexBufferSize(this.indexBufferSize);
                            qTParseContext.setParseAudioTrack(this.openAudioTrack);
                            qTParseContext.setParseVideoTrack(this.openVideoTrack);
                            qTParseContext.setIndexFilePtr(this.metaFileStream);
                            iRandomAccessReader2 = this.metaFileStream;
                            iRandomAccessReader = null;
                            if (this.bufferSeekIO) {
                                iRandomAccessReader2 = null;
                                try {
                                    iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)string, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                                    iRandomAccessReader.open();
                                }
                                catch (Exception exception) {
                                    iRandomAccessReader = null;
                                }
                                try {
                                    if (iRandomAccessReader != null) {
                                        int n = this.indexBufferSize;
                                        iRandomAccessReader2 = new ScheduledRandomAccessReaderWrapper(this.stream, iRandomAccessReader, n, n / 2);
                                        iRandomAccessReader2.open();
                                    }
                                }
                                catch (Exception exception) {
                                    iRandomAccessReader2 = null;
                                }
                                if (iRandomAccessReader2 == null) {
                                    iRandomAccessReader2 = this.metaFileStream;
                                }
                            }
                            IRandomAccessReader iRandomAccessReader3 = iRandomAccessReader2;
                            this.container = QTUtils.parseQTMediaContainer(iRandomAccessReader3, iRandomAccessReader3.length(), qTParseContext);
                            if (this.bufferSeekIO) {
                                try {
                                    if (iRandomAccessReader2 != null) {
                                        iRandomAccessReader2.close();
                                    }
                                    iRandomAccessReader2 = null;
                                }
                                catch (Exception exception) {}
                                try {
                                    if (iRandomAccessReader != null) {
                                        iRandomAccessReader.close();
                                    }
                                    iRandomAccessReader = null;
                                }
                                catch (Exception exception) {}
                            }
                            if (this.container != null) {
                                MediaReaderH264 mediaReaderH264 = this;
                                this.appInstance.notifyMediaReaderOpen((IMediaReader)mediaReaderH264, mediaReaderH264.stream);
                                QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
                                QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
                                QTAtomtrak qTAtomtrak3 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
                                this.cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, qTAtomtrak3, this.cursorType);
                                if (this.cursor != null) {
                                    this.videoSampleCount = this.cursor.getVideoSampleCount();
                                    this.audioSampleCount = this.cursor.getAudioSampleCount();
                                    this.dataSampleCount = this.cursor.getDataSampleCount();
                                }
                                this.readMetadata();
                                if (this.d != null) {
                                    this.cursor = new H264CursorCaptionProvider(this.d, this.c, qTAtomtrak, qTAtomtrak2, this.cursorType);
                                    if (this.cursor != null) {
                                        this.videoSampleCount = this.cursor.getVideoSampleCount();
                                        this.audioSampleCount = this.cursor.getAudioSampleCount();
                                        this.dataSampleCount = this.cursor.getDataSampleCount();
                                    }
                                }
                                MediaReaderH264 mediaReaderH2642 = this;
                                this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)mediaReaderH2642, mediaReaderH2642.stream);
                                if (qTParseContext.getIndexRefCount() <= 0) {
                                    this.metaFileStream.close();
                                    this.metaFileStream = null;
                                }
                            }
                            if (this.container == null) {
                                if (!this.errorReported) {
                                    WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, JSON.regionMatches((String)"FiignBtswqg^%.-45sm{qza\u000716*4g8(88%#)o68>6t39%58.{\u0007\u0010\u000ek\u001d", (int)(51 * 41)), null, JSON.regionMatches((String)"w`tqm{", (int)(807 / 200)), "comment", 500, this.mediaName);
                                }
                                this.errorReported = true;
                            }
                            break block36;
                        }
                        catch (Exception exception) {
                            if (this.errorReported) break block37;
                        }
                        WMSLoggerFactory.getLogger(MediaReaderH264.class).log(Level.WARN, Base64.lastIndexOf((int)(62 - -37), (String)"\u000e!!/&\u001a,+/)?\u0006}fe|<$08\fj\u0004`{") + exception.toString(), null, Base64.lastIndexOf((int)(-29 - 2), (String)"2'12 4"), "comment", 404, this.mediaName, (Throwable)exception);
                    }
                    this.errorReported = true;
                    this.container = null;
                }
            }
            if (!this.bufferSeekIO) return;
            try {
                if (iRandomAccessReader2 != null) {
                    iRandomAccessReader2.close();
                }
                iRandomAccessReader2 = null;
            }
            catch (Exception exception) {}
            try {
                if (iRandomAccessReader == null) return;
                iRandomAccessReader.close();
                return;
            }
            catch (Exception exception) {}
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOpen() {
        if (this.container == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        this.container = null;
        try {
            if (this.videoFileStream != null) {
                this.videoFileStream.close();
            }
            if (this.metaFileStream != null) {
                this.metaFileStream.close();
            }
            if (this.cursor != null) {
                this.cursor.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.lastIndexOf((int)(99 + 36), (String)"Jmmcj^hokucZ!\"!8xh|t@") + this.getContextStr() + Base64.lastIndexOf((int)(572 / 174), (String)"^$"), (Throwable)exception);
        }
        this.metaData = null;
        this.duration = -1L;
        this.videoSampleCount = -1L;
        this.dataSampleCount = -1L;
        this.audioSampleCount = -1L;
        this.cursor = null;
        this.length = 0L;
        this.onMetadataSample = -1L;
        MediaReaderH264 mediaReaderH264 = this;
        this.appInstance.notifyMediaReaderClose((IMediaReader)mediaReaderH264, mediaReaderH264.stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readMetadata() {
        block50: {
            block46: {
                block49: {
                    block47: {
                        block51: {
                            if (this.container == null) {
                                this.metaData = null;
                                return;
                            }
                            this.initTimedTextOnOpen();
                            var1_46 = false;
                            var2_47 = -1L;
                            if (this.trackIndexData != -1) {
                                var1_46 = true;
                                v0 = this;
                                var2_47 = v0.getTrackDataTrackId(v0.trackIndexData);
                            } else {
                                this.trackIndexData = 0;
                            }
                            this.metaData = new ArrayList<E>();
                            var4_1 = new AMFDataMixedArray();
                            var5_48 = this.container.getMoovAtom();
                            var6_2 = var5_48.getVideoTrack(this.trackIndexVideo);
                            var7_3 = var6_2 == null ? null : var6_2.getMdiaAtom().getMinfAtom().getStblAtom();
                            var8_4 = var5_48.getAudioTrack(this.trackIndexAudio);
                            v1 = var9_5 = var8_4 == null ? null : var8_4.getMdiaAtom().getMinfAtom().getStblAtom();
                            if (this.cursor == null || (var10_50 = this.cursor.getDataSampleCount()) <= 0L || !this.a(var5_48, this.trackIndexData)) break block51;
                            var12_53 = this.getStreamPosition();
                            var13_54 = 0;
                            if (true) ** GOTO lbl129
lbl24:
                            // 4 sources

                            while (var7_3 != null) {
                                var14_7 = var6_2.getMdiaAtom().getTimescale();
                                var16_19 = 0.0;
                                if (var7_3.getTimeToSample() != null) {
                                    var18_27 = var7_3.getTimeToSample().get(0, 1);
                                    var16_19 = (double)var14_7 / (double)var18_27;
                                }
                                var4_1.put(Base64.lastIndexOf((int)(-55 - -38), (String)"9957<2'7:=+;/9"), (AMFData)new AMFDataItem(var16_19));
                                if (!this.calculateDatarate || !((var20_29 = (double)(var18_24 = var6_2.getMdiaAtom().getDuration()) / (double)var14_7) >= 0.0)) break block46;
                                var22_35 = this.cursor.videoGetTotalTrackSize();
                                var24_44 = (int)Math.round((double)(var22_35 * 8L) / (var20_29 * 1024.0));
                                var4_1.put(Base64.lastIndexOf((int)(320 / 76), (String)"rlbbgmk\u007fm\u007fo{u"), (AMFData)new AMFDataItem(var24_44));
                                break block46;
                            }
                            break block46;
lbl37:
                            // 1 sources

                            while (true) {
                                block48: {
                                    block56: {
                                        block55: {
                                            block54: {
                                                block53: {
                                                    block52: {
                                                        if (!var21_34 /* !! */ .hasNext()) break block52;
                                                        var22_37 = (String)var21_34 /* !! */ .next();
                                                        var13_54 = var15_15.getTrackIndex();
                                                        var23_40 = false;
                                                        var24_43 = new AMFDataObj();
                                                        if (!var22_37.equals(JSON.regionMatches((String)"ej s", (int)(21 * 13)))) break block48;
                                                        break block53;
                                                    }
                                                    if (var19_59) {
                                                        var17_55.put(Base64.lastIndexOf((int)(270 / 76), (String)"pehvkmmoxo\u007fg\u007fdx}}"), (AMFData)var18_25);
                                                        var11_51.add((AMFData)var17_55);
                                                    }
                                                    break block47;
                                                }
                                                if (!var1_46 && this.d == null) continue;
                                                if (this.d == null) break block54;
                                                if (StringUtils.isEmpty((String)var16_20)) ** GOTO lbl-1000
                                                break block55;
                                            }
                                            if (var2_47 != var15_15.getTrackId()) break block56;
                                            var25_61 /* !! */  = var15_15.getMdiaAtom().getMinfAtom().getStblAtom().getTX3GData();
                                            var24_43 = this.a((QTTX3GData)var25_61 /* !! */ , var22_37);
                                            var10_49 = true;
                                            break block48;
                                        }
                                        if (var16_20.equals(this.c)) lbl-1000:
                                        // 2 sources

                                        {
                                            if ((var25_61 /* !! */  = this.d.getLanguageRenditionAMF(var16_20)) != null) {
                                                var25_61 /* !! */ .setTrackIndex(var13_54);
                                            }
                                            var26_63 = var15_15.getMdiaAtom().getMinfAtom().getStblAtom().getTX3GData();
                                            var24_43 = this.a(var26_63, var22_37);
                                            var10_49 = true;
                                            break block48;
                                        } else {
                                            var23_40 = true;
                                        }
                                        break block48;
                                    }
                                    var23_40 = true;
                                }
                                if (var23_40) {
                                    var24_43.put(Base64.lastIndexOf((int)(42 + 114), (String)"o|soldvzt`"), (AMFData)new AMFDataItem(Base64.lastIndexOf((int)(45 * 5), (String)"6-4>$3)=://")));
                                } else {
                                    var24_43.put(Base64.lastIndexOf((int)(11 * 21), (String)"4)$:')97?5"), (AMFData)new AMFDataItem(var22_37));
                                }
                                var18_25.add((AMFData)var24_43);
                                var19_59 = true;
                                continue;
                                break;
                            }
                            do {
                                block57: {
                                    if (var14_8 == 18 || var14_8 == 15) {
                                        try {
                                            var17_58 = this.cursor.getFileLoc();
                                            var19_60 = this.cursor.getSize();
                                            if (var19_60 <= 0L) {
                                            }
                                        }
                                        catch (Exception var17_57) {}
                                        break block57;
                                        var21_34 /* !! */  = new byte[(int)var19_60];
                                        var22_36 = 0;
                                        var23_41 = this.videoFileStream;
                                        synchronized (var23_41) {
                                            this.videoFileStream.seek(var17_58);
                                            var22_36 = this.videoFileStream.read(var21_34 /* !! */ , 0, (int)var19_60);
                                        }
                                        if ((long)var22_36 == var19_60 && (var23_41 = new AMFDataList(var21_34 /* !! */ )).size() > 1 && var23_41.get(0).getType() == 2) {
                                            var24_43 = var23_41.getString(0);
                                            if (var24_43.equals(Base64.lastIndexOf((int)(32 - 60), (String)"\u00046#3\f(>*\n?/\"5"))) {
                                                var23_41.remove(0);
                                            }
                                            if (var23_41.size() > 1 && var23_41.get(0).getType() == 2 && (var24_43 = var23_41.getString(0)).equalsIgnoreCase(Base64.lastIndexOf((int)(60 - 40), (String)"{{[rlx^zh|")) && ((var25_62 = var23_41.get(1).getType()) == 3 || var25_62 == 8)) {
                                                if (var25_62 == 3) {
                                                    var26_63 = (AMFDataObj)var23_41.get(1);
                                                    var27_64 = var26_63.getKeys();
                                                    for (String var29_66 : var27_64) {
                                                        var30_67 = var26_63.get(var29_66);
                                                        var4_1.put(var29_66, var30_67);
                                                    }
                                                } else if (var25_62 == 8) {
                                                    var26_63 = (AMFDataMixedArray)var23_41.get(1);
                                                    var27_64 = var26_63.getKeys();
                                                    for (String var29_66 : var27_64) {
                                                        var30_67 = var26_63.get(var29_66);
                                                        var4_1.put(var29_66, var30_67);
                                                    }
                                                }
                                                this.onMetadataSample = this.cursor.getSample();
                                            }
                                        }
                                    }
                                }
                                if (this.onMetadataSample >= 0L) break;
                                this.cursor.moveNextSample();
                                if (this.cursor.isAtEnd()) break;
                                ++var13_54;
lbl129:
                                // 2 sources

                                if (var13_54 >= 10) break;
                                var14_8 = this.cursor.getCurrentType();
                            } while ((var15_16 = this.cursor.getTimeMillis()) <= 0L);
                            this.setStreamPosition(var12_53);
                        }
                        var10_49 = false;
                        var11_51 = new AMFDataArray();
                        var12_52 = var5_48.getTrakCount();
                        var13_54 = 0;
                        break block47;
lbl139:
                        // 1 sources

                        while (this.b(var5_48, this.trackIndexData)) {
                            this.cursor.setDataAtEnd();
                            this.cursor.dCursor = null;
                            this.cursor.dataTrackAtom = null;
                            break block49;
                        }
                        break block49;
lbl145:
                        // 2 sources

                        while (true) {
                            if (var7_3 != null) {
                                var14_10 = var7_3.getDataTypes();
                                if (var14_10.contains(Base64.lastIndexOf((int)(122 + -47), (String)"#:.\u007f")) || var14_10.contains(JSON.regionMatches((String)"mcq9", (int)(1229 / 226)))) {
                                    this.videoCodec = 12;
                                }
                                if (this.useDisplaySize) {
                                    var4_1.put(Base64.lastIndexOf((int)(41 * 41), (String)"f{w`}"), (AMFData)new AMFDataItem(var7_3.getDisplayWidth()));
                                    var4_1.put(Base64.lastIndexOf((int)(-53 - 13), (String)"vz)&*7"), (AMFData)new AMFDataItem(var7_3.getDisplayHeight()));
                                } else {
                                    var4_1.put(JSON.regionMatches((String)"slbs`", (int)(1025 / 208)), (AMFData)new AMFDataItem(var7_3.getFrameWidth()));
                                    var4_1.put(JSON.regionMatches((String)"aobkez", (int)(61 * 61)), (AMFData)new AMFDataItem(var7_3.getFrameHeight()));
                                }
                                var4_1.put(Base64.lastIndexOf((int)(35 * 47), (String)"+<.=4\u0005:0!>"), (AMFData)new AMFDataItem(var7_3.getFrameWidth()));
                                var4_1.put(JSON.regionMatches((String)"1*87>\u0014878(5", (int)(36 - -51)), (AMFData)new AMFDataItem(var7_3.getFrameHeight()));
                                var4_1.put(JSON.regionMatches((String)"kybb\u007fulA~|mr", (int)(17 * 31)), (AMFData)new AMFDataItem(var7_3.getDisplayWidth()));
                                var4_1.put(Base64.lastIndexOf((int)(41 * 27), (String)"7=&&;9 \u0012>5:6+"), (AMFData)new AMFDataItem(var7_3.getDisplayHeight()));
                                var15_17 = var7_3.getFrameRate();
                                if (var15_17 > 0.0) {
                                    var4_1.put(JSON.regionMatches((String)"azhgn~lzj", (int)(18 - 11)), (AMFData)new AMFDataItem(var15_17));
                                }
                            }
                            var4_1.put(Base64.lastIndexOf((int)(33 + 50), (String)">;: '7*3/520"), (AMFData)new AMFDataItem(this.container.getMoovAtom().getOffset() + 8L));
                            var14_12 = 0.0;
                            if (var8_4 != null) {
                                var16_22 = var8_4.getMdiaAtom().getTimescale();
                                var18_24 = var8_4.getMdiaAtom().getDuration();
                                var14_12 = (double)var18_24 / (double)var16_22;
                                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(JSON.regionMatches((String)"neu{|P`dvlpuu&", (int)(13 * 11)) + var14_12 + ":" + var16_22 + ":" + var18_24);
                            }
                            var16_21 = 0.0;
                            if (var6_2 != null) {
                                var18_24 = var6_2.getMdiaAtom().getTimescale();
                                var20_31 = var6_2.getMdiaAtom().getDuration();
                                var16_21 = (double)var20_31 / (double)var18_24;
                                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(JSON.regionMatches((String)"rlbbgM\u007fymyg`~+", (int)(1031 / 251)) + var16_21 + ":" + var18_24 + ":" + var20_31);
                            }
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(JSON.regionMatches((String)"asui}cdb7", (int)(951 / 170)) + Math.max(var14_12, var16_21));
                            var18_28 = Math.max(var14_12, var16_21);
                            this.duration = Math.round(var18_28 * 1000.0);
                            var4_1.put(JSON.regionMatches((String)"m\u007fymyg`~", (int)(95 + -54)), (AMFData)new AMFDataItem(var18_28));
                            var20_33 = new AMFDataList();
                            var20_33.add((AMFData)new AMFDataItem(JSON.regionMatches((String)"qqMdvb@drf", (int)(-19 - -49))));
                            var20_33.add((AMFData)var4_1);
                            var21_34 /* !! */  = var20_33.serialize();
                            this.metaData.add(ByteBuffer.wrap(var21_34 /* !! */ ));
                            if (var9_5 == null) return;
                            var22_38 = var9_5.getDataTypes();
                            var23_42 = this.getAudioCodecConfig(0L);
                            if (!(var22_38.contains(Base64.lastIndexOf((int)(91 + -60), (String)"1mq1")) || var22_38.contains(Base64.lastIndexOf((int)(40 - -34), (String)"';x,")) && var23_42 == null)) {
                                if (var22_38.contains(Base64.lastIndexOf((int)(9 * 23), (String)"< 4*")) && var23_42 == null) {
                                    this.audioType = 178;
                                    this.audioExtraSize = 1;
                                    this.audioCodec = 11;
                                    return;
                                }
                                if (!var22_38.contains(JSON.regionMatches((String)"}~3,", (int)(118 + 38)))) {
                                    if (var22_38.contains(Base64.lastIndexOf((int)(28 + 8), (String)"af+4")) == false) return;
                                }
                                if (var23_42 != null) return;
                                this.audioType = 31;
                                this.audioExtraSize = 1;
                                this.audioCodec = 1;
                                return;
                            }
                            this.audioType = 47;
                            this.audioExtraSize = 1;
                            this.audioCodec = 2;
                            return;
                        }
                    }
                    for (var14_8 = 0; var14_8 < var12_52; ++var14_8) {
                        var15_15 = var5_48.getTrak(var14_8);
                        if (var15_15 == null) continue;
                        var16_20 = var15_15.getLanguageStr();
                        if (var16_20.length() <= 0) {
                            var16_20 = JSON.regionMatches((String)",$,", (int)(1 + 104));
                        }
                        var17_55 = new AMFDataObj();
                        var17_55.put(Base64.lastIndexOf((int)(917 / 221), (String)"hdh`}hmn"), (AMFData)new AMFDataItem(var16_20));
                        var17_55.put(JSON.regionMatches((String)"wmhctkhfn", (int)(553 / 144)), (AMFData)new AMFDataItem(var15_15.getMdiaAtom().getTimescale()));
                        var17_55.put(Base64.lastIndexOf((int)(-21 - 6), (String)")#)/=\""), (AMFData)new AMFDataItem(var15_15.getMdiaAtom().getDuration()));
                        var18_25 = new AMFDataArray();
                        var19_59 = false;
                        var20_30 = var15_15.getMdiaAtom().getMinfAtom().getStblAtom().getDataTypes();
                        var21_34 /* !! */  = (byte[])var20_30.iterator();
                        ** continue;
lbl222:
                        // 1 sources

                        ** GOTO lbl37
                    }
                    if (this.d == null && !var1_46) ** GOTO lbl139
                }
                if (this.d != null && !var10_49 && (var14_11 = this.d.getLanguageRenditionAMF(this.c)) != null) {
                    var14_11.setTrackIndex(var13_54 + 1);
                    var15_14 = new AMFDataObj();
                    var15_14.put(Base64.lastIndexOf((int)(47 * 3), (String)"aoawdstq"), (AMFData)new AMFDataItem(this.c));
                    var15_14.put(Base64.lastIndexOf((int)(196 / 31), (String)"rnelyhmak"), (AMFData)new AMFDataItem(1000));
                    var15_14.put(Base64.lastIndexOf((int)(27 * 23), (String)"!+!7%:"), (AMFData)new AMFDataItem(1000L * var14_11.getDuration()));
                    var16_20 = new AMFDataArray();
                    var17_56 = new AMFDataObj();
                    var17_56.put(Base64.lastIndexOf((int)(197 / 31), (String)"ufeyfnxt~j"), (AMFData)new AMFDataItem(Base64.lastIndexOf((int)(43 * 37), (String)"c`*}")));
                    var16_20.add((AMFData)var17_56);
                    var15_14.put(Base64.lastIndexOf((int)(49 - 23), (String)"izqmrzddq`vlvsafd"), (AMFData)var16_20);
                    var11_51.add((AMFData)var15_14);
                }
                var4_1.put(JSON.regionMatches((String)"ruijabbka", (int)(1351 / 215)), (AMFData)var11_51);
                if (var9_5 == null) ** GOTO lbl24
                var4_1.put(Base64.lastIndexOf((int)(41 * 19), (String)"jyig`sys}zpzd"), (AMFData)new AMFDataItem(var9_5.getAudioChannels()));
                var4_1.put(JSON.regionMatches((String)"epbngzkf|ak}qew", (int)(703 / 141)), (AMFData)new AMFDataItem(var8_4.getMdiaAtom().getTimescale()));
                if (!this.calculateDatarate) ** GOTO lbl24
                var14_13 = var8_4.getMdiaAtom().getTimescale();
                var16_23 = var8_4.getMdiaAtom().getDuration();
                var18_26 = (double)var16_23 / (double)var14_13;
                if (!(var18_26 >= 0.0)) ** GOTO lbl24
                var20_32 = this.cursor.audioGetTotalTrackSize();
                var22_39 = (int)Math.round((double)(var20_32 * 8L) / (var18_26 * 1024.0));
                var4_1.put(JSON.regionMatches((String)"xo\u007furz~4 0\"0 ", (int)(69 + -12)), (AMFData)new AMFDataItem(var22_39));
                ** GOTO lbl24
lbl250:
                // 1 sources

                while (true) {
                    var4_1.put(JSON.regionMatches((String)")?)');+#", (int)(14 - 38)), (AMFData)new AMFDataItem(var14_9.getLevel()));
                    var4_1.put(Base64.lastIndexOf((int)(333 / 52), (String)"gqkyxdjdbj"), (AMFData)new AMFDataItem(var14_9.getProfile()));
lbl253:
                    // 2 sources

                    while (var9_5 == null) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var7_3 == null) ** GOTO lbl145
                            var4_1.put(JSON.regionMatches((String)":$**?2=716?3", (int)(-20 - 32)), (AMFData)new AMFDataItem(var7_3.getDataTypes().get(0)));
                            ** continue;
                            break;
                        }
lbl258:
                        // 1 sources

                        ** GOTO lbl145
                    }
                    break block50;
                    break;
                }
            }
            var4_1.put(JSON.regionMatches((String)"cbgdis", (int)(29 - -5)), (AMFData)new AMFDataItem(2.0));
            ** while (var7_3 != null && (var14_9 = var7_3.getAVCCData()) != null)
lbl263:
            // 1 sources

            ** GOTO lbl253
        }
        var4_1.put(JSON.regionMatches((String)"sfp|ytw}\u007fxuy", (int)(-67 + 117)), (AMFData)new AMFDataItem(var9_5.getDataTypes().get(0)));
        ** while (true)
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private final boolean a(QTAtommoov qTAtommoov, int n) {
        block3: {
            String string;
            Iterator<String> iterator;
            boolean bl;
            block2: {
                bl = false;
                QTAtomtrak qTAtomtrak = qTAtommoov.getDataTrack(n);
                QTAtomstbl qTAtomstbl = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
                if (qTAtomstbl == null) return bl;
                List<String> list = qTAtomstbl.getDataTypes();
                iterator = list.iterator();
                if (!true) break block2;
                if (!iterator.hasNext()) return bl;
                if ((string = iterator.next()).toLowerCase().indexOf(JSON.regionMatches((String)"zq{.", (int)(61 * 55))) >= 0) break block3;
            }
            do {
                if (string.toLowerCase().indexOf(JSON.regionMatches((String)"<39s", (int)(11 * 55))) >= 0) return true;
                if (!iterator.hasNext()) return bl;
            } while ((string = iterator.next()).toLowerCase().indexOf(JSON.regionMatches((String)"zq{.", (int)(61 * 55))) < 0);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean b(QTAtommoov qTAtommoov, int n) {
        String string;
        boolean bl = false;
        QTAtomtrak qTAtomtrak = qTAtommoov.getDataTrack(n);
        QTAtomstbl qTAtomstbl = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
        if (qTAtomstbl == null) return bl;
        List<String> list = qTAtomstbl.getDataTypes();
        Iterator<String> iterator = list.iterator();
        do {
            if (!iterator.hasNext()) return bl;
        } while ((string = iterator.next()).toLowerCase().indexOf(Base64.lastIndexOf((int)(18 + 2), (String)"`m%p")) < 0);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private final AMFDataObj a(QTTX3GData qTTX3GData, String string) {
        AMFDataObj aMFDataObj = new AMFDataObj();
        aMFDataObj.put(JSON.regionMatches((String)"ufeyfnxt~j", (int)(1644 / 246)), (AMFData)new AMFDataItem(string));
        if (qTTX3GData == null) return aMFDataObj;
        AMFDataObj aMFDataObj2 = new AMFDataObj();
        aMFDataObj.put(JSON.regionMatches((String)"egeepjs{}sgi", (int)(-37 - -38)), (AMFData)aMFDataObj2);
        AMFDataObj aMFDataObj3 = new AMFDataObj();
        aMFDataObj.put(Base64.lastIndexOf((int)(29 + 100), (String)"egeepjs|lr\u007fnbv"), (AMFData)aMFDataObj3);
        aMFDataObj.put(Base64.lastIndexOf((int)(49 * 59), (String)"/%>>#1(4?52%"), (AMFData)new AMFDataItem(qTTX3GData.displayFlags));
        aMFDataObj.put(Base64.lastIndexOf((int)(690 / 223), (String)"kkwo}gg~j`g{|dxtzwtb~ww"), (AMFData)new AMFDataItem(qTTX3GData.justificationHoriz));
        aMFDataObj.put(JSON.regionMatches((String)"scu|`ij`g{|dxtzwtb~ww", (int)(403 / 72)), (AMFData)new AMFDataItem(qTTX3GData.justificationVert));
        aMFDataObj.put(JSON.regionMatches((String)"wwts~htisz|/--1", (int)(11 * 63)), (AMFData)new AMFDataItem(qTTX3GData.backgroundColor));
        aMFDataObj3.put(JSON.regionMatches((String)"tnr", (int)(50 + 110)), (AMFData)new AMFDataItem(qTTX3GData.textBox[0]));
        aMFDataObj3.put(JSON.regionMatches((String)"8\"+%:", (int)(-53 - -31)), (AMFData)new AMFDataItem(qTTX3GData.textBox[3]));
        aMFDataObj3.put(JSON.regionMatches((String)"+-/>", (int)(95 + 104)), (AMFData)new AMFDataItem(qTTX3GData.textBox[1]));
        aMFDataObj3.put(Base64.lastIndexOf((int)(4 - -53), (String)"{uohrs"), (AMFData)new AMFDataItem(qTTX3GData.textBox[2]));
        aMFDataObj2.put(Base64.lastIndexOf((int)(31 * 13), (String)"``tdc{q{i"), (AMFData)new AMFDataItem(qTTX3GData.startChar));
        aMFDataObj2.put(JSON.regionMatches((String)"icjlxp`", (int)(124 + 48)), (AMFData)new AMFDataItem(qTTX3GData.endChar));
        aMFDataObj2.put(JSON.regionMatches((String)"qwwnrx", (int)(91 + -68)), (AMFData)new AMFDataItem(qTTX3GData.fontId));
        aMFDataObj2.put(JSON.regionMatches((String)"`fkly\u007fuaki|pu`", (int)(1396 / 201)), (AMFData)new AMFDataItem(qTTX3GData.faceStyleFlags));
        aMFDataObj2.put(JSON.regionMatches((String)"4<:!%>\"<", (int)(10 - 24)), (AMFData)new AMFDataItem(qTTX3GData.fontSize));
        aMFDataObj2.put(JSON.regionMatches((String)"qc\u007f|jegc\u007f", (int)(405 / 72)), (AMFData)new AMFDataItem(qTTX3GData.textColor));
        if (qTTX3GData.fonts.size() <= 0) return aMFDataObj;
        AMFDataObj aMFDataObj4 = new AMFDataObj();
        aMFDataObj.put(Base64.lastIndexOf((int)(74 + -52), (String)"pxvmvroi"), (AMFData)aMFDataObj4);
        Iterator<Integer> iterator = qTTX3GData.fonts.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            QTTX3GFont qTTX3GFont = qTTX3GData.fonts.get(n);
            aMFDataObj4.put(qTTX3GFont.fontId + "", (AMFData)new AMFDataItem(qTTX3GFont.fontName));
        }
        return aMFDataObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDuration() {
        if (this.duration >= 0L) {
            return this.duration;
        }
        double d = 0.0;
        IRandomAccessReader iRandomAccessReader = null;
        try {
            long l;
            iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
            iRandomAccessReader.open();
            QTParseContext qTParseContext = new QTParseContext();
            qTParseContext.setClientId(this.stream.getClientId());
            qTParseContext.setIndexFilePtr(iRandomAccessReader);
            IRandomAccessReader iRandomAccessReader2 = iRandomAccessReader;
            QTMediaContainer qTMediaContainer = QTUtils.parseQTMediaContainer(iRandomAccessReader2, iRandomAccessReader2.length(), qTParseContext);
            QTAtomtrak qTAtomtrak = qTMediaContainer.getMoovAtom().getVideoTrack(this.trackIndexVideo);
            QTAtomtrak qTAtomtrak2 = qTMediaContainer.getMoovAtom().getAudioTrack(this.trackIndexAudio);
            double d2 = 0.0;
            if (qTAtomtrak2 != null) {
                long l2 = qTAtomtrak2.getMdiaAtom().getTimescale();
                l = qTAtomtrak2.getMdiaAtom().getDuration();
                d2 = (double)l / (double)l2;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(JSON.regionMatches((String)"epbngM\u007fymyg`~+", (int)(-34 - -38)) + d2 + ":" + l2 + ":" + l);
            }
            double d3 = 0.0;
            if (qTAtomtrak != null) {
                l = qTAtomtrak.getMdiaAtom().getTimescale();
                long l3 = qTAtomtrak.getMdiaAtom().getDuration();
                d3 = (double)l3 / (double)l;
                WMSLoggerFactory.getLogger(MediaReaderH264.class).debug(JSON.regionMatches((String)"pnlleOy\u007fo{y~|)", (int)(1381 / 206)) + d3 + ":" + l + ":" + l3);
            }
            d = Math.max(d2, d3);
        }
        catch (Exception exception) {}
        if (iRandomAccessReader != null) {
            try {
                iRandomAccessReader.close();
            }
            catch (Exception exception) {}
        }
        iRandomAccessReader = null;
        return Math.round(d * 1000.0);
    }

    public IMediaReaderStreamPosition getStreamPosition() {
        if (this.container != null) {
            return new H264StreamPosition(this.cursor.getAudioSample(), this.cursor.getVideoSample(), !this.cursor.isAtDataEnd() ? this.cursor.getDataSample() : -1L);
        }
        return new H264StreamPosition();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        if (this.container == null) {
            return;
        }
        H264StreamPosition h264StreamPosition = (H264StreamPosition)iMediaReaderStreamPosition;
        long l = h264StreamPosition.getAudioSample();
        long l2 = h264StreamPosition.getVideoSample();
        long l3 = h264StreamPosition.getDataSample();
        if (l >= 0L) {
            this.cursor.setAudioSample(l);
        }
        if (l2 >= 0L) {
            this.cursor.setVideoSample(l2);
        }
        if (l3 < 0L) {
            this.cursor.setDataAtEnd();
            return;
        }
        this.cursor.setDataSample(l3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLength() {
        if (this.videoFileStream == null) return 0L;
        long l = this.videoFileStream.length();
        return l;
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public List getMetadata() {
        return this.metaData;
    }

    public String getPath() {
        return this.videoFileStream.getPath();
    }

    public void rewind() {
        if (this.container != null) {
            this.cursor.setAudioSample(0L);
            this.cursor.setVideoSample(0L);
            this.cursor.setDataSample(0L);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlaylistSeekResult seek(long l, int n) {
        if (l > 0L) {
            return this.internalSeek(l, n);
        }
        l = 0L;
        return this.internalSeek(l, n);
    }

    /*
     * Unable to fully structure code
     */
    protected PlaylistSeekResult internalSeek(long var1_1, int var3_2) {
        block41: {
            block43: {
                block42: {
                    block34: {
                        block39: {
                            block40: {
                                block38: {
                                    block37: {
                                        block35: {
                                            block33: {
                                                block32: {
                                                    block36: {
                                                        var4_3 = new PlaylistSeekResult(var1_1);
                                                        if (this.container != null) break block36;
                                                        ** GOTO lbl126
lbl4:
                                                        // 1 sources

                                                        while (true) {
                                                            ++var11_8;
                                                            break block32;
                                                            break;
                                                        }
lbl7:
                                                        // 1 sources

                                                        while (true) {
                                                            var25_19 = 0;
                                                            ** GOTO lbl68
                                                            break;
                                                        }
lbl10:
                                                        // 1 sources

                                                        while (true) {
                                                            continue;
                                                            break;
                                                        }
lbl12:
                                                        // 2 sources

                                                        while (true) {
                                                            var4_3.setResults((IMediaReaderStreamPosition)new H264StreamPosition(var5_5, var9_7, var11_8), var13_11, 8, 1);
                                                            var4_3.setResultTimecode(var13_11);
                                                            var4_3.setSearchTimecode(var1_1);
                                                            return var4_3;
                                                        }
lbl17:
                                                        // 1 sources

                                                        while (true) {
                                                            var26_21 = this.cursor.dataSampleToTimecode(var23_18);
                                                            var28_22 = this.cursor.dataTimecodeToTimeMillis(var26_21);
                                                            if (var28_22 < var15_14) ** GOTO lbl123
                                                            ** GOTO lbl108
                                                            break;
                                                        }
lbl22:
                                                        // 1 sources

                                                        while (true) {
                                                            v0 = this.cursor;
                                                            var5_5 = v0.audioTimecodeToSample(v0.audioTimeMillisToTimecode(var1_1));
                                                            break block33;
                                                            break;
                                                        }
lbl26:
                                                        // 1 sources

                                                        while (true) {
                                                            var15_14 = this.cursor.videoSampleToTimecode(var9_7);
                                                            var13_11 = this.cursor.videoTimecodeToTimeMillis(var15_14);
                                                            this.cursor.resetVideoAtEnd();
                                                            break block34;
                                                            break;
                                                        }
                                                    }
                                                    var5_5 = -1L;
                                                    var7_6 = -1L;
                                                    var9_7 = -1L;
                                                    var11_8 = -1L;
                                                    if (!this.cursor.containsAudio()) break block33;
                                                    ** while (true)
lbl38:
                                                    // 1 sources

                                                    while (true) {
                                                        ++var25_19;
                                                        ** GOTO lbl68
                                                        break;
                                                    }
lbl41:
                                                    // 1 sources

                                                    while (true) {
                                                        var15_14 = this.cursor.audioSampleToTimecode(var5_5);
                                                        var13_11 = this.cursor.audioTimecodeToTimeMillis(var15_14);
                                                        this.cursor.resetAudioAtEnd();
                                                        break block34;
                                                        break;
                                                    }
                                                }
                                                ++var13_9;
                                                ** GOTO lbl117
                                            }
                                            if (!this.cursor.containsData()) break block37;
                                            break block38;
                                            v1 = this.cursor;
                                            var9_7 = v1.videoTimecodeToSample(v1.videoTimeMillisToTimecode(var1_1));
                                            block0 : switch (var3_2) {
                                                case 3: {
                                                    var7_6 = this.cursor.videoFindKeySample(var9_7, 3);
                                                    ** GOTO lbl141
                                                }
lbl58:
                                                // 1 sources

                                                while (true) {
                                                    if (!this.cursor.getDataSampleValid(var11_8 + 1L)) break block0;
                                                    ** continue;
                                                    break;
                                                }
lbl61:
                                                // 1 sources

                                                while (var5_5 >= 0L) {
                                                    ** continue;
lbl63:
                                                    // 1 sources

                                                    ** GOTO lbl41
                                                }
                                                break block34;
lbl65:
                                                // 1 sources

                                                while (this.cursor.getAudioSampleValid(var19_16 + 1L)) {
                                                    ** GOTO lbl113
                                                }
                                                ** GOTO lbl127
lbl68:
                                                // 2 sources

                                                if (var25_19 >= 10) ** GOTO lbl108
                                                ** continue;
lbl70:
                                                // 1 sources

                                                while (true) {
                                                    ++var23_18;
                                                    ** continue;
                                                    break;
                                                }
lbl73:
                                                // 1 sources

                                                while (true) {
                                                    var15_14 = this.cursor.audioSampleToTimecode(var5_5);
                                                    var17_15 = this.cursor.audioTimecodeToTimeMillis(var15_14);
                                                    var19_16 = this.cursor.videoSampleToTimecode(var9_7);
                                                    var21_17 = this.cursor.videoTimecodeToTimeMillis(var19_16);
                                                    if (!this.onSeekUseVideoTimecode) ** GOTO lbl130
                                                    ** GOTO lbl115
                                                    break;
                                                }
lbl80:
                                                // 2 sources

                                                while (true) {
                                                    var4_3.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(-1L, -1L, -1L));
                                                    ** GOTO lbl102
                                                    break;
                                                }
                                                while (true) {
                                                    var4_3.setResultVideoTimecode(var15_14);
                                                    ** GOTO lbl96
                                                    break;
                                                }
lbl86:
                                                // 1 sources

                                                while (true) {
                                                    var13_10 = this.cursor.videoSampleToTimecode(var7_6);
                                                    var15_14 = this.cursor.videoTimecodeToTimeMillis(var13_10);
                                                    var17_15 = this.cursor.audioTimeMillisToTimecode(var15_14);
                                                    var19_16 = this.cursor.audioTimecodeToSample(var17_15);
                                                    var21_17 = this.cursor.dataTimeMillisToTimecode(var15_14);
                                                    var23_18 = this.cursor.dataTimecodeToSample(var21_17);
                                                    if (var23_18 >= 0L) {
                                                        ** continue;
                                                    }
                                                    ** GOTO lbl108
                                                    break;
                                                }
lbl96:
                                                // 2 sources

                                                while (true) {
                                                    this.cursor.resetVideoAtEnd();
                                                    ** GOTO lbl102
                                                    break;
                                                }
                                                case 1: {
                                                    var7_6 = this.cursor.videoFindKeySample(var9_7, 1);
                                                    ** GOTO lbl141
                                                }
lbl102:
                                                // 2 sources

                                                var13_11 = 0L;
                                                if (var5_5 < 0L) break block39;
                                                break block40;
                                                case 2: {
                                                    var7_6 = this.cursor.videoFindKeySample(var9_7, 2);
                                                    ** GOTO lbl141
                                                }
lbl108:
                                                // 4 sources

                                                while (true) {
                                                    var17_15 = this.cursor.audioSampleToTimecode(var19_16);
                                                    var25_20 = this.cursor.audioTimecodeToTimeMillis(var17_15);
                                                    if (var25_20 >= var15_14) ** GOTO lbl127
                                                    ** GOTO lbl65
                                                    break;
                                                }
lbl113:
                                                // 1 sources

                                                var17_15 = this.cursor.audioSampleToTimecode(++var19_16);
                                                ** GOTO lbl127
lbl115:
                                                // 1 sources

                                                var13_11 = var21_17;
                                                break block41;
lbl117:
                                                // 2 sources

                                                while (var13_9 < 10) {
                                                    break block35;
                                                }
                                                break block37;
lbl120:
                                                // 1 sources

                                                while (true) {
                                                    var13_9 = 0;
                                                    ** GOTO lbl117
                                                    break;
                                                }
lbl123:
                                                // 1 sources

                                                if (this.cursor.getDataSampleValid(var23_18 + 1L)) {
                                                    ** continue;
                                                }
                                                break block42;
lbl126:
                                                // 1 sources

                                                return var4_3;
lbl127:
                                                // 3 sources

                                                var4_3.setVideoStreamPos((IMediaReaderStreamPosition)new H264StreamPosition(var19_16, var7_6, var23_18));
                                                if (var5_5 < 0L) ** continue;
                                                break block43;
lbl130:
                                                // 1 sources

                                                var13_11 = Math.min(var17_15, var21_17);
                                                break block41;
                                                case 4: {
                                                    ** GOTO lbl141
                                                }
                                                default: {
                                                    if (var7_6 < 0L) ** continue;
                                                }
                                            }
                                            var11_8 = -1L;
                                            break block37;
                                        }
                                        ** while ((var16_4 = this.cursor.dataTimecodeToTimeMillis((long)(var14_13 = this.cursor.dataSampleToTimecode((long)var11_8)))) < var1_1)
lbl140:
                                        // 1 sources

                                        break block37;
lbl141:
                                        // 5 sources

                                        if (var7_6 < 0L) ** GOTO lbl80
                                        ** while (true)
                                    }
lbl144:
                                    // 2 sources

                                    while (true) {
                                        if (!this.cursor.containsVideo()) ** GOTO lbl141
                                        ** continue;
                                        break;
                                    }
lbl147:
                                    // 1 sources

                                    while (true) {
                                        this.cursor.resetDataAtEnd();
                                        ** GOTO lbl12
                                        break;
                                    }
                                }
                                v2 = this.cursor;
                                ** while ((var11_8 = v2.dataTimecodeToSample((long)v2.dataTimeMillisToTimecode((long)var1_1))) < 0L)
lbl153:
                                // 1 sources

                                ** while (true)
                            }
                            ** while (var9_7 >= 0L)
                        }
                        if (var9_7 < 0L) ** GOTO lbl61
                        ** while (true)
                    }
lbl160:
                    // 2 sources

                    while (true) {
                        if (var11_8 >= 0L) ** break;
                        ** continue;
                        ** continue;
                        break;
                    }
                }
                var23_18 = -1L;
                ** while (true)
            }
            var27_23 = this.cursor.audioTimecodeToTimeMillis(var17_15);
            var4_3.setResultVideoTimecode(Math.min(var27_23, var15_14));
            ** while (true)
        }
        this.cursor.resetAudioAtEnd();
        this.cursor.resetVideoAtEnd();
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.chunkWorkBuffer == null) {
            bl = true;
        } else if (this.chunkWorkBuffer.length < n) {
            bl = true;
        }
        if (!bl) return;
        this.chunkWorkBuffer = new byte[n];
    }

    public void startPlayback() {
        this.doSendVideoTrakInfo = true;
        this.doSendAudioTrakInfo = true;
        this.doSendEnhanceSeek = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return false;
        int[] nArray = new int[]{9, 0, 0, 0};
        if (iClient.testFlashVersion(nArray) < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long getSampleDesc(H264Cursor h264Cursor, long l, int n) {
        long l2 = 0L;
        H264ReadAheadPacket h264ReadAheadPacket = this.getReadAheadPacket(n, l);
        if (h264ReadAheadPacket == null) return h264Cursor.getSampleDesc();
        return h264ReadAheadPacket.getSampleDesc();
    }

    /*
     * Exception decompiling
     */
    public int writeGeneratedKeyFrame(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 256->805)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public byte getFirstByte(H264Cursor var1_1) {
        block7: {
            var2_2 = 0;
            var3_3 = var1_1.getCurrentType();
            switch (var3_3) {
                case 9: {
                    if (var1_1.isKeyFrame()) break;
                    v0 = 32;
                    break block7;
                }
lbl8:
                // 2 sources

                default: lbl-1000:
                // 3 sources

                {
                    return var2_2;
                }
                case 15: 
                case 18: {
                    var2_2 = 0;
                    ** GOTO lbl8
                }
            }
            v0 = 16;
            break block7;
            {
                ** case 8:
            }
lbl17:
            // 1 sources

            var2_2 = (byte)this.audioType;
            ** GOTO lbl-1000
        }
        var2_2 = (byte)(v0 | this.videoCodec);
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int writeEnhancedCmd(int n, int n2, int n3, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, long[] lArray, int n4) {
        int n5 = 0;
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) return 0;
        try {
            int[] nArray = new int[5];
            nArray[1] = 0;
            nArray[2] = n3;
            nArray[0] = 9;
            byte[] byArray = new byte[]{(byte)n, (byte)(0xFF & n2)};
            nArray[1] = 2;
            int n6 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, byArray);
            n5 += n6;
            lArray[2] = lArray[2] + (long)n6;
            lArray[3] = lArray[3] + 1L;
            return n5;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(JSON.regionMatches((String)"\\ww}tDry}\u007fiT/(+n$,+%+%\",\n'/\u0017", (int)(7 * 7)) + this.getContextStr() + Base64.lastIndexOf((int)(11 + 125), (String)"U)"), (Throwable)exception);
            return n5;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        int n3 = 0;
        switch (n) {
            case 9: {
                int n4 = playlistCursor.getWriteControl().getChunkSize();
                this.checkWorkBuffer(n4);
                byte[] byArray = new byte[5];
                int n5 = 0;
                int[] nArray = new int[5];
                nArray[1] = 0;
                nArray[2] = n2;
                nArray[0] = 9;
                byArray[0] = (byte)(0x10 | this.videoCodec);
                byArray[1] = 2;
                byArray[2] = 0;
                byArray[3] = 0;
                byArray[4] = 0;
                nArray[1] = 5;
                n5 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4, byArray);
                n3 += n5;
                lArray[2] = lArray[2] + (long)n5;
                lArray[3] = lArray[3] + 1L;
            }
            default: {
                return n3;
            }
            case 8: 
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected byte[] getVideoCodecConfig(long l) {
        byte[] byArray = null;
        QTAtomstbl qTAtomstbl = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return byArray;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getVideoTrack(this.trackIndexVideo);
        if (qTAtomtrak == null) {
            return byArray;
        }
        QTAtommdia qTAtommdia = qTAtomtrak.getMdiaAtom();
        if (qTAtommdia == null) {
            return byArray;
        }
        QTAtomminf qTAtomminf = qTAtommdia.getMinfAtom();
        if (qTAtomminf == null) {
            return byArray;
        }
        qTAtomstbl = qTAtomminf.getStblAtom();
        if (qTAtomstbl == null) return byArray;
        IQTCodecData iQTCodecData = qTAtomstbl.getCodecSpecificData((int)l);
        if (iQTCodecData == null) return byArray;
        return iQTCodecData.getCodecSpecificBytes();
    }

    /*
     * Unable to fully structure code
     */
    public int sendVideoTrakData(int var1_1, boolean var2_2, IMediaStream var3_3, OutputStream var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10, byte[] var11_11) {
        block11: {
            block7: {
                block9: {
                    block10: {
                        block6: {
                            block8: {
                                var12_12 = 0;
                                var13_13 = false;
                                var14_14 = var6_6.getWriteControl().getChunkSize();
                                this.checkWorkBuffer(var14_14);
                                if (var11_11 != null) break block8;
                                break block9;
lbl7:
                                // 2 sources

                                return var12_12;
lbl9:
                                // 1 sources

                                while (true) {
                                    var16_16 = this.directOutputBuf(var17_17, var2_2, var3_3.getSrc(), var4_4, var5_5, this.chunkWorkBuffer, var14_14, var15_15);
                                    var12_12 += var16_16;
                                    var9_9[2] = var9_9[2] + (long)var16_16;
                                    var9_9[3] = var9_9[3] + 1L;
                                    ++var18_18;
                                    break block6;
                                    break;
                                }
lbl16:
                                // 2 sources

                                while (true) {
                                    if (var18_18 >= v0) ** GOTO lbl7
                                    ** continue;
                                    break;
                                }
lbl19:
                                // 1 sources

                                while (true) {
                                    v0 = 2;
                                    ** GOTO lbl16
                                    break;
                                }
                            }
                            v1 = var11_11.length;
                            break block10;
                        }
lbl26:
                        // 2 sources

                        while (var13_13) {
                            ** continue;
lbl28:
                            // 1 sources

                            ** GOTO lbl19
                        }
                        break block11;
                    }
lbl31:
                    // 2 sources

                    while (true) {
                        var15_15 = new byte[v1 + 5];
                        var16_16 = 0;
                        var17_17 = new int[5];
                        var17_17[1] = 0;
                        var17_17[2] = var1_1;
                        var17_17[0] = 9;
                        if (var11_11 != null) ** break;
                        ** continue;
                        break block7;
                        break;
                    }
                }
                v1 = 0;
                ** while (true)
            }
            var15_15[0] = (byte)(16 | this.videoCodec);
            var15_15[1] = 0;
            var15_15[2] = 0;
            var15_15[3] = 0;
            var15_15[4] = 0;
            System.arraycopy(var11_11, 0, var15_15, 5, var11_11.length);
            var17_17[1] = var11_11.length + 5;
            var17_17[2] = 0;
            var2_2 = false;
            var18_18 = 0;
            ** GOTO lbl26
        }
        v0 = 1;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected byte[] getAudioCodecConfig(long l) {
        byte[] byArray = null;
        QTAtomstbl qTAtomstbl = null;
        ESDSData eSDSData = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return byArray;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getAudioTrack(this.trackIndexAudio);
        if (qTAtomtrak == null) {
            return byArray;
        }
        QTAtommdia qTAtommdia = qTAtomtrak.getMdiaAtom();
        if (qTAtommdia == null) {
            return byArray;
        }
        QTAtomminf qTAtomminf = qTAtommdia.getMinfAtom();
        if (qTAtomminf == null) {
            return byArray;
        }
        qTAtomstbl = qTAtomminf.getStblAtom();
        if (qTAtomstbl == null) {
            return byArray;
        }
        eSDSData = qTAtomstbl.getESDSData((int)l);
        if (eSDSData != null) return eSDSData.specData;
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int sendAudioTrakData(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, byte[] byArray) {
        int n2 = 0;
        if (byArray == null) {
            return n2;
        }
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        int[] nArray = new int[5];
        nArray[1] = 0;
        nArray[2] = n;
        nArray[0] = 8;
        byte[] byArray2 = new byte[byArray.length + 2];
        byArray2[0] = -81;
        byArray2[1] = 0;
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        nArray[1] = byArray.length + 2;
        int n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, byArray2);
        n2 += n4;
        lArray[0] = lArray[0] + (long)n4;
        lArray[1] = lArray[1] + 1L;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        if (this.container == null) {
            return 0;
        }
        if (fastPlaySettings == null) return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
        if (fastPlaySettings.getDirection() >= 0) return this.writePacketsFastPlay(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
        return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int writePackets(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, boolean var10_10) {
        block37: {
            var11_11 = 0;
            var12_12 = false;
            var13_13 = false;
            var14_14 = false;
            var15_15 = 0;
            var16_16 = var7_7.getMaxTC();
            this.videoFileStream.setDirecton(1);
            var18_17 = var6_6.getWriteControl().getChunkSize();
            this.checkWorkBuffer(var18_17);
            var19_18 = 0L;
            var21_19 = 0L;
            ** GOTO lbl166
lbl-1000:
            // 1 sources

            {
                block38: {
                    block39: {
                        while (var27_23 >= var16_16) {
                            // MONITOREXIT : var23_20
                            break block37;
                        }
                        break block39;
                        while (true) {
                            var6_6.setSendAbsBroadcastTC(false);
                            ** GOTO lbl27
                            break;
                        }
                        while (true) {
                            var32_30 = var6_6.isSendAbsBroadcastTC();
                            if (var6_6.isSendAbsBroadcastTC()) {
                                this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                if (this.chunkHeaderValues[2] >= 0) ** continue;
                            } else {
                                this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastBroadcastTC() & 0xFFFFFFFFL);
lbl27:
                                // 2 sources

                                var6_6.setLastBroadcastTC(var27_23);
                                var6_6.incDataPacketCount();
                                var25_22 = var27_23;
                                if (var10_10) {
                                    this.chunkHeaderValues[2] = 0;
                                }
                                v0 = this;
                                var33_33 = v0.directOutput(v0.chunkHeaderValues, var19_18, (boolean)var32_30, var1_1.getSrc(), var2_2, var5_5, this.chunkWorkBuffer, var18_17, this.cursor, false);
                                var11_11 += var33_33;
                                var9_9[4] = var9_9[4] + (long)var33_33;
                                var9_9[5] = var9_9[5] + 1L;
                                var24_21 = true;
                            }
                            ** GOTO lbl151
                            break;
                        }
lbl39:
                        // 2 sources

                        while (true) {
                            var30_25 = var7_7.testVideoFrame(this.chunkHeaderValues[3]);
                            if (this.chunkHeaderValues[2] < 0 || !var30_25) {
                                if (!var30_25) {
                                    var9_9[6] = var9_9[6] + (long)this.chunkHeaderValues[1];
                                    var9_9[7] = var9_9[7] + 1L;
                                }
                            } else {
                                if (var10_10) {
                                    this.chunkHeaderValues[2] = 0;
                                }
                                if (var21_19 != var6_6.getVideoSampleDesc()) {
                                    var31_29 = this.getVideoCodecConfig(var21_19);
                                    var32_30 = var6_6.compareAndSetVideoCodecConfig(var31_29);
                                    if (var32_30 == 0) {
                                        v1 = this;
                                        var33_33 = v1.sendVideoTrakData(v1.chunkHeaderValues[2], (boolean)var29_24, var1_1, var2_2, var4_4, var6_6, var7_7, var8_8, var9_9, var10_10, var31_29);
                                        if (var33_33 > 0) {
                                            var29_24 = 0;
                                            this.chunkHeaderValues[2] = 0;
                                        }
                                        var11_11 += var33_33;
                                    }
                                    var6_6.setVideoSampleDesc(var21_19);
                                }
                                var6_6.setLastVideoTC(var27_23);
                                var6_6.incVideoPacketCount();
                                var25_22 = var27_23;
                                if (var1_1.isReceiveVideo()) {
                                    while (true) {
                                        v2 = false;
                                        break;
                                    }
                                } else {
                                    if (this.videoCodec != 7 && this.videoCodec != 12) ** continue;
                                    v2 = true;
                                }
                                var31_27 = v2;
                                v3 = this;
                                var32_30 = v3.directOutput(v3.chunkHeaderValues, var19_18, (boolean)var29_24, var1_1.getSrc(), var2_2, var4_4, this.chunkWorkBuffer, var18_17, this.cursor, var31_27);
                                var11_11 += var32_30;
                                var24_21 = true;
                                var8_8.incVideoPackets();
                                if (this.videoSampleCount > 0L && var19_18 == this.videoSampleCount - 1L) {
                                    v4 = this;
                                    var33_33 = v4.directOutput(v4.chunkHeaderValues, var19_18, (boolean)var29_24, var1_1.getSrc(), var2_2, var4_4, this.chunkWorkBuffer, var18_17, this.cursor, true);
                                    var11_11 += var33_33;
                                    var8_8.incVideoPackets();
                                }
                                var12_12 = true;
                                var13_13 = true;
                                var9_9[2] = var9_9[2] + (long)var32_30;
                                var9_9[3] = var9_9[3] + 1L;
                            }
                            ** GOTO lbl151
                            break;
                        }
                        while (true) {
                            var6_6.setSendAbsAudioTC(false);
                            ** GOTO lbl102
                            break;
                        }
                        while (true) {
                            block44: {
                                block40: {
                                    block43: {
                                        block42: {
                                            block41: {
                                                switch (this.chunkHeaderValues[0]) {
                                                    case 15: 
                                                    case 18: {
                                                        if (this.onMetadataSample < 0L || var19_18 != this.onMetadataSample) ** continue;
                                                        break block40;
                                                    }
                                                    case 9: {
                                                        if (!var1_1.isReceiveVideo() && this.videoCodec != 7) {
                                                            break;
                                                        }
                                                        break block41;
                                                    }
                                                    case 8: {
                                                        if (!var1_1.isReceiveAudio()) break block40;
                                                        if (var7_7.isSkipAudio() || var7_7.isAudioFilter()) break block40;
                                                        var31_27 = var6_6.isSendAbsAudioTC();
                                                        if (var6_6.isSendAbsAudioTC()) ** GOTO lbl105
                                                        this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastAudioTC() & 0xFFFFFFFFL);
lbl102:
                                                        // 2 sources

                                                        if (this.chunkHeaderValues[2] < 0) break block40;
                                                        if (!var10_10) ** GOTO lbl109
                                                        ** GOTO lbl108
lbl105:
                                                        // 1 sources

                                                        this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                                        if (this.chunkHeaderValues[2] >= 0) ** continue;
                                                        break block40;
lbl108:
                                                        // 1 sources

                                                        this.chunkHeaderValues[2] = 0;
lbl109:
                                                        // 2 sources

                                                        if (var21_19 != var6_6.getAudioSampleDesc()) {
                                                            var32_31 = this.getAudioCodecConfig(var21_19);
                                                            var33_33 = (int)var6_6.compareAndSetAudioCodecConfig(var32_31);
                                                            if (var33_33 == 0) {
                                                                v5 = this;
                                                                var34_34 = v5.sendAudioTrakData(v5.chunkHeaderValues[2], var31_27, var1_1, var2_2, var3_3, var6_6, var7_7, var8_8, var9_9, var10_10, var32_31);
                                                                if (var34_34 > 0) {
                                                                    var31_27 = false;
                                                                    this.chunkHeaderValues[2] = 0;
                                                                }
                                                            }
                                                            var6_6.setAudioSampleDesc(var21_19);
                                                        }
                                                        var6_6.setLastAudioTC(var27_23);
                                                        var6_6.incAudioPacketCount();
                                                        var25_22 = var27_23;
                                                        v6 = this;
                                                        var32_30 = v6.directOutput(v6.chunkHeaderValues, var19_18, var31_27, var1_1.getSrc(), var2_2, var3_3, this.chunkWorkBuffer, var18_17, this.cursor, false);
                                                        var11_11 += var32_30;
                                                        var24_21 = true;
                                                        var8_8.incAudioPackets();
                                                        var12_12 = true;
                                                        var14_14 = true;
                                                        var9_9[0] = var9_9[0] + (long)var32_30;
                                                        var9_9[1] = var9_9[1] + 1L;
                                                        break block40;
                                                    }
                                                }
                                                if (this.videoCodec != 12) break block40;
                                            }
                                            if (!var6_6.isWaitForKeyFrame()) break block42;
                                            var29_24 = FLVUtils.getFrameType((int)this.chunkHeaderValues[3]);
                                            if (!var29_24) break block40;
                                            var6_6.setWaitForKeyFrame(false);
                                        }
                                        var29_24 = var6_6.isSendAbsVideoTC();
                                        if (var6_6.isSendAbsVideoTC()) break block43;
                                        this.chunkHeaderValues[2] = (int)(var27_23 - var6_6.getLastVideoTC() & 0xFFFFFFFFL);
                                        ** GOTO lbl39
                                    }
                                    var30_26 = var6_6.getForceVideoTC();
                                    if (var30_26 >= 0L) {
                                        this.chunkHeaderValues[2] = (int)(var30_26 + var6_6.getStartTCOffset());
                                        var27_23 = var30_26;
                                    } else {
                                        this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + var6_6.getStartTCOffset());
                                    }
                                    if (this.chunkHeaderValues[2] >= 0) break block44;
                                }
                                var8_8.setLastTC(var27_23);
                                ++var15_15;
                                this.cursor.moveNextSample();
                                if (var16_16 != 0L) ** GOTO lbl-1000
                                if (!var13_13 && var15_15 <= 20) break;
                                // MONITOREXIT : var23_20
                                break block37;
                            }
                            var6_6.setForceVideoTC(-1L);
                            var6_6.setSendAbsVideoTC(false);
                            ** continue;
                            break;
                        }
                    }
                    // MONITOREXIT : var23_20
lbl166:
                    // 2 sources

                    var23_20 = this.lock;
                    // MONITORENTER : var23_20
                    if (var6_6.isBreakLoop()) {
                        // MONITOREXIT : var23_20
                        break block37;
                    }
                    if (!this.cursor.isAtEnd()) break block38;
                    var8_8.setHitEnd(true);
                    // MONITOREXIT : var23_20
                    break block37;
                }
                this.chunkHeaderValues[2] = (int)this.cursor.getTimeMillis();
                this.chunkHeaderValues[0] = this.cursor.getCurrentType();
                v7 = this;
                this.chunkHeaderValues[3] = v7.getFirstByte(v7.cursor);
                var19_18 = this.cursor.getSample();
                v8 = this;
                var21_19 = v8.getSampleDesc(v8.cursor, var19_18, this.chunkHeaderValues[0]);
                var24_21 = false;
                var25_22 = 0L;
                var27_23 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                if (var16_16 <= 0L || var27_23 < var16_16) ** continue;
                // MONITOREXIT : var23_20
            }
        }
        var8_8.setTotalSize(var11_11);
        return var11_11;
        catch (Throwable var35_35) {
            // MONITOREXIT : var23_20
            throw var35_35;
        }
    }

    /*
     * Exception decompiling
     */
    public int writePacketsFastPlay(IMediaStream var1_1, OutputStream var2_2, AMFObj var3_3, AMFObj var4_4, AMFObj var5_5, PlaylistCursor var6_6, PlaylistWriteControl var7_7, PlaylistReaderWriteResults var8_8, long[] var9_9, FastPlaySettings var10_10, boolean var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [41[UNCONDITIONALDOLOOP], 42[UNCONDITIONALDOLOOP]], but top level block is 4[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int directOutput(int[] nArray, long l, boolean bl, int n, OutputStream outputStream, AMFObj aMFObj, byte[] byArray, int n2, H264Cursor h264Cursor, boolean bl2) {
        return this.directOutput(nArray, l, bl, n, outputStream, aMFObj, byArray, n2, h264Cursor, bl2, 0L);
    }

    /*
     * Exception decompiling
     */
    protected int directOutput(int[] var1_1, long var2_2, boolean var4_3, int var5_4, OutputStream var6_5, AMFObj var7_6, byte[] var8_7, int var9_8, H264Cursor var10_9, boolean var11_10, long var12_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [2 : 110->1972)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int directOutputBuf(int[] var1_1, boolean var2_2, int var3_3, OutputStream var4_4, AMFObj var5_5, byte[] var6_6, int var7_7, byte[] var8_8) {
        var9_9 = 0;
        ** try [egrp 0[TRYBLOCK] [1 : 95->1256)] { 
lbl3:
        // 1 sources

        ** GOTO lbl9
lbl4:
        // 1 sources

        catch (Exception var10_10) {
            block27: {
                block32: {
                    block23: {
                        block31: {
                            block29: {
                                block30: {
                                    block28: {
                                        block21: {
                                            block22: {
                                                var11_12 = System.currentTimeMillis();
                                                if (this.reportDirectOutputError >= 0L) {
                                                }
                                                break block27;
lbl9:
                                                // 1 sources

                                                var10_11 = (long)var1_1[2] & 0xFFFFFFFFL;
                                                var12_13 = var1_1[1];
                                                var13_14 = var1_1[0];
                                                var14_15 = IFasterByteArrayOutputStream.getProtocol((OutputStream)var4_4);
                                                var15_16 = var5_5.getId();
                                                var16_17 = var5_5.isNew();
                                                var17_18 = var16_17 | var2_2;
                                                var18_19 = false;
                                                var5_5.setNew(false);
                                                if (var14_15 == 4) {
                                                    var19_21 = IFasterByteArrayOutputStream.getWOWZSession((OutputStream)var4_4);
                                                    var20_23 = new WOWZHeader();
                                                    var20_23.cid = var15_16;
                                                    var20_23.timecode = var10_11;
                                                    var20_23.isTimecodeAbs = var17_18;
                                                    var20_23.size = var12_13;
                                                    var20_23.type = var13_14;
                                                    var20_23.src = var3_3;
                                                    var20_23.updateFlags();
                                                    var5_5.setSize(var12_13);
                                                    var5_5.setType(var13_14);
                                                    var5_5.setTimecode(var10_11);
                                                    var5_5.setLastSentAbsTimecode(var16_17);
                                                    var5_5.setSrc(var3_3);
                                                    var9_9 += var19_21.sendStart(var4_4);
                                                    var9_9 += var19_21.writeHeader(var4_4, var20_23);
                                                    if (var12_13 > 0) {
                                                        var4_4.write(var8_8, 0, var12_13);
                                                        var9_9 += var12_13;
                                                    }
                                                    return var9_9 += var19_21.sendStop(var4_4);
                                                }
                                                var19_20 = 0;
                                                var6_6[0] = (byte)(255 & var15_16);
                                                if (var10_11 >= 0xFFFFFFL) {
                                                    var6_6[1] = -1;
                                                    var6_6[2] = -1;
                                                    var6_6[3] = -1;
                                                    var18_19 = true;
lbl46:
                                                    // 2 sources

                                                    while (true) {
                                                        var6_6[4] = (byte)(255 & var12_13 >> 16);
                                                        var6_6[5] = (byte)(255 & var12_13 >> 8);
                                                        var6_6[6] = (byte)(255 & var12_13);
                                                        var6_6[7] = (byte)var13_14;
                                                        var19_20 += 8;
                                                        var5_5.setSize(var12_13);
                                                        var5_5.setType(var13_14);
                                                        var5_5.setTimecode(var10_11);
                                                        if (!var17_18 && var5_5.getSrc() == var3_3) break block21;
                                                        break block22;
                                                        break;
                                                    }
                                                }
                                                var6_6[1] = (byte)(255L & var10_11 >> 16);
                                                var6_6[2] = (byte)(255L & var10_11 >> 8);
                                                var6_6[3] = (byte)(255L & var10_11);
                                                ** continue;
                                            }
                                            var6_6[8] = (byte)(255 & var3_3);
                                            var6_6[9] = (byte)(255 & var3_3 >> 8);
                                            var6_6[10] = (byte)(255 & var3_3 >> 16);
                                            var6_6[11] = (byte)(255 & var3_3 >> 24);
                                            var19_20 += 4;
                                            var5_5.setSrc(var3_3);
                                        }
                                        if (var15_16 < 64) break block28;
                                        var20_22 = var15_16 - 64;
                                        if (var20_22 <= 255) break block29;
                                        v0 = 3;
                                        break block30;
                                    }
                                    if (var19_20 < 12) {
                                        var6_6[0] = (byte)(var6_6[0] | 64);
                                    }
                                    break block31;
                                }
lbl79:
                                // 2 sources

                                while (true) {
                                    var21_24 = v0;
                                    var22_26 = new byte[var21_24];
                                    if (var19_20 >= 12) break block23;
                                    var22_26[0] = (byte)(64 + (var21_24 - 2));
                                    break block23;
                                    break;
                                }
                            }
                            v0 = 2;
                            ** continue;
                        }
                        var4_4.write(var6_6, 0, var19_20);
                        var9_9 += var19_20;
                        break block32;
                    }
                    var22_26[1] = (byte)(255 & var20_22);
                    if (var21_24 == 3) {
                        var22_26[2] = (byte)(255 & var20_22 >> 8);
                    }
                    var4_4.write(var22_26, 0, var21_24);
                    var4_4.write(var6_6, 1, var19_20 - 1);
                    var9_9 += var19_20 + 1;
                }
                if (var18_19) {
                    var6_6[0] = (byte)(255L & var10_11 >> 24);
                    var6_6[1] = (byte)(255L & var10_11 >> 16);
                    var6_6[2] = (byte)(255L & var10_11 >> 8);
                    var6_6[3] = (byte)(255L & var10_11);
                    var4_4.write(var6_6, 0, 4);
                    var9_9 = 4;
                }
                if (var12_13 <= 0) return var9_9;
                var20_22 = var12_13;
                var21_24 = 0;
                var22_25 = 0;
                do {
                    block24: {
                        block36: {
                            block25: {
                                block26: {
                                    block35: {
                                        block34: {
                                            block33: {
                                                if (var21_24 <= 0) break block33;
                                                if (var15_16 < 64) break block34;
                                                var23_27 = var15_16 - 64;
                                                if (var23_27 > 255) break block35;
                                                v1 = 2;
                                                break block36;
                                            }
lbl119:
                                            // 3 sources

                                            while (true) {
                                                var22_25 = var7_7;
                                                if (var22_25 > var20_22 - var21_24) {
                                                    var22_25 = var20_22 - var21_24;
                                                }
                                                try {
                                                    var4_4.write(var8_8, var21_24, var22_25);
                                                    break block24;
                                                }
                                                catch (Exception var23_28) {
                                                    var24_30 = System.currentTimeMillis();
                                                    if (this.reportDirectOutputError < 0L) break block25;
                                                    break block26;
                                                }
                                                break;
                                            }
                                        }
                                        var6_6[0] = (byte)(255 & var15_16 | 192);
                                        var4_4.write(var6_6, 0, 1);
                                        ++var9_9;
lbl134:
                                        // 2 sources

                                        while (true) {
                                            if (!var18_19) ** GOTO lbl119
                                            var6_6[0] = (byte)(255L & var10_11 >> 24);
                                            var6_6[1] = (byte)(255L & var10_11 >> 16);
                                            var6_6[2] = (byte)(255L & var10_11 >> 8);
                                            var6_6[3] = (byte)(255L & var10_11);
                                            var4_4.write(var6_6, 0, 4);
                                            var9_9 = 4;
                                            ** continue;
                                            break;
                                        }
                                    }
                                    v1 = 3;
                                    break block36;
                                }
                                if (var24_30 - this.reportDirectOutputError >= 3000L) break block24;
                            }
                            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(JSON.regionMatches((String)"Kbl`kYiljjbY % ;r~j|yoShjouu@vb^", (int)(753 / 116)) + this.getContextStr() + JSON.regionMatches((String)"@$?\u00103-!( +g:,+/%#)o9?\"& u0>4<z", (int)(55 * 43)), (Throwable)var23_28);
                            this.reportDirectOutputError = var24_30;
                            break block24;
                        }
                        var24_29 = v1;
                        var6_6[0] = (byte)(192 + (var24_29 - 2));
                        var6_6[1] = (byte)(255 & var23_27);
                        if (var24_29 == 3) {
                            var6_6[2] = (byte)(255 & var23_27 >> 8);
                        }
                        var4_4.write(var6_6, 0, var24_29);
                        var9_9 += var24_29;
                        ** continue;
                    }
                    var9_9 += var22_25;
                } while ((var21_24 += var22_25) != var20_22);
                return var9_9;
            }
lbl167:
            // 2 sources

            while (true) {
                WMSLoggerFactory.getLogger(MediaReaderH264.class).error(Base64.lastIndexOf((int)(115 + -58), (String)"T\u007f\u007fu|Lz!%'1\fwpsf-#9).:\u0000%%\"& \u0017#1\u0003") + this.getContextStr() + Base64.lastIndexOf((int)(11 * 39), (String)"P."), (Throwable)var10_10);
                this.reportDirectOutputError = var11_12;
                return var9_9;
            }
        }
        if (var11_12 - this.reportDirectOutputError >= 3000L) return var9_9;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    public void debugPackets(int n) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(MediaReaderH264.class);
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
        QTAtomtrak qTAtomtrak2 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
        QTAtomtrak qTAtomtrak3 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
        H264Cursor h264Cursor = new H264Cursor(qTAtomtrak, qTAtomtrak2, qTAtomtrak3, 1);
        int n2 = 0;
        while (true) {
            int n3 = (int)h264Cursor.getSize();
            long l = h264Cursor.getTimeMillis();
            if (n3 <= 0 || n3 >= n) {
                wMSLogger.info(Base64.lastIndexOf((int)(-5 - -12), (String)"wijanx7.") + n3 + ":" + n);
            }
            h264Cursor.moveNextSample();
            if (h264Cursor.isAtEnd()) {
                wMSLogger.info(Base64.lastIndexOf((int)(891 / 190), (String)"./,tidzginaz~e(3") + n2);
                return;
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected H264ReadAheadRequest tiggerNextReadAhead(H264ReadAheadRequest var1_1) {
        block19: {
            block17: {
                block18: {
                    block15: {
                        block13: {
                            block14: {
                                block16: {
                                    block12: {
                                        var2_2 = null;
                                        var3_3 = this.container.getMoovAtom().getVideoTrack(this.trackIndexVideo);
                                        var4_4 = this.container.getMoovAtom().getAudioTrack(this.trackIndexAudio);
                                        var5_5 = this.container.getMoovAtom().getDataTrack(this.trackIndexData);
                                        if (this.cursorReadAhead != null) break block14;
                                        break block16;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            if (var2_2 != null) break block12;
lbl9:
                                            // 7 sources

                                            return var2_2;
                                        }
                                        while (true) {
                                            if (!this.cursorReadAhead.isAtEnd()) break block13;
                                            ** GOTO lbl7
                                            break;
                                        }
                                    }
                                    var2_2.setCursorPosition(this.cursorReadAhead.getCurrentPosition());
                                    if (this.stream == null) ** GOTO lbl9
                                    break block17;
                                    while (true) {
                                        var10_9 = var9_13.getIOScheduler();
                                        if (var10_9 == null) ** GOTO lbl9
                                        var10_9.executeRaw((Runnable)var2_2);
                                        ** GOTO lbl9
                                        break;
                                    }
lbl23:
                                    // 1 sources

                                    while (true) {
                                        this.cursorReadAhead = new H264CursorCaptionProvider(this.d, this.c, var3_3, var4_4);
                                        this.dataDataToAMFHandler = (IQTDataDataToAMF)this.cursorReadAhead;
                                        break block14;
                                        break;
                                    }
lbl27:
                                    // 1 sources

                                    while (true) {
                                        this.cursorReadAhead.setCurrentPosition(var1_1.getCursorPosition());
                                        break block15;
                                        break;
                                    }
lbl30:
                                    // 1 sources

                                    while (true) {
                                        var2_2 = new H264ReadAheadRequest();
                                        var2_2.setDataTrack(var5_5);
                                        var2_2.setDataDataToAMFHandler(this.dataDataToAMFHandler);
                                        ** GOTO lbl65
                                        break;
                                    }
lbl35:
                                    // 1 sources

                                    while (true) {
                                        if ((var9_13 = var8_7.getVHost()) != null) ** continue;
                                        ** GOTO lbl9
                                        break;
                                    }
                                    while (true) {
                                        this.cursorReadAhead.setCurrentPosition(this.cursor.getCurrentPosition());
                                        break block15;
                                        break;
                                    }
                                }
                                ** while (this.d != null)
lbl43:
                                // 1 sources

                                break block18;
                            }
lbl45:
                            // 2 sources

                            while (true) {
                                if (var1_1 == null) ** continue;
                                ** continue;
                                break;
                            }
                        }
lbl49:
                        // 2 sources

                        while (true) {
                            var8_6 = this.cursorReadAhead.getSize();
                            var10_8 = this.cursorReadAhead.getCurrentType();
                            var11_11 = this.cursorReadAhead.getSample();
                            var13_12 = this.cursorReadAhead.getSampleDesc();
                            var2_2.addPacket(var10_8, var11_11, this.cursorReadAhead.getFileLoc(), var8_6, var13_12);
                            this.cursorReadAhead.moveNextSample();
                            if ((var6_10 += var8_6) <= (long)this.readAheadSize) ** continue;
                            ** continue;
                            break;
                        }
                    }
                    if (!this.cursorReadAhead.isAtEnd()) break block19;
                    ** GOTO lbl9
lbl62:
                    // 1 sources

                    while (true) {
                        var2_2 = this.readAheadCache.remove(0);
                        var2_2.clear();
lbl65:
                        // 2 sources

                        var2_2.setFileStream(this.videoFileStream);
                        var2_2.setReadAheadTrigger(this.readAheadTrigger);
                        var6_10 = 0L;
                        ** continue;
                        break;
                    }
                }
                this.cursorReadAhead = new H264Cursor(var3_3, var4_4, var5_5);
                ** while (true)
            }
            ** while ((var8_7 = this.stream.getStreams()) != null)
lbl74:
            // 1 sources

            ** while (true)
        }
        ** while (this.readAheadCache.size() <= 0)
lbl77:
        // 1 sources

        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected H264ReadAheadPacket getReadAheadPacket(int n, long l) {
        H264ReadAheadPacket h264ReadAheadPacket = null;
        Object object = this.readAheadLock;
        synchronized (object) {
            block12: {
                block13: {
                    block11: {
                        if (this.currReadAhead == null) break block11;
                        this.currReadAhead.waitForComplete();
                        h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                        if (h264ReadAheadPacket != null) break block12;
                        if (this.cacheReadAhead) {
                            this.readAheadCache.add(this.currReadAhead);
                        }
                        this.currReadAhead = null;
                    }
                    this.currReadAhead = this.nextReadAhead;
                    this.nextReadAhead = null;
                    if (this.currReadAhead == null) break block13;
                    this.currReadAhead.waitForComplete();
                    h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                    if (h264ReadAheadPacket != null) break block12;
                    if (this.cacheReadAhead) {
                        this.readAheadCache.add(this.currReadAhead);
                    }
                    this.currReadAhead = null;
                }
                this.currReadAhead = this.tiggerNextReadAhead(null);
                if (this.currReadAhead != null) {
                    this.currReadAhead.waitForComplete();
                    h264ReadAheadPacket = this.currReadAhead.getReadAheadPacket(n, l);
                    if (h264ReadAheadPacket == null) {
                        if (this.cacheReadAhead) {
                            this.readAheadCache.add(this.currReadAhead);
                        }
                        this.currReadAhead = null;
                    }
                }
            }
            if (h264ReadAheadPacket == null) return h264ReadAheadPacket;
            if (this.nextReadAhead != null) return h264ReadAheadPacket;
            if (!h264ReadAheadPacket.isAfterTrigger) return h264ReadAheadPacket;
            MediaReaderH264 mediaReaderH264 = this;
            mediaReaderH264.nextReadAhead = mediaReaderH264.tiggerNextReadAhead(mediaReaderH264.currReadAhead);
            return h264ReadAheadPacket;
        }
    }

    /*
     * Exception decompiling
     */
    public int writePackets(List<AMFPacket> var1_1, PlaylistCursor var2_2, PlaylistWriteControl var3_3, PlaylistReaderWriteResults var4_4, long[] var5_5, FastPlaySettings var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 191->1048)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AMFPacket a(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray == null) {
            return aMFPacket;
        }
        aMFPacket = new AMFPacket(9, 0, byArray.length + 5);
        byte[] byArray2 = aMFPacket.getData();
        byArray2[0] = (byte)(0x10 | this.videoCodec);
        byArray2[1] = 0;
        byArray2[2] = 0;
        byArray2[3] = 0;
        byArray2[4] = 0;
        aMFPacket.addDataEx(byArray, 0, 5, byArray.length);
        return aMFPacket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final AMFPacket b(int n, byte[] byArray) {
        AMFPacket aMFPacket = null;
        if (byArray == null) {
            return aMFPacket;
        }
        aMFPacket = new AMFPacket(8, 0, byArray.length + 2);
        byte[] byArray2 = aMFPacket.getData();
        byArray2[0] = -81;
        byArray2[1] = 0;
        aMFPacket.addDataEx(byArray, 0, 2, byArray.length);
        return aMFPacket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AMFPacket getFramePacket(int[] nArray, long l) {
        H264ReadAheadPacket h264ReadAheadPacket;
        int n;
        int n2;
        AMFPacket aMFPacket = null;
        try {
            n2 = nArray[0];
            n = 0;
            h264ReadAheadPacket = this.getReadAheadPacket(n2, l);
            if (h264ReadAheadPacket != null) {
                n = (int)h264ReadAheadPacket.getSize();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderH264.class).error(JSON.regionMatches((String)"\t \".)\u001b/*((<\u0007bgf}30\"\u0011*87>\f<=4euY", (int)(-20 - 8)) + this.getContextStr() + JSON.regionMatches((String)"\u0004z", (int)(-25 - 14)), (Throwable)exception);
            return aMFPacket;
        }
        if (n <= 0) return aMFPacket;
        int n3 = 5;
        if (n2 != 8) {
            if (n2 == 18 || n2 == 15) {
                n3 = 0;
            }
        } else {
            n3 = this.audioExtraSize;
        }
        aMFPacket = new AMFPacket(nArray[0], 0, n + n3);
        byte[] byArray = aMFPacket.getData();
        byArray[0] = (byte)this.chunkHeaderValues[3];
        if (n3 > 1) {
            byArray[1] = 1;
        }
        if (n3 == 5) {
            int n4 = this.cursor.getCTTSMillis();
            byArray[2] = (byte)(n4 >> 16 & 0xFF);
            byArray[3] = (byte)(n4 >> 8 & 0xFF);
            byArray[4] = (byte)(n4 & 0xFF);
        }
        byte[] byArray2 = null;
        int n5 = 0;
        if (h264ReadAheadPacket != null) {
            byArray2 = h264ReadAheadPacket.getBuffer();
            n5 = h264ReadAheadPacket.boffset;
        }
        aMFPacket.addDataEx(byArray2, n5, n3, n);
        return aMFPacket;
    }

    public int getTrackIndexVideo() {
        return this.trackIndexVideo;
    }

    public void setTrackIndexVideo(int n) {
        this.trackIndexVideo = n;
    }

    public int getTrackIndexAudio() {
        return this.trackIndexAudio;
    }

    public void setTrackIndexAudio(int n) {
        this.trackIndexAudio = n;
    }

    public int getTrackIndexData() {
        return this.trackIndexData;
    }

    public void setTrackIndexData(int n) {
        this.trackIndexData = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountVideo() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getVideoTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountAudio() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getAudioTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTrackCountData() {
        int n = 0;
        if (this.container == null) return n;
        return this.container.getMoovAtom().getDataTrackCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTrackLanguageAudio(int n) {
        String string = "";
        if (this.container == null) return string;
        return this.container.getMoovAtom().getAudioTrackLanguage(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTrackLanguageData(int n) {
        String string = "";
        if (this.container == null) return string;
        return this.container.getMoovAtom().getDataTrackLanguage(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackDataTrackId(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_DATA, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackAudioTrackId(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_AUDIO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackDataAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_DATA, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackAudioAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_AUDIO, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QTAtomtrak getTrackVideoAtom(int n) {
        QTAtomtrak qTAtomtrak = null;
        if (this.container != null) return this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        return qTAtomtrak;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoTrackId(int n) {
        long l = -1L;
        if (this.container == null) {
            return l;
        }
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackId();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoWidth(int n) {
        long l = -1L;
        if (this.container == null) return l;
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackWidth();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTrackVideoHeight(int n) {
        long l = -1L;
        if (this.container == null) {
            return l;
        }
        QTAtomtrak qTAtomtrak = this.container.getMoovAtom().getTrackByMinf(QTAtommoov.MINFTYPES_VIDEO, n);
        if (qTAtomtrak != null) return qTAtomtrak.getTkhdAtom().getTrackHeight();
        return l;
    }

    public String getTrackDataCharSet() {
        return this.trackDataCharSet;
    }

    public void setTrackDataCharSet(String string) {
        this.trackDataCharSet = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] dataDataToAMF(long l, QTAtomtrak qTAtomtrak, byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = null;
        AMFDataList aMFDataList = null;
        QTAtomstbl qTAtomstbl = qTAtomtrak == null ? null : qTAtomtrak.getMdiaAtom().getMinfAtom().getStblAtom();
        if (qTAtomstbl != null && (n3 = qTAtomstbl.getDataTrackType()) == 2) {
            aMFDataList = new AMFDataList();
            AMFDataObj aMFDataObj = new AMFDataObj();
            aMFDataList.add((AMFData)new AMFDataItem(JSON.regionMatches((String)"~|GqmbSym{", (int)(36 - 19))));
            aMFDataList.add((AMFData)aMFDataObj);
            String string = qTAtomtrak.getLanguageStr();
            aMFDataObj.put(JSON.regionMatches((String)" 0.#", (int)(101 + -17)), (AMFData)new AMFDataItem(""));
            aMFDataObj.put(Base64.lastIndexOf((int)(1469 / 221), (String)"ruijabh"), (AMFData)new AMFDataItem(qTAtomtrak.getTrackIndex()));
            aMFDataObj.put(Base64.lastIndexOf((int)(629 / 195), (String)"oekarino"), (AMFData)new AMFDataItem(string));
            if (n2 >= 2) {
                int n4 = 0;
                int n5 = BufferUtils.byteArrayToInt((byte[])byArray, (int)n, (int)2);
                if (n5 > 0 && n5 <= n2 - (n4 += 2)) {
                    String string2 = "";
                    try {
                        string2 = new String(byArray, n + n4, n2 - n4, this.trackDataCharSet);
                    }
                    catch (Exception exception) {}
                    aMFDataObj.put(Base64.lastIndexOf((int)(35 * 39), (String)"!3/,"), (AMFData)new AMFDataItem(string2));
                }
            }
        }
        if (aMFDataList == null) return byArray2;
        return aMFDataList.serialize(0);
    }

    public int getCursorType() {
        return this.cursorType;
    }

    public void setCursorType(int n) {
        this.cursorType = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlayReadySampleInfo getPlayReadyAudioTrackInfo(int n) {
        PlayReadySampleInfo playReadySampleInfo = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return playReadySampleInfo;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getAudioTrack(n);
        if (qTAtomtrak != null) return qTAtomtrak.getPlayReadySampleInfo(this.metaFileStream, 0L);
        return playReadySampleInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlayReadySampleInfo getPlayReadyVideoTrackInfo(int n) {
        PlayReadySampleInfo playReadySampleInfo = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov == null) {
            return playReadySampleInfo;
        }
        QTAtomtrak qTAtomtrak = qTAtommoov.getVideoTrack(n);
        if (qTAtomtrak != null) return qTAtomtrak.getPlayReadySampleInfo(this.metaFileStream, 0L);
        return playReadySampleInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlayReadyMediaInfo getPlayReadyInfo() {
        PlayReadyMediaInfo playReadyMediaInfo = null;
        QTAtommoov qTAtommoov = this.container.getMoovAtom();
        if (qTAtommoov != null) return this.container.getMoovAtom().getPlayReadyInfo();
        return playReadyMediaInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final TimedTextRequest a(Map<String, String> map) {
        String string;
        TimedTextRequest timedTextRequest = new TimedTextRequest();
        String string2 = map.get(this.captionLanguageQueryParameter);
        if (StringUtils.isNotEmpty((String)string2)) {
            string2 = string2.toLowerCase();
            try {
                List list = TimedTextRequest.parseTimedTextLanguageIDs((String)string2);
                timedTextRequest.setLanguageURLRequestName(this.captionLanguageQueryParameter);
                timedTextRequest.setLanguageRequestStr(string2);
                timedTextRequest.setLanguageIDs(list);
            }
            catch (Exception exception) {}
        }
        if (!StringUtils.isNotEmpty((String)(string = map.get(this.captionFilenameQueryParameter)))) return timedTextRequest;
        timedTextRequest.setFilenameQueryParam(this.captionFilenameQueryParameter);
        timedTextRequest.setFilename(string);
        return timedTextRequest;
    }

    public MediaReaderEncInfo getEncInfo() {
        return this.encInfo;
    }

    public int getVideoCodec() {
        return this.videoCodec;
    }

    public int getAudioCodec() {
        return this.audioCodec;
    }
}

