/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.bootstrap;

import com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl;
import com.wowza.wms.bootstrap.BootstrapConsoleLogger;
import com.wowza.wms.bootstrap.BootstrapTuningConfig;
import com.wowza.wms.bootstrap.BootstrapTuningHandler;
import com.wowza.wms.bootstrap.IWowzaServerTestRunner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.SystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Bootstrap {
    public static final int APPHOME = 1;
    public static final int CONFIGHOME = 2;
    public static final String NATIVELIBFOLDER = "lib-native";
    public static ClassLoader loader = null;
    private static final String CRLF = "\r\n";
    private static final String HTTP_PROTOCOL = "HTTP/1.1";
    private static final String[] hexadecimal = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public static final String DATEFORMAT = "EEE, dd MMM yyyy HH:mm:ss";

    public static void main(String[] stringArray) {
        Bootstrap.resolveServerHome();
        if (stringArray.length > 0) {
            if (stringArray[0].equals("start")) {
                Bootstrap.startServer();
            } else if (stringArray[0].equals("stop")) {
                Bootstrap.stopServer();
            } else if (stringArray[0].equals("runTest")) {
                Bootstrap.runTest(stringArray[1]);
            } else if (stringArray[0].equals("runTestCL")) {
                Bootstrap.runTestCL(stringArray);
            } else if (stringArray[0].equals("runJUnit")) {
                Bootstrap.runJUnit(stringArray);
            } else if (stringArray[0].equals("startDebugger")) {
                Bootstrap.startDebugger();
            } else if (stringArray[0].equals("stopDebugger")) {
                Bootstrap.stopDebugger();
            } else if (stringArray[0].equals("outputTuningCommandLine")) {
                BootstrapTuningHandler.outputTuningCommandLine();
            } else if (stringArray[0].equals("tailLogFile")) {
                Bootstrap.tailLogFile();
            }
        }
    }

    public static void tailLogFile() {
        BootstrapConsoleLogger bootstrapConsoleLogger = new BootstrapConsoleLogger();
        String string = Bootstrap.getServerHome(1);
        String string2 = string + "/conf/log4j.properties";
        bootstrapConsoleLogger.setPropertiesPath(string2);
        bootstrapConsoleLogger.init();
        while (true) {
            try {
                bootstrapConsoleLogger.run();
            }
            catch (Exception exception) {
                System.out.println("*** ERROR: Bootstrap.tailLogFile[" + string2 + "]: " + exception.toString());
                break;
            }
            try {
                Thread.currentThread();
                Thread.sleep(750L);
            }
            catch (Exception exception) {}
        }
    }

    private static void doWait() {
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isRunModeService() {
        boolean bl = false;
        String string = System.getProperty("com.wowza.wms.runmode");
        if (string != null && string.equals("service")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isNativeWindows() {
        boolean bl;
        block0: {
            bl = false;
            String string = Bootstrap.getNativeOS();
            if (string == null || !"win".equals(string)) break block0;
            bl = true;
        }
        return bl;
    }

    public static boolean isNativeLinux() {
        boolean bl;
        block0: {
            bl = false;
            String string = Bootstrap.getNativeOS();
            if (string == null || !"linux".equals(string)) break block0;
            bl = true;
        }
        return bl;
    }

    public static boolean isNativeOSX() {
        boolean bl;
        block0: {
            bl = false;
            String string = Bootstrap.getNativeOS();
            if (string == null || !"osx".equals(string)) break block0;
            bl = true;
        }
        return bl;
    }

    private static String expandEnvironmentVariables(String string) {
        Pattern pattern = Pattern.compile("\\$\\{[^}]*\\}");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group().substring(2, matcher.group().length() - 1);
            string = string.substring(0, matcher.start()) + System.getProperty(string2) + string.substring(matcher.end());
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private static ClassLoader createClassLoader(Map var0) {
        var1_1 = null;
        var2_2 = new ArrayList<URL>();
        try {
            var3_3 = Bootstrap.getServerHome(1);
            var4_5 = (var3_3 == null ? "" : var3_3) + File.separatorChar + "lib" + File.separatorChar;
            var5_6 = (var3_3 == null ? "" : var3_3) + File.separatorChar + "lib-license" + File.separatorChar;
            var6_7 = new File(var4_5).exists();
            if (var6_7) {
                var7_8 = new File(var4_5);
                if (var7_8.exists()) {
                    var8_9 = var7_8.listFiles();
                    for (var9_10 = 0; var9_10 < ((Object)var8_9).length; ++var9_10) {
                        var10_16 = var8_9[var9_10];
                        var11_21 = var10_16.toString();
                        if (var10_16.isDirectory() || !var11_21.toLowerCase().endsWith(".jar") && !var11_21.toLowerCase().endsWith(".xml") && !var11_21.toLowerCase().endsWith(".properties") && !var11_21.toLowerCase().endsWith(".class")) continue;
                        var2_2.add(var10_16.toURL());
                    }
                }
                if ((var8_9 = new File(var5_6)).exists()) {
                    var9_11 = var8_9.listFiles();
                    for (var10_17 = 0; var10_17 < var9_11.length; ++var10_17) {
                        var11_21 = var9_11[var10_17];
                        var12_22 = var11_21.toString();
                        if (var11_21.isDirectory() || !var12_22.toLowerCase().endsWith(".jar") && !var12_22.toLowerCase().endsWith(".xml") && !var12_22.toLowerCase().endsWith(".properties") && !var12_22.toLowerCase().endsWith(".class")) continue;
                        var2_2.add(var11_21.toURL());
                    }
                }
            } else {
                var7_8 = Bootstrap.getConfigURL();
                var8_9 = var7_8;
                var8_9 = var8_9.indexOf("?") >= 0 ? (String)var8_9 + "&" : (String)var8_9 + "?";
                var8_9 = (String)var8_9 + "context=server&filename=" + Bootstrap.encodeValue("conf/LibFolder.xml");
                try {
                    var9_12 = DocumentBuilderFactory.newInstance();
                    var10_18 = var9_12.newDocumentBuilder();
                    var11_21 = var10_18.parse((String)var8_9);
                    var12_22 = Bootstrap.newXPathFactory();
                    var13_23 = var12_22.newXPath();
                    if (var11_21 == null) ** GOTO lbl57
                    var14_24 = var11_21.getDocumentElement();
                    var15_26 = "/Root/LibFolder/Lib";
                    var16_27 = var13_23.compile((String)var15_26);
                    var17_28 = (NodeList)var16_27.evaluate(var14_24, XPathConstants.NODESET);
                    if (var17_28 == null) ** GOTO lbl57
                    for (var18_30 = 0; var18_30 < var17_28.getLength(); ++var18_30) {
                        var19_32 = var17_28.item(var18_30);
                        var20_33 = Bootstrap.getNodeValue((Node)var19_32);
                        var2_2.add(new URL(var20_33));
                    }
                }
                catch (Exception var9_13) {
                    System.out.println("Error parsing LibFolder.xml: " + var9_13.toString());
                    var9_13.printStackTrace();
                    Bootstrap.doWait();
                }
            }
lbl57:
            // 5 sources

            var7_8 = (Map)var0.get("VHosts");
            if (var7_8 != null) {
                var8_9 = var7_8.keySet().iterator();
                while (var8_9.hasNext()) {
                    var9_14 = (Map)var7_8.get(var8_9.next());
                    var10_19 = Bootstrap.expandEnvironmentVariables((String)var9_14.get("ConfigDir"));
                    var11_21 = var10_19 + File.separatorChar + "applications";
                    var12_22 = new File((String)var11_21);
                    if (var12_22.exists() && var12_22.isDirectory()) {
                        var13_23 = var12_22.listFiles();
                        for (var14_25 = 0; var14_25 < var13_23.length; ++var14_25) {
                            var15_26 = var13_23[var14_25];
                            if (!var15_26.isDirectory()) continue;
                            var16_27 = var15_26.listFiles();
                            for (var17_29 = 0; var17_29 < var16_27.length; ++var17_29) {
                                var18_31 = var16_27[var17_29];
                                var19_32 = var18_31.toString();
                                if (var18_31.isDirectory() || !var19_32.toLowerCase().endsWith(".jar") && !var19_32.toLowerCase().endsWith(".xml") && !var19_32.toLowerCase().endsWith(".properties") && !var19_32.toLowerCase().endsWith(".class")) continue;
                                var2_2.add(var18_31.toURL());
                            }
                        }
                        continue;
                    }
                    System.out.println("Error: applications folder missing: " + var12_22);
                }
            }
            var8_9 = var2_2.toArray(new URL[var2_2.size()]);
            var9_15 = Thread.currentThread().getContextClassLoader();
            var10_20 = new BootstrapURLClassLoader((URL[])var8_9, var9_15);
            Thread.currentThread().setContextClassLoader(var10_20);
            var1_1 = var10_20;
        }
        catch (Exception var3_4) {
            System.out.println("Error creating class loader: " + var3_4);
            var3_4.printStackTrace();
            Bootstrap.doWait();
        }
        return var1_1;
    }

    public static boolean loadJar(File file) {
        boolean bl;
        block8: {
            bl = false;
            if (!file.exists() || !(loader instanceof BootstrapURLClassLoader)) break block8;
            BootstrapURLClassLoader bootstrapURLClassLoader = (BootstrapURLClassLoader)loader;
            URL uRL = null;
            try {
                uRL = file.toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uRL != null) {
                URL[] uRLArray = bootstrapURLClassLoader.getURLs();
                boolean bl2 = false;
                if (uRLArray != null) {
                    for (int i = 0; i < uRLArray.length; ++i) {
                        if (!uRLArray[i].toString().equals(uRL.toString())) continue;
                        bl2 = false;
                        break;
                    }
                }
                if (!bl2) {
                    try {
                        bootstrapURLClassLoader.addURL(uRL);
                    }
                    catch (Exception exception) {
                        break block8;
                    }
                }
                bl = true;
            }
        }
        return bl;
    }

    public static Class findClass(String string) {
        Class<?> clazz = null;
        try {
            if (loader != null) {
                clazz = loader.loadClass(string);
            } else {
                System.out.println("Bootstrap.findClass (" + string + "): Class loader is null");
            }
        }
        catch (Exception exception) {
            System.out.println("Bootstrap.findClass (" + string + "): " + exception);
            exception.printStackTrace();
        }
        return clazz;
    }

    private static void startServer() {
        try {
            Map map = Bootstrap.getServerInfo();
            if (map != null) {
                loader = Bootstrap.createClassLoader(map);
                String string = "com.wowza.wms.server.Server";
                Class<?> clazz = loader.loadClass(string);
                Method method = clazz.getMethod("start", new Class[0]);
                method.invoke(null, (Object[])null);
            }
        }
        catch (Exception exception) {
            System.out.println("Error starting: " + exception);
            exception.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void startDebugger() {
        try {
            Map map = Bootstrap.getServerInfo();
            if (map != null) {
                ClassLoader classLoader = Bootstrap.createClassLoader(map);
                String string = "com.wowza.wms.debugger.DebugServer";
                Class<?> clazz = classLoader.loadClass(string);
                Method method = clazz.getMethod("startServer", new Class[0]);
                method.invoke(null, (Object[])null);
            }
        }
        catch (Exception exception) {
            System.out.println("Error starting: " + exception);
            exception.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void stopDebugger() {
    }

    private static String getServerGUID() {
        String string = null;
        BufferedReader bufferedReader = null;
        if (string == null) {
            String string2 = Bootstrap.getServerHome(2);
            string2 = string2 + File.separatorChar + "conf" + File.separatorChar + "Server.guid";
            try {
                File file = new File(string2);
                if (file.exists()) {
                    String string3;
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if ((string3 = string3.trim()).startsWith("#") || string3.length() == 0) continue;
                        string = string3;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Server.getServerGUID: File error[" + string2 + "]: " + exception.toString());
            }
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            bufferedReader = null;
        }
        catch (Exception exception) {
            System.out.println("Server.getServerGUID: Close error: " + exception.toString());
        }
        return string;
    }

    private static String getAdminGUID() {
        String string = null;
        BufferedReader bufferedReader = null;
        if (string == null) {
            String string2 = Bootstrap.getServerHome(2);
            string2 = string2 + File.separatorChar + "conf" + File.separatorChar + "Admin.guid";
            try {
                File file = new File(string2);
                if (file.exists()) {
                    String string3;
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if ((string3 = string3.trim()).startsWith("#") || string3.length() == 0) continue;
                        string = string3;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Server.getAdminGUID: File error[" + string2 + "]: " + exception.toString());
            }
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            bufferedReader = null;
        }
        catch (Exception exception) {
            System.out.println("Server.getAdminGUID: Close error: " + exception.toString());
        }
        return string;
    }

    private static byte[] getServerCommandEncryptionKey(String string, String string2) {
        byte[] byArray = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray2 = messageDigest.digest((string + ":" + string2).getBytes("UTF-8"));
            if (byArray2 != null) {
                byArray = new byte[16];
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private static String signServerCommand(String string) {
        String string2 = null;
        byte[] byArray = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byArray = messageDigest.digest(string.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray != null) {
            string2 = Bootstrap.encodeHexString(byArray);
        }
        return string2;
    }

    public static String encodeHexString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xF;
            int n2 = (byArray[i] & 0xF0) >> 4;
            string = string + hexadecimal[n2];
            string = string + hexadecimal[n];
        }
        return string;
    }

    public static String httpDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATEFORMAT, Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date()) + "GMT";
    }

    private static byte[] encryptMessageServerCommand(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeySpec);
            byArray3 = cipher.doFinal(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray3;
    }

    private static boolean sendServerCommand(String string, byte[] byArray) {
        boolean bl = true;
        try {
            Map map = Bootstrap.getServerInfo();
            String string2 = Bootstrap.getAdminGUID();
            if (string2 != null && map != null) {
                byte[] byArray2;
                String string3 = "GET";
                String string4 = "/ws-admin/current/server?action=" + string;
                String string5 = HTTP_PROTOCOL;
                String string6 = Bootstrap.httpDate();
                long l = byArray == null ? 0 : byArray.length;
                String string7 = string3 + "\n" + string4 + "\n" + string5 + "\n" + string6 + "\n" + l + "\n" + string2;
                String string8 = Bootstrap.signServerCommand(string7);
                byte[] byArray3 = Bootstrap.getServerCommandEncryptionKey(string2, string8);
                InetAddress inetAddress = (InetAddress)map.get("HostPort.address");
                int n = (Integer)map.get("HostPort.port");
                Socket socket = inetAddress == null ? new Socket("127.0.0.1", n) : new Socket(inetAddress, n);
                OutputStream outputStream = socket.getOutputStream();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string3 + " " + string4 + " " + string5 + CRLF);
                stringBuffer.append("Date: " + string6 + CRLF);
                stringBuffer.append("Content-Length: " + l + CRLF);
                stringBuffer.append("Authorization: WOWZA " + string8 + CRLF);
                stringBuffer.append(CRLF);
                byte[] byArray4 = stringBuffer.toString().getBytes();
                outputStream.write(byArray4);
                if (byArray != null && (byArray2 = Bootstrap.encryptMessageServerCommand(byArray3, byArray)) != null) {
                    outputStream.write(byArray2);
                }
                outputStream.flush();
                outputStream.close();
                socket.close();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static void stopServer() {
        Bootstrap.sendServerCommand("serverstop", null);
    }

    public static void restartServer() {
    }

    public static XPathFactory newXPathFactory() {
        XPathFactory xPathFactory = null;
        if (xPathFactory == null) {
            try {
                xPathFactory = XPathFactory.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (xPathFactory == null) {
            try {
                new XPathFactoryImpl();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (xPathFactory == null) {
            System.out.println("Error: Can't find XPathFactory");
        }
        return xPathFactory;
    }

    public static String encodeValue(String string) {
        String string2 = string;
        try {
            string2 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (Exception exception) {
            System.out.println("encodeValue (" + string + "): " + exception.toString());
            string2 = string;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static String expandEnvironmentVariables(String string, Map map) {
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\$\\{[^}]*\\}");
        Matcher matcher = pattern.matcher(string);
        ArrayList<ReplaceItem> arrayList = new ArrayList<ReplaceItem>();
        while (matcher.find()) {
            void object;
            void var6_11;
            String string2 = matcher.group().substring(2, matcher.group().length() - 1);
            Object var6_7 = null;
            if (map == null) {
                String string3 = System.getProperty(string2);
            } else if (map.containsKey(string2)) {
                String string4 = (String)map.get(string2);
            } else {
                String string5 = System.getProperty(string2);
            }
            if (var6_11 == null) {
                String string6 = "${" + (String)string2 + "}";
            }
            arrayList.add(0, new ReplaceItem(matcher.start(), matcher.end(), (String)object));
        }
        for (ReplaceItem replaceItem : arrayList) {
            string = string.substring(0, replaceItem.start) + replaceItem.newValue + string.substring(replaceItem.end);
        }
        return string;
    }

    public static BootstrapTuningConfig getTuningConfig() {
        BootstrapTuningConfig bootstrapTuningConfig = new BootstrapTuningConfig();
        String string = Bootstrap.getTuneXMLURL();
        if (string != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(string);
                XPathFactory xPathFactory = Bootstrap.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                if (document != null) {
                    XPathExpression xPathExpression;
                    NodeList nodeList;
                    Element element = document.getDocumentElement();
                    bootstrapTuningConfig.heapSize = Bootstrap.getNodeValue(xPath, "/Root/Tune/HeapSize", element, null);
                    bootstrapTuningConfig.garbageCollector = Bootstrap.getNodeValue(xPath, "/Root/Tune/GarbageCollector", element, null);
                    if (bootstrapTuningConfig.heapSize != null) {
                        bootstrapTuningConfig.heapSize = bootstrapTuningConfig.heapSize.trim();
                        if (bootstrapTuningConfig.heapSize.length() <= 0) {
                            bootstrapTuningConfig.heapSize = null;
                        }
                    }
                    if (bootstrapTuningConfig.garbageCollector != null) {
                        bootstrapTuningConfig.garbageCollector = bootstrapTuningConfig.garbageCollector.trim();
                        if (bootstrapTuningConfig.garbageCollector.length() <= 0) {
                            bootstrapTuningConfig.garbageCollector = null;
                        }
                    }
                    if ((nodeList = (NodeList)(xPathExpression = xPath.compile("/Root/Tune/VMOptions/VMOption")).evaluate(element, XPathConstants.NODESET)) != null) {
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Node node = nodeList.item(i);
                            Element element2 = (Element)node;
                            String string2 = Bootstrap.getNodeValue(element2);
                            if (string2 == null || (string2 = string2.trim()).length() <= 0) continue;
                            bootstrapTuningConfig.vmOptions.add(string2);
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Error parsing Tune.xml[" + string + "]: " + exception.toString());
            }
        }
        return bootstrapTuningConfig;
    }

    private static Map getServerInfo() {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Node node;
        Node node2;
        Object object7;
        XPathExpression xPathExpression;
        String string2;
        Element element;
        XPath xPath;
        XPathFactory xPathFactory;
        Document document;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory;
        String string3;
        HashMap<String, Serializable> hashMap = null;
        String string4 = Bootstrap.getServerXMLURL();
        if (string4 == null) {
            System.out.println("ERROR: Server.xml not found: exiting.");
            System.exit(1);
        }
        if ((string3 = Bootstrap.getVHostsXMLURL()) == null) {
            System.out.println("ERROR: VHosts.xml not found: exiting.");
            System.exit(1);
        }
        hashMap = new HashMap<String, Serializable>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        hashMap.put("VHosts", hashMap2);
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(string4);
            xPathFactory = Bootstrap.newXPathFactory();
            xPath = xPathFactory.newXPath();
            if (document != null) {
                element = document.getDocumentElement();
                string2 = "/Root/Server/CommandInterface/HostPort";
                xPathExpression = xPath.compile(string2);
                object7 = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
                if (object7 != null) {
                    Node node3 = Bootstrap.getNodeByTagName((Element)object7, "DomainName");
                    node2 = Bootstrap.getNodeByTagName((Element)object7, "IpAddress");
                    node = Bootstrap.getNodeByTagName((Element)object7, "Port");
                    if ((node3 != null || node2 != null) && node != null) {
                        object6 = Bootstrap.getNodeValue(node3);
                        object5 = Bootstrap.getNodeValue(node2);
                        object4 = Bootstrap.getNodeValue(node);
                        object3 = null;
                        string = null;
                        if (node2 != null) {
                            if (((String)object5).equals("*")) {
                                object3 = null;
                            } else {
                                object2 = ((String)object5).split("[.]");
                                if (((String[])object2).length == 4) {
                                    object = new byte[((String[])object2).length];
                                    for (int i = 0; i < ((String[])object2).length; ++i) {
                                        object[i] = (byte)Integer.parseInt(object2[i]);
                                    }
                                    object3 = InetAddress.getByAddress((byte[])object);
                                } else {
                                    System.out.println("setIpAddress: invalid ipAddress: " + (String)object5);
                                }
                            }
                        } else if (node3 != null) {
                            object3 = ((String)object6).equals("*") ? null : InetAddress.getByName((String)object6);
                        }
                        hashMap.put("HostPort.address", (Serializable)object3);
                        hashMap.put("HostPort.port", new Integer(Integer.parseInt((String)object4)));
                    } else {
                        System.out.println("Error parsing Server.xml: <DomainName> or <IpAddress> and <Port> required");
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error parsing Server.xml: <DomainName> or <IpAddress> and <Port> required: " + exception.toString());
            exception.printStackTrace();
            Bootstrap.doWait();
        }
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(string3);
            xPathFactory = Bootstrap.newXPathFactory();
            xPath = xPathFactory.newXPath();
            if (document != null) {
                element = document.getDocumentElement();
                string2 = "/Root/VHosts/VHost";
                xPathExpression = xPath.compile(string2);
                object7 = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (object7 != null) {
                    for (int i = 0; i < object7.getLength(); ++i) {
                        node2 = object7.item(i);
                        node = (Element)node2;
                        object6 = Bootstrap.getNodeByTagName((Element)node, "Name");
                        object5 = Bootstrap.getNodeByTagName((Element)node, "ConfigDir");
                        object4 = Bootstrap.getNodeByTagName((Element)node, "ConnectionLimit");
                        if (object6 != null && object5 != null) {
                            object3 = Bootstrap.getNodeValue((Node)object6);
                            string = Bootstrap.getNodeValue((Node)object5);
                            object2 = null;
                            if (object4 != null) {
                                object2 = Bootstrap.getNodeValue((Node)object4);
                            }
                            object = new HashMap();
                            object.put("Name", object3);
                            object.put("ConfigDir", string);
                            object.put("ConnectionLimit", object2);
                            hashMap2.put(object3, object);
                            continue;
                        }
                        System.out.println("loadConfigFile: error parsing vhosts config file: (" + string3 + ") : error <Name> and <ConfigDir> required.");
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error parsing VHosts.xml (" + string3 + "): " + exception.toString());
            exception.printStackTrace();
            Bootstrap.doWait();
        }
        return hashMap;
    }

    private static Node getNodeByTagName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            return nodeList.item(0);
        }
        return null;
    }

    private static String getNodeValue(Node node) {
        String string = "";
        if (node != null) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                string = string + node2.getNodeValue();
            }
        }
        return string;
    }

    public static String getNodeValue(XPath xPath, String string, Element element, String string2) {
        String string3 = string2;
        try {
            String string4 = xPath.evaluate(string, element);
            if (string4.length() > 0) {
                string3 = string4;
            }
        }
        catch (Exception exception) {
            System.out.println("getNodeValue: " + exception.toString());
        }
        return string3;
    }

    public static String getServerLog4jPropertiesURL() {
        String string = null;
        String string2 = Bootstrap.getConfigURL();
        String string3 = Bootstrap.getServerHome(2);
        String string4 = (string3 == null ? "" : string3) + File.separatorChar + "conf" + File.separatorChar + "log4j.properties";
        if (new File(string4).exists()) {
            string = string4.replace("\\", "/");
            if (string.charAt(1) == ':') {
                string = "/" + string;
            }
            string = "file://" + string;
        } else if (string2 != null) {
            string = string2;
            string = string.indexOf("?") >= 0 ? string + "&" : string + "?";
            string = string + "context=server&filename=" + Bootstrap.encodeValue("conf/log4j.properties");
        }
        return string;
    }

    public static String getServerLicenseURL() {
        String string = null;
        String string2 = Bootstrap.getServerHome(2);
        String string3 = (string2 == null ? "" : string2) + File.separatorChar + "conf" + File.separatorChar + "Server.license";
        if (new File(string3).exists()) {
            string = string3.replace("\\", "/");
            if (string.charAt(1) == ':') {
                string = "/" + string;
            }
            string = "file://" + string;
        }
        return string;
    }

    public static String getTuneXMLURL() {
        String string = null;
        String string2 = Bootstrap.getConfigURL();
        String string3 = Bootstrap.getServerHome(2);
        String string4 = (string3 == null ? "" : string3) + File.separatorChar + "conf" + File.separatorChar + "Tune.xml";
        if (new File(string4).exists()) {
            string = string4.replace("\\", "/");
            if (string.charAt(1) == ':') {
                string = "/" + string;
            }
            string = "file://" + string;
        } else if (string2 != null) {
            string = string2;
            string = string.indexOf("?") >= 0 ? string + "&" : string + "?";
            string = string + "context=server&filename=" + Bootstrap.encodeValue("conf/Tune.xml");
        }
        return string;
    }

    public static String getServerXMLURL() {
        String string = null;
        String string2 = Bootstrap.getConfigURL();
        String string3 = Bootstrap.getServerHome(2);
        String string4 = (string3 == null ? "" : string3) + File.separatorChar + "conf" + File.separatorChar + "Server.xml";
        if (new File(string4).exists()) {
            string = string4.replace("\\", "/");
            if (string.charAt(1) == ':') {
                string = "/" + string;
            }
            string = "file://" + string;
        } else if (string2 != null) {
            string = string2;
            string = string.indexOf("?") >= 0 ? string + "&" : string + "?";
            string = string + "context=server&filename=" + Bootstrap.encodeValue("conf/Server.xml");
        }
        return string;
    }

    public static String getVHostsXMLURL() {
        String string = null;
        String string2 = Bootstrap.getConfigURL();
        String string3 = Bootstrap.getServerHome(2);
        String string4 = (string3 == null ? "" : string3) + File.separatorChar + "conf" + File.separatorChar + "VHosts.xml";
        if (new File(string4).exists()) {
            string = string4.replace("\\", "/");
            if (string.charAt(1) == ':') {
                string = "/" + string;
            }
            string = "file://" + string;
        } else if (string2 != null) {
            string = string2;
            string = string.indexOf("?") >= 0 ? string + "&" : string + "?";
            string = string + "context=server&filename=" + Bootstrap.encodeValue("conf/VHosts.xml");
        }
        return string;
    }

    public static String getConfigURL() {
        String string = System.getProperty("com.wowza.wms.ConfigURL");
        if (string == null) {
            return null;
        }
        if (string.trim().length() == 0) {
            return null;
        }
        return string.trim();
    }

    public static boolean isServerURLConfig() {
        return Bootstrap.getConfigURL() != null;
    }

    public static void resolveServerHome() {
        String string = System.getProperty("com.wowza.wms.AppHome");
        if (string == null) {
            string = System.getenv("WMSAPP_HOME");
        }
        if (string != null) {
            string = string.trim();
            string = string.replace("\\", "/");
            if ((string = string.replace("//", "/")).endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() == 0) {
                string = null;
            }
        }
        System.setProperty("com.wowza.wms.AppHome", string);
        String string2 = System.getProperty("com.wowza.wms.ConfigHome");
        if (string2 == null) {
            string2 = System.getenv("WMSCONFIG_HOME");
        }
        if (string2 != null) {
            string2 = string2.trim();
            string2 = string2.replace("\\", "/");
            if ((string2 = string2.replace("//", "/")).endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.length() == 0) {
                string2 = null;
            }
        }
        System.setProperty("com.wowza.wms.ConfigHome", string2);
    }

    public static String getServerHome(int n) {
        return n == 1 ? System.getProperty("com.wowza.wms.AppHome") : System.getProperty("com.wowza.wms.ConfigHome");
    }

    private static void runTest(String string) {
        try {
            Map map = Bootstrap.getServerInfo();
            if (map != null) {
                ClassLoader classLoader = Bootstrap.createClassLoader(map);
                String string2 = "com.wowza.wms.performance.PerformanceTestList";
                Class<?> clazz = classLoader.loadClass(string2);
                Method method = clazz.getMethod("run", String.class);
                method.invoke(null, string);
            }
        }
        catch (Exception exception) {
            System.out.println("Error running test (" + string + "): " + exception);
            exception.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void runTestCL(String[] stringArray) {
        try {
            Map map = Bootstrap.getServerInfo();
            if (map != null) {
                ClassLoader classLoader = Bootstrap.createClassLoader(map);
                String string = stringArray[1];
                Class<?> clazz = classLoader.loadClass(string);
                Method method = clazz.getMethod("run", List.class);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 2; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
                method.invoke(null, arrayList);
            }
        }
        catch (Exception exception) {
            System.out.println("Error running test (" + stringArray[1] + "): " + exception);
            exception.printStackTrace();
            Bootstrap.doWait();
        }
    }

    private static void runJUnit(String[] stringArray) {
        Object object;
        Object object2;
        String string = "com.wowza.wms.plugin.junit.runner.WowzaServerJUnitRunner";
        boolean bl = false;
        boolean bl2 = false;
        Map map = null;
        try {
            map = Bootstrap.getServerInfo();
            if (map != null) {
                loader = Bootstrap.createClassLoader(map);
            }
        }
        catch (Exception exception) {
            bl = false;
            System.out.println("Bootstrap.runJUnit: Error starting bootstrap loader: " + exception);
            exception.printStackTrace();
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = loader.loadClass(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (clazz == null) {
            System.out.printf("Bootstrap.runJUnit: Class '%s' cannot be found. No JUnit tests run.\n", string);
            return;
        }
        IWowzaServerTestRunner iWowzaServerTestRunner = null;
        try {
            if (clazz != null) {
                object2 = clazz.getMethod("createRunner", String[].class);
                if (object2 == null) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.createRunner(String, String[]) not found. No JUnit tests run.\n", string);
                }
                if (!((object = ((Method)object2).invoke(null, new Object[]{stringArray})) instanceof IWowzaServerTestRunner)) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.createRunner(String[]) was unsuccessful,  Return value: %s\n", string, object);
                    return;
                }
                iWowzaServerTestRunner = (IWowzaServerTestRunner)object;
            }
        }
        catch (Exception exception) {
            bl2 = false;
            System.out.printf("Bootstrap.runJUnit: Method %s.createRunner(String[]) was unsuccessful,  e:\n", exception);
            return;
        }
        try {
            if (iWowzaServerTestRunner != null) {
                object2 = clazz.getMethod("setUp", String.class);
                if (object2 == null) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.setUp(String) not found. No JUnit tests run.\n", string);
                }
                if (!(object = ((Method)object2).invoke(iWowzaServerTestRunner, Bootstrap.getServerHome(1))).toString().equals("0")) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.setUp(String[]) was unsuccessful,  Return value: %s\n", string, object);
                    return;
                }
            }
        }
        catch (Exception exception) {
            bl2 = false;
            System.out.printf("Bootstrap.runJUnit: Method %s.setUp(String[]) was unsuccessful,  e:\n", exception);
            return;
        }
        try {
            if (loader != null) {
                object2 = "com.wowza.wms.server.Server";
                object = loader.loadClass((String)object2);
                Method method = ((Class)object).getMethod("start", new Class[0]);
                method.invoke(null, (Object[])null);
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
            System.out.println("Bootstrap.runJUnit: Error starting: " + exception);
            exception.printStackTrace();
        }
        try {
            if (bl && clazz != null) {
                object2 = clazz.getMethod("runTests", new Class[0]);
                if (object2 == null) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.runTests(String[]) not found. No JUnit tests run.\n", string);
                }
                object = ((Method)object2).invoke(iWowzaServerTestRunner, new Object[0]);
                bl2 = true;
                if (!object.toString().equals("0")) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.runTests(String[]) did not run tests,  Return value: %s\n", string, object);
                }
            }
        }
        catch (Exception exception) {
            bl2 = false;
            System.out.println("Bootstrap.runTests: Error starting JUnit tests: " + exception);
            exception.printStackTrace();
        }
        try {
            if (clazz != null) {
                object2 = clazz.getMethod("tearDown", String.class);
                if (object2 == null) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.tearDown(String) not found. No JUnit tests run.\n", string);
                }
                if (!(object = ((Method)object2).invoke((Object)iWowzaServerTestRunner, Bootstrap.getServerHome(1))).toString().equals("0")) {
                    System.out.printf("Bootstrap.runJUnit: Method %s.tearDown(String[]) was unsuccessful,  Return value: %s\n", string, object);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
            System.out.printf("Bootstrap.runJUnit: Method %s.tearDown(String[]) was unsuccessful,  e:\n", exception);
        }
        Bootstrap.stopServer();
    }

    public static String getNativeOS() {
        String string = System.getProperty("com.wowza.wms.native.base");
        if (string == null) {
            if (SystemUtils.IS_OS_WINDOWS) {
                string = "win";
            } else if (SystemUtils.IS_OS_LINUX) {
                string = "linux";
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                string = "osx";
            }
        }
        return string;
    }

    public static String getNativeArchitecture() {
        String string = System.getProperty("sun.arch.data.model");
        return string;
    }

    public static String getNativeLibPath() {
        String string = System.getProperty("sun.arch.data.model");
        String string2 = System.getProperty("com.wowza.wms.native.base");
        if (string2 == null) {
            if (SystemUtils.IS_OS_WINDOWS) {
                string2 = "win";
            } else if (SystemUtils.IS_OS_LINUX) {
                string2 = "linux";
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                string2 = "osx";
            }
        }
        String string3 = Bootstrap.getServerHome(1) + "/" + NATIVELIBFOLDER + "/" + string2 + string;
        return string3;
    }

    public static class BootstrapURLClassLoader
    extends URLClassLoader {
        public BootstrapURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        @Override
        public void addURL(URL uRL) {
            this.addURL(uRL);
        }
    }

    public static class ReplaceItem {
        public int start = 0;
        public int end = 0;
        public String newValue = null;

        public ReplaceItem(int n, int n2, String string) {
            this.start = n;
            this.end = n2;
            this.newValue = string;
        }
    }
}

