/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.bootstrap;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import org.apache.commons.lang.SystemUtils;

public class BootstrapSystemTuningInfo {
    private int architecture = 32;
    private int cores = 2;
    private long physicalMemory = 2048L;
    private long heapMemory = 768L;
    private String nativeBase = "win";

    public boolean is64Bit() {
        return this.architecture > 32;
    }

    public boolean isWindows() {
        return "win".equals(this.nativeBase);
    }

    public boolean isOSX() {
        return "osx".equals(this.nativeBase);
    }

    public boolean isLinux() {
        return "linux".equals(this.nativeBase);
    }

    public int getArchitecture() {
        return this.architecture;
    }

    public int getCores() {
        return this.cores;
    }

    public long getPhysicalMemory() {
        return this.physicalMemory;
    }

    public String getNativeBase() {
        return this.nativeBase;
    }

    public static BootstrapSystemTuningInfo getSystemTuningInfo() {
        String string;
        int n;
        OperatingSystemMXBean operatingSystemMXBean;
        long l;
        BootstrapSystemTuningInfo bootstrapSystemTuningInfo = new BootstrapSystemTuningInfo();
        String string2 = System.getProperty("sun.arch.data.model");
        if (string2 != null) {
            try {
                bootstrapSystemTuningInfo.architecture = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((l = (operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize()) > 0L) {
            bootstrapSystemTuningInfo.physicalMemory = l / 0x100000L;
        }
        if ((n = Runtime.getRuntime().availableProcessors()) > 0) {
            bootstrapSystemTuningInfo.cores = n;
        }
        if ((string = System.getProperty("com.wowza.wms.native.base")) == null) {
            if (SystemUtils.IS_OS_WINDOWS) {
                string = "win";
            } else if (SystemUtils.IS_OS_LINUX) {
                string = "linux";
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                string = "osx";
            }
        }
        bootstrapSystemTuningInfo.nativeBase = string;
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        bootstrapSystemTuningInfo.heapMemory = memoryMXBean.getHeapMemoryUsage().getMax() / 0x100000L;
        return bootstrapSystemTuningInfo;
    }

    public long getHeapMemory() {
        return this.heapMemory;
    }
}

