/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.farng.mp3.AbstractMP3FileItem;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.RandomAccessFile;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.ID3v2_2;
import org.farng.mp3.id3.ID3v2_3;
import org.farng.mp3.id3.ID3v2_4;
import org.farng.mp3.object.AbstractMP3Object;

public abstract class AbstractMP3FragmentBody
extends AbstractMP3FileItem {
    private static final int SIZE_OBJECT_LIST = 16;
    private static final int SIZE_BRIEF_DESCRIPTION = 64;
    private static final int SIZE_DESCRIPTION = 256;
    private List objectList = new ArrayList(16);

    protected AbstractMP3FragmentBody() {
        this.setupObjectList();
    }

    protected AbstractMP3FragmentBody(AbstractMP3FragmentBody abstractMP3FragmentBody) {
        super(abstractMP3FragmentBody);
        Iterator iterator = abstractMP3FragmentBody.iterator();
        while (iterator.hasNext()) {
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)iterator.next();
            AbstractMP3Object abstractMP3Object2 = (AbstractMP3Object)TagUtility.copyObject(abstractMP3Object);
            this.objectList.add(abstractMP3Object2);
        }
    }

    public String getBriefDescription() {
        StringBuffer stringBuffer = new StringBuffer(64);
        ListIterator listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)listIterator.next();
            String string = abstractMP3Object.toString();
            if (string == null || string.length() <= 0) continue;
            String string2 = abstractMP3Object.getIdentifier();
            stringBuffer.append(string2);
            stringBuffer.append("=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"; ");
        }
        return stringBuffer.toString();
    }

    public String getDescription() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(256);
        ListIterator listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            object = (AbstractMP3Object)listIterator.next();
            String string = ((AbstractMP3Object)object).getIdentifier();
            stringBuffer.append(string);
            stringBuffer.append(" = ");
            String string2 = ((AbstractMP3Object)object).toString();
            stringBuffer.append(string2);
            stringBuffer.append(TagConstant.SEPERATOR_LINE);
        }
        object = stringBuffer.toString();
        return ((String)object).trim();
    }

    public Iterator getObjectListIterator() {
        return this.objectList.listIterator();
    }

    public void setObject(String string, Object object) {
        ListIterator listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)listIterator.next();
            String string2 = abstractMP3Object.getIdentifier();
            if (!string2.equals(string)) continue;
            abstractMP3Object.setValue(object);
        }
    }

    public Object getObject(String string) {
        Object object = null;
        ListIterator listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)listIterator.next();
            String string2 = abstractMP3Object.getIdentifier();
            if (!string2.equals(string)) continue;
            object = abstractMP3Object.getValue();
        }
        return object;
    }

    @Override
    public int getSize() {
        int n = 0;
        ListIterator listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)listIterator.next();
            n += abstractMP3Object.getSize();
        }
        return n;
    }

    @Override
    public boolean isSubsetOf(Object object) {
        if (!super.isSubsetOf(object)) {
            return false;
        }
        if (!(object instanceof AbstractMP3FragmentBody)) {
            return false;
        }
        List list = ((AbstractMP3FragmentBody)object).objectList;
        int n = this.objectList.size();
        for (int i = 0; i < n; ++i) {
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)this.objectList.get(i);
            if (abstractMP3Object.getValue() == null || list.contains(abstractMP3Object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractMP3FragmentBody)) {
            return false;
        }
        AbstractMP3FragmentBody abstractMP3FragmentBody = (AbstractMP3FragmentBody)object;
        if (!((Object)this.objectList).equals(abstractMP3FragmentBody.objectList)) {
            return false;
        }
        return super.equals(object);
    }

    public Iterator iterator() {
        return this.objectList.iterator();
    }

    protected void appendToObjectList(AbstractMP3Object abstractMP3Object) {
        this.objectList.add(abstractMP3Object);
    }

    @Override
    public void read(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        int n = this.readHeader(randomAccessFile);
        byte[] byArray = new byte[n];
        randomAccessFile.read(byArray);
        ListIterator listIterator = this.objectList.listIterator();
        int n2 = 0;
        while (listIterator.hasNext()) {
            if (n2 > n - 1) {
                throw new InvalidTagException("Invalid size for Frame Body");
            }
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)listIterator.next();
            abstractMP3Object.readByteArray(byArray, n2);
            n2 += abstractMP3Object.getSize();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = this.getIdentifier();
        stringBuffer.append(string);
        stringBuffer.append(TagConstant.SEPERATOR_LINE);
        ListIterator listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)listIterator.next();
            String string2 = abstractMP3Object.getIdentifier();
            stringBuffer.append(string2);
            stringBuffer.append(" = ");
            String string3 = abstractMP3Object.toString();
            stringBuffer.append(string3);
            stringBuffer.append(TagConstant.SEPERATOR_LINE);
        }
        return stringBuffer.toString();
    }

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n = this.getSize();
        this.writeHeader(randomAccessFile, n);
        ListIterator listIterator = this.objectList.listIterator();
        while (listIterator.hasNext()) {
            AbstractMP3Object abstractMP3Object = (AbstractMP3Object)listIterator.next();
            byte[] byArray = abstractMP3Object.writeByteArray();
            randomAccessFile.write(byArray);
        }
    }

    protected abstract int readHeader(RandomAccessFile var1) throws IOException, InvalidTagException;

    protected abstract void setupObjectList();

    protected abstract void writeHeader(RandomAccessFile var1, int var2) throws IOException;

    protected static boolean has6ByteHeader() {
        Exception exception = new Exception();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        String string = ID3v2_2.class.getName();
        String string2 = ID3v2_3.class.getName();
        String string3 = ID3v2_4.class.getName();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
            String string4 = stackTraceElementArray[i].getClassName();
            if (string.equals(string4)) {
                bl = true;
                bl2 = true;
                continue;
            }
            if (string2.equals(string4)) {
                bl = false;
                bl2 = true;
                continue;
            }
            if (!string3.equals(string4)) continue;
            bl = false;
            bl2 = true;
        }
        if (!bl2) {
            throw new UnsupportedOperationException("FragmentBody not called within ID3v2 tag.");
        }
        return bl;
    }
}

