/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.filename;

import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.filename.AbstractFilenameComposite;
import org.farng.mp3.filename.FilenameDelimiter;
import org.farng.mp3.filename.FilenameParenthesisIterator;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.ID3v2_4;

public class FilenameParenthesis
extends FilenameDelimiter {
    private AbstractFilenameComposite middleComposite = null;
    private String openDelimiter = null;

    public FilenameParenthesis() {
    }

    public FilenameParenthesis(FilenameParenthesis filenameParenthesis) {
        super(filenameParenthesis);
        this.openDelimiter = filenameParenthesis.openDelimiter;
        this.middleComposite = (AbstractFilenameComposite)TagUtility.copyObject(filenameParenthesis.middleComposite);
    }

    @Override
    public void setFrame(AbstractID3v2Frame abstractID3v2Frame) {
        if (abstractID3v2Frame != null) {
            if (this.getBeforeComposite() != null) {
                this.getBeforeComposite().setFrame(abstractID3v2Frame);
            }
            if (this.middleComposite != null) {
                this.middleComposite.setFrame(abstractID3v2Frame);
            }
            if (this.getAfterComposite() != null) {
                this.getAfterComposite().setFrame(abstractID3v2Frame);
            }
        }
    }

    public void setMiddleComposite(AbstractFilenameComposite abstractFilenameComposite) {
        this.middleComposite = abstractFilenameComposite;
    }

    public AbstractFilenameComposite getMiddleComposite() {
        return this.middleComposite;
    }

    public void setOpenDelimiter(String string) {
        this.openDelimiter = string;
    }

    public String getOpenDelimiter() {
        return this.openDelimiter;
    }

    @Override
    public String composeFilename() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.getBeforeComposite() != null) {
            stringBuffer.append(this.getBeforeComposite().composeFilename());
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.openDelimiter);
        if (this.middleComposite != null) {
            stringBuffer.append(this.middleComposite.composeFilename());
        }
        stringBuffer.append(TagOptionSingleton.getInstance().getCloseParenthesis(this.openDelimiter));
        stringBuffer.append(' ');
        if (this.getAfterComposite() != null) {
            stringBuffer.append(this.getAfterComposite().composeFilename());
        }
        return stringBuffer.toString().trim();
    }

    @Override
    public ID3v2_4 createId3Tag() {
        ID3v2_4 iD3v2_4 = null;
        if (this.getBeforeComposite() != null) {
            iD3v2_4 = this.getBeforeComposite().createId3Tag();
        }
        if (this.middleComposite != null) {
            if (iD3v2_4 != null) {
                iD3v2_4.append(this.middleComposite.createId3Tag());
            } else {
                iD3v2_4 = this.middleComposite.createId3Tag();
            }
        }
        if (this.getAfterComposite() != null) {
            if (iD3v2_4 != null) {
                iD3v2_4.append(this.getAfterComposite().createId3Tag());
            } else {
                iD3v2_4 = this.getAfterComposite().createId3Tag();
            }
        }
        return iD3v2_4;
    }

    @Override
    public Iterator iterator() {
        return new FilenameParenthesisIterator(this);
    }

    @Override
    public void matchAgainstKeyword(Class clazz) {
        if (AbstractID3v2FrameBody.class.isAssignableFrom(clazz)) {
            if (this.getBeforeComposite() != null) {
                this.getBeforeComposite().matchAgainstKeyword(clazz);
            }
            if (this.middleComposite != null) {
                this.middleComposite.matchAgainstKeyword(clazz);
            }
            if (this.getAfterComposite() != null) {
                this.getAfterComposite().matchAgainstKeyword(clazz);
            }
        }
    }

    @Override
    public void matchAgainstTag(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag != null) {
            if (this.getBeforeComposite() != null) {
                this.getBeforeComposite().matchAgainstTag(abstractMP3Tag);
            }
            if (this.middleComposite != null) {
                this.middleComposite.matchAgainstTag(abstractMP3Tag);
            }
            if (this.getAfterComposite() != null) {
                this.getAfterComposite().matchAgainstTag(abstractMP3Tag);
            }
        }
    }
}

