/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.filename;

import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.filename.AbstractFilenameComposite;
import org.farng.mp3.filename.FilenameTokenIterator;
import org.farng.mp3.id3.AbstractFrameBodyTextInformation;
import org.farng.mp3.id3.AbstractFrameBodyUrlLink;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.ID3v2_4;
import org.farng.mp3.id3.ID3v2_4Frame;

public class FilenameToken
extends AbstractFilenameComposite {
    private Class id3v2FrameBodyClass = null;
    private String token = null;

    public FilenameToken() {
    }

    public FilenameToken(FilenameToken filenameToken) {
        super(filenameToken);
        try {
            this.id3v2FrameBodyClass = this.id3v2FrameBodyClass.newInstance().getClass();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NullPointerException("IllegalAccessException: No access to run constructor to create copy " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new NullPointerException("InstantiationException: Unable to instantiate constructor to copy " + instantiationException.getMessage());
        }
        this.token = filenameToken.token;
    }

    @Override
    public void setFrame(AbstractID3v2Frame abstractID3v2Frame) {
        if (this.id3v2FrameBodyClass != null && this.id3v2FrameBodyClass.equals(abstractID3v2Frame.getBody().getClass())) {
            if (AbstractFrameBodyTextInformation.class.isInstance(abstractID3v2Frame.getBody())) {
                this.token = ((AbstractFrameBodyTextInformation)abstractID3v2Frame.getBody()).getText();
            } else if (AbstractFrameBodyUrlLink.class.isInstance(abstractID3v2Frame.getBody())) {
                this.token = ((AbstractFrameBodyUrlLink)abstractID3v2Frame.getBody()).getUrlLink();
            }
        }
    }

    public void setId3v2FrameBodyClass(Class clazz) {
        this.id3v2FrameBodyClass = clazz;
    }

    public Class getId3v2FrameBodyClass() {
        return this.id3v2FrameBodyClass;
    }

    public void setToken(String string) {
        this.token = string.trim();
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public String composeFilename() {
        return this.token;
    }

    @Override
    public ID3v2_4 createId3Tag() {
        ID3v2_4 iD3v2_4 = new ID3v2_4();
        if (this.id3v2FrameBodyClass != null) {
            try {
                AbstractID3v2FrameBody abstractID3v2FrameBody = (AbstractID3v2FrameBody)this.id3v2FrameBodyClass.newInstance();
                if (abstractID3v2FrameBody instanceof AbstractFrameBodyTextInformation) {
                    ((AbstractFrameBodyTextInformation)abstractID3v2FrameBody).setText(this.token);
                    ((AbstractFrameBodyTextInformation)abstractID3v2FrameBody).setTextEncoding((byte)0);
                } else if (abstractID3v2FrameBody instanceof AbstractFrameBodyUrlLink) {
                    ((AbstractFrameBodyUrlLink)abstractID3v2FrameBody).setUrlLink(this.token);
                } else if (abstractID3v2FrameBody instanceof FrameBodyCOMM) {
                    ((FrameBodyCOMM)abstractID3v2FrameBody).setText(this.token);
                    ((FrameBodyCOMM)abstractID3v2FrameBody).setDescription("");
                    ((FrameBodyCOMM)abstractID3v2FrameBody).setLanguage(TagOptionSingleton.getInstance().getLanguage());
                    ((FrameBodyCOMM)abstractID3v2FrameBody).setTextEncoding(TagOptionSingleton.getInstance().getTextEncoding());
                }
                ID3v2_4Frame iD3v2_4Frame = new ID3v2_4Frame();
                iD3v2_4Frame.setBody(abstractID3v2FrameBody);
                iD3v2_4.setFrame(iD3v2_4Frame);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return iD3v2_4;
    }

    @Override
    public Iterator iterator() {
        return new FilenameTokenIterator(this);
    }

    @Override
    public void matchAgainstKeyword(Class clazz) {
        if (AbstractID3v2FrameBody.class.isAssignableFrom(clazz) && (TagOptionSingleton.getInstance().isCompositeMatchOverwrite() || this.id3v2FrameBodyClass == null)) {
            Iterator iterator = TagOptionSingleton.getInstance().getKeywordListIterator(clazz);
            String string = this.token.toLowerCase();
            while (iterator.hasNext()) {
                String string2 = ((String)iterator.next()).toLowerCase();
                if (!string2.equals(string) && string2.indexOf(string) < 0 && string.indexOf(string2) < 0) continue;
                this.setId3v2FrameBodyClass(clazz);
                break;
            }
        }
    }

    @Override
    public void matchAgainstTag(AbstractMP3Tag abstractMP3Tag) {
        if (TagOptionSingleton.getInstance().isCompositeMatchOverwrite() || this.id3v2FrameBodyClass == null) {
            ID3v2_4 iD3v2_4 = abstractMP3Tag instanceof ID3v2_4 ? (ID3v2_4)abstractMP3Tag : new ID3v2_4(abstractMP3Tag);
            Iterator iterator = iD3v2_4.iterator();
            String string = null;
            String string2 = this.token.toLowerCase();
            while (iterator.hasNext()) {
                ID3v2_4Frame iD3v2_4Frame = (ID3v2_4Frame)iterator.next();
                AbstractID3v2FrameBody abstractID3v2FrameBody = (AbstractID3v2FrameBody)iD3v2_4Frame.getBody();
                if (abstractID3v2FrameBody instanceof AbstractFrameBodyTextInformation) {
                    string = ((AbstractFrameBodyTextInformation)abstractID3v2FrameBody).getText();
                    if (string != null) {
                        string = string.toLowerCase();
                    }
                } else if (abstractID3v2FrameBody instanceof AbstractFrameBodyUrlLink) {
                    string = ((AbstractFrameBodyUrlLink)abstractID3v2FrameBody).getUrlLink();
                    if (string != null) {
                        string = string.toLowerCase();
                    }
                } else if (abstractID3v2FrameBody instanceof FrameBodyCOMM) {
                    string = ((FrameBodyCOMM)abstractID3v2FrameBody).getText();
                }
                if (!string2.equals(string) && (string == null || string.indexOf(string2) < 0 && string2.indexOf(string) < 0)) continue;
                this.setId3v2FrameBodyClass(abstractID3v2FrameBody.getClass());
                break;
            }
        }
    }

    public String toString() {
        return this.id3v2FrameBodyClass + ": " + this.token;
    }
}

