/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.lyrics3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.RandomAccessFile;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.lyrics3.AbstractLyrics3v2FieldBody;
import org.farng.mp3.object.ObjectID3v2LyricLine;
import org.farng.mp3.object.ObjectLyrics3Line;
import org.farng.mp3.object.ObjectLyrics3TimeStamp;

public class FieldBodyLYR
extends AbstractLyrics3v2FieldBody {
    private ArrayList lines = new ArrayList();

    public FieldBodyLYR() {
    }

    public FieldBodyLYR(FieldBodyLYR fieldBodyLYR) {
        super(fieldBodyLYR);
        for (int i = 0; i < fieldBodyLYR.lines.size(); ++i) {
            ObjectLyrics3Line objectLyrics3Line = (ObjectLyrics3Line)fieldBodyLYR.lines.get(i);
            ObjectLyrics3Line objectLyrics3Line2 = new ObjectLyrics3Line(objectLyrics3Line);
            this.lines.add(objectLyrics3Line2);
        }
    }

    public FieldBodyLYR(String string) {
        this.readString(string);
    }

    public FieldBodyLYR(FrameBodySYLT frameBodySYLT) {
        this.addLyric(frameBodySYLT);
    }

    public FieldBodyLYR(FrameBodyUSLT frameBodyUSLT) {
        this.addLyric(frameBodyUSLT);
    }

    public FieldBodyLYR(RandomAccessFile randomAccessFile) throws InvalidTagException, IOException {
        this.read(randomAccessFile);
    }

    @Override
    public String getIdentifier() {
        return "LYR";
    }

    public void setLyric(String string) {
        this.readString(string);
    }

    public String getLyric() {
        return this.writeString();
    }

    @Override
    public int getSize() {
        int n = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            ObjectLyrics3Line objectLyrics3Line = (ObjectLyrics3Line)this.lines.get(i);
            n += objectLyrics3Line.getSize() + 2;
        }
        return n;
    }

    @Override
    public boolean isSubsetOf(Object object) {
        if (!(object instanceof FieldBodyLYR)) {
            return false;
        }
        ArrayList arrayList = ((FieldBodyLYR)object).lines;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (arrayList.contains(this.lines.get(i))) continue;
            return false;
        }
        return super.isSubsetOf(object);
    }

    public void addLyric(FrameBodySYLT frameBodySYLT) {
        Iterator iterator = frameBodySYLT.iterator();
        HashMap<String, ObjectLyrics3Line> hashMap = new HashMap<String, ObjectLyrics3Line>();
        while (iterator.hasNext()) {
            ObjectLyrics3Line objectLyrics3Line;
            ObjectID3v2LyricLine objectID3v2LyricLine = (ObjectID3v2LyricLine)iterator.next();
            objectID3v2LyricLine = new ObjectID3v2LyricLine(objectID3v2LyricLine);
            ObjectLyrics3TimeStamp objectLyrics3TimeStamp = new ObjectLyrics3TimeStamp("Time Stamp");
            objectLyrics3TimeStamp.setTimeStamp(objectID3v2LyricLine.getTimeStamp(), frameBodySYLT.getTimeStampFormat());
            if (hashMap.containsKey(objectID3v2LyricLine.getText())) {
                objectLyrics3Line = (ObjectLyrics3Line)hashMap.get(objectID3v2LyricLine.getText());
                objectLyrics3Line.addTimeStamp(objectLyrics3TimeStamp);
                continue;
            }
            objectLyrics3Line = new ObjectLyrics3Line("Lyric Line");
            objectLyrics3Line.setLyric(objectID3v2LyricLine);
            objectLyrics3Line.setTimeStamp(objectLyrics3TimeStamp);
            hashMap.put(objectID3v2LyricLine.getText(), objectLyrics3Line);
            this.lines.add(objectLyrics3Line);
        }
    }

    public void addLyric(FrameBodyUSLT frameBodyUSLT) {
        ObjectLyrics3Line objectLyrics3Line = new ObjectLyrics3Line("Lyric Line");
        objectLyrics3Line.setLyric(new String(frameBodyUSLT.getLyric()));
        this.lines.add(objectLyrics3Line);
        this.appendToObjectList(objectLyrics3Line);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FieldBodyLYR)) {
            return false;
        }
        FieldBodyLYR fieldBodyLYR = (FieldBodyLYR)object;
        if (!this.lines.equals(fieldBodyLYR.lines)) {
            return false;
        }
        return super.equals(object);
    }

    public boolean hasTimeStamp() {
        boolean bl = false;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (!((ObjectLyrics3Line)this.lines.get(i)).hasTimeStamp()) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public Iterator iterator() {
        return this.lines.iterator();
    }

    @Override
    protected void setupObjectList() {
    }

    @Override
    public void read(RandomAccessFile randomAccessFile) throws InvalidTagException, IOException {
        byte[] byArray = new byte[5];
        randomAccessFile.read(byArray, 0, 5);
        int n = Integer.parseInt(new String(byArray, 0, 5));
        if (n == 0 && !TagOptionSingleton.getInstance().isLyrics3KeepEmptyFieldIfRead()) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }
        byArray = new byte[n];
        randomAccessFile.read(byArray);
        String string = new String(byArray);
        this.readString(string);
    }

    @Override
    public String toString() {
        String string = this.getIdentifier() + " : ";
        for (int i = 0; i < this.lines.size(); ++i) {
            string = string + this.lines.get(i).toString();
        }
        return string;
    }

    @Override
    public void write(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        int n2 = 0;
        byte[] byArray = new byte[5];
        int n3 = this.getSize();
        String string = Integer.toString(n3);
        for (n = 0; n < 5 - string.length(); ++n) {
            byArray[n] = 48;
        }
        n2 += 5 - string.length();
        for (n = 0; n < string.length(); ++n) {
            byArray[n + n2] = (byte)string.charAt(n);
        }
        n2 += string.length();
        randomAccessFile.write(byArray, 0, 5);
        if (n3 > 0) {
            string = this.writeString();
            byArray = new byte[string.length()];
            for (n = 0; n < string.length(); ++n) {
                byArray[n] = (byte)string.charAt(n);
            }
            randomAccessFile.write(byArray);
        }
    }

    private void readString(String string) {
        ObjectLyrics3Line objectLyrics3Line;
        String string2;
        int n = 0;
        int n2 = string.indexOf(TagConstant.SEPERATOR_LINE);
        this.lines = new ArrayList();
        while (n2 >= 0) {
            string2 = string.substring(n, n2);
            objectLyrics3Line = new ObjectLyrics3Line("Lyric Line");
            objectLyrics3Line.setLyric(string2);
            this.lines.add(objectLyrics3Line);
            this.appendToObjectList(objectLyrics3Line);
            n = n2 + TagConstant.SEPERATOR_LINE.length();
            n2 = string.indexOf(TagConstant.SEPERATOR_LINE, n);
        }
        if (n < string.length()) {
            string2 = string.substring(n);
            objectLyrics3Line = new ObjectLyrics3Line("Lyric Line");
            objectLyrics3Line.setLyric(string2);
            this.lines.add(objectLyrics3Line);
            this.appendToObjectList(objectLyrics3Line);
        }
    }

    private String writeString() {
        String string = "";
        for (int i = 0; i < this.lines.size(); ++i) {
            ObjectLyrics3Line objectLyrics3Line = (ObjectLyrics3Line)this.lines.get(i);
            string = string + objectLyrics3Line.writeString() + TagConstant.SEPERATOR_LINE;
        }
        return string;
    }
}

