/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.farng.mp3.TagConstant;
import org.farng.mp3.object.ObjectHashMapInterface;
import org.farng.mp3.object.ObjectNumberFixedLength;

public class ObjectNumberHashMap
extends ObjectNumberFixedLength
implements ObjectHashMapInterface {
    public static final String GENRE = "Genre";
    public static final String TEXT_ENCODING = "Text Encoding";
    public static final String INTERPOLATION_METHOD = "Interpolation Method";
    public static final String ID3V2_FRAME_DESCRIPTION = "ID3v2 Frame Description";
    public static final String PICTURE_TYPE = "Picture Type";
    public static final String TYPE_OF_EVENT = "Type Of Event";
    public static final String TIME_STAMP_FORMAT = "Time Stamp Format";
    public static final String TYPE_OF_CHANNEL = "Type Of Channel";
    public static final String RECIEVED_AS = "Recieved As";
    private HashMap idToString = null;
    private HashMap stringToId = null;
    private boolean hasEmptyValue = false;

    public ObjectNumberHashMap(String string, int n) {
        super(string, n);
        if (string.equals(GENRE)) {
            this.stringToId = TagConstant.genreStringToId;
            this.idToString = TagConstant.genreIdToString;
            this.hasEmptyValue = true;
        } else if (string.equals(TEXT_ENCODING)) {
            this.stringToId = TagConstant.textEncodingStringToId;
            this.idToString = TagConstant.textEncodingIdToString;
        } else if (string.equals(INTERPOLATION_METHOD)) {
            this.stringToId = TagConstant.interpolationMethodStringToId;
            this.idToString = TagConstant.interpolationMethodIdToString;
        } else if (string.equals(ID3V2_FRAME_DESCRIPTION)) {
            this.stringToId = TagConstant.id3v2_4FrameStringToId;
            this.idToString = TagConstant.id3v2_4FrameIdToString;
        } else if (string.equals(PICTURE_TYPE)) {
            this.stringToId = TagConstant.pictureTypeStringToId;
            this.idToString = TagConstant.pictureTypeIdToString;
        } else if (string.equals(TYPE_OF_EVENT)) {
            this.stringToId = TagConstant.typeOfEventStringToId;
            this.idToString = TagConstant.typeOfEventIdToString;
        } else if (string.equals(TIME_STAMP_FORMAT)) {
            this.stringToId = TagConstant.timeStampFormatStringToId;
            this.idToString = TagConstant.timeStampFormatIdToString;
        } else if (string.equals(TYPE_OF_CHANNEL)) {
            this.stringToId = TagConstant.typeOfChannelStringToId;
            this.idToString = TagConstant.typeOfChannelIdToString;
        } else if (string.equals(RECIEVED_AS)) {
            this.stringToId = TagConstant.recievedAsStringToId;
            this.idToString = TagConstant.recievedAsIdToString;
        } else {
            throw new IllegalArgumentException("Hashmap identifier not defined in this class: " + string);
        }
    }

    public ObjectNumberHashMap(ObjectNumberHashMap objectNumberHashMap) {
        super(objectNumberHashMap);
        this.hasEmptyValue = objectNumberHashMap.hasEmptyValue;
        this.idToString = objectNumberHashMap.idToString;
        this.stringToId = objectNumberHashMap.stringToId;
    }

    @Override
    public HashMap getIdToString() {
        return this.idToString;
    }

    @Override
    public HashMap getStringToId() {
        return this.stringToId;
    }

    @Override
    public void setValue(Object object) {
        this.value = object instanceof Byte ? new Long(((Byte)object).byteValue()) : (object instanceof Short ? new Long(((Short)object).shortValue()) : (object instanceof Integer ? new Long(((Integer)object).intValue()) : object));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ObjectNumberHashMap)) {
            return false;
        }
        ObjectNumberHashMap objectNumberHashMap = (ObjectNumberHashMap)object;
        if (this.hasEmptyValue != objectNumberHashMap.hasEmptyValue) {
            return false;
        }
        if (this.idToString == null ? objectNumberHashMap.idToString != null : !this.idToString.equals(objectNumberHashMap.idToString)) {
            return false;
        }
        if (this.stringToId == null ? objectNumberHashMap.stringToId != null : !this.stringToId.equals(objectNumberHashMap.stringToId)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Iterator iterator() {
        if (this.idToString == null) {
            return null;
        }
        TreeSet treeSet = new TreeSet(this.idToString.values());
        if (this.hasEmptyValue) {
            treeSet.add("");
        }
        return treeSet.iterator();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.idToString.get(this.value) == null) {
            return "";
        }
        return this.idToString.get(this.value).toString();
    }
}

