/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;

public class ObjectStringNullTerminated
extends AbstractMP3Object {
    public ObjectStringNullTerminated(String string) {
        this.identifier = string;
    }

    public ObjectStringNullTerminated(ObjectStringNullTerminated objectStringNullTerminated) {
        super(objectStringNullTerminated);
    }

    @Override
    public int getSize() {
        int n = 0;
        if (this.value != null) {
            n = ((String)this.value).length() + 1;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ObjectStringNullTerminated)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public void readString(String string, int n) {
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to String is out of bounds: offset = " + n + ", string.length()" + string.length());
        }
        int n2 = string.indexOf(0, n);
        this.value = n2 >= 0 ? string.substring(n, n2) : string.substring(n);
    }

    @Override
    public String toString() {
        return (String)this.value;
    }

    @Override
    public String writeString() {
        String string = "";
        if (this.value != null) {
            string = this.value.toString() + '\u0000';
        }
        return string;
    }
}

